module "base" {
    source = "../base"
}

# Should be moved to a base module
provider "aws" {
  region = "us-west-2"
}

########
# Phab #
########

resource "aws_instance" "phabricator" {
  count = 1
  # Force an ami version to prevent terraform from rebuilding:
  ami = "ami-331e3103"
  instance_type = "c4.large"
  subnet_id = "${element(split(",", module.base.prod_avail), count.index % 3)}"
  security_groups = ["${module.base.prod_twitch_security_group}"]
  tags {
    Name = "phab-${count.index}.prod.us-west2.justin.tv"
  }
  user_data = <<END_OF_STRING
#cloud-config
hostname: "phab-${count.index}"
fqdn: "phab-${count.index}.prod.us-west2.justin.tv"
manage_etc_hosts: true
runcmd:
 - sleep 1
 - echo "cluster=phabricator" > /etc/facter/facts.d/cluster.txt
 - echo "twitch_environment=production" > /etc/facter/facts.d/twitch_environment.txt
 - echo "app_env=production" > /etc/facter/facts.d/app_env.txt
 - echo "clean=true" > /etc/facter/facts.d/clean.txt
 - puppet agent --test --server=puppetmaster-6dbb10.sfo01.justin.tv
END_OF_STRING
}

resource "aws_route53_record" "phabricator" {
  count = 1
  zone_id = "${module.base.r53}"
  name = "phab-${count.index}.prod.us-west2.justin.tv"
  type = "A"
  ttl = "300"
  records = ["${element(aws_instance.phabricator.*.private_ip, count.index)}"]
} 

######
# DB #
######

resource "aws_db_parameter_group" "phab" {
    name = "phab-mysql"
    family = "mysql5.6"
    description = "Phabriactor Settings"

    parameter {
      name = "sql_mode"
      value = "STRICT_ALL_TABLES"
    }
}

resource "aws_security_group" "phab_db" {
  name = "phab"
  description = "DB subnet for phab"
  vpc_id="${module.base.prod_vpc}"
  ingress = {
		from_port = 3306
		to_port = 3306
    protocol = "-1"
    cidr_blocks = ["${aws_instance.phabricator.private_ip}/32"]
  }
}


resource "aws_db_instance" "phab" {
  identifier = "phab"
  allocated_storage = 5
  engine = "mysql"
  engine_version = "5.6.22"
  instance_class = "db.t2.medium"
  multi_az = true
  name = "phab"
  port = 3306
  username = "phab"
  password = "Z5GXY5PDiTbz"
  vpc_security_group_ids = ["${aws_security_group.phab_db.id}"]
  db_subnet_group_name = "prod"
  parameter_group_name = "${aws_db_parameter_group.phab.name}"
}

resource "aws_route53_record" "phabdb" {
  count = 1
  zone_id = "${module.base.r53}"
  name = "phab-db.prod.us-west2.justin.tv"
  type = "CNAME"
  ttl = "300"
  records = ["${aws_db_instance.phab.address}"]
}

#######
# SSL #
#######

resource "aws_route53_record" "phab-elb" {
  count = 1
  zone_id = "${module.base.r53}"
  name = "phab.prod.us-west2.justin.tv"
  type = "CNAME"
  ttl = "300"
  records = ["${aws_elb.phabricator.dns_name}"]
}

resource "aws_elb" "phabricator" {
  name = "phabricator"
  subnets = ["${aws_instance.phabricator.*.subnet_id}"]
  internal = true

  #listener {
  #  instance_port = 80
  #  instance_protocol = "http"
  #  lb_port = 80
  #  lb_protocol = "http"
  #}

  listener {
    instance_port = 80
    instance_protocol = "http"
    lb_port = 443
    lb_protocol = "https"
    ssl_certificate_id = "arn:aws:iam::673385534282:server-certificate/wildcard.internal.justin.tv"
  }

  health_check {
    healthy_threshold = 2
    unhealthy_threshold = 2
    timeout = 3
    target = "HTTP:80/"
    interval = 30
  }

  security_groups = ["${module.base.prod_twitch_security_group}"]
  instances = ["${aws_instance.phabricator.*.id}"]
  cross_zone_load_balancing = true
}

###########
# Outputs #
###########

output "phab_0_hostname" {
  value = "${aws_route53_record.phabricator.name}"
}

output "phab_db" {
  value = "${aws_route53_record.phabdb.name}"
}
