resource "aws_route53_record" "hystrix" {
	zone_id = "${var.ids.privateR53}"
	name = "hystrix.dev.us-west2.justin.tv"
	type = "A"
	ttl = "300"
	records = ["${module.hystrix-instance.private_ip}"]
}

module "hystrix-instance" {
    source = "../puppet_instance"
    hostname_prefix = "hystrix"
    cluster = "hystrix-production"
    owner = "kthornhill"
    instance_type = "m3.xlarge"
}
