##############
# User input #
##############

module "base" {
    source = "../base"
}

#variable "ssh_key" {}

############################
# Should be in global base #
############################

variable "ami" {
	default {
		base = "ami-23210013"
	}
}

# Should be moved to a base module
provider "aws" {
	region = "us-west-2"
}

#####################
# Production Config #
#####################

variable "names" {
	default {
		vpc = "us-west-2-prod"
	}
}

variable "ids" {
	default {
		# ID for the current vpc:
		vpc = "vpc-0213b167"

		# Route53 zones:
		privateR53 = "ZRG00SM48517Z"
	}
}

variable "avail" {
	default {
		zone0 = "subnet-faa4239f"
		zone1 = "subnet-88a207ff"
		zone2 = "subnet-9c4ab1c5"
		# Hack to support larger server counts:
		zone3  = "subnet-faa4239f"
		zone4  = "subnet-88a207ff"
		zone5  = "subnet-9c4ab1c5"
		zone6  = "subnet-faa4239f"
		zone7  = "subnet-88a207ff"
		zone8  = "subnet-9c4ab1c5"
		zone9  = "subnet-faa4239f"
		zone10 = "subnet-88a207ff"
		zone11 = "subnet-9c4ab1c5"
		zone12 = "subnet-faa4239f"
		zone13 = "subnet-88a207ff"
		zone14 = "subnet-9c4ab1c5"
		zone15 = "subnet-faa4239f"
		zone16 = "subnet-88a207ff"
		zone17 = "subnet-9c4ab1c5"
		zone18 = "subnet-faa4239f"
		zone19 = "subnet-88a207ff"
		zone20 = "subnet-9c4ab1c5"
	}
}

#####################
# Global Production #
#####################

resource "aws_security_group" "twitch_subnets" {
    name = "twitch_subnets"
    description = "Allow access from the twitch subnet"
	vpc_id="${var.ids.vpc}"

    ingress {
		from_port = 0
		to_port = 0
		protocol = "-1"
		cidr_blocks = [
	 		"10.0.0.0/8",
			"192.16.64.0/21",
			"199.9.248.0/21",
			"185.42.204.0/22",
			"127.0.0.1/32",
			// Twitch Office:
			"38.99.10.97/32",
			"38.104.129.210/32",
      "192.168.0.0/16",

      // APAC
      "45.113.128.0/22",
      "103.53.48.0/22",

      // Datacenters
      "52.223.192.0/18",
      "52.223.240.0/20"
			]
    }
}

#####################
# Github Enterprise #
#####################

resource "aws_instance" "git_001_prod_us_west2_justin_tv" {
	ami = "ami-b7654687"
	instance_type = "r3.8xlarge"
	subnet_id = "${lookup(var.avail, "zone0")}"
	security_groups = ["${aws_security_group.twitch_subnets.id}"]
	user_data = "{\"twitch_role\": \"github-enterprise\", \"twitch_environment\":\"production\", \"cluster\": \"github-enterprise\", \"fqdn\": \"git-001.prod.us-west2.justin.tv\"}"
	tags {
		Name = "git-001.prod.us-west2.justin.tv"
	}
	ebs_block_device {
		device_name= "/dev/xvdf"
		delete_on_termination= false
		volume_size= 128
		encrypted= true
		volume_type= "gp2"
	}
}

resource "aws_eip" "git-001" {
	instance = "${aws_instance.git_001_prod_us_west2_justin_tv.id}"
	vpc = true
}

#############################
# Production Jenkins Slaves #
#############################

variable "jenkins-slave" {
	default {
		count = 5
	}
}

# We only want to attach the iam instance profile to slave 4 currently
variable "iam-instance-profile" {
         default {
           "0" = ""
           "1" = ""
           "2" = ""
           "3" = ""
           "4" = "JenkinsSlave"
         }
}

resource "aws_route53_record" "private-jenkins-slaves" {
   zone_id = "${var.ids.privateR53}"
   name = "jenkins-slaves.prod.us-west2.justin.tv"
   type = "A"
   ttl = "300"
   records = ["${aws_instance.jenkins-slave.*.private_ip}"]
}

resource "aws_instance" "jenkins-slave" {
	count = "${var.jenkins-slave.count}"
	ami = "ami-03bc9e33"
	instance_type = "c4.4xlarge"
        iam_instance_profile = "${lookup(var.iam-instance-profile, count.index)}"
	subnet_id = "${lookup(var.avail, concat("zone", count.index))}"
	security_groups = ["${aws_security_group.twitch_subnets.id}"]
	user_data = "{\"twitch_role\": \"jenkins-slave\", \"twitch_environment\":\"production\", \"cluster\": \"jenkins-slave\", \"fqdn\": \"jenkins-slave-${count.index}.prod.us-west2.justin.tv\"}"
	tags {
		Name = "jenkins-slave-${count.index}.prod.us-west2.justin.tv"
	}
	ebs_block_device {
		device_name = "/dev/xvdb"
		volume_size = 1000
		volume_type = "gp2"
	}
}

resource "aws_route53_record" "jenkins-slave" {
   count = "${var.jenkins-slave.count}"
   zone_id = "${var.ids.privateR53}"
   name = "jenkins-slave-${count.index}.prod.us-west2.justin.tv"
   type = "A"
   ttl = "300"
   records = ["${element(aws_instance.jenkins-slave.*.private_ip, count.index)}"]
}

#############################
# Production Jenkins Master #
#############################

variable "jenkins-master" {
	default {
		count = 1
	}
}

resource "aws_route53_record" "private-jenkins-masters" {
   zone_id = "${var.ids.privateR53}"
   name = "jenkins-masters.prod.us-west2.justin.tv"
   type = "A"
   ttl = "300"
   records = ["${aws_instance.jenkins-master.*.private_ip}"]
}

resource "aws_instance" "jenkins-master" {
	count = "${var.jenkins-master.count}"
	ami = "ami-03bc9e33"
	instance_type = "c4.4xlarge"
	subnet_id = "${lookup(var.avail, concat("zone", count.index))}"
	security_groups = ["${aws_security_group.twitch_subnets.id}"]
	user_data = "{\"twitch_role\": \"jenkins-master\", \"twitch_environment\":\"production\", \"cluster\": \"jenkins-master\", \"fqdn\": \"jenkins-master-${count.index}.prod.us-west2.justin.tv\"}"
	tags {
		Name = "jenkins-master-${count.index}.prod.us-west2.justin.tv"
	}
	ebs_block_device {
		device_name= "/dev/xvdb"
		volume_size = 1000
		volume_type = "gp2"
	}
}

resource "aws_route53_record" "jenkins-master" {
   count = "${var.jenkins-master.count}"
   zone_id = "${var.ids.privateR53}"
   name = "jenkins-master-${count.index}.prod.us-west2.justin.tv"
   type = "A"
   ttl = "300"
   records = ["${element(aws_instance.jenkins-master.*.private_ip, count.index)}"]
}

# Discuss

resource "aws_elb" "discuss" {
  name = "discuss"
  subnets = ["${var.avail.zone0}", "${var.avail.zone1}", "${var.avail.zone2}"]

  listener {
    instance_port = 80
    instance_protocol = "http"
    lb_port = 80
    lb_protocol = "http"
  }

  health_check {
    healthy_threshold = 2
    unhealthy_threshold = 2
    timeout = 3
    target = "HTTP:80/"
    interval = 30
  }

  instances = ["${aws_instance.discuss.id}"]
  cross_zone_load_balancing = true
}

resource "aws_route53_record" "discuss" {
   count = "1"
   zone_id = "${var.ids.privateR53}"
   name = "discuss-${count.index}.prod.us-west2.justin.tv"
   type = "A"
   ttl = "300"
   records = ["${aws_instance.discuss.*.private_ip}"]
}

resource "aws_instance" "discuss" {
  count = "1"
  ami = "ami-e50d20d5"
  instance_type = "t2.medium"
  subnet_id = "${lookup(var.avail, concat("zone", count.index))}"
  security_groups = ["${aws_security_group.twitch_subnets.id}"]
  user_data = "{\"cluster\": \"discuss\", \"fqdn\": \"discuss-${count.index}.prod.us-west2.justin.tv\"}"
	tags {
		Name = "discuss-${count.index}.prod.us-west2.justin.tv"
	}
}

resource "aws_db_subnet_group" "prod" {
    name = "prod"
    description = "Our production group of subnets"
    subnet_ids = ["${var.avail.zone0}", "${var.avail.zone1}", "${var.avail.zone2}"]
}

