#########
# Skadi #
#########

resource "aws_route53_record" "skadi" {
   count = "1"
   zone_id = "${var.ids.privateR53}"
   name = "skadi-${count.index}.prod.us-west2.justin.tv"
   type = "A"
   ttl = "300"
   records = ["${aws_instance.skadi.*.private_ip}"]
}

resource "aws_db_subnet_group" "skadi" {
	name = "skadi"
	description = "DB subnet for skadi"

	subnet_ids = ["${var.avail.zone0}", "${var.avail.zone1}", "${var.avail.zone2}"]
} 

resource "aws_db_instance" "skadi" {
	identifier = "skadi"
	allocated_storage = 5
	engine = "postgres"
	engine_version = "9.3.10"
	instance_class = "db.t2.medium"
	multi_az = true
	name = "skadi"
	port = 5432
	username = "skadi"
	password = "j1230b97q3zc99"
	vpc_security_group_ids = ["${aws_security_group.twitch_subnets.id}"]
	db_subnet_group_name = "${aws_db_subnet_group.skadi.name}"
	parameter_group_name = "default.postgres9.3"
}

resource "aws_instance" "skadi" {
  count = "1"
  ami = "ami-a9ceec99"
  instance_type = "c3.xlarge"
  subnet_id = "${lookup(var.avail, concat("zone", count.index))}"
  security_groups = ["${aws_security_group.twitch_subnets.id}"]
  user_data = "{\"cluster\": \"skadi-production\", \"fqdn\": \"skadi-${count.index}.prod.us-west2.justin.tv\"}"
	tags {
		Name = "skadi-${count.index}.prod.us-west2.justin.tv"
	}
}

#######
# ELB #
#######

resource "aws_elb" "skadi" {
  name = "prod-skadi"
  subnets = ["${aws_instance.skadi.*.subnet_id}"]
  internal = true
  security_groups = ["${aws_security_group.twitch_subnets.id}"]

  listener {
    instance_port = 8080
    instance_protocol = "http"
    lb_port = 80
    lb_protocol = "http"
  }

  listener {
    instance_port = 8080
    instance_protocol = "http"
    lb_port = 443
    lb_protocol = "https"
    ssl_certificate_id = "arn:aws:iam::673385534282:server-certificate/wildcard.internal.justin.tv"
  }

  health_check {
    healthy_threshold = 2
    unhealthy_threshold = 2
    timeout = 3
    target = "HTTP:8080/running"
    interval = 30
  }

  instances = ["${aws_instance.skadi.id}"]
  cross_zone_load_balancing = true
}

resource "aws_route53_record" "skadi-elb" {
  count = 1
  zone_id = "${module.base.r53}"
  name = "skadi.prod.us-west2.justin.tv"
  type = "CNAME"
  ttl = "300"
  records = ["${aws_elb.skadi.dns_name}"]
}

##########
# Legacy #
##########

# The deploy-0 ID points at skadi-0 which then redirects it to the correct
# hostname.

resource "aws_route53_record" "deploy" {
   count = "1"
   zone_id = "${var.ids.privateR53}"
   name = "deploy-${count.index}.prod.us-west2.justin.tv"
   type = "A"
   ttl = "300"
   records = ["${element(aws_instance.skadi.*.private_ip, count.index)}"]
}
