##########
# Vanity #
##########

resource "aws_route53_record" "vanity-elb" {
   count = "1"
   zone_id = "${var.ids.privateR53}"
   name = "vanity.prod.us-west2.justin.tv"
   type = "CNAME"
   ttl = "300"
   records = ["${aws_elb.vanity.dns_name}"]
}

# Create an ELB to do SSL termination for us:
resource "aws_elb" "vanity" {
  name = "vanity"
  subnets = ["${aws_instance.vanity.*.subnet_id}"]
  internal = true
  security_groups = ["${aws_security_group.twitch_subnets.id}"]

  listener {
    instance_port = 80
    instance_protocol = "http"
    lb_port = 80
    lb_protocol = "http"
  }

  listener {
    instance_port = 80
    instance_protocol = "http"
    lb_port = 443
    lb_protocol = "https"
    ssl_certificate_id = "arn:aws:iam::673385534282:server-certificate/wildcard.justin.tv"
  }

  health_check {
    healthy_threshold = 2
    unhealthy_threshold = 2
    timeout = 3
    target = "HTTP:80/"
    interval = 30
  }

  instances = ["${aws_instance.vanity.*.id}"]
  cross_zone_load_balancing = true
}

resource "aws_route53_record" "vanity" {
   count = "1"
   zone_id = "${var.ids.privateR53}"
   name = "vanity-${count.index}.prod.us-west2.justin.tv"
   type = "A"
   ttl = "300"
   records = ["${aws_instance.vanity.*.private_ip}"]
}

resource "aws_instance" "vanity" {
  count = "1"
  ami = "ami-331e3103"
  instance_type = "t2.medium"
  subnet_id = "${lookup(var.avail, concat("zone", count.index))}"
  security_groups = ["${aws_security_group.twitch_subnets.id}"]
  user_data = <<END_OF_STRING
#cloud-config
hostname: "vanity-${count.index}"
fqdn: "vanity-${count.index}.prod.us-west2.justin.tv"
manage_etc_hosts: true
runcmd:
 - sleep 1
 - echo "cluster=vanity" > /etc/facter/facts.d/cluster.txt
 - echo "twitch_environment=production" > /etc/facter/facts.d/twitch_environment.txt
 - echo "clean=true" > /etc/facter/facts.d/clean.txt
 - echo "app_env=vanity" > /etc/facter/facts.d/app_env.txt
 - puppet agent --test --server=puppetmaster-6dbb10.sfo01.justin.tv
END_OF_STRING
	tags {
		Name = "vanity-${count.index}.prod.us-west2.justin.tv"
		Owner = "devtools"
		Email = "devtools@twitch.tv"
	}
}
