variable "ami" {
	default {
		scratch = "ami-01e5be31"
	}
}

variable "hard_ids" {
	default {
		public_r53 = "Z2Z5V7P21UMI4B"
		private_r53 = "ZRI5372JHYV6O"
		prod_vpc = "vpc-0213b167"
		devel_vpc = "vpc-1e13b17b"
	}
}

# variable "ssh_key" {
# 	description = "Name of a SSH Keypair to intialize the instance with"
# }

provider "aws" {
	region = "us-west-2"
}

resource "aws_security_group" "prod_scratch_twitch_subnet" {
    name = "prod_scratch_twitch_subnet"
    description = "Allow access from the twitch subnet"
	vpc_id="${var.hard_ids.prod_vpc}"

    ingress {
		from_port = 0
		to_port = 65535
		protocol = "tcp"
		cidr_blocks = [
		 	"10.0.0.0/8",
			"192.16.64.0/21",
			"199.9.248.0/21",
			"185.42.204.0/22",
			"127.0.0.1/32",
			"38.99.10.97/32",
			]
    }

    ingress {
		from_port = 0
		to_port = 65535
		protocol = "udp"
		cidr_blocks = [
	 		"10.0.0.0/8",
			"192.16.64.0/21",
			"199.9.248.0/21",
			"185.42.204.0/22",
			"127.0.0.1/32",
			// Twitch Office:
			"38.99.10.97/32",
			]
    }
}

resource "aws_security_group" "devel_scratch_twitch_subnet" {
    name = "devel_scratch_twitch_subnet"
    description = "Allow access from the twitch subnet"
	vpc_id="${var.hard_ids.devel_vpc}"

    ingress {
		from_port = 0
		to_port = 65535
		protocol = "tcp"
		cidr_blocks = [
		 	"10.0.0.0/8",
			"192.16.64.0/21",
			"199.9.248.0/21",
			"185.42.204.0/22",
			"127.0.0.1/32",
			"38.99.10.97/32",
			]
    }

    ingress {
		from_port = 0
		to_port = 65535
		protocol = "udp"
		cidr_blocks = [
	 		"10.0.0.0/8",
			"192.16.64.0/21",
			"199.9.248.0/21",
			"185.42.204.0/22",
			"127.0.0.1/32",
			// Twitch Office:
			"38.99.10.97/32",
			]
    }
}

resource "aws_instance" "production1" {
	ami = "${var.ami.scratch}"
	instance_type = "m1.small"
	security_groups = ["${aws_security_group.prod_scratch_twitch_subnet.id}"]
	subnet_id = "subnet-faa4239f"
	tags {
		Name = "production1"
	}
	#key_name = "${var.ssh_key}"
}

resource "aws_instance" "development1" {
	ami = "${var.ami.scratch}"
	instance_type = "m1.small"
	security_groups = ["${aws_security_group.devel_scratch_twitch_subnet.id}"]
	subnet_id = "subnet-d4a423b1"
	tags {
		Name = "development1"
	}
	#key_name = "${var.ssh_key}"
}

resource "aws_route53_record" "public-production1" {
   zone_id = "${var.hard_ids.public_r53}"
   name = "production1.us-west2-prod.aws.justin.tv"
   type = "A"
   ttl = "300"
   records = ["${aws_eip.production1.public_ip}"]
}

resource "aws_route53_record" "private-production1" {
   zone_id = "${var.hard_ids.private_r53}"
   name = "production1.us-west2-prod.aws.justin.tv"
   type = "A"
   ttl = "300"
   records = ["${aws_instance.production1.private_ip}"]
}

resource "aws_eip" "production1" {
    instance = "${aws_instance.production1.id}"
}

resource "aws_eip" "development1" {
    instance = "${aws_instance.development1.id}"
}

# output "production1_ssh" {
# 	value = "ubuntu@${aws_instance.production1.public_ip}"
# }
# 
# output "development1_ssh" {
# 	value = "ubuntu@${aws_instance.development1.public_ip}"
# }

output "production1_private_ip" {
	value = "${aws_instance.production1.private_ip}"
}

output "development1_private_ip" {
	value = "${aws_instance.development1.private_ip}"
}

output "production1_eip" {
	value = "${aws_eip.production1.public_ip}"
}

output "development1_eip" {
	value = "${aws_eip.development1.public_ip}"
}
