module "base" {
    source = "../base"
}

# Should be moved to a base module
provider "aws" {
  region = "us-west-2"
}

variable "avail" {
  default {
    zone0 = "subnet-faa4239f"
    zone1 = "subnet-88a207ff"
    zone2 = "subnet-9c4ab1c5"
    # Hack to support larger server counts:
    zone3  = "subnet-faa4239f"
    zone4  = "subnet-88a207ff"
    zone5  = "subnet-9c4ab1c5"
    zone6  = "subnet-faa4239f"
    zone7  = "subnet-88a207ff"
    zone8  = "subnet-9c4ab1c5"
    zone9  = "subnet-faa4239f"
    zone10 = "subnet-88a207ff"
    zone11 = "subnet-9c4ab1c5"
    zone12 = "subnet-faa4239f"
    zone13 = "subnet-88a207ff"
    zone14 = "subnet-9c4ab1c5"
    zone15 = "subnet-faa4239f"
    zone16 = "subnet-88a207ff"
    zone17 = "subnet-9c4ab1c5"
    zone18 = "subnet-faa4239f"
    zone19 = "subnet-88a207ff"
    zone20 = "subnet-9c4ab1c5"
  }
}

####################
# Production Vault #
####################

variable vault {
  default {
    count = 3
  }
}

resource "aws_route53_record" "private-vault" {
  zone_id = "${module.base.r53}"
  name = "vault.prod.us-west2.justin.tv"
  type = "A"
  ttl = "300"
  records = ["${aws_instance.vault.*.private_ip}"]
}

resource "aws_instance" "vault" {
  count = "${var.vault.count}"
  ami = "${module.base.ami}"
  instance_type = "c3.xlarge"
  subnet_id = "${lookup(var.avail, concat("zone", count.index))}"
  security_groups = ["${module.base.prod_twitch_security_group}"]
  user_data = <<END_OF_STRING
#cloud-config
hostname: "vault-${count.index}"
fqdn: "vault-${count.index}.prod.us-west2.justin.tv"
manage_etc_hosts: true
runcmd:
 - sleep 1
 - echo "cluster=vault" > /etc/facter/facts.d/cluster.txt
 - echo "app_env=production" > /etc/facter/facts.d/app_env.txt
 - echo "clean=true" > /etc/facter/facts.d/clean.txt
 - puppet agent --test --server=puppetmaster-6dbb10.sfo01.justin.tv
END_OF_STRING
  tags {
    Name = "vault-${count.index}.prod.us-west2.justin.tv"
  }
}

resource "aws_route53_record" "vault" {
  count = "${var.vault.count}"
   zone_id = "${module.base.r53}"
   name = "vault-${count.index}.prod.us-west2.justin.tv"
   type = "A"
   ttl = "300"
   records = ["${element(aws_instance.vault.*.private_ip, count.index)}"]
}
