module "base" {
  source = "../base"
}

provider "aws" {
  region = "us-west-2"
}

provider "consul" {
  address = "consul.internal.justin.tv"
  datacenter = "sfo01"
}

resource "aws_route53_record" "private-twitch-wall" {
  zone_id = "${module.base.r53}"
  name = "wall.prod.us-west2.justin.tv"
  type = "A"
  ttl = "300"
  records = ["${aws_instance.wall_host.*.private_ip}"]
}

resource "aws_instance" "wall_host" {
  ami = "${module.base.ami}"
  instance_type = "t2.micro"
  subnet_id = "subnet-faa4239f"
  security_groups = ["${module.base.prod_twitch_security_group}"]

  tags {
    Name = "wall.prod.us-west2.justin.tv"
    Owner = "cconger"
  }

  user_data = <<END_OF_STRING
#cloud-config
hostname: "wall"
fqdn: "wall.prod.us-west2.justin.tv"
manage_etc_hosts: true
bootcmd:
 - sleep 1
 - echo "cluster=wall" > /etc/facter/facts.d/cluster.txt
 - echo "twitch_environment=production" > /etc/facter/facts.d/twitch_environment.txt
 - echo "app_env=production" > /etc/facter/facts.d/app_env.txt
 - echo "clean=true" > /etc/facter/facts.d/clean.txt
 - puppet agent --test --server=puppet.internal.justin.tv
END_OF_STRING
  
}

output "fqdn" {
  value = "${aws_route53_record.private-twitch-wall.fqdn}"
}
