Web
===

**Requires a SSH key on jtv@puppetmaster-...**

A terraform module for spinning up a web cluster.


Usage
=====

Install update-deployed-version:

```
go get code.justin.tv/kthornhill/update-deployed-version
```

Make sure it is in yoru path:

```
which update-deployed-version
```

On your local computer make a terraform directory to store your state and
other terraform config.

Create a file:

```
module "web" {
    source = "git::git+ssh://git@git-aws.internal.justin.tv/release/terraform.git//web"
	# The prefix for hostnames and the consul env:
	env  = "tarrant-test"
	# Who it should ssh to to provision the machine:
	remote_user = "tarrant"
    owner = "tarrant"
	email = "tarrant@twitch.tv"
}


provider "consul" {
    address = "consul.internal.justin.tv"
    datacenter = "sfo01"
}

provider "aws" {
	region = "us-west-2"
}

output "url" {
	value = "${module.web.url}"
}
```

```
# Run terraform get:
terraform get -update
terraform plan -module-depth=2

# If everything looks good. Spin it up:
terraform apply
```

Publicly Accessible Staging Environments
========================================

If you need a staging environment to be publicly accessible you need to do a
bit more work.

First you need to define your access whitelist. An example whitelist that
allows anyone to access it would be:


```
resource "aws_security_group" "public_security_group" {
    name = "external-staging-1-xsola-security-group"
    description = "Allow xsola access external-staging-1"
    vpc_id="vpc-1e13b17b"

    ingress {
        from_port = 80
        to_port = 80
        protocol = "tcp"
        cidr_blocks = [
          "0.0.0.0/0",
        ]
    }

    ingress {
        from_port = 443
        to_port = 443
        protocol = "tcp"
        cidr_blocks = [
          "0.0.0.0/0",
        ]
    }
}
```

Then in your call to the "web" module you would add the following lines:

```
  public_security_group = "${aws_security_group.public_security_group.id}"
  public = 1
```

The `public_security_group` field needs to be set to the ID of the custom
security group you declare.

The `public` option can be set to `0` to disable public access, or `1` to
allow public access.
