#######
# App #
#######

resource "aws_route53_record" "app" {
   count = "1"
   zone_id = "${module.base.r53}"
   name = "${var.env.name}-app-${count.index}.dev.us-west2.justin.tv"
   type = "A"
   ttl = "300"
   records = ["${aws_instance.app.*.private_ip}"]
}

resource "aws_instance" "app" {
  count = "1"
  ami = "${module.base.ami}"
  instance_type = "c4.xlarge"
  subnet_id = "${element(split(",", module.base.dev_avail), count.index % 3)}"
  security_groups = ["${aws_security_group.staging_security_group.id}"]
  user_data = <<END_OF_STRING
#cloud-config
hostname: "${var.env.name}-app-${count.index}"
fqdn: "${var.env.name}-app-${count.index}.dev.us-west2.justin.tv"
manage_etc_hosts: true
runcmd:
 - sleep 1
 - echo "cluster=aws-app" > /etc/facter/facts.d/cluster.txt
 - echo "twitch_environment=${var.env.name}" > /etc/facter/facts.d/twitch_environment.txt
 - echo "clean=true" > /etc/facter/facts.d/clean.txt
 - echo "app_env=${var.env.name}" > /etc/facter/facts.d/app_env.txt
 - puppet agent --test
END_OF_STRING
  root_block_device {
    volume_size = "${var.root_volume_size.name}"
  }
  tags {
    Name = "${var.env.name}-app-${count.index}.dev.us-west2.justin.tv"
    Owner = "\"${var.owner.name}\" <${var.email.name}>"
  }
  provisioner "local-exec" {
      command="CONSUL_HOST='consul.internal.justin.tv' update-deployed-version -env clean-${var.env.name} -repo web/web -commit ${consul_keys.web-known-version.var.known-version}"
  }
  provisioner "local-exec" {
      command="CONSUL_HOST='consul.internal.justin.tv' update-deployed-version -env clean-${var.env.name} -repo video/twitch_player -commit ${consul_keys.twitch-player-known-version.var.known-version}"
  }
  provisioner "local-exec" {
      command="CONSUL_HOST='consul.internal.justin.tv' update-deployed-version -env clean-${var.env.name} -repo chat/tmi-js-client -commit ${consul_keys.tmi-client-known-version.var.known-version}"
  }
  provisioner "local-exec" {
      command="CONSUL_HOST='consul.internal.justin.tv' update-deployed-version -env clean-${var.env.name} -repo web/workers -commit ${consul_keys.web-workers-known-version.var.known-version}"
  }
}
