module "base" {
    source = "../base"
}

variable env {
    default {
        name = "tarrant"
    }
}

variable owner {
    default {
        name = ""
    }
}

variable email {
    default {
        name = ""
    }
}

variable root_volume_size {
    default {
        name = "8"
    }
}

variable public {
  description = "Set to 1 to make the instance publicly accessible. 0 for private."
  default {
    enable = 0
  }
}

variable public_security_group {
  description = "ID for a security group to whitelist public access. Defaults to '0.0.0.0/0'"
  default {
    id = ""
  }
}

variable remote_user {
    default {
        name = "tarrant"
        key  = "~/.ssh/id_rsa"
    }
}

provider "aws" {
    region = "us-west-2"
}

resource "aws_security_group" "staging_security_group" {
    name = "${var.env.name}-staging-security-group"
    description = "Limit access other boxes that are part of ${var.env.name}"
    vpc_id="vpc-1e13b17b"

    ingress {
        from_port = 22
        to_port = 22
        protocol = "tcp"
        cidr_blocks = [
            "10.0.0.0/8",
            "192.16.64.0/21",
            "199.9.248.0/21",
            "185.42.204.0/22",
            "127.0.0.1/32",
            // Twitch Office:
            "38.99.10.97/32",
            "192.168.0.0/16",
            ]
    }

    ingress {
        from_port = 8306
        to_port = 8306
        protocol = "udp"
        cidr_blocks = [
            "10.0.0.0/8",
            "192.16.64.0/21",
            "199.9.248.0/21",
            "185.42.204.0/22",
            "127.0.0.1/32",
            // Twitch Office:
            "38.99.10.97/32",
            "192.168.0.0/16",
            ]
    }

    ingress {
        from_port = 8400
        to_port = 8400
        protocol = "tcp"
        cidr_blocks = [
            "10.0.0.0/8",
            "192.16.64.0/21",
            "199.9.248.0/21",
            "185.42.204.0/22",
            "127.0.0.1/32",
            // Twitch Office:
            "38.99.10.97/32",
            "192.168.0.0/16",
            ]
    }

    ingress {
        from_port = 0
        to_port = 0
        protocol = "-1"
        self = true
    }

    egress {
        from_port = 0
        to_port = 0
        protocol = "-1"
    }

    ingress {
        from_port = 0
        to_port = 255
        protocol = "icmp"
        cidr_blocks = [
            "10.0.0.0/8",
            "192.16.64.0/21",
            "199.9.248.0/21",
            "185.42.204.0/22",
            "127.0.0.1/32",
            // Twitch Office:
            "38.99.10.97/32",
            "192.168.0.0/16",
            ]
    }
}


##################################
# Register environment in consul #
##################################

resource "consul_keys" "web-env" {
    datacenter = "sfo01"
    key {
        name = "env-registration"
        path = "dynamic-envs/web/web/clean-${var.env.name}"
        value = "{}"
        delete = true
    }
}

resource "consul_keys" "tmi-client-env" {
    datacenter = "sfo01"
    key {
        name = "env-registration"
        path = "dynamic-envs/chat/tmi-js-client/clean-${var.env.name}"
        value = "{}"
        delete = true
    }
}

resource "consul_keys" "twitch-player-env" {
    datacenter = "sfo01"
    key {
        name = "env-registration"
        path = "dynamic-envs/video/twitch_player/clean-${var.env.name}"
        value = "{}"
        delete = true
    }
}

resource "consul_keys" "web-client-env" {
    datacenter = "sfo01"
    key {
        name = "env-registration"
        path = "dynamic-envs/web/web-client/clean-${var.env.name}"
        value = "{}"
        delete = true
    }
}

resource "consul_keys" "web-workers-env" {
    datacenter = "sfo01"
    key {
        name = "env-registration"
        path = "dynamic-envs/web/web-workers/clean-${var.env.name}"
        value = "{}"
        delete = true
    }
}

#############################
# Lets fake deploy versions #
#############################

resource "consul_keys" "web-known-version" {
    datacenter = "sfo01"
    key {
        name = "known-version"
        path = "deployed-version/web/web/clean-production"
    }
}

resource "consul_keys" "tmi-client-known-version" {
    datacenter = "sfo01"
    key {
        name = "known-version"
        path = "deployed-version/chat/tmi-js-client/clean-production"
    }
}

resource "consul_keys" "twitch-player-known-version" {
    datacenter = "sfo01"
    key {
        name = "known-version"
        path = "deployed-version/video/twitch_player/clean-production"
    }
}

resource "consul_keys" "web-client-known-version" {
    datacenter = "sfo01"
    key {
        name = "known-version"
        path = "deployed-version/web/web-client/clean-production"
    }
}

resource "consul_keys" "web-workers-known-version" {
    datacenter = "sfo01"
    key {
        name = "known-version"
        path = "deployed-version/web/workers/clean-production"
    }
}

