##################
# ELB Public DNS #
##################

resource "aws_route53_record" "public-api" {
   count="${var.public.enable}"
   zone_id = "${module.base.public_twitch_r53}"
   name = "${var.env.name}-api.dev.us-west2.twitch.tv"
   type = "CNAME"
   ttl = "300"
   records = ["${aws_elb.public-web.dns_name}"]
}

resource "aws_route53_record" "public-secure-login-twitch" {
   count="${var.public.enable}"
   zone_id = "${module.base.public_twitch_r53}"
   name = "${var.env.name}-secure-login.dev.us-west2.twitch.tv"
   type = "CNAME"
   ttl = "300"
   records = ["${aws_elb.public-web.dns_name}"]
}

resource "aws_route53_record" "public-www" {
   count="${var.public.enable}"
   zone_id = "${module.base.public_twitch_r53}"
   name = "${var.env.name}-www.dev.us-west2.twitch.tv"
   type = "CNAME"
   ttl = "300"
   records = ["${aws_elb.public-web.dns_name}"]
}

resource "aws_route53_record" "public-www-cdn" {
   count="${var.public.enable}"
   zone_id = "${module.base.public_twitch_r53}"
   name = "${var.env.name}-www-cdn.dev.us-west2.twitch.tv"
   type = "CNAME"
   ttl = "300"
   records = ["${aws_elb.public-web.dns_name}"]
}

resource "aws_route53_record" "public-secure" {
   count="${var.public.enable}"
   zone_id = "${module.base.public_twitch_r53}"
   name = "${var.env.name}-secure.dev.us-west2.twitch.tv"
   type = "CNAME"
   ttl = "300"
   records = ["${aws_elb.public-web.dns_name}"]
}

resource "aws_route53_record" "public-admin" {
   count = "${var.public.enable}"
   zone_id = "${module.base.public_twitch_r53}"
   name = "${var.env.name}-admin.dev.us-west2.twitch.tv"
   type = "CNAME"
   ttl = "300"
   records = ["${aws_elb.public-web.dns_name}"]
}

resource "aws_route53_record" "public-web-client-elb" {
   count = "${var.public.enable}"
   zone_id = "${module.base.public_twitch_r53}"
   name = "${var.env.name}-web-client.dev.us-west2.twitch.tv"
   type = "CNAME"
   ttl = "300"
   records = ["${aws_elb.public-web.dns_name}"]
}

##############
# Public ELB #
##############

resource "aws_elb" "public-web" {
  count = "${var.public.enable}"
  name = "${var.env.name}-public-web"
  subnets = ["${aws_instance.web.*.subnet_id}"]
  security_groups = ["${module.base.dev_twitch_security_group}", "${aws_security_group.staging_security_group.id}", "${var.public_security_group.id}"]

  listener {
    instance_port = 80
    instance_protocol = "http"
    lb_port = 80
    lb_protocol = "http"
  }

  listener {
    instance_port = 80
    instance_protocol = "http"
    lb_port = 443
    lb_protocol = "https"
    ssl_certificate_id = "arn:aws:iam::673385534282:server-certificate/wildcard.dev.us-west2.twitch.tv"
  }

  health_check {
    healthy_threshold = 2
    unhealthy_threshold = 2
    timeout = 3
    target = "HTTP:80/"
    interval = 30
  }

  instances = ["${aws_instance.web.id}"]
  cross_zone_load_balancing = true
}
