#######################
# Secure Login Server #
#######################

resource "aws_route53_record" "secure-login" {
   count = "1"
   zone_id = "${module.base.r53}"
   name = "${var.env.name}-secure-login-${count.index}.dev.us-west2.justin.tv"
   type = "A"
   ttl = "300"
   records = ["${aws_instance.secure-login.*.private_ip}"]
}

resource "aws_instance" "secure-login" {
  count = "1"
  ami = "ami-1fc9e62f"
  key_name = "devtools/tarrant"
  instance_type = "m3.medium"
  subnet_id = "${element(split(",", module.base.dev_avail), count.index % 3)}"
  iam_instance_profile = "staging_secure_login"
  security_groups = ["${aws_security_group.staging_security_group.id}"]
  user_data = <<END_OF_STRING
  export CLOUD_ENVIRONMENT=dev
  export CLOUD_APP=securelogin
  export CLOUD_APP_GROUP=infra
  export CLOUD_STACK=infra
  export CLOUD_AUTO_SCALE_GROUP=securelogin-infra-d0staging-${var.env.name}
  export EC2_REGION=us-west-2
  export CLOUD_DEV_PHASE=staging
  export REDIRECT_URL=${var.env.name}-www.dev.us-west2.twitch.tv
  export APP_ENV=${var.env.name}
END_OF_STRING
  tags {
    Name = "${var.env.name}-secure-login-${count.index}.dev.us-west2.justin.tv"
    Owner = "\"${var.owner.name}\" <${var.email.name}>"
  }
  depends_on = [
    "aws_instance.app",
    ]
}
