##############
# Web Client #
##############

resource "aws_route53_record" "web-client" {
   count = "1"
   zone_id = "${module.base.r53}"
   name = "${var.env.name}-web-client-${count.index}.dev.us-west2.justin.tv"
   type = "A"
   ttl = "300"
   records = ["${aws_instance.web-client.*.private_ip}"]
}

resource "aws_instance" "web-client" {
  count = "1"
  ami = "${module.base.ami}"
  instance_type = "t2.small"
  subnet_id = "${element(split(",", module.base.dev_avail), count.index % 3)}"

  security_groups = ["${aws_security_group.staging_security_group.id}"]
  user_data = <<END_OF_STRING
#cloud-config
hostname: "${var.env.name}-web-client-${count.index}"
fqdn: "${var.env.name}-web-client-${count.index}.dev.us-west2.justin.tv"
manage_etc_hosts: true
runcmd:
 - echo "cluster=aws-web-client" > /etc/facter/facts.d/cluster.txt
 - echo "twitch_environment=${var.env.name}" > /etc/facter/facts.d/twitch_environment.txt
 - echo "clean=true" > /etc/facter/facts.d/clean.txt
 - echo "app_env=${var.env.name}" > /etc/facter/facts.d/app_env.txt
 - puppet agent --test
END_OF_STRING
  tags {
    Name = "${var.env.name}-web-client-${count.index}.dev.us-west2.justin.tv"
    Owner = "\"${var.owner.name}\" <${var.email.name}>"
  }
	provisioner "local-exec" {
      command="CONSUL_HOST='consul.internal.justin.tv' update-deployed-version -env clean-${var.env.name} -repo web/web-client -commit ${consul_keys.web-client-known-version.var.known-version}"
  }
}
