package analysis

import "code.justin.tv/release/trace/analysis/tx"

// Percentile returns the pth percentile greatest value in the given
// txset, sorted by the given SortOrder.
func Percentile(txset tx.TransactionSet, p float64, order tx.SortOrder) *tx.Transaction {
	txs := txset.Sorted(order)
	var idx int = int(p * float64(len(txs)-1))
	return txs[idx]
}
