// Code generated by protoc-gen-go. DO NOT EDIT.
// source: code.justin.tv/release/trace/api/report_v1/archive.proto

/*
Package report_v1 is a generated protocol buffer package.

It is generated from these files:
	code.justin.tv/release/trace/api/report_v1/archive.proto
	code.justin.tv/release/trace/api/report_v1/distribution.proto
	code.justin.tv/release/trace/api/report_v1/httpbody.proto
	code.justin.tv/release/trace/api/report_v1/report.proto

It has these top-level messages:
	TransactionRef
	IndexLocationRef
	TransactionSetLocationRef
	ListTransactionsPageToken
	ListTransactionsRequest
	ListTransactionsResponse
	GetTransactionRequest
	Distribution
	HttpBody
	Report
	ListReportsRequest
	ListReportsResponse
	LookupTransactionRequest
	LookupTransactionResponse
	ListProgramsInReportRequest
	ListProgramsInReportResponse
	GetProgramReportRequest
	GetProgramReportResponse
	GetTransactionPageRequest
	ProgramReport
	NoteworthyTransactions
	SubtreeSummary
	CallSummary
	CallRef
	MethodRef
	ProgramRef
	CallSignatureSummary
	GetAssetRequest
*/
package report_v1

import (
	fmt "fmt"
	proto "github.com/golang/protobuf/proto"

	math "math"

	"code.justin.tv/common/chitin/grpctrace"
	code_justin_tv_release_trace_api "code.justin.tv/release/trace/api"

	context "golang.org/x/net/context"

	grpc "google.golang.org/grpc"
)

// Reference imports to suppress errors if they are not otherwise used.
var _ = proto.Marshal
var _ = fmt.Errorf
var _ = math.Inf

// This is a compile-time assertion to ensure that this generated file
// is compatible with the proto package it is being compiled against.
// A compilation error at this line likely means your copy of the
// proto package needs to be updated.
const _ = proto.ProtoPackageIsVersion2 // please upgrade the proto package

// A TransactionRef points to the storage location of a Transaction.
type TransactionRef struct {
	// Required. The ID of the Transaction in the canonical text format.
	Txid string `protobuf:"bytes,1,opt,name=txid" json:"txid,omitempty"`
	// Location of the index file that references this transaction. (Used
	// internally for paging.)
	IndexLocation *IndexLocationRef `protobuf:"bytes,2,opt,name=index_location,json=indexLocation" json:"index_location,omitempty"`
	// Location of the TransactionSet that includes the referenced Transaction.
	DataLocation *TransactionSetLocationRef `protobuf:"bytes,3,opt,name=data_location,json=dataLocation" json:"data_location,omitempty"`
}

func (m *TransactionRef) Reset()                    { *m = TransactionRef{} }
func (m *TransactionRef) String() string            { return proto.CompactTextString(m) }
func (*TransactionRef) ProtoMessage()               {}
func (*TransactionRef) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{0} }

func (m *TransactionRef) GetTxid() string {
	if m != nil {
		return m.Txid
	}
	return ""
}

func (m *TransactionRef) GetIndexLocation() *IndexLocationRef {
	if m != nil {
		return m.IndexLocation
	}
	return nil
}

func (m *TransactionRef) GetDataLocation() *TransactionSetLocationRef {
	if m != nil {
		return m.DataLocation
	}
	return nil
}

// An IndexLocationRef points to a portion of the Transaction index.
type IndexLocationRef struct {
	// Name of the S3 bucket.
	S3Bucket string `protobuf:"bytes,1,opt,name=s3_bucket,json=s3Bucket" json:"s3_bucket,omitempty"`
	// Name of the S3 object.
	S3Key string `protobuf:"bytes,2,opt,name=s3_key,json=s3Key" json:"s3_key,omitempty"`
}

func (m *IndexLocationRef) Reset()                    { *m = IndexLocationRef{} }
func (m *IndexLocationRef) String() string            { return proto.CompactTextString(m) }
func (*IndexLocationRef) ProtoMessage()               {}
func (*IndexLocationRef) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{1} }

func (m *IndexLocationRef) GetS3Bucket() string {
	if m != nil {
		return m.S3Bucket
	}
	return ""
}

func (m *IndexLocationRef) GetS3Key() string {
	if m != nil {
		return m.S3Key
	}
	return ""
}

// A TransactionSetLocationRef points to the storage location of a
// TransactionSet.
type TransactionSetLocationRef struct {
	// ARN of the Kinesis stream.
	KinesisStreamArn string `protobuf:"bytes,1,opt,name=kinesis_stream_arn,json=kinesisStreamArn" json:"kinesis_stream_arn,omitempty"`
	// ID of the Kinesis shard.
	KinesisShardId string `protobuf:"bytes,2,opt,name=kinesis_shard_id,json=kinesisShardId" json:"kinesis_shard_id,omitempty"`
	// Sequence number of the Kinesis record.
	KinesisSequenceNumber string `protobuf:"bytes,3,opt,name=kinesis_sequence_number,json=kinesisSequenceNumber" json:"kinesis_sequence_number,omitempty"`
}

func (m *TransactionSetLocationRef) Reset()                    { *m = TransactionSetLocationRef{} }
func (m *TransactionSetLocationRef) String() string            { return proto.CompactTextString(m) }
func (*TransactionSetLocationRef) ProtoMessage()               {}
func (*TransactionSetLocationRef) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{2} }

func (m *TransactionSetLocationRef) GetKinesisStreamArn() string {
	if m != nil {
		return m.KinesisStreamArn
	}
	return ""
}

func (m *TransactionSetLocationRef) GetKinesisShardId() string {
	if m != nil {
		return m.KinesisShardId
	}
	return ""
}

func (m *TransactionSetLocationRef) GetKinesisSequenceNumber() string {
	if m != nil {
		return m.KinesisSequenceNumber
	}
	return ""
}

// ListTransactionsPageToken is used internally for paging the
// ListTransactions method.
type ListTransactionsPageToken struct {
	PreviousEnd *TransactionRef `protobuf:"bytes,1,opt,name=previous_end,json=previousEnd" json:"previous_end,omitempty"`
}

func (m *ListTransactionsPageToken) Reset()                    { *m = ListTransactionsPageToken{} }
func (m *ListTransactionsPageToken) String() string            { return proto.CompactTextString(m) }
func (*ListTransactionsPageToken) ProtoMessage()               {}
func (*ListTransactionsPageToken) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{3} }

func (m *ListTransactionsPageToken) GetPreviousEnd() *TransactionRef {
	if m != nil {
		return m.PreviousEnd
	}
	return nil
}

type ListTransactionsRequest struct {
	// Opaque token for continuing long requests.
	PageToken string `protobuf:"bytes,1,opt,name=page_token,json=pageToken" json:"page_token,omitempty"`
	// Limit on number of results to return. The number of results may be
	// smaller than requested.
	PageSize int32 `protobuf:"varint,2,opt,name=page_size,json=pageSize" json:"page_size,omitempty"`
	// The ID of the desired Transaction in the canonical text format, or a
	// prefix of the ID.
	TxidPrefix string `protobuf:"bytes,3,opt,name=txid_prefix,json=txidPrefix" json:"txid_prefix,omitempty"`
}

func (m *ListTransactionsRequest) Reset()                    { *m = ListTransactionsRequest{} }
func (m *ListTransactionsRequest) String() string            { return proto.CompactTextString(m) }
func (*ListTransactionsRequest) ProtoMessage()               {}
func (*ListTransactionsRequest) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{4} }

func (m *ListTransactionsRequest) GetPageToken() string {
	if m != nil {
		return m.PageToken
	}
	return ""
}

func (m *ListTransactionsRequest) GetPageSize() int32 {
	if m != nil {
		return m.PageSize
	}
	return 0
}

func (m *ListTransactionsRequest) GetTxidPrefix() string {
	if m != nil {
		return m.TxidPrefix
	}
	return ""
}

type ListTransactionsResponse struct {
	// Opaque token for continuing long requests, to be used as the page_token
	// of a future request. An empty string here means there are no more pages.
	NextPageToken string `protobuf:"bytes,1,opt,name=next_page_token,json=nextPageToken" json:"next_page_token,omitempty"`
	// List of Transaction references matching the search criteria.
	Matches []*TransactionRef `protobuf:"bytes,2,rep,name=matches" json:"matches,omitempty"`
}

func (m *ListTransactionsResponse) Reset()                    { *m = ListTransactionsResponse{} }
func (m *ListTransactionsResponse) String() string            { return proto.CompactTextString(m) }
func (*ListTransactionsResponse) ProtoMessage()               {}
func (*ListTransactionsResponse) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{5} }

func (m *ListTransactionsResponse) GetNextPageToken() string {
	if m != nil {
		return m.NextPageToken
	}
	return ""
}

func (m *ListTransactionsResponse) GetMatches() []*TransactionRef {
	if m != nil {
		return m.Matches
	}
	return nil
}

type GetTransactionRequest struct {
	Ref *TransactionRef `protobuf:"bytes,1,opt,name=ref" json:"ref,omitempty"`
}

func (m *GetTransactionRequest) Reset()                    { *m = GetTransactionRequest{} }
func (m *GetTransactionRequest) String() string            { return proto.CompactTextString(m) }
func (*GetTransactionRequest) ProtoMessage()               {}
func (*GetTransactionRequest) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{6} }

func (m *GetTransactionRequest) GetRef() *TransactionRef {
	if m != nil {
		return m.Ref
	}
	return nil
}

func init() {
	proto.RegisterType((*TransactionRef)(nil), "code.justin.tv.release.trace.api.report.v1.TransactionRef")
	proto.RegisterType((*IndexLocationRef)(nil), "code.justin.tv.release.trace.api.report.v1.IndexLocationRef")
	proto.RegisterType((*TransactionSetLocationRef)(nil), "code.justin.tv.release.trace.api.report.v1.TransactionSetLocationRef")
	proto.RegisterType((*ListTransactionsPageToken)(nil), "code.justin.tv.release.trace.api.report.v1.ListTransactionsPageToken")
	proto.RegisterType((*ListTransactionsRequest)(nil), "code.justin.tv.release.trace.api.report.v1.ListTransactionsRequest")
	proto.RegisterType((*ListTransactionsResponse)(nil), "code.justin.tv.release.trace.api.report.v1.ListTransactionsResponse")
	proto.RegisterType((*GetTransactionRequest)(nil), "code.justin.tv.release.trace.api.report.v1.GetTransactionRequest")
}

// Reference imports to suppress errors if they are not otherwise used.
var _ context.Context
var _ grpc.ClientConn

// This is a compile-time assertion to ensure that this generated file
// is compatible with the grpc package it is being compiled against.
const _ = grpc.SupportPackageIsVersion4

// Client API for Archive service

type ArchiveClient interface {
	// List Transactions matching the search criteria.
	ListTransactions(ctx context.Context, in *ListTransactionsRequest, opts ...grpc.CallOption) (*ListTransactionsResponse, error)
	// Get a single Transaction.
	GetTransaction(ctx context.Context, in *GetTransactionRequest, opts ...grpc.CallOption) (*code_justin_tv_release_trace_api.Transaction, error)
}

type archiveClient struct {
	cc *grpc.ClientConn
}

func NewArchiveClient(cc *grpc.ClientConn) ArchiveClient {
	return &archiveClient{cc}
}

func (c *archiveClient) ListTransactions(ctx context.Context, in *ListTransactionsRequest, opts ...grpc.CallOption) (*ListTransactionsResponse, error) {
	out := new(ListTransactionsResponse)
	err := grpctrace.Invoke(ctx, "/code.justin.tv.release.trace.api.report.v1.Archive/ListTransactions", in, out, c.cc, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *archiveClient) GetTransaction(ctx context.Context, in *GetTransactionRequest, opts ...grpc.CallOption) (*code_justin_tv_release_trace_api.Transaction, error) {
	out := new(code_justin_tv_release_trace_api.Transaction)
	err := grpctrace.Invoke(ctx, "/code.justin.tv.release.trace.api.report.v1.Archive/GetTransaction", in, out, c.cc, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

// Server API for Archive service

type ArchiveServer interface {
	// List Transactions matching the search criteria.
	ListTransactions(context.Context, *ListTransactionsRequest) (*ListTransactionsResponse, error)
	// Get a single Transaction.
	GetTransaction(context.Context, *GetTransactionRequest) (*code_justin_tv_release_trace_api.Transaction, error)
}

func RegisterArchiveServer(s *grpc.Server, srv ArchiveServer) {
	grpctrace.RegisterService(s, &_Archive_serviceDesc, srv)
}

func _Archive_ListTransactions_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ListTransactionsRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ArchiveServer).ListTransactions(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/code.justin.tv.release.trace.api.report.v1.Archive/ListTransactions",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ArchiveServer).ListTransactions(ctx, req.(*ListTransactionsRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _Archive_GetTransaction_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetTransactionRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ArchiveServer).GetTransaction(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/code.justin.tv.release.trace.api.report.v1.Archive/GetTransaction",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ArchiveServer).GetTransaction(ctx, req.(*GetTransactionRequest))
	}
	return interceptor(ctx, in, info, handler)
}

var _Archive_serviceDesc = grpc.ServiceDesc{
	ServiceName: "code.justin.tv.release.trace.api.report.v1.Archive",
	HandlerType: (*ArchiveServer)(nil),
	Methods: []grpc.MethodDesc{
		{
			MethodName: "ListTransactions",
			Handler:    _Archive_ListTransactions_Handler,
		},
		{
			MethodName: "GetTransaction",
			Handler:    _Archive_GetTransaction_Handler,
		},
	},
	Streams:  []grpc.StreamDesc{},
	Metadata: "code.justin.tv/release/trace/api/report_v1/archive.proto",
}

func init() {
	proto.RegisterFile("code.justin.tv/release/trace/api/report_v1/archive.proto", fileDescriptor0)
}

var fileDescriptor0 = []byte{
	// 574 bytes of a gzipped FileDescriptorProto
	0x1f, 0x8b, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0xff, 0xac, 0x54, 0x4d, 0x6f, 0xd3, 0x40,
	0x10, 0xad, 0x5b, 0xfa, 0xe1, 0x49, 0x1b, 0xa2, 0x95, 0xaa, 0xa6, 0xad, 0x10, 0x95, 0x0f, 0xa8,
	0x42, 0xe0, 0xa8, 0x89, 0x84, 0x10, 0xe2, 0xd2, 0x42, 0x41, 0x15, 0x11, 0xaa, 0x9c, 0x9c, 0x90,
	0xd0, 0x6a, 0x63, 0x4f, 0x9a, 0x6d, 0x9a, 0xb5, 0xd9, 0xdd, 0x58, 0x69, 0xce, 0xfc, 0x08, 0x6e,
	0xfc, 0x00, 0x6e, 0xfc, 0x37, 0xee, 0x68, 0xd7, 0xce, 0x67, 0xa9, 0x4a, 0x28, 0x37, 0xef, 0x9b,
	0x99, 0xf7, 0x66, 0xde, 0x58, 0x03, 0x2f, 0xc3, 0x38, 0x42, 0xff, 0xb2, 0xaf, 0x34, 0x17, 0xbe,
	0x4e, 0x2b, 0x12, 0xaf, 0x90, 0x29, 0xac, 0x68, 0xc9, 0x42, 0xac, 0xb0, 0x84, 0x57, 0x24, 0x26,
	0xb1, 0xd4, 0x34, 0x3d, 0xaa, 0x30, 0x19, 0x76, 0x78, 0x8a, 0x7e, 0x22, 0x63, 0x1d, 0x93, 0xa7,
	0xb3, 0x95, 0x7e, 0x5e, 0xe9, 0xdb, 0x4a, 0x9f, 0x25, 0xdc, 0xcf, 0x2a, 0xfd, 0xf4, 0x68, 0xaf,
	0x7a, 0xa7, 0x8a, 0x96, 0x4c, 0x28, 0x16, 0x6a, 0x1e, 0x8b, 0x8c, 0xdf, 0xfb, 0xe5, 0x40, 0xb1,
	0x39, 0x41, 0x03, 0x6c, 0x13, 0x02, 0x0f, 0xf4, 0x80, 0x47, 0x65, 0xe7, 0xc0, 0x39, 0x74, 0x03,
	0xfb, 0x4d, 0x42, 0x28, 0x72, 0x11, 0xe1, 0x80, 0x5e, 0xc5, 0x21, 0x33, 0x89, 0xe5, 0xe5, 0x03,
	0xe7, 0xb0, 0x50, 0x7d, 0xed, 0xff, 0x7d, 0x7f, 0xfe, 0x99, 0x61, 0xa8, 0xe7, 0x04, 0x01, 0xb6,
	0x83, 0x2d, 0x3e, 0x8d, 0x90, 0x4b, 0xd8, 0x8a, 0x98, 0x66, 0x13, 0x8d, 0x15, 0xab, 0x71, 0xba,
	0x88, 0xc6, 0xd4, 0x2c, 0x0d, 0xd4, 0xd3, 0x62, 0x9b, 0x86, 0x7b, 0x04, 0x78, 0xef, 0xa0, 0x34,
	0xdf, 0x0e, 0xd9, 0x07, 0x57, 0xd5, 0x68, 0xab, 0x1f, 0x76, 0x51, 0xe7, 0xd3, 0x6f, 0xa8, 0xda,
	0x89, 0x7d, 0x93, 0x6d, 0x58, 0x53, 0x35, 0xda, 0xc5, 0x6b, 0x3b, 0xb9, 0x1b, 0xac, 0xaa, 0xda,
	0x07, 0xbc, 0xf6, 0x7e, 0x38, 0xb0, 0x7b, 0xab, 0x26, 0x79, 0x06, 0xa4, 0xcb, 0x05, 0x2a, 0xae,
	0xa8, 0xd2, 0x12, 0x59, 0x8f, 0x32, 0x29, 0x72, 0xea, 0x52, 0x1e, 0x69, 0xd8, 0xc0, 0xb1, 0x14,
	0xe4, 0x10, 0x4a, 0xe3, 0xec, 0x0e, 0x93, 0x11, 0xe5, 0x51, 0x2e, 0x56, 0x1c, 0xe5, 0x1a, 0xf8,
	0x2c, 0x22, 0x2f, 0x60, 0x67, 0x9c, 0x89, 0x5f, 0xfa, 0x28, 0x42, 0xa4, 0xa2, 0xdf, 0x6b, 0xa1,
	0xb4, 0x9e, 0xb9, 0xc1, 0xf6, 0xa8, 0x20, 0x8f, 0x7e, 0xb4, 0x41, 0x6f, 0x08, 0xbb, 0x75, 0xae,
	0xf4, 0x54, 0xc3, 0xea, 0x9c, 0x5d, 0x60, 0x33, 0xee, 0xa2, 0x20, 0x9f, 0x61, 0x33, 0x91, 0x98,
	0xf2, 0xb8, 0xaf, 0x28, 0x8a, 0x6c, 0xff, 0x85, 0xea, 0xab, 0x7f, 0x74, 0xdf, 0x58, 0x5e, 0x18,
	0xf1, 0x9d, 0x8a, 0xc8, 0x4b, 0x61, 0x67, 0x5e, 0x3b, 0x30, 0xdd, 0x29, 0x4d, 0x1e, 0x01, 0x24,
	0xec, 0x02, 0xa9, 0x36, 0x7d, 0xe4, 0xf6, 0xb8, 0xc9, 0xb8, 0xb1, 0x7d, 0xb0, 0x0f, 0xaa, 0xf8,
	0x10, 0xad, 0x21, 0xab, 0xc1, 0x86, 0x01, 0x1a, 0x7c, 0x88, 0xe4, 0x31, 0x14, 0xcc, 0x1f, 0x4a,
	0x13, 0x89, 0x6d, 0x3e, 0xc8, 0xc7, 0x07, 0x03, 0x9d, 0x5b, 0xc4, 0xfb, 0xe6, 0x40, 0xf9, 0xa6,
	0xb0, 0x4a, 0x62, 0xa1, 0x90, 0x3c, 0x81, 0x87, 0x02, 0x07, 0x9a, 0xde, 0x90, 0xdf, 0x32, 0xf0,
	0xc4, 0x9b, 0x26, 0xac, 0xf7, 0x98, 0x0e, 0x3b, 0xa8, 0xca, 0xcb, 0x07, 0x2b, 0xf7, 0xb4, 0x65,
	0x44, 0xe5, 0x21, 0x6c, 0xbf, 0x47, 0x3d, 0x13, 0xcd, 0x0c, 0xa9, 0xc3, 0x8a, 0xc4, 0xf6, 0x7f,
	0xd8, 0x80, 0xa1, 0xa9, 0xfe, 0x5c, 0x86, 0xf5, 0xe3, 0xec, 0xaa, 0x90, 0xef, 0x0e, 0x94, 0xe6,
	0xdd, 0x20, 0x6f, 0x16, 0x51, 0xb8, 0x65, 0x89, 0x7b, 0x6f, 0xef, 0x47, 0x92, 0x2d, 0xc4, 0x5b,
	0x22, 0x5f, 0x1d, 0x28, 0xce, 0xba, 0x42, 0x8e, 0x17, 0xa1, 0xfe, 0xa3, 0xa3, 0x7b, 0xcf, 0xef,
	0xa6, 0x98, 0xaa, 0xf2, 0x96, 0x4e, 0x0a, 0x9f, 0xdc, 0xf1, 0x4d, 0x6e, 0xad, 0xd9, 0x63, 0x59,
	0xfb, 0x1d, 0x00, 0x00, 0xff, 0xff, 0x3b, 0x77, 0xdf, 0x9c, 0xc8, 0x05, 0x00, 0x00,
}
