// Code generated by protoc-gen-go. DO NOT EDIT.
// source: code.justin.tv/release/trace/api/report_v1/report.proto

package report_v1

import (
	fmt "fmt"
	proto "github.com/golang/protobuf/proto"

	math "math"

	"code.justin.tv/common/chitin/grpctrace"
	code_justin_tv_release_trace_api "code.justin.tv/release/trace/api"
	_ "google.golang.org/genproto/googleapis/api/annotations"

	google_protobuf1 "github.com/golang/protobuf/ptypes/duration"

	google_protobuf2 "github.com/golang/protobuf/ptypes/empty"

	google_protobuf3 "github.com/golang/protobuf/ptypes/timestamp"

	context "golang.org/x/net/context"

	grpc "google.golang.org/grpc"
)

// Reference imports to suppress errors if they are not otherwise used.
var _ = proto.Marshal
var _ = fmt.Errorf
var _ = math.Inf

type Report struct {
	// Opaque identifier for the report
	Id       string                      `protobuf:"bytes,1,opt,name=id" json:"id,omitempty"`
	Modified *google_protobuf3.Timestamp `protobuf:"bytes,2,opt,name=modified" json:"modified,omitempty"`
}

func (m *Report) Reset()                    { *m = Report{} }
func (m *Report) String() string            { return proto.CompactTextString(m) }
func (*Report) ProtoMessage()               {}
func (*Report) Descriptor() ([]byte, []int) { return fileDescriptor3, []int{0} }

func (m *Report) GetId() string {
	if m != nil {
		return m.Id
	}
	return ""
}

func (m *Report) GetModified() *google_protobuf3.Timestamp {
	if m != nil {
		return m.Modified
	}
	return nil
}

type ListReportsRequest struct {
}

func (m *ListReportsRequest) Reset()                    { *m = ListReportsRequest{} }
func (m *ListReportsRequest) String() string            { return proto.CompactTextString(m) }
func (*ListReportsRequest) ProtoMessage()               {}
func (*ListReportsRequest) Descriptor() ([]byte, []int) { return fileDescriptor3, []int{1} }

type ListReportsResponse struct {
	Report []*Report `protobuf:"bytes,1,rep,name=report" json:"report,omitempty"`
}

func (m *ListReportsResponse) Reset()                    { *m = ListReportsResponse{} }
func (m *ListReportsResponse) String() string            { return proto.CompactTextString(m) }
func (*ListReportsResponse) ProtoMessage()               {}
func (*ListReportsResponse) Descriptor() ([]byte, []int) { return fileDescriptor3, []int{2} }

func (m *ListReportsResponse) GetReport() []*Report {
	if m != nil {
		return m.Report
	}
	return nil
}

type LookupTransactionRequest struct {
	TransactionId string `protobuf:"bytes,1,opt,name=transaction_id,json=transactionId" json:"transaction_id,omitempty"`
	// Opaque report identifier
	ReportId string `protobuf:"bytes,2,opt,name=report_id,json=reportId" json:"report_id,omitempty"`
}

func (m *LookupTransactionRequest) Reset()                    { *m = LookupTransactionRequest{} }
func (m *LookupTransactionRequest) String() string            { return proto.CompactTextString(m) }
func (*LookupTransactionRequest) ProtoMessage()               {}
func (*LookupTransactionRequest) Descriptor() ([]byte, []int) { return fileDescriptor3, []int{3} }

func (m *LookupTransactionRequest) GetTransactionId() string {
	if m != nil {
		return m.TransactionId
	}
	return ""
}

func (m *LookupTransactionRequest) GetReportId() string {
	if m != nil {
		return m.ReportId
	}
	return ""
}

type LookupTransactionResponse struct {
	Transaction *code_justin_tv_release_trace_api.Transaction `protobuf:"bytes,1,opt,name=transaction" json:"transaction,omitempty"`
}

func (m *LookupTransactionResponse) Reset()                    { *m = LookupTransactionResponse{} }
func (m *LookupTransactionResponse) String() string            { return proto.CompactTextString(m) }
func (*LookupTransactionResponse) ProtoMessage()               {}
func (*LookupTransactionResponse) Descriptor() ([]byte, []int) { return fileDescriptor3, []int{4} }

func (m *LookupTransactionResponse) GetTransaction() *code_justin_tv_release_trace_api.Transaction {
	if m != nil {
		return m.Transaction
	}
	return nil
}

type ListProgramsInReportRequest struct {
	// Opaque report identifier
	ReportId string `protobuf:"bytes,1,opt,name=report_id,json=reportId" json:"report_id,omitempty"`
}

func (m *ListProgramsInReportRequest) Reset()                    { *m = ListProgramsInReportRequest{} }
func (m *ListProgramsInReportRequest) String() string            { return proto.CompactTextString(m) }
func (*ListProgramsInReportRequest) ProtoMessage()               {}
func (*ListProgramsInReportRequest) Descriptor() ([]byte, []int) { return fileDescriptor3, []int{5} }

func (m *ListProgramsInReportRequest) GetReportId() string {
	if m != nil {
		return m.ReportId
	}
	return ""
}

type ListProgramsInReportResponse struct {
	Programs []*ProgramRef `protobuf:"bytes,1,rep,name=programs" json:"programs,omitempty"`
}

func (m *ListProgramsInReportResponse) Reset()                    { *m = ListProgramsInReportResponse{} }
func (m *ListProgramsInReportResponse) String() string            { return proto.CompactTextString(m) }
func (*ListProgramsInReportResponse) ProtoMessage()               {}
func (*ListProgramsInReportResponse) Descriptor() ([]byte, []int) { return fileDescriptor3, []int{6} }

func (m *ListProgramsInReportResponse) GetPrograms() []*ProgramRef {
	if m != nil {
		return m.Programs
	}
	return nil
}

type GetProgramReportRequest struct {
	// Opaque report identifier
	ReportId string      `protobuf:"bytes,1,opt,name=report_id,json=reportId" json:"report_id,omitempty"`
	Program  *ProgramRef `protobuf:"bytes,2,opt,name=program" json:"program,omitempty"`
}

func (m *GetProgramReportRequest) Reset()                    { *m = GetProgramReportRequest{} }
func (m *GetProgramReportRequest) String() string            { return proto.CompactTextString(m) }
func (*GetProgramReportRequest) ProtoMessage()               {}
func (*GetProgramReportRequest) Descriptor() ([]byte, []int) { return fileDescriptor3, []int{7} }

func (m *GetProgramReportRequest) GetReportId() string {
	if m != nil {
		return m.ReportId
	}
	return ""
}

func (m *GetProgramReportRequest) GetProgram() *ProgramRef {
	if m != nil {
		return m.Program
	}
	return nil
}

type GetProgramReportResponse struct {
	Content *ProgramReport `protobuf:"bytes,1,opt,name=content" json:"content,omitempty"`
}

func (m *GetProgramReportResponse) Reset()                    { *m = GetProgramReportResponse{} }
func (m *GetProgramReportResponse) String() string            { return proto.CompactTextString(m) }
func (*GetProgramReportResponse) ProtoMessage()               {}
func (*GetProgramReportResponse) Descriptor() ([]byte, []int) { return fileDescriptor3, []int{8} }

func (m *GetProgramReportResponse) GetContent() *ProgramReport {
	if m != nil {
		return m.Content
	}
	return nil
}

type GetTransactionPageRequest struct {
	// Opaque report identifier
	ReportId string `protobuf:"bytes,1,opt,name=report_id,json=reportId" json:"report_id,omitempty"`
}

func (m *GetTransactionPageRequest) Reset()                    { *m = GetTransactionPageRequest{} }
func (m *GetTransactionPageRequest) String() string            { return proto.CompactTextString(m) }
func (*GetTransactionPageRequest) ProtoMessage()               {}
func (*GetTransactionPageRequest) Descriptor() ([]byte, []int) { return fileDescriptor3, []int{9} }

func (m *GetTransactionPageRequest) GetReportId() string {
	if m != nil {
		return m.ReportId
	}
	return ""
}

// ProgramReport describes the behavior of a single program.
//
// This message generally includes Transactions by reference. This reduces the
// size of the messages, and prepares for reports to become less focused on
// the server at the root of the RPC tree.
type ProgramReport struct {
	Program *ProgramRef `protobuf:"bytes,1,opt,name=program" json:"program,omitempty"`
	// Distribution of root span response time in nanoseconds, as measured by
	// the root server.
	RootServerTimingDistribution *Distribution           `protobuf:"bytes,2,opt,name=root_server_timing_distribution,json=rootServerTimingDistribution" json:"root_server_timing_distribution,omitempty"`
	Noteworthy                   *NoteworthyTransactions `protobuf:"bytes,3,opt,name=noteworthy" json:"noteworthy,omitempty"`
	Signature                    []*CallSignatureSummary `protobuf:"bytes,4,rep,name=signature" json:"signature,omitempty"`
}

func (m *ProgramReport) Reset()                    { *m = ProgramReport{} }
func (m *ProgramReport) String() string            { return proto.CompactTextString(m) }
func (*ProgramReport) ProtoMessage()               {}
func (*ProgramReport) Descriptor() ([]byte, []int) { return fileDescriptor3, []int{10} }

func (m *ProgramReport) GetProgram() *ProgramRef {
	if m != nil {
		return m.Program
	}
	return nil
}

func (m *ProgramReport) GetRootServerTimingDistribution() *Distribution {
	if m != nil {
		return m.RootServerTimingDistribution
	}
	return nil
}

func (m *ProgramReport) GetNoteworthy() *NoteworthyTransactions {
	if m != nil {
		return m.Noteworthy
	}
	return nil
}

func (m *ProgramReport) GetSignature() []*CallSignatureSummary {
	if m != nil {
		return m.Signature
	}
	return nil
}

type NoteworthyTransactions struct {
	Slowest *SubtreeSummary `protobuf:"bytes,1,opt,name=slowest" json:"slowest,omitempty"`
	Deepest *SubtreeSummary `protobuf:"bytes,2,opt,name=deepest" json:"deepest,omitempty"`
	Largest *SubtreeSummary `protobuf:"bytes,3,opt,name=largest" json:"largest,omitempty"`
}

func (m *NoteworthyTransactions) Reset()                    { *m = NoteworthyTransactions{} }
func (m *NoteworthyTransactions) String() string            { return proto.CompactTextString(m) }
func (*NoteworthyTransactions) ProtoMessage()               {}
func (*NoteworthyTransactions) Descriptor() ([]byte, []int) { return fileDescriptor3, []int{11} }

func (m *NoteworthyTransactions) GetSlowest() *SubtreeSummary {
	if m != nil {
		return m.Slowest
	}
	return nil
}

func (m *NoteworthyTransactions) GetDeepest() *SubtreeSummary {
	if m != nil {
		return m.Deepest
	}
	return nil
}

func (m *NoteworthyTransactions) GetLargest() *SubtreeSummary {
	if m != nil {
		return m.Largest
	}
	return nil
}

// SubtreeSummary provides an overview of a single call, including its cost as
// measured in a few dimensions. This summary of the call does not depend on
// where it might be located within a larger RPC tree; it summarizes only the
// RPC subtree that was created in the service of a single call.
type SubtreeSummary struct {
	Call         *CallSummary `protobuf:"bytes,1,opt,name=call" json:"call,omitempty"`
	SubtreeSize  int64        `protobuf:"varint,2,opt,name=subtree_size,json=subtreeSize" json:"subtree_size,omitempty"`
	SubtreeDepth int64        `protobuf:"varint,3,opt,name=subtree_depth,json=subtreeDepth" json:"subtree_depth,omitempty"`
}

func (m *SubtreeSummary) Reset()                    { *m = SubtreeSummary{} }
func (m *SubtreeSummary) String() string            { return proto.CompactTextString(m) }
func (*SubtreeSummary) ProtoMessage()               {}
func (*SubtreeSummary) Descriptor() ([]byte, []int) { return fileDescriptor3, []int{12} }

func (m *SubtreeSummary) GetCall() *CallSummary {
	if m != nil {
		return m.Call
	}
	return nil
}

func (m *SubtreeSummary) GetSubtreeSize() int64 {
	if m != nil {
		return m.SubtreeSize
	}
	return 0
}

func (m *SubtreeSummary) GetSubtreeDepth() int64 {
	if m != nil {
		return m.SubtreeDepth
	}
	return 0
}

type CallSummary struct {
	Ref            *CallRef                   `protobuf:"bytes,1,opt,name=ref" json:"ref,omitempty"`
	ServerDuration *google_protobuf1.Duration `protobuf:"bytes,2,opt,name=server_duration,json=serverDuration" json:"server_duration,omitempty"`
}

func (m *CallSummary) Reset()                    { *m = CallSummary{} }
func (m *CallSummary) String() string            { return proto.CompactTextString(m) }
func (*CallSummary) ProtoMessage()               {}
func (*CallSummary) Descriptor() ([]byte, []int) { return fileDescriptor3, []int{13} }

func (m *CallSummary) GetRef() *CallRef {
	if m != nil {
		return m.Ref
	}
	return nil
}

func (m *CallSummary) GetServerDuration() *google_protobuf1.Duration {
	if m != nil {
		return m.ServerDuration
	}
	return nil
}

// CallRef identifies a single call and the Transaction that contains it.
type CallRef struct {
	TransactionId string   `protobuf:"bytes,1,opt,name=transaction_id,json=transactionId" json:"transaction_id,omitempty"`
	Path          []uint32 `protobuf:"varint,2,rep,packed,name=path" json:"path,omitempty"`
}

func (m *CallRef) Reset()                    { *m = CallRef{} }
func (m *CallRef) String() string            { return proto.CompactTextString(m) }
func (*CallRef) ProtoMessage()               {}
func (*CallRef) Descriptor() ([]byte, []int) { return fileDescriptor3, []int{14} }

func (m *CallRef) GetTransactionId() string {
	if m != nil {
		return m.TransactionId
	}
	return ""
}

func (m *CallRef) GetPath() []uint32 {
	if m != nil {
		return m.Path
	}
	return nil
}

type MethodRef struct {
	// Name of the program that provides the method
	Program *ProgramRef `protobuf:"bytes,1,opt,name=program" json:"program,omitempty"`
	// Name of the method, possibly fully-qualified with gRPC/Twirp service name.
	MethodName string `protobuf:"bytes,2,opt,name=method_name,json=methodName" json:"method_name,omitempty"`
}

func (m *MethodRef) Reset()                    { *m = MethodRef{} }
func (m *MethodRef) String() string            { return proto.CompactTextString(m) }
func (*MethodRef) ProtoMessage()               {}
func (*MethodRef) Descriptor() ([]byte, []int) { return fileDescriptor3, []int{15} }

func (m *MethodRef) GetProgram() *ProgramRef {
	if m != nil {
		return m.Program
	}
	return nil
}

func (m *MethodRef) GetMethodName() string {
	if m != nil {
		return m.MethodName
	}
	return ""
}

type ProgramRef struct {
	// Name of the server program. For Go programs, this is the import path of
	// package "main".
	Name string `protobuf:"bytes,1,opt,name=name" json:"name,omitempty"`
}

func (m *ProgramRef) Reset()                    { *m = ProgramRef{} }
func (m *ProgramRef) String() string            { return proto.CompactTextString(m) }
func (*ProgramRef) ProtoMessage()               {}
func (*ProgramRef) Descriptor() ([]byte, []int) { return fileDescriptor3, []int{16} }

func (m *ProgramRef) GetName() string {
	if m != nil {
		return m.Name
	}
	return ""
}

type CallSignatureSummary struct {
	Method                 *MethodRef    `protobuf:"bytes,1,opt,name=method" json:"method,omitempty"`
	Dependencies           []*ProgramRef `protobuf:"bytes,2,rep,name=dependencies" json:"dependencies,omitempty"`
	TransitiveDependencies []*ProgramRef `protobuf:"bytes,3,rep,name=transitive_dependencies,json=transitiveDependencies" json:"transitive_dependencies,omitempty"`
	// Distribution of response time in nanoseconds, as measured by the server.
	ServerTimingDistribution *Distribution `protobuf:"bytes,4,opt,name=server_timing_distribution,json=serverTimingDistribution" json:"server_timing_distribution,omitempty"`
	Examples                 []*CallRef    `protobuf:"bytes,5,rep,name=examples" json:"examples,omitempty"`
}

func (m *CallSignatureSummary) Reset()                    { *m = CallSignatureSummary{} }
func (m *CallSignatureSummary) String() string            { return proto.CompactTextString(m) }
func (*CallSignatureSummary) ProtoMessage()               {}
func (*CallSignatureSummary) Descriptor() ([]byte, []int) { return fileDescriptor3, []int{17} }

func (m *CallSignatureSummary) GetMethod() *MethodRef {
	if m != nil {
		return m.Method
	}
	return nil
}

func (m *CallSignatureSummary) GetDependencies() []*ProgramRef {
	if m != nil {
		return m.Dependencies
	}
	return nil
}

func (m *CallSignatureSummary) GetTransitiveDependencies() []*ProgramRef {
	if m != nil {
		return m.TransitiveDependencies
	}
	return nil
}

func (m *CallSignatureSummary) GetServerTimingDistribution() *Distribution {
	if m != nil {
		return m.ServerTimingDistribution
	}
	return nil
}

func (m *CallSignatureSummary) GetExamples() []*CallRef {
	if m != nil {
		return m.Examples
	}
	return nil
}

type GetAssetRequest struct {
	AssetName string `protobuf:"bytes,1,opt,name=asset_name,json=assetName" json:"asset_name,omitempty"`
}

func (m *GetAssetRequest) Reset()                    { *m = GetAssetRequest{} }
func (m *GetAssetRequest) String() string            { return proto.CompactTextString(m) }
func (*GetAssetRequest) ProtoMessage()               {}
func (*GetAssetRequest) Descriptor() ([]byte, []int) { return fileDescriptor3, []int{18} }

func (m *GetAssetRequest) GetAssetName() string {
	if m != nil {
		return m.AssetName
	}
	return ""
}

func init() {
	proto.RegisterType((*Report)(nil), "code.justin.tv.release.trace.api.report.v1.Report")
	proto.RegisterType((*ListReportsRequest)(nil), "code.justin.tv.release.trace.api.report.v1.ListReportsRequest")
	proto.RegisterType((*ListReportsResponse)(nil), "code.justin.tv.release.trace.api.report.v1.ListReportsResponse")
	proto.RegisterType((*LookupTransactionRequest)(nil), "code.justin.tv.release.trace.api.report.v1.LookupTransactionRequest")
	proto.RegisterType((*LookupTransactionResponse)(nil), "code.justin.tv.release.trace.api.report.v1.LookupTransactionResponse")
	proto.RegisterType((*ListProgramsInReportRequest)(nil), "code.justin.tv.release.trace.api.report.v1.ListProgramsInReportRequest")
	proto.RegisterType((*ListProgramsInReportResponse)(nil), "code.justin.tv.release.trace.api.report.v1.ListProgramsInReportResponse")
	proto.RegisterType((*GetProgramReportRequest)(nil), "code.justin.tv.release.trace.api.report.v1.GetProgramReportRequest")
	proto.RegisterType((*GetProgramReportResponse)(nil), "code.justin.tv.release.trace.api.report.v1.GetProgramReportResponse")
	proto.RegisterType((*GetTransactionPageRequest)(nil), "code.justin.tv.release.trace.api.report.v1.GetTransactionPageRequest")
	proto.RegisterType((*ProgramReport)(nil), "code.justin.tv.release.trace.api.report.v1.ProgramReport")
	proto.RegisterType((*NoteworthyTransactions)(nil), "code.justin.tv.release.trace.api.report.v1.NoteworthyTransactions")
	proto.RegisterType((*SubtreeSummary)(nil), "code.justin.tv.release.trace.api.report.v1.SubtreeSummary")
	proto.RegisterType((*CallSummary)(nil), "code.justin.tv.release.trace.api.report.v1.CallSummary")
	proto.RegisterType((*CallRef)(nil), "code.justin.tv.release.trace.api.report.v1.CallRef")
	proto.RegisterType((*MethodRef)(nil), "code.justin.tv.release.trace.api.report.v1.MethodRef")
	proto.RegisterType((*ProgramRef)(nil), "code.justin.tv.release.trace.api.report.v1.ProgramRef")
	proto.RegisterType((*CallSignatureSummary)(nil), "code.justin.tv.release.trace.api.report.v1.CallSignatureSummary")
	proto.RegisterType((*GetAssetRequest)(nil), "code.justin.tv.release.trace.api.report.v1.GetAssetRequest")
}

// Reference imports to suppress errors if they are not otherwise used.
var _ context.Context
var _ grpc.ClientConn

// This is a compile-time assertion to ensure that this generated file
// is compatible with the grpc package it is being compiled against.
const _ = grpc.SupportPackageIsVersion4

// Client API for Reports service

type ReportsClient interface {
	ListReports(ctx context.Context, in *ListReportsRequest, opts ...grpc.CallOption) (*ListReportsResponse, error)
	LookupTransaction(ctx context.Context, in *LookupTransactionRequest, opts ...grpc.CallOption) (*LookupTransactionResponse, error)
	ListProgramsInReport(ctx context.Context, in *ListProgramsInReportRequest, opts ...grpc.CallOption) (*ListProgramsInReportResponse, error)
	GetProgramReport(ctx context.Context, in *GetProgramReportRequest, opts ...grpc.CallOption) (*GetProgramReportResponse, error)
}

type reportsClient struct {
	cc *grpc.ClientConn
}

func NewReportsClient(cc *grpc.ClientConn) ReportsClient {
	return &reportsClient{cc}
}

func (c *reportsClient) ListReports(ctx context.Context, in *ListReportsRequest, opts ...grpc.CallOption) (*ListReportsResponse, error) {
	out := new(ListReportsResponse)
	err := grpctrace.Invoke(ctx, "/code.justin.tv.release.trace.api.report.v1.Reports/ListReports", in, out, c.cc, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *reportsClient) LookupTransaction(ctx context.Context, in *LookupTransactionRequest, opts ...grpc.CallOption) (*LookupTransactionResponse, error) {
	out := new(LookupTransactionResponse)
	err := grpctrace.Invoke(ctx, "/code.justin.tv.release.trace.api.report.v1.Reports/LookupTransaction", in, out, c.cc, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *reportsClient) ListProgramsInReport(ctx context.Context, in *ListProgramsInReportRequest, opts ...grpc.CallOption) (*ListProgramsInReportResponse, error) {
	out := new(ListProgramsInReportResponse)
	err := grpctrace.Invoke(ctx, "/code.justin.tv.release.trace.api.report.v1.Reports/ListProgramsInReport", in, out, c.cc, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *reportsClient) GetProgramReport(ctx context.Context, in *GetProgramReportRequest, opts ...grpc.CallOption) (*GetProgramReportResponse, error) {
	out := new(GetProgramReportResponse)
	err := grpctrace.Invoke(ctx, "/code.justin.tv.release.trace.api.report.v1.Reports/GetProgramReport", in, out, c.cc, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

// Server API for Reports service

type ReportsServer interface {
	ListReports(context.Context, *ListReportsRequest) (*ListReportsResponse, error)
	LookupTransaction(context.Context, *LookupTransactionRequest) (*LookupTransactionResponse, error)
	ListProgramsInReport(context.Context, *ListProgramsInReportRequest) (*ListProgramsInReportResponse, error)
	GetProgramReport(context.Context, *GetProgramReportRequest) (*GetProgramReportResponse, error)
}

func RegisterReportsServer(s *grpc.Server, srv ReportsServer) {
	grpctrace.RegisterService(s, &_Reports_serviceDesc, srv)
}

func _Reports_ListReports_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ListReportsRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ReportsServer).ListReports(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/code.justin.tv.release.trace.api.report.v1.Reports/ListReports",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ReportsServer).ListReports(ctx, req.(*ListReportsRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _Reports_LookupTransaction_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(LookupTransactionRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ReportsServer).LookupTransaction(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/code.justin.tv.release.trace.api.report.v1.Reports/LookupTransaction",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ReportsServer).LookupTransaction(ctx, req.(*LookupTransactionRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _Reports_ListProgramsInReport_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ListProgramsInReportRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ReportsServer).ListProgramsInReport(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/code.justin.tv.release.trace.api.report.v1.Reports/ListProgramsInReport",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ReportsServer).ListProgramsInReport(ctx, req.(*ListProgramsInReportRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _Reports_GetProgramReport_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetProgramReportRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ReportsServer).GetProgramReport(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/code.justin.tv.release.trace.api.report.v1.Reports/GetProgramReport",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ReportsServer).GetProgramReport(ctx, req.(*GetProgramReportRequest))
	}
	return interceptor(ctx, in, info, handler)
}

var _Reports_serviceDesc = grpc.ServiceDesc{
	ServiceName: "code.justin.tv.release.trace.api.report.v1.Reports",
	HandlerType: (*ReportsServer)(nil),
	Methods: []grpc.MethodDesc{
		{
			MethodName: "ListReports",
			Handler:    _Reports_ListReports_Handler,
		},
		{
			MethodName: "LookupTransaction",
			Handler:    _Reports_LookupTransaction_Handler,
		},
		{
			MethodName: "ListProgramsInReport",
			Handler:    _Reports_ListProgramsInReport_Handler,
		},
		{
			MethodName: "GetProgramReport",
			Handler:    _Reports_GetProgramReport_Handler,
		},
	},
	Streams:  []grpc.StreamDesc{},
	Metadata: "code.justin.tv/release/trace/api/report_v1/report.proto",
}

// Client API for ReportBrowser service

type ReportBrowserClient interface {
	ListProgramsInReport(ctx context.Context, in *ListProgramsInReportRequest, opts ...grpc.CallOption) (*HttpBody, error)
	GetProgramReport(ctx context.Context, in *GetProgramReportRequest, opts ...grpc.CallOption) (*HttpBody, error)
	LookupTransaction(ctx context.Context, in *LookupTransactionRequest, opts ...grpc.CallOption) (*HttpBody, error)
	GetTransactionPage(ctx context.Context, in *GetTransactionPageRequest, opts ...grpc.CallOption) (*HttpBody, error)
	GetLatestReport(ctx context.Context, in *google_protobuf2.Empty, opts ...grpc.CallOption) (*HttpBody, error)
	GetAsset(ctx context.Context, in *GetAssetRequest, opts ...grpc.CallOption) (*HttpBody, error)
}

type reportBrowserClient struct {
	cc *grpc.ClientConn
}

func NewReportBrowserClient(cc *grpc.ClientConn) ReportBrowserClient {
	return &reportBrowserClient{cc}
}

func (c *reportBrowserClient) ListProgramsInReport(ctx context.Context, in *ListProgramsInReportRequest, opts ...grpc.CallOption) (*HttpBody, error) {
	out := new(HttpBody)
	err := grpctrace.Invoke(ctx, "/code.justin.tv.release.trace.api.report.v1.ReportBrowser/ListProgramsInReport", in, out, c.cc, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *reportBrowserClient) GetProgramReport(ctx context.Context, in *GetProgramReportRequest, opts ...grpc.CallOption) (*HttpBody, error) {
	out := new(HttpBody)
	err := grpctrace.Invoke(ctx, "/code.justin.tv.release.trace.api.report.v1.ReportBrowser/GetProgramReport", in, out, c.cc, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *reportBrowserClient) LookupTransaction(ctx context.Context, in *LookupTransactionRequest, opts ...grpc.CallOption) (*HttpBody, error) {
	out := new(HttpBody)
	err := grpctrace.Invoke(ctx, "/code.justin.tv.release.trace.api.report.v1.ReportBrowser/LookupTransaction", in, out, c.cc, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *reportBrowserClient) GetTransactionPage(ctx context.Context, in *GetTransactionPageRequest, opts ...grpc.CallOption) (*HttpBody, error) {
	out := new(HttpBody)
	err := grpctrace.Invoke(ctx, "/code.justin.tv.release.trace.api.report.v1.ReportBrowser/GetTransactionPage", in, out, c.cc, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *reportBrowserClient) GetLatestReport(ctx context.Context, in *google_protobuf2.Empty, opts ...grpc.CallOption) (*HttpBody, error) {
	out := new(HttpBody)
	err := grpctrace.Invoke(ctx, "/code.justin.tv.release.trace.api.report.v1.ReportBrowser/GetLatestReport", in, out, c.cc, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *reportBrowserClient) GetAsset(ctx context.Context, in *GetAssetRequest, opts ...grpc.CallOption) (*HttpBody, error) {
	out := new(HttpBody)
	err := grpctrace.Invoke(ctx, "/code.justin.tv.release.trace.api.report.v1.ReportBrowser/GetAsset", in, out, c.cc, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

// Server API for ReportBrowser service

type ReportBrowserServer interface {
	ListProgramsInReport(context.Context, *ListProgramsInReportRequest) (*HttpBody, error)
	GetProgramReport(context.Context, *GetProgramReportRequest) (*HttpBody, error)
	LookupTransaction(context.Context, *LookupTransactionRequest) (*HttpBody, error)
	GetTransactionPage(context.Context, *GetTransactionPageRequest) (*HttpBody, error)
	GetLatestReport(context.Context, *google_protobuf2.Empty) (*HttpBody, error)
	GetAsset(context.Context, *GetAssetRequest) (*HttpBody, error)
}

func RegisterReportBrowserServer(s *grpc.Server, srv ReportBrowserServer) {
	grpctrace.RegisterService(s, &_ReportBrowser_serviceDesc, srv)
}

func _ReportBrowser_ListProgramsInReport_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ListProgramsInReportRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ReportBrowserServer).ListProgramsInReport(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/code.justin.tv.release.trace.api.report.v1.ReportBrowser/ListProgramsInReport",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ReportBrowserServer).ListProgramsInReport(ctx, req.(*ListProgramsInReportRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _ReportBrowser_GetProgramReport_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetProgramReportRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ReportBrowserServer).GetProgramReport(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/code.justin.tv.release.trace.api.report.v1.ReportBrowser/GetProgramReport",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ReportBrowserServer).GetProgramReport(ctx, req.(*GetProgramReportRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _ReportBrowser_LookupTransaction_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(LookupTransactionRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ReportBrowserServer).LookupTransaction(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/code.justin.tv.release.trace.api.report.v1.ReportBrowser/LookupTransaction",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ReportBrowserServer).LookupTransaction(ctx, req.(*LookupTransactionRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _ReportBrowser_GetTransactionPage_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetTransactionPageRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ReportBrowserServer).GetTransactionPage(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/code.justin.tv.release.trace.api.report.v1.ReportBrowser/GetTransactionPage",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ReportBrowserServer).GetTransactionPage(ctx, req.(*GetTransactionPageRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _ReportBrowser_GetLatestReport_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(google_protobuf2.Empty)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ReportBrowserServer).GetLatestReport(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/code.justin.tv.release.trace.api.report.v1.ReportBrowser/GetLatestReport",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ReportBrowserServer).GetLatestReport(ctx, req.(*google_protobuf2.Empty))
	}
	return interceptor(ctx, in, info, handler)
}

func _ReportBrowser_GetAsset_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetAssetRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ReportBrowserServer).GetAsset(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/code.justin.tv.release.trace.api.report.v1.ReportBrowser/GetAsset",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ReportBrowserServer).GetAsset(ctx, req.(*GetAssetRequest))
	}
	return interceptor(ctx, in, info, handler)
}

var _ReportBrowser_serviceDesc = grpc.ServiceDesc{
	ServiceName: "code.justin.tv.release.trace.api.report.v1.ReportBrowser",
	HandlerType: (*ReportBrowserServer)(nil),
	Methods: []grpc.MethodDesc{
		{
			MethodName: "ListProgramsInReport",
			Handler:    _ReportBrowser_ListProgramsInReport_Handler,
		},
		{
			MethodName: "GetProgramReport",
			Handler:    _ReportBrowser_GetProgramReport_Handler,
		},
		{
			MethodName: "LookupTransaction",
			Handler:    _ReportBrowser_LookupTransaction_Handler,
		},
		{
			MethodName: "GetTransactionPage",
			Handler:    _ReportBrowser_GetTransactionPage_Handler,
		},
		{
			MethodName: "GetLatestReport",
			Handler:    _ReportBrowser_GetLatestReport_Handler,
		},
		{
			MethodName: "GetAsset",
			Handler:    _ReportBrowser_GetAsset_Handler,
		},
	},
	Streams:  []grpc.StreamDesc{},
	Metadata: "code.justin.tv/release/trace/api/report_v1/report.proto",
}

func init() {
	proto.RegisterFile("code.justin.tv/release/trace/api/report_v1/report.proto", fileDescriptor3)
}

var fileDescriptor3 = []byte{
	// 1239 bytes of a gzipped FileDescriptorProto
	0x1f, 0x8b, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0xff, 0xb4, 0x98, 0x4f, 0x73, 0xdb, 0xc4,
	0x1b, 0xc7, 0x7f, 0xb2, 0xd3, 0xd8, 0x7e, 0xdc, 0xa4, 0x3f, 0xb6, 0x25, 0x75, 0x9c, 0x34, 0x09,
	0x62, 0x18, 0x52, 0x33, 0x48, 0xc4, 0x85, 0xfe, 0x63, 0x42, 0x21, 0x75, 0x26, 0x0d, 0xa4, 0x6d,
	0x46, 0xce, 0x29, 0x87, 0x7a, 0xd6, 0xd6, 0xc6, 0x51, 0x91, 0xb4, 0x42, 0xbb, 0x76, 0x9a, 0x66,
	0x02, 0x33, 0x9c, 0x38, 0xc2, 0x70, 0x61, 0xb8, 0x30, 0xc3, 0x0c, 0x5c, 0x38, 0xc1, 0x85, 0x2b,
	0x07, 0xde, 0x01, 0x6f, 0x81, 0x77, 0xc1, 0x85, 0xd1, 0x6a, 0x25, 0xcb, 0xb1, 0x43, 0x23, 0xbb,
	0xb9, 0x59, 0xfb, 0xec, 0xf3, 0x79, 0xbe, 0xcf, 0xb3, 0xab, 0xdd, 0x47, 0x86, 0x5b, 0x2d, 0x6a,
	0x12, 0xed, 0x69, 0x87, 0x71, 0xcb, 0xd5, 0x78, 0x57, 0xf7, 0x89, 0x4d, 0x30, 0x23, 0x3a, 0xf7,
	0x71, 0x8b, 0xe8, 0xd8, 0xb3, 0x74, 0x9f, 0x78, 0xd4, 0xe7, 0x8d, 0xee, 0x8a, 0xfc, 0xa5, 0x79,
	0x3e, 0xe5, 0x14, 0x55, 0xfa, 0x1d, 0x35, 0xe9, 0xa8, 0x09, 0x47, 0x0d, 0x7b, 0x96, 0x26, 0xa7,
	0x77, 0x57, 0xca, 0xab, 0x29, 0x82, 0x98, 0x16, 0xe3, 0xbe, 0xd5, 0xec, 0x70, 0x8b, 0xba, 0x61,
	0xa8, 0xf2, 0x9d, 0x14, 0xee, 0xfb, 0x9c, 0x7b, 0x4d, 0x6a, 0x1e, 0x4a, 0xd7, 0xea, 0x0b, 0x5d,
	0xb9, 0x8f, 0x5d, 0x86, 0x5b, 0x89, 0x70, 0xf3, 0x6d, 0x4a, 0xdb, 0x76, 0x68, 0xc5, 0xae, 0x4b,
	0x39, 0x0e, 0x8c, 0x4c, 0x5a, 0x17, 0xa4, 0x55, 0x3c, 0x35, 0x3b, 0x7b, 0xba, 0xd9, 0xf1, 0x71,
	0xc2, 0x7b, 0xee, 0xa4, 0x9d, 0x38, 0x1e, 0x8f, 0xe4, 0x2c, 0x9e, 0x34, 0x72, 0xcb, 0x21, 0x8c,
	0x63, 0xc7, 0x0b, 0x27, 0xa8, 0xdb, 0x30, 0x69, 0x88, 0x5c, 0xd0, 0x34, 0x64, 0x2c, 0xb3, 0xa4,
	0x2c, 0x29, 0xcb, 0x05, 0x23, 0x63, 0x99, 0xe8, 0x26, 0xe4, 0x1d, 0x6a, 0x5a, 0x7b, 0x16, 0x31,
	0x4b, 0x99, 0x25, 0x65, 0xb9, 0x58, 0x2d, 0x6b, 0x21, 0x4d, 0x8b, 0x68, 0xda, 0x4e, 0x44, 0x33,
	0xe2, 0xb9, 0xea, 0x15, 0x40, 0x5b, 0x16, 0xe3, 0x21, 0x95, 0x19, 0xe4, 0xb3, 0x0e, 0x61, 0x5c,
	0xc5, 0x70, 0xb9, 0x6f, 0x94, 0x79, 0xd4, 0x65, 0x04, 0x7d, 0x0c, 0x93, 0x61, 0x29, 0x4b, 0xca,
	0x52, 0x76, 0xb9, 0x58, 0xad, 0x6a, 0x67, 0x5f, 0x65, 0x2d, 0x84, 0x19, 0x92, 0xa0, 0x3e, 0x81,
	0xd2, 0x16, 0xa5, 0x9f, 0x76, 0xbc, 0x9d, 0x5e, 0x85, 0x65, 0x78, 0xf4, 0x06, 0x4c, 0x27, 0xea,
	0xde, 0x88, 0x13, 0x9d, 0x4a, 0x8c, 0x6e, 0x9a, 0x68, 0x0e, 0x0a, 0x72, 0x65, 0xad, 0x30, 0xe9,
	0x82, 0x91, 0x0f, 0x07, 0x36, 0x4d, 0xd5, 0x86, 0xd9, 0x21, 0x7c, 0x99, 0xc8, 0x63, 0x28, 0x26,
	0x50, 0x82, 0x5e, 0xac, 0xbe, 0xfd, 0xe2, 0x6c, 0x92, 0xac, 0x24, 0x41, 0xbd, 0x0b, 0x73, 0x41,
	0xc1, 0xb6, 0x7d, 0xda, 0xf6, 0xb1, 0xc3, 0x36, 0x5d, 0x99, 0xad, 0x4c, 0xa8, 0x4f, 0xa9, 0x72,
	0x42, 0xa9, 0x0f, 0xf3, 0xc3, 0x7d, 0xa5, 0x58, 0x03, 0xf2, 0x9e, 0xb4, 0xc9, 0xba, 0xdf, 0x4c,
	0x53, 0x77, 0xc9, 0x35, 0xc8, 0x9e, 0x11, 0x73, 0xd4, 0xaf, 0x14, 0xb8, 0xba, 0x41, 0x78, 0x6c,
	0x3b, 0xab, 0x58, 0xb4, 0x0d, 0x39, 0x09, 0x91, 0xdb, 0x6c, 0x54, 0x2d, 0x11, 0x46, 0xa5, 0x50,
	0x1a, 0x54, 0x22, 0x53, 0xaf, 0x43, 0xae, 0x45, 0x5d, 0x4e, 0x5c, 0x2e, 0xd7, 0xe8, 0xce, 0x48,
	0xd1, 0x04, 0x33, 0x22, 0xa9, 0xb7, 0x61, 0x76, 0x83, 0xf0, 0xc4, 0x52, 0x6e, 0xe3, 0x36, 0x39,
	0xd3, 0x4a, 0xfd, 0x9c, 0x85, 0xa9, 0x3e, 0x68, 0xb2, 0x1c, 0xca, 0x4b, 0x29, 0x07, 0xfa, 0x02,
	0x16, 0x7d, 0x4a, 0x79, 0x83, 0x11, 0xbf, 0x4b, 0xfc, 0x06, 0xb7, 0x1c, 0xcb, 0x6d, 0x37, 0x92,
	0xc7, 0x9e, 0x2c, 0xfc, 0xed, 0x34, 0x91, 0x6a, 0x09, 0x7f, 0x63, 0x3e, 0x08, 0x50, 0x17, 0xfc,
	0x1d, 0x81, 0x4f, 0x5a, 0x51, 0x13, 0xc0, 0xa5, 0x9c, 0x1c, 0x50, 0x9f, 0xef, 0x1f, 0x96, 0xb2,
	0x22, 0xd6, 0x5a, 0x9a, 0x58, 0x8f, 0x62, 0xef, 0x44, 0x8d, 0x99, 0x91, 0xa0, 0xa2, 0x27, 0x50,
	0x60, 0x56, 0xdb, 0xc5, 0xbc, 0xe3, 0x93, 0xd2, 0x84, 0xd8, 0xd3, 0x1f, 0xa6, 0x09, 0x71, 0x1f,
	0xdb, 0x76, 0x3d, 0x02, 0xd4, 0x3b, 0x8e, 0x83, 0xfd, 0x43, 0xa3, 0x87, 0x54, 0xbf, 0xcf, 0xc0,
	0xcc, 0x70, 0x19, 0x68, 0x07, 0x72, 0xcc, 0xa6, 0x07, 0x84, 0x45, 0x5b, 0xea, 0x6e, 0x9a, 0xc0,
	0xf5, 0x4e, 0x93, 0xfb, 0x24, 0x0e, 0x19, 0xa1, 0x02, 0xaa, 0x49, 0x88, 0x17, 0x50, 0x33, 0xe3,
	0x53, 0x25, 0x2a, 0xa0, 0xda, 0xd8, 0x6f, 0x07, 0xd4, 0xec, 0xf8, 0x54, 0x89, 0x52, 0x7f, 0x52,
	0x60, 0xba, 0xdf, 0x86, 0x3e, 0x81, 0x89, 0x16, 0xb6, 0x6d, 0x59, 0x91, 0x5b, 0xa9, 0x97, 0x42,
	0x86, 0x10, 0x10, 0xf4, 0x1a, 0x5c, 0x64, 0x21, 0xbe, 0xc1, 0xac, 0xe7, 0x44, 0x14, 0x24, 0x6b,
	0x14, 0xe5, 0x58, 0xdd, 0x7a, 0x4e, 0xd0, 0xeb, 0x30, 0x15, 0x4d, 0x31, 0x89, 0xc7, 0xf7, 0x45,
	0x7a, 0x59, 0x23, 0xf2, 0xab, 0x05, 0x63, 0xea, 0x77, 0x0a, 0x14, 0x13, 0x74, 0xb4, 0x0e, 0x59,
	0x9f, 0xec, 0x49, 0x8d, 0x37, 0xd2, 0x6a, 0x0c, 0x5e, 0xb2, 0xc0, 0x1f, 0xad, 0xc1, 0x25, 0xf9,
	0x6e, 0x45, 0x57, 0xb3, 0x5c, 0xb2, 0xd9, 0x81, 0x0b, 0xb3, 0x26, 0x27, 0x18, 0xd3, 0xa1, 0x47,
	0xf4, 0xac, 0xd6, 0x20, 0x27, 0x99, 0x67, 0xbd, 0xab, 0x10, 0x4c, 0x78, 0x98, 0xef, 0x97, 0x32,
	0x4b, 0xd9, 0xe5, 0x29, 0x43, 0xfc, 0x56, 0x3f, 0x87, 0xc2, 0x43, 0xc2, 0xf7, 0xa9, 0x19, 0x70,
	0x5e, 0xfe, 0x49, 0xb2, 0x08, 0x45, 0x47, 0xe0, 0x1b, 0x2e, 0x76, 0x88, 0xbc, 0x20, 0x21, 0x1c,
	0x7a, 0x84, 0x1d, 0xa2, 0x2e, 0x01, 0xf4, 0xfc, 0x02, 0x85, 0x62, 0x5e, 0x28, 0x5f, 0xfc, 0x56,
	0xff, 0xc9, 0xc2, 0x95, 0x61, 0xef, 0x1a, 0x7a, 0x08, 0x93, 0x21, 0x48, 0x8a, 0x7d, 0x2f, 0x8d,
	0xd8, 0x38, 0x69, 0x43, 0x42, 0xd0, 0x2e, 0x5c, 0x34, 0x89, 0x47, 0x5c, 0x93, 0xb8, 0x2d, 0x8b,
	0x30, 0x51, 0xa5, 0xd1, 0x2b, 0xd0, 0xc7, 0x42, 0x14, 0xae, 0x8a, 0xa5, 0xb0, 0xb8, 0xd5, 0x15,
	0xdb, 0xad, 0x17, 0x26, 0x3b, 0x56, 0x98, 0x99, 0x1e, 0xb6, 0x96, 0x0c, 0xd8, 0x85, 0xf2, 0x7f,
	0x1c, 0xde, 0x13, 0x63, 0x1e, 0xde, 0x25, 0x76, 0xda, 0xc1, 0xfd, 0x18, 0xf2, 0xe4, 0x19, 0x76,
	0x3c, 0x9b, 0xb0, 0xd2, 0x05, 0x91, 0xd9, 0x48, 0x2f, 0x49, 0x0c, 0x51, 0xdf, 0x81, 0x4b, 0x1b,
	0x84, 0x7f, 0xc4, 0x18, 0x89, 0x7b, 0x83, 0x6b, 0x00, 0x38, 0x78, 0x6e, 0x24, 0xb6, 0x4a, 0x41,
	0x8c, 0x04, 0x3b, 0xaa, 0xfa, 0xcd, 0x05, 0xc8, 0xc9, 0xa6, 0x11, 0x7d, 0xad, 0x40, 0x31, 0xd1,
	0x44, 0xa2, 0x0f, 0xd2, 0x88, 0x19, 0xec, 0x49, 0xcb, 0xf7, 0x46, 0xf6, 0x0f, 0x9b, 0x09, 0xf5,
	0x7f, 0xe8, 0x47, 0x05, 0x5e, 0x19, 0x68, 0x0a, 0x51, 0x2d, 0x15, 0xf8, 0x94, 0x9e, 0xb5, 0xbc,
	0x3e, 0x26, 0x25, 0x16, 0xf9, 0x8b, 0x02, 0x57, 0x86, 0xf5, 0x83, 0x68, 0x23, 0x6d, 0x01, 0x4e,
	0xe9, 0x46, 0xcb, 0x0f, 0xc6, 0x07, 0xc5, 0x6a, 0x7f, 0x50, 0xe0, 0xff, 0x27, 0xdb, 0x37, 0x74,
	0x3f, 0x4d, 0x80, 0x53, 0xda, 0xd0, 0x72, 0x6d, 0x3c, 0x48, 0xa4, 0xb0, 0xfa, 0x7b, 0x1e, 0xa6,
	0xc2, 0xc1, 0x35, 0x9f, 0x1e, 0x30, 0xe2, 0xa3, 0xdf, 0xce, 0xbd, 0xc2, 0xef, 0xa6, 0x01, 0x3d,
	0xe0, 0xdc, 0x5b, 0xa3, 0xe6, 0xa1, 0x3a, 0xf7, 0xe5, 0x5f, 0x7f, 0x7f, 0x9b, 0x79, 0x15, 0x5d,
	0xd6, 0x8f, 0xe2, 0x1e, 0xf4, 0x58, 0x7e, 0xbc, 0xa2, 0x3f, 0xce, 0xad, 0xd0, 0xa3, 0x89, 0x5d,
	0x11, 0x62, 0xdf, 0x42, 0xd7, 0x87, 0x88, 0xd5, 0x9b, 0x96, 0xab, 0x1f, 0xc9, 0x7b, 0x48, 0x0b,
	0x8e, 0x8a, 0xd5, 0x4a, 0xe5, 0x38, 0x48, 0xe1, 0xdc, 0x5e, 0xbf, 0xd1, 0x92, 0xd0, 0x45, 0x12,
	0xd7, 0xd1, 0x9b, 0xc3, 0x92, 0xe0, 0xcf, 0xf4, 0xa3, 0xfe, 0xab, 0xfd, 0x18, 0xfd, 0xaa, 0x00,
	0x1a, 0xfc, 0x78, 0x40, 0xeb, 0x29, 0xd7, 0x61, 0xf8, 0xc7, 0xc7, 0x88, 0x49, 0x2c, 0x88, 0x24,
	0x4a, 0x68, 0x66, 0x78, 0x12, 0xc8, 0x13, 0xc7, 0xf8, 0x16, 0xe6, 0x24, 0x3a, 0x13, 0xd1, 0xcc,
	0x40, 0xab, 0xb3, 0xee, 0x78, 0xfc, 0x70, 0x44, 0x01, 0x97, 0x84, 0x80, 0x02, 0xca, 0xe9, 0xb6,
	0x08, 0x82, 0xfe, 0x54, 0x20, 0x1f, 0xdd, 0x1c, 0xe8, 0xfd, 0x94, 0xb5, 0x49, 0xde, 0x37, 0x23,
	0x0a, 0x5a, 0x17, 0x82, 0xee, 0xa1, 0x6b, 0x7a, 0x25, 0xaa, 0xc3, 0x51, 0xef, 0xda, 0x5a, 0x6d,
	0x31, 0xa6, 0x57, 0x2a, 0xc7, 0xbb, 0x0b, 0x68, 0x7e, 0xf8, 0x84, 0xa7, 0xc2, 0xbe, 0x56, 0xdc,
	0x2d, 0xc4, 0xff, 0x1c, 0x35, 0x27, 0x45, 0xa9, 0x6e, 0xfc, 0x1b, 0x00, 0x00, 0xff, 0xff, 0x34,
	0x33, 0x09, 0x3b, 0x12, 0x13, 0x00, 0x00,
}
