// Code generated by protoc-gen-twirp v5.3.0, DO NOT EDIT.
// source: code.justin.tv/release/trace/api/report_v1/report.proto

package report_v1

import bytes "bytes"
import strings "strings"
import context "context"
import fmt "fmt"
import ioutil "io/ioutil"
import http "net/http"

import jsonpb "github.com/golang/protobuf/jsonpb"
import proto "github.com/golang/protobuf/proto"
import twirp "github.com/twitchtv/twirp"
import ctxsetters "github.com/twitchtv/twirp/ctxsetters"

import google_protobuf "github.com/golang/protobuf/ptypes/empty"

// =================
// Reports Interface
// =================

type Reports interface {
	ListReports(context.Context, *ListReportsRequest) (*ListReportsResponse, error)

	LookupTransaction(context.Context, *LookupTransactionRequest) (*LookupTransactionResponse, error)

	ListProgramsInReport(context.Context, *ListProgramsInReportRequest) (*ListProgramsInReportResponse, error)

	GetProgramReport(context.Context, *GetProgramReportRequest) (*GetProgramReportResponse, error)
}

// =======================
// Reports Protobuf Client
// =======================

type reportsProtobufClient struct {
	client HTTPClient
	urls   [4]string
}

// NewReportsProtobufClient creates a Protobuf client that implements the Reports interface.
// It communicates using Protobuf and can be configured with a custom HTTPClient.
func NewReportsProtobufClient(addr string, client HTTPClient) Reports {
	prefix := urlBase(addr) + ReportsPathPrefix
	urls := [4]string{
		prefix + "ListReports",
		prefix + "LookupTransaction",
		prefix + "ListProgramsInReport",
		prefix + "GetProgramReport",
	}
	if httpClient, ok := client.(*http.Client); ok {
		return &reportsProtobufClient{
			client: withoutRedirects(httpClient),
			urls:   urls,
		}
	}
	return &reportsProtobufClient{
		client: client,
		urls:   urls,
	}
}

func (c *reportsProtobufClient) ListReports(ctx context.Context, in *ListReportsRequest) (*ListReportsResponse, error) {
	ctx = ctxsetters.WithPackageName(ctx, "code.justin.tv.release.trace.api.report.v1")
	ctx = ctxsetters.WithServiceName(ctx, "Reports")
	ctx = ctxsetters.WithMethodName(ctx, "ListReports")
	out := new(ListReportsResponse)
	err := doProtobufRequest(ctx, c.client, c.urls[0], in, out)
	return out, err
}

func (c *reportsProtobufClient) LookupTransaction(ctx context.Context, in *LookupTransactionRequest) (*LookupTransactionResponse, error) {
	ctx = ctxsetters.WithPackageName(ctx, "code.justin.tv.release.trace.api.report.v1")
	ctx = ctxsetters.WithServiceName(ctx, "Reports")
	ctx = ctxsetters.WithMethodName(ctx, "LookupTransaction")
	out := new(LookupTransactionResponse)
	err := doProtobufRequest(ctx, c.client, c.urls[1], in, out)
	return out, err
}

func (c *reportsProtobufClient) ListProgramsInReport(ctx context.Context, in *ListProgramsInReportRequest) (*ListProgramsInReportResponse, error) {
	ctx = ctxsetters.WithPackageName(ctx, "code.justin.tv.release.trace.api.report.v1")
	ctx = ctxsetters.WithServiceName(ctx, "Reports")
	ctx = ctxsetters.WithMethodName(ctx, "ListProgramsInReport")
	out := new(ListProgramsInReportResponse)
	err := doProtobufRequest(ctx, c.client, c.urls[2], in, out)
	return out, err
}

func (c *reportsProtobufClient) GetProgramReport(ctx context.Context, in *GetProgramReportRequest) (*GetProgramReportResponse, error) {
	ctx = ctxsetters.WithPackageName(ctx, "code.justin.tv.release.trace.api.report.v1")
	ctx = ctxsetters.WithServiceName(ctx, "Reports")
	ctx = ctxsetters.WithMethodName(ctx, "GetProgramReport")
	out := new(GetProgramReportResponse)
	err := doProtobufRequest(ctx, c.client, c.urls[3], in, out)
	return out, err
}

// ===================
// Reports JSON Client
// ===================

type reportsJSONClient struct {
	client HTTPClient
	urls   [4]string
}

// NewReportsJSONClient creates a JSON client that implements the Reports interface.
// It communicates using JSON and can be configured with a custom HTTPClient.
func NewReportsJSONClient(addr string, client HTTPClient) Reports {
	prefix := urlBase(addr) + ReportsPathPrefix
	urls := [4]string{
		prefix + "ListReports",
		prefix + "LookupTransaction",
		prefix + "ListProgramsInReport",
		prefix + "GetProgramReport",
	}
	if httpClient, ok := client.(*http.Client); ok {
		return &reportsJSONClient{
			client: withoutRedirects(httpClient),
			urls:   urls,
		}
	}
	return &reportsJSONClient{
		client: client,
		urls:   urls,
	}
}

func (c *reportsJSONClient) ListReports(ctx context.Context, in *ListReportsRequest) (*ListReportsResponse, error) {
	ctx = ctxsetters.WithPackageName(ctx, "code.justin.tv.release.trace.api.report.v1")
	ctx = ctxsetters.WithServiceName(ctx, "Reports")
	ctx = ctxsetters.WithMethodName(ctx, "ListReports")
	out := new(ListReportsResponse)
	err := doJSONRequest(ctx, c.client, c.urls[0], in, out)
	return out, err
}

func (c *reportsJSONClient) LookupTransaction(ctx context.Context, in *LookupTransactionRequest) (*LookupTransactionResponse, error) {
	ctx = ctxsetters.WithPackageName(ctx, "code.justin.tv.release.trace.api.report.v1")
	ctx = ctxsetters.WithServiceName(ctx, "Reports")
	ctx = ctxsetters.WithMethodName(ctx, "LookupTransaction")
	out := new(LookupTransactionResponse)
	err := doJSONRequest(ctx, c.client, c.urls[1], in, out)
	return out, err
}

func (c *reportsJSONClient) ListProgramsInReport(ctx context.Context, in *ListProgramsInReportRequest) (*ListProgramsInReportResponse, error) {
	ctx = ctxsetters.WithPackageName(ctx, "code.justin.tv.release.trace.api.report.v1")
	ctx = ctxsetters.WithServiceName(ctx, "Reports")
	ctx = ctxsetters.WithMethodName(ctx, "ListProgramsInReport")
	out := new(ListProgramsInReportResponse)
	err := doJSONRequest(ctx, c.client, c.urls[2], in, out)
	return out, err
}

func (c *reportsJSONClient) GetProgramReport(ctx context.Context, in *GetProgramReportRequest) (*GetProgramReportResponse, error) {
	ctx = ctxsetters.WithPackageName(ctx, "code.justin.tv.release.trace.api.report.v1")
	ctx = ctxsetters.WithServiceName(ctx, "Reports")
	ctx = ctxsetters.WithMethodName(ctx, "GetProgramReport")
	out := new(GetProgramReportResponse)
	err := doJSONRequest(ctx, c.client, c.urls[3], in, out)
	return out, err
}

// ======================
// Reports Server Handler
// ======================

type reportsServer struct {
	Reports
	hooks *twirp.ServerHooks
}

func NewReportsServer(svc Reports, hooks *twirp.ServerHooks) TwirpServer {
	return &reportsServer{
		Reports: svc,
		hooks:   hooks,
	}
}

// writeError writes an HTTP response with a valid Twirp error format, and triggers hooks.
// If err is not a twirp.Error, it will get wrapped with twirp.InternalErrorWith(err)
func (s *reportsServer) writeError(ctx context.Context, resp http.ResponseWriter, err error) {
	writeError(ctx, resp, err, s.hooks)
}

// ReportsPathPrefix is used for all URL paths on a twirp Reports server.
// Requests are always: POST ReportsPathPrefix/method
// It can be used in an HTTP mux to route twirp requests along with non-twirp requests on other routes.
const ReportsPathPrefix = "/twirp/code.justin.tv.release.trace.api.report.v1.Reports/"

func (s *reportsServer) ServeHTTP(resp http.ResponseWriter, req *http.Request) {
	ctx := req.Context()
	ctx = ctxsetters.WithPackageName(ctx, "code.justin.tv.release.trace.api.report.v1")
	ctx = ctxsetters.WithServiceName(ctx, "Reports")
	ctx = ctxsetters.WithResponseWriter(ctx, resp)

	var err error
	ctx, err = callRequestReceived(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	if req.Method != "POST" {
		msg := fmt.Sprintf("unsupported method %q (only POST is allowed)", req.Method)
		err = badRouteError(msg, req.Method, req.URL.Path)
		s.writeError(ctx, resp, err)
		return
	}

	switch req.URL.Path {
	case "/twirp/code.justin.tv.release.trace.api.report.v1.Reports/ListReports":
		s.serveListReports(ctx, resp, req)
		return
	case "/twirp/code.justin.tv.release.trace.api.report.v1.Reports/LookupTransaction":
		s.serveLookupTransaction(ctx, resp, req)
		return
	case "/twirp/code.justin.tv.release.trace.api.report.v1.Reports/ListProgramsInReport":
		s.serveListProgramsInReport(ctx, resp, req)
		return
	case "/twirp/code.justin.tv.release.trace.api.report.v1.Reports/GetProgramReport":
		s.serveGetProgramReport(ctx, resp, req)
		return
	default:
		msg := fmt.Sprintf("no handler for path %q", req.URL.Path)
		err = badRouteError(msg, req.Method, req.URL.Path)
		s.writeError(ctx, resp, err)
		return
	}
}

func (s *reportsServer) serveListReports(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	header := req.Header.Get("Content-Type")
	i := strings.Index(header, ";")
	if i == -1 {
		i = len(header)
	}
	switch strings.TrimSpace(strings.ToLower(header[:i])) {
	case "application/json":
		s.serveListReportsJSON(ctx, resp, req)
	case "application/protobuf":
		s.serveListReportsProtobuf(ctx, resp, req)
	default:
		msg := fmt.Sprintf("unexpected Content-Type: %q", req.Header.Get("Content-Type"))
		twerr := badRouteError(msg, req.Method, req.URL.Path)
		s.writeError(ctx, resp, twerr)
	}
}

func (s *reportsServer) serveListReportsJSON(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "ListReports")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	reqContent := new(ListReportsRequest)
	unmarshaler := jsonpb.Unmarshaler{AllowUnknownFields: true}
	if err = unmarshaler.Unmarshal(req.Body, reqContent); err != nil {
		err = wrapErr(err, "failed to parse request json")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	// Call service method
	var respContent *ListReportsResponse
	func() {
		defer func() {
			// In case of a panic, serve a 500 error and then panic.
			if r := recover(); r != nil {
				s.writeError(ctx, resp, twirp.InternalError("Internal service panic"))
				panic(r)
			}
		}()
		respContent, err = s.ListReports(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *ListReportsResponse and nil error while calling ListReports. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	var buf bytes.Buffer
	marshaler := &jsonpb.Marshaler{OrigName: true}
	if err = marshaler.Marshal(&buf, respContent); err != nil {
		err = wrapErr(err, "failed to marshal json response")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/json")
	resp.WriteHeader(http.StatusOK)

	respBytes := buf.Bytes()
	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *reportsServer) serveListReportsProtobuf(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "ListReports")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	buf, err := ioutil.ReadAll(req.Body)
	if err != nil {
		err = wrapErr(err, "failed to read request body")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}
	reqContent := new(ListReportsRequest)
	if err = proto.Unmarshal(buf, reqContent); err != nil {
		err = wrapErr(err, "failed to parse request proto")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	// Call service method
	var respContent *ListReportsResponse
	func() {
		defer func() {
			// In case of a panic, serve a 500 error and then panic.
			if r := recover(); r != nil {
				s.writeError(ctx, resp, twirp.InternalError("Internal service panic"))
				panic(r)
			}
		}()
		respContent, err = s.ListReports(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *ListReportsResponse and nil error while calling ListReports. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	respBytes, err := proto.Marshal(respContent)
	if err != nil {
		err = wrapErr(err, "failed to marshal proto response")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/protobuf")
	resp.WriteHeader(http.StatusOK)
	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *reportsServer) serveLookupTransaction(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	header := req.Header.Get("Content-Type")
	i := strings.Index(header, ";")
	if i == -1 {
		i = len(header)
	}
	switch strings.TrimSpace(strings.ToLower(header[:i])) {
	case "application/json":
		s.serveLookupTransactionJSON(ctx, resp, req)
	case "application/protobuf":
		s.serveLookupTransactionProtobuf(ctx, resp, req)
	default:
		msg := fmt.Sprintf("unexpected Content-Type: %q", req.Header.Get("Content-Type"))
		twerr := badRouteError(msg, req.Method, req.URL.Path)
		s.writeError(ctx, resp, twerr)
	}
}

func (s *reportsServer) serveLookupTransactionJSON(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "LookupTransaction")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	reqContent := new(LookupTransactionRequest)
	unmarshaler := jsonpb.Unmarshaler{AllowUnknownFields: true}
	if err = unmarshaler.Unmarshal(req.Body, reqContent); err != nil {
		err = wrapErr(err, "failed to parse request json")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	// Call service method
	var respContent *LookupTransactionResponse
	func() {
		defer func() {
			// In case of a panic, serve a 500 error and then panic.
			if r := recover(); r != nil {
				s.writeError(ctx, resp, twirp.InternalError("Internal service panic"))
				panic(r)
			}
		}()
		respContent, err = s.LookupTransaction(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *LookupTransactionResponse and nil error while calling LookupTransaction. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	var buf bytes.Buffer
	marshaler := &jsonpb.Marshaler{OrigName: true}
	if err = marshaler.Marshal(&buf, respContent); err != nil {
		err = wrapErr(err, "failed to marshal json response")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/json")
	resp.WriteHeader(http.StatusOK)

	respBytes := buf.Bytes()
	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *reportsServer) serveLookupTransactionProtobuf(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "LookupTransaction")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	buf, err := ioutil.ReadAll(req.Body)
	if err != nil {
		err = wrapErr(err, "failed to read request body")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}
	reqContent := new(LookupTransactionRequest)
	if err = proto.Unmarshal(buf, reqContent); err != nil {
		err = wrapErr(err, "failed to parse request proto")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	// Call service method
	var respContent *LookupTransactionResponse
	func() {
		defer func() {
			// In case of a panic, serve a 500 error and then panic.
			if r := recover(); r != nil {
				s.writeError(ctx, resp, twirp.InternalError("Internal service panic"))
				panic(r)
			}
		}()
		respContent, err = s.LookupTransaction(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *LookupTransactionResponse and nil error while calling LookupTransaction. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	respBytes, err := proto.Marshal(respContent)
	if err != nil {
		err = wrapErr(err, "failed to marshal proto response")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/protobuf")
	resp.WriteHeader(http.StatusOK)
	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *reportsServer) serveListProgramsInReport(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	header := req.Header.Get("Content-Type")
	i := strings.Index(header, ";")
	if i == -1 {
		i = len(header)
	}
	switch strings.TrimSpace(strings.ToLower(header[:i])) {
	case "application/json":
		s.serveListProgramsInReportJSON(ctx, resp, req)
	case "application/protobuf":
		s.serveListProgramsInReportProtobuf(ctx, resp, req)
	default:
		msg := fmt.Sprintf("unexpected Content-Type: %q", req.Header.Get("Content-Type"))
		twerr := badRouteError(msg, req.Method, req.URL.Path)
		s.writeError(ctx, resp, twerr)
	}
}

func (s *reportsServer) serveListProgramsInReportJSON(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "ListProgramsInReport")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	reqContent := new(ListProgramsInReportRequest)
	unmarshaler := jsonpb.Unmarshaler{AllowUnknownFields: true}
	if err = unmarshaler.Unmarshal(req.Body, reqContent); err != nil {
		err = wrapErr(err, "failed to parse request json")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	// Call service method
	var respContent *ListProgramsInReportResponse
	func() {
		defer func() {
			// In case of a panic, serve a 500 error and then panic.
			if r := recover(); r != nil {
				s.writeError(ctx, resp, twirp.InternalError("Internal service panic"))
				panic(r)
			}
		}()
		respContent, err = s.ListProgramsInReport(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *ListProgramsInReportResponse and nil error while calling ListProgramsInReport. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	var buf bytes.Buffer
	marshaler := &jsonpb.Marshaler{OrigName: true}
	if err = marshaler.Marshal(&buf, respContent); err != nil {
		err = wrapErr(err, "failed to marshal json response")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/json")
	resp.WriteHeader(http.StatusOK)

	respBytes := buf.Bytes()
	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *reportsServer) serveListProgramsInReportProtobuf(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "ListProgramsInReport")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	buf, err := ioutil.ReadAll(req.Body)
	if err != nil {
		err = wrapErr(err, "failed to read request body")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}
	reqContent := new(ListProgramsInReportRequest)
	if err = proto.Unmarshal(buf, reqContent); err != nil {
		err = wrapErr(err, "failed to parse request proto")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	// Call service method
	var respContent *ListProgramsInReportResponse
	func() {
		defer func() {
			// In case of a panic, serve a 500 error and then panic.
			if r := recover(); r != nil {
				s.writeError(ctx, resp, twirp.InternalError("Internal service panic"))
				panic(r)
			}
		}()
		respContent, err = s.ListProgramsInReport(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *ListProgramsInReportResponse and nil error while calling ListProgramsInReport. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	respBytes, err := proto.Marshal(respContent)
	if err != nil {
		err = wrapErr(err, "failed to marshal proto response")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/protobuf")
	resp.WriteHeader(http.StatusOK)
	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *reportsServer) serveGetProgramReport(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	header := req.Header.Get("Content-Type")
	i := strings.Index(header, ";")
	if i == -1 {
		i = len(header)
	}
	switch strings.TrimSpace(strings.ToLower(header[:i])) {
	case "application/json":
		s.serveGetProgramReportJSON(ctx, resp, req)
	case "application/protobuf":
		s.serveGetProgramReportProtobuf(ctx, resp, req)
	default:
		msg := fmt.Sprintf("unexpected Content-Type: %q", req.Header.Get("Content-Type"))
		twerr := badRouteError(msg, req.Method, req.URL.Path)
		s.writeError(ctx, resp, twerr)
	}
}

func (s *reportsServer) serveGetProgramReportJSON(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "GetProgramReport")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	reqContent := new(GetProgramReportRequest)
	unmarshaler := jsonpb.Unmarshaler{AllowUnknownFields: true}
	if err = unmarshaler.Unmarshal(req.Body, reqContent); err != nil {
		err = wrapErr(err, "failed to parse request json")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	// Call service method
	var respContent *GetProgramReportResponse
	func() {
		defer func() {
			// In case of a panic, serve a 500 error and then panic.
			if r := recover(); r != nil {
				s.writeError(ctx, resp, twirp.InternalError("Internal service panic"))
				panic(r)
			}
		}()
		respContent, err = s.GetProgramReport(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *GetProgramReportResponse and nil error while calling GetProgramReport. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	var buf bytes.Buffer
	marshaler := &jsonpb.Marshaler{OrigName: true}
	if err = marshaler.Marshal(&buf, respContent); err != nil {
		err = wrapErr(err, "failed to marshal json response")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/json")
	resp.WriteHeader(http.StatusOK)

	respBytes := buf.Bytes()
	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *reportsServer) serveGetProgramReportProtobuf(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "GetProgramReport")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	buf, err := ioutil.ReadAll(req.Body)
	if err != nil {
		err = wrapErr(err, "failed to read request body")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}
	reqContent := new(GetProgramReportRequest)
	if err = proto.Unmarshal(buf, reqContent); err != nil {
		err = wrapErr(err, "failed to parse request proto")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	// Call service method
	var respContent *GetProgramReportResponse
	func() {
		defer func() {
			// In case of a panic, serve a 500 error and then panic.
			if r := recover(); r != nil {
				s.writeError(ctx, resp, twirp.InternalError("Internal service panic"))
				panic(r)
			}
		}()
		respContent, err = s.GetProgramReport(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *GetProgramReportResponse and nil error while calling GetProgramReport. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	respBytes, err := proto.Marshal(respContent)
	if err != nil {
		err = wrapErr(err, "failed to marshal proto response")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/protobuf")
	resp.WriteHeader(http.StatusOK)
	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *reportsServer) ServiceDescriptor() ([]byte, int) {
	return twirpFileDescriptor1, 0
}

func (s *reportsServer) ProtocGenTwirpVersion() string {
	return "v5.3.0"
}

// =======================
// ReportBrowser Interface
// =======================

type ReportBrowser interface {
	ListProgramsInReport(context.Context, *ListProgramsInReportRequest) (*HttpBody, error)

	GetProgramReport(context.Context, *GetProgramReportRequest) (*HttpBody, error)

	LookupTransaction(context.Context, *LookupTransactionRequest) (*HttpBody, error)

	GetTransactionPage(context.Context, *GetTransactionPageRequest) (*HttpBody, error)

	GetLatestReport(context.Context, *google_protobuf.Empty) (*HttpBody, error)

	GetAsset(context.Context, *GetAssetRequest) (*HttpBody, error)
}

// =============================
// ReportBrowser Protobuf Client
// =============================

type reportBrowserProtobufClient struct {
	client HTTPClient
	urls   [6]string
}

// NewReportBrowserProtobufClient creates a Protobuf client that implements the ReportBrowser interface.
// It communicates using Protobuf and can be configured with a custom HTTPClient.
func NewReportBrowserProtobufClient(addr string, client HTTPClient) ReportBrowser {
	prefix := urlBase(addr) + ReportBrowserPathPrefix
	urls := [6]string{
		prefix + "ListProgramsInReport",
		prefix + "GetProgramReport",
		prefix + "LookupTransaction",
		prefix + "GetTransactionPage",
		prefix + "GetLatestReport",
		prefix + "GetAsset",
	}
	if httpClient, ok := client.(*http.Client); ok {
		return &reportBrowserProtobufClient{
			client: withoutRedirects(httpClient),
			urls:   urls,
		}
	}
	return &reportBrowserProtobufClient{
		client: client,
		urls:   urls,
	}
}

func (c *reportBrowserProtobufClient) ListProgramsInReport(ctx context.Context, in *ListProgramsInReportRequest) (*HttpBody, error) {
	ctx = ctxsetters.WithPackageName(ctx, "code.justin.tv.release.trace.api.report.v1")
	ctx = ctxsetters.WithServiceName(ctx, "ReportBrowser")
	ctx = ctxsetters.WithMethodName(ctx, "ListProgramsInReport")
	out := new(HttpBody)
	err := doProtobufRequest(ctx, c.client, c.urls[0], in, out)
	return out, err
}

func (c *reportBrowserProtobufClient) GetProgramReport(ctx context.Context, in *GetProgramReportRequest) (*HttpBody, error) {
	ctx = ctxsetters.WithPackageName(ctx, "code.justin.tv.release.trace.api.report.v1")
	ctx = ctxsetters.WithServiceName(ctx, "ReportBrowser")
	ctx = ctxsetters.WithMethodName(ctx, "GetProgramReport")
	out := new(HttpBody)
	err := doProtobufRequest(ctx, c.client, c.urls[1], in, out)
	return out, err
}

func (c *reportBrowserProtobufClient) LookupTransaction(ctx context.Context, in *LookupTransactionRequest) (*HttpBody, error) {
	ctx = ctxsetters.WithPackageName(ctx, "code.justin.tv.release.trace.api.report.v1")
	ctx = ctxsetters.WithServiceName(ctx, "ReportBrowser")
	ctx = ctxsetters.WithMethodName(ctx, "LookupTransaction")
	out := new(HttpBody)
	err := doProtobufRequest(ctx, c.client, c.urls[2], in, out)
	return out, err
}

func (c *reportBrowserProtobufClient) GetTransactionPage(ctx context.Context, in *GetTransactionPageRequest) (*HttpBody, error) {
	ctx = ctxsetters.WithPackageName(ctx, "code.justin.tv.release.trace.api.report.v1")
	ctx = ctxsetters.WithServiceName(ctx, "ReportBrowser")
	ctx = ctxsetters.WithMethodName(ctx, "GetTransactionPage")
	out := new(HttpBody)
	err := doProtobufRequest(ctx, c.client, c.urls[3], in, out)
	return out, err
}

func (c *reportBrowserProtobufClient) GetLatestReport(ctx context.Context, in *google_protobuf.Empty) (*HttpBody, error) {
	ctx = ctxsetters.WithPackageName(ctx, "code.justin.tv.release.trace.api.report.v1")
	ctx = ctxsetters.WithServiceName(ctx, "ReportBrowser")
	ctx = ctxsetters.WithMethodName(ctx, "GetLatestReport")
	out := new(HttpBody)
	err := doProtobufRequest(ctx, c.client, c.urls[4], in, out)
	return out, err
}

func (c *reportBrowserProtobufClient) GetAsset(ctx context.Context, in *GetAssetRequest) (*HttpBody, error) {
	ctx = ctxsetters.WithPackageName(ctx, "code.justin.tv.release.trace.api.report.v1")
	ctx = ctxsetters.WithServiceName(ctx, "ReportBrowser")
	ctx = ctxsetters.WithMethodName(ctx, "GetAsset")
	out := new(HttpBody)
	err := doProtobufRequest(ctx, c.client, c.urls[5], in, out)
	return out, err
}

// =========================
// ReportBrowser JSON Client
// =========================

type reportBrowserJSONClient struct {
	client HTTPClient
	urls   [6]string
}

// NewReportBrowserJSONClient creates a JSON client that implements the ReportBrowser interface.
// It communicates using JSON and can be configured with a custom HTTPClient.
func NewReportBrowserJSONClient(addr string, client HTTPClient) ReportBrowser {
	prefix := urlBase(addr) + ReportBrowserPathPrefix
	urls := [6]string{
		prefix + "ListProgramsInReport",
		prefix + "GetProgramReport",
		prefix + "LookupTransaction",
		prefix + "GetTransactionPage",
		prefix + "GetLatestReport",
		prefix + "GetAsset",
	}
	if httpClient, ok := client.(*http.Client); ok {
		return &reportBrowserJSONClient{
			client: withoutRedirects(httpClient),
			urls:   urls,
		}
	}
	return &reportBrowserJSONClient{
		client: client,
		urls:   urls,
	}
}

func (c *reportBrowserJSONClient) ListProgramsInReport(ctx context.Context, in *ListProgramsInReportRequest) (*HttpBody, error) {
	ctx = ctxsetters.WithPackageName(ctx, "code.justin.tv.release.trace.api.report.v1")
	ctx = ctxsetters.WithServiceName(ctx, "ReportBrowser")
	ctx = ctxsetters.WithMethodName(ctx, "ListProgramsInReport")
	out := new(HttpBody)
	err := doJSONRequest(ctx, c.client, c.urls[0], in, out)
	return out, err
}

func (c *reportBrowserJSONClient) GetProgramReport(ctx context.Context, in *GetProgramReportRequest) (*HttpBody, error) {
	ctx = ctxsetters.WithPackageName(ctx, "code.justin.tv.release.trace.api.report.v1")
	ctx = ctxsetters.WithServiceName(ctx, "ReportBrowser")
	ctx = ctxsetters.WithMethodName(ctx, "GetProgramReport")
	out := new(HttpBody)
	err := doJSONRequest(ctx, c.client, c.urls[1], in, out)
	return out, err
}

func (c *reportBrowserJSONClient) LookupTransaction(ctx context.Context, in *LookupTransactionRequest) (*HttpBody, error) {
	ctx = ctxsetters.WithPackageName(ctx, "code.justin.tv.release.trace.api.report.v1")
	ctx = ctxsetters.WithServiceName(ctx, "ReportBrowser")
	ctx = ctxsetters.WithMethodName(ctx, "LookupTransaction")
	out := new(HttpBody)
	err := doJSONRequest(ctx, c.client, c.urls[2], in, out)
	return out, err
}

func (c *reportBrowserJSONClient) GetTransactionPage(ctx context.Context, in *GetTransactionPageRequest) (*HttpBody, error) {
	ctx = ctxsetters.WithPackageName(ctx, "code.justin.tv.release.trace.api.report.v1")
	ctx = ctxsetters.WithServiceName(ctx, "ReportBrowser")
	ctx = ctxsetters.WithMethodName(ctx, "GetTransactionPage")
	out := new(HttpBody)
	err := doJSONRequest(ctx, c.client, c.urls[3], in, out)
	return out, err
}

func (c *reportBrowserJSONClient) GetLatestReport(ctx context.Context, in *google_protobuf.Empty) (*HttpBody, error) {
	ctx = ctxsetters.WithPackageName(ctx, "code.justin.tv.release.trace.api.report.v1")
	ctx = ctxsetters.WithServiceName(ctx, "ReportBrowser")
	ctx = ctxsetters.WithMethodName(ctx, "GetLatestReport")
	out := new(HttpBody)
	err := doJSONRequest(ctx, c.client, c.urls[4], in, out)
	return out, err
}

func (c *reportBrowserJSONClient) GetAsset(ctx context.Context, in *GetAssetRequest) (*HttpBody, error) {
	ctx = ctxsetters.WithPackageName(ctx, "code.justin.tv.release.trace.api.report.v1")
	ctx = ctxsetters.WithServiceName(ctx, "ReportBrowser")
	ctx = ctxsetters.WithMethodName(ctx, "GetAsset")
	out := new(HttpBody)
	err := doJSONRequest(ctx, c.client, c.urls[5], in, out)
	return out, err
}

// ============================
// ReportBrowser Server Handler
// ============================

type reportBrowserServer struct {
	ReportBrowser
	hooks *twirp.ServerHooks
}

func NewReportBrowserServer(svc ReportBrowser, hooks *twirp.ServerHooks) TwirpServer {
	return &reportBrowserServer{
		ReportBrowser: svc,
		hooks:         hooks,
	}
}

// writeError writes an HTTP response with a valid Twirp error format, and triggers hooks.
// If err is not a twirp.Error, it will get wrapped with twirp.InternalErrorWith(err)
func (s *reportBrowserServer) writeError(ctx context.Context, resp http.ResponseWriter, err error) {
	writeError(ctx, resp, err, s.hooks)
}

// ReportBrowserPathPrefix is used for all URL paths on a twirp ReportBrowser server.
// Requests are always: POST ReportBrowserPathPrefix/method
// It can be used in an HTTP mux to route twirp requests along with non-twirp requests on other routes.
const ReportBrowserPathPrefix = "/twirp/code.justin.tv.release.trace.api.report.v1.ReportBrowser/"

func (s *reportBrowserServer) ServeHTTP(resp http.ResponseWriter, req *http.Request) {
	ctx := req.Context()
	ctx = ctxsetters.WithPackageName(ctx, "code.justin.tv.release.trace.api.report.v1")
	ctx = ctxsetters.WithServiceName(ctx, "ReportBrowser")
	ctx = ctxsetters.WithResponseWriter(ctx, resp)

	var err error
	ctx, err = callRequestReceived(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	if req.Method != "POST" {
		msg := fmt.Sprintf("unsupported method %q (only POST is allowed)", req.Method)
		err = badRouteError(msg, req.Method, req.URL.Path)
		s.writeError(ctx, resp, err)
		return
	}

	switch req.URL.Path {
	case "/twirp/code.justin.tv.release.trace.api.report.v1.ReportBrowser/ListProgramsInReport":
		s.serveListProgramsInReport(ctx, resp, req)
		return
	case "/twirp/code.justin.tv.release.trace.api.report.v1.ReportBrowser/GetProgramReport":
		s.serveGetProgramReport(ctx, resp, req)
		return
	case "/twirp/code.justin.tv.release.trace.api.report.v1.ReportBrowser/LookupTransaction":
		s.serveLookupTransaction(ctx, resp, req)
		return
	case "/twirp/code.justin.tv.release.trace.api.report.v1.ReportBrowser/GetTransactionPage":
		s.serveGetTransactionPage(ctx, resp, req)
		return
	case "/twirp/code.justin.tv.release.trace.api.report.v1.ReportBrowser/GetLatestReport":
		s.serveGetLatestReport(ctx, resp, req)
		return
	case "/twirp/code.justin.tv.release.trace.api.report.v1.ReportBrowser/GetAsset":
		s.serveGetAsset(ctx, resp, req)
		return
	default:
		msg := fmt.Sprintf("no handler for path %q", req.URL.Path)
		err = badRouteError(msg, req.Method, req.URL.Path)
		s.writeError(ctx, resp, err)
		return
	}
}

func (s *reportBrowserServer) serveListProgramsInReport(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	header := req.Header.Get("Content-Type")
	i := strings.Index(header, ";")
	if i == -1 {
		i = len(header)
	}
	switch strings.TrimSpace(strings.ToLower(header[:i])) {
	case "application/json":
		s.serveListProgramsInReportJSON(ctx, resp, req)
	case "application/protobuf":
		s.serveListProgramsInReportProtobuf(ctx, resp, req)
	default:
		msg := fmt.Sprintf("unexpected Content-Type: %q", req.Header.Get("Content-Type"))
		twerr := badRouteError(msg, req.Method, req.URL.Path)
		s.writeError(ctx, resp, twerr)
	}
}

func (s *reportBrowserServer) serveListProgramsInReportJSON(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "ListProgramsInReport")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	reqContent := new(ListProgramsInReportRequest)
	unmarshaler := jsonpb.Unmarshaler{AllowUnknownFields: true}
	if err = unmarshaler.Unmarshal(req.Body, reqContent); err != nil {
		err = wrapErr(err, "failed to parse request json")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	// Call service method
	var respContent *HttpBody
	func() {
		defer func() {
			// In case of a panic, serve a 500 error and then panic.
			if r := recover(); r != nil {
				s.writeError(ctx, resp, twirp.InternalError("Internal service panic"))
				panic(r)
			}
		}()
		respContent, err = s.ListProgramsInReport(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *HttpBody and nil error while calling ListProgramsInReport. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	var buf bytes.Buffer
	marshaler := &jsonpb.Marshaler{OrigName: true}
	if err = marshaler.Marshal(&buf, respContent); err != nil {
		err = wrapErr(err, "failed to marshal json response")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/json")
	resp.WriteHeader(http.StatusOK)

	respBytes := buf.Bytes()
	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *reportBrowserServer) serveListProgramsInReportProtobuf(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "ListProgramsInReport")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	buf, err := ioutil.ReadAll(req.Body)
	if err != nil {
		err = wrapErr(err, "failed to read request body")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}
	reqContent := new(ListProgramsInReportRequest)
	if err = proto.Unmarshal(buf, reqContent); err != nil {
		err = wrapErr(err, "failed to parse request proto")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	// Call service method
	var respContent *HttpBody
	func() {
		defer func() {
			// In case of a panic, serve a 500 error and then panic.
			if r := recover(); r != nil {
				s.writeError(ctx, resp, twirp.InternalError("Internal service panic"))
				panic(r)
			}
		}()
		respContent, err = s.ListProgramsInReport(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *HttpBody and nil error while calling ListProgramsInReport. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	respBytes, err := proto.Marshal(respContent)
	if err != nil {
		err = wrapErr(err, "failed to marshal proto response")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/protobuf")
	resp.WriteHeader(http.StatusOK)
	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *reportBrowserServer) serveGetProgramReport(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	header := req.Header.Get("Content-Type")
	i := strings.Index(header, ";")
	if i == -1 {
		i = len(header)
	}
	switch strings.TrimSpace(strings.ToLower(header[:i])) {
	case "application/json":
		s.serveGetProgramReportJSON(ctx, resp, req)
	case "application/protobuf":
		s.serveGetProgramReportProtobuf(ctx, resp, req)
	default:
		msg := fmt.Sprintf("unexpected Content-Type: %q", req.Header.Get("Content-Type"))
		twerr := badRouteError(msg, req.Method, req.URL.Path)
		s.writeError(ctx, resp, twerr)
	}
}

func (s *reportBrowserServer) serveGetProgramReportJSON(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "GetProgramReport")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	reqContent := new(GetProgramReportRequest)
	unmarshaler := jsonpb.Unmarshaler{AllowUnknownFields: true}
	if err = unmarshaler.Unmarshal(req.Body, reqContent); err != nil {
		err = wrapErr(err, "failed to parse request json")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	// Call service method
	var respContent *HttpBody
	func() {
		defer func() {
			// In case of a panic, serve a 500 error and then panic.
			if r := recover(); r != nil {
				s.writeError(ctx, resp, twirp.InternalError("Internal service panic"))
				panic(r)
			}
		}()
		respContent, err = s.GetProgramReport(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *HttpBody and nil error while calling GetProgramReport. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	var buf bytes.Buffer
	marshaler := &jsonpb.Marshaler{OrigName: true}
	if err = marshaler.Marshal(&buf, respContent); err != nil {
		err = wrapErr(err, "failed to marshal json response")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/json")
	resp.WriteHeader(http.StatusOK)

	respBytes := buf.Bytes()
	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *reportBrowserServer) serveGetProgramReportProtobuf(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "GetProgramReport")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	buf, err := ioutil.ReadAll(req.Body)
	if err != nil {
		err = wrapErr(err, "failed to read request body")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}
	reqContent := new(GetProgramReportRequest)
	if err = proto.Unmarshal(buf, reqContent); err != nil {
		err = wrapErr(err, "failed to parse request proto")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	// Call service method
	var respContent *HttpBody
	func() {
		defer func() {
			// In case of a panic, serve a 500 error and then panic.
			if r := recover(); r != nil {
				s.writeError(ctx, resp, twirp.InternalError("Internal service panic"))
				panic(r)
			}
		}()
		respContent, err = s.GetProgramReport(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *HttpBody and nil error while calling GetProgramReport. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	respBytes, err := proto.Marshal(respContent)
	if err != nil {
		err = wrapErr(err, "failed to marshal proto response")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/protobuf")
	resp.WriteHeader(http.StatusOK)
	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *reportBrowserServer) serveLookupTransaction(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	header := req.Header.Get("Content-Type")
	i := strings.Index(header, ";")
	if i == -1 {
		i = len(header)
	}
	switch strings.TrimSpace(strings.ToLower(header[:i])) {
	case "application/json":
		s.serveLookupTransactionJSON(ctx, resp, req)
	case "application/protobuf":
		s.serveLookupTransactionProtobuf(ctx, resp, req)
	default:
		msg := fmt.Sprintf("unexpected Content-Type: %q", req.Header.Get("Content-Type"))
		twerr := badRouteError(msg, req.Method, req.URL.Path)
		s.writeError(ctx, resp, twerr)
	}
}

func (s *reportBrowserServer) serveLookupTransactionJSON(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "LookupTransaction")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	reqContent := new(LookupTransactionRequest)
	unmarshaler := jsonpb.Unmarshaler{AllowUnknownFields: true}
	if err = unmarshaler.Unmarshal(req.Body, reqContent); err != nil {
		err = wrapErr(err, "failed to parse request json")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	// Call service method
	var respContent *HttpBody
	func() {
		defer func() {
			// In case of a panic, serve a 500 error and then panic.
			if r := recover(); r != nil {
				s.writeError(ctx, resp, twirp.InternalError("Internal service panic"))
				panic(r)
			}
		}()
		respContent, err = s.LookupTransaction(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *HttpBody and nil error while calling LookupTransaction. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	var buf bytes.Buffer
	marshaler := &jsonpb.Marshaler{OrigName: true}
	if err = marshaler.Marshal(&buf, respContent); err != nil {
		err = wrapErr(err, "failed to marshal json response")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/json")
	resp.WriteHeader(http.StatusOK)

	respBytes := buf.Bytes()
	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *reportBrowserServer) serveLookupTransactionProtobuf(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "LookupTransaction")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	buf, err := ioutil.ReadAll(req.Body)
	if err != nil {
		err = wrapErr(err, "failed to read request body")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}
	reqContent := new(LookupTransactionRequest)
	if err = proto.Unmarshal(buf, reqContent); err != nil {
		err = wrapErr(err, "failed to parse request proto")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	// Call service method
	var respContent *HttpBody
	func() {
		defer func() {
			// In case of a panic, serve a 500 error and then panic.
			if r := recover(); r != nil {
				s.writeError(ctx, resp, twirp.InternalError("Internal service panic"))
				panic(r)
			}
		}()
		respContent, err = s.LookupTransaction(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *HttpBody and nil error while calling LookupTransaction. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	respBytes, err := proto.Marshal(respContent)
	if err != nil {
		err = wrapErr(err, "failed to marshal proto response")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/protobuf")
	resp.WriteHeader(http.StatusOK)
	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *reportBrowserServer) serveGetTransactionPage(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	header := req.Header.Get("Content-Type")
	i := strings.Index(header, ";")
	if i == -1 {
		i = len(header)
	}
	switch strings.TrimSpace(strings.ToLower(header[:i])) {
	case "application/json":
		s.serveGetTransactionPageJSON(ctx, resp, req)
	case "application/protobuf":
		s.serveGetTransactionPageProtobuf(ctx, resp, req)
	default:
		msg := fmt.Sprintf("unexpected Content-Type: %q", req.Header.Get("Content-Type"))
		twerr := badRouteError(msg, req.Method, req.URL.Path)
		s.writeError(ctx, resp, twerr)
	}
}

func (s *reportBrowserServer) serveGetTransactionPageJSON(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "GetTransactionPage")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	reqContent := new(GetTransactionPageRequest)
	unmarshaler := jsonpb.Unmarshaler{AllowUnknownFields: true}
	if err = unmarshaler.Unmarshal(req.Body, reqContent); err != nil {
		err = wrapErr(err, "failed to parse request json")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	// Call service method
	var respContent *HttpBody
	func() {
		defer func() {
			// In case of a panic, serve a 500 error and then panic.
			if r := recover(); r != nil {
				s.writeError(ctx, resp, twirp.InternalError("Internal service panic"))
				panic(r)
			}
		}()
		respContent, err = s.GetTransactionPage(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *HttpBody and nil error while calling GetTransactionPage. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	var buf bytes.Buffer
	marshaler := &jsonpb.Marshaler{OrigName: true}
	if err = marshaler.Marshal(&buf, respContent); err != nil {
		err = wrapErr(err, "failed to marshal json response")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/json")
	resp.WriteHeader(http.StatusOK)

	respBytes := buf.Bytes()
	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *reportBrowserServer) serveGetTransactionPageProtobuf(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "GetTransactionPage")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	buf, err := ioutil.ReadAll(req.Body)
	if err != nil {
		err = wrapErr(err, "failed to read request body")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}
	reqContent := new(GetTransactionPageRequest)
	if err = proto.Unmarshal(buf, reqContent); err != nil {
		err = wrapErr(err, "failed to parse request proto")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	// Call service method
	var respContent *HttpBody
	func() {
		defer func() {
			// In case of a panic, serve a 500 error and then panic.
			if r := recover(); r != nil {
				s.writeError(ctx, resp, twirp.InternalError("Internal service panic"))
				panic(r)
			}
		}()
		respContent, err = s.GetTransactionPage(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *HttpBody and nil error while calling GetTransactionPage. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	respBytes, err := proto.Marshal(respContent)
	if err != nil {
		err = wrapErr(err, "failed to marshal proto response")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/protobuf")
	resp.WriteHeader(http.StatusOK)
	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *reportBrowserServer) serveGetLatestReport(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	header := req.Header.Get("Content-Type")
	i := strings.Index(header, ";")
	if i == -1 {
		i = len(header)
	}
	switch strings.TrimSpace(strings.ToLower(header[:i])) {
	case "application/json":
		s.serveGetLatestReportJSON(ctx, resp, req)
	case "application/protobuf":
		s.serveGetLatestReportProtobuf(ctx, resp, req)
	default:
		msg := fmt.Sprintf("unexpected Content-Type: %q", req.Header.Get("Content-Type"))
		twerr := badRouteError(msg, req.Method, req.URL.Path)
		s.writeError(ctx, resp, twerr)
	}
}

func (s *reportBrowserServer) serveGetLatestReportJSON(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "GetLatestReport")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	reqContent := new(google_protobuf.Empty)
	unmarshaler := jsonpb.Unmarshaler{AllowUnknownFields: true}
	if err = unmarshaler.Unmarshal(req.Body, reqContent); err != nil {
		err = wrapErr(err, "failed to parse request json")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	// Call service method
	var respContent *HttpBody
	func() {
		defer func() {
			// In case of a panic, serve a 500 error and then panic.
			if r := recover(); r != nil {
				s.writeError(ctx, resp, twirp.InternalError("Internal service panic"))
				panic(r)
			}
		}()
		respContent, err = s.GetLatestReport(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *HttpBody and nil error while calling GetLatestReport. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	var buf bytes.Buffer
	marshaler := &jsonpb.Marshaler{OrigName: true}
	if err = marshaler.Marshal(&buf, respContent); err != nil {
		err = wrapErr(err, "failed to marshal json response")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/json")
	resp.WriteHeader(http.StatusOK)

	respBytes := buf.Bytes()
	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *reportBrowserServer) serveGetLatestReportProtobuf(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "GetLatestReport")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	buf, err := ioutil.ReadAll(req.Body)
	if err != nil {
		err = wrapErr(err, "failed to read request body")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}
	reqContent := new(google_protobuf.Empty)
	if err = proto.Unmarshal(buf, reqContent); err != nil {
		err = wrapErr(err, "failed to parse request proto")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	// Call service method
	var respContent *HttpBody
	func() {
		defer func() {
			// In case of a panic, serve a 500 error and then panic.
			if r := recover(); r != nil {
				s.writeError(ctx, resp, twirp.InternalError("Internal service panic"))
				panic(r)
			}
		}()
		respContent, err = s.GetLatestReport(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *HttpBody and nil error while calling GetLatestReport. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	respBytes, err := proto.Marshal(respContent)
	if err != nil {
		err = wrapErr(err, "failed to marshal proto response")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/protobuf")
	resp.WriteHeader(http.StatusOK)
	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *reportBrowserServer) serveGetAsset(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	header := req.Header.Get("Content-Type")
	i := strings.Index(header, ";")
	if i == -1 {
		i = len(header)
	}
	switch strings.TrimSpace(strings.ToLower(header[:i])) {
	case "application/json":
		s.serveGetAssetJSON(ctx, resp, req)
	case "application/protobuf":
		s.serveGetAssetProtobuf(ctx, resp, req)
	default:
		msg := fmt.Sprintf("unexpected Content-Type: %q", req.Header.Get("Content-Type"))
		twerr := badRouteError(msg, req.Method, req.URL.Path)
		s.writeError(ctx, resp, twerr)
	}
}

func (s *reportBrowserServer) serveGetAssetJSON(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "GetAsset")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	reqContent := new(GetAssetRequest)
	unmarshaler := jsonpb.Unmarshaler{AllowUnknownFields: true}
	if err = unmarshaler.Unmarshal(req.Body, reqContent); err != nil {
		err = wrapErr(err, "failed to parse request json")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	// Call service method
	var respContent *HttpBody
	func() {
		defer func() {
			// In case of a panic, serve a 500 error and then panic.
			if r := recover(); r != nil {
				s.writeError(ctx, resp, twirp.InternalError("Internal service panic"))
				panic(r)
			}
		}()
		respContent, err = s.GetAsset(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *HttpBody and nil error while calling GetAsset. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	var buf bytes.Buffer
	marshaler := &jsonpb.Marshaler{OrigName: true}
	if err = marshaler.Marshal(&buf, respContent); err != nil {
		err = wrapErr(err, "failed to marshal json response")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/json")
	resp.WriteHeader(http.StatusOK)

	respBytes := buf.Bytes()
	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *reportBrowserServer) serveGetAssetProtobuf(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "GetAsset")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	buf, err := ioutil.ReadAll(req.Body)
	if err != nil {
		err = wrapErr(err, "failed to read request body")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}
	reqContent := new(GetAssetRequest)
	if err = proto.Unmarshal(buf, reqContent); err != nil {
		err = wrapErr(err, "failed to parse request proto")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	// Call service method
	var respContent *HttpBody
	func() {
		defer func() {
			// In case of a panic, serve a 500 error and then panic.
			if r := recover(); r != nil {
				s.writeError(ctx, resp, twirp.InternalError("Internal service panic"))
				panic(r)
			}
		}()
		respContent, err = s.GetAsset(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *HttpBody and nil error while calling GetAsset. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	respBytes, err := proto.Marshal(respContent)
	if err != nil {
		err = wrapErr(err, "failed to marshal proto response")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/protobuf")
	resp.WriteHeader(http.StatusOK)
	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *reportBrowserServer) ServiceDescriptor() ([]byte, int) {
	return twirpFileDescriptor1, 1
}

func (s *reportBrowserServer) ProtocGenTwirpVersion() string {
	return "v5.3.0"
}

var twirpFileDescriptor1 = []byte{
	// 1239 bytes of a gzipped FileDescriptorProto
	0x1f, 0x8b, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0xff, 0xb4, 0x98, 0x4f, 0x73, 0xdb, 0xc4,
	0x1b, 0xc7, 0x7f, 0xb2, 0xd3, 0xd8, 0x7e, 0xdc, 0xa4, 0x3f, 0xb6, 0x25, 0x75, 0x9c, 0x34, 0x09,
	0x62, 0x18, 0x52, 0x33, 0x48, 0xc4, 0x85, 0xfe, 0x63, 0x42, 0x21, 0x75, 0x26, 0x0d, 0xa4, 0x6d,
	0x46, 0xce, 0x29, 0x87, 0x7a, 0xd6, 0xd6, 0xc6, 0x51, 0x91, 0xb4, 0x42, 0xbb, 0x76, 0x9a, 0x66,
	0x02, 0x33, 0x9c, 0x38, 0xc2, 0x70, 0x61, 0xb8, 0x30, 0xc3, 0x0c, 0x5c, 0x38, 0xc1, 0x85, 0x2b,
	0x07, 0xde, 0x01, 0x6f, 0x81, 0x77, 0xc1, 0x85, 0xd1, 0x6a, 0x25, 0xcb, 0xb1, 0x43, 0x23, 0xbb,
	0xb9, 0x59, 0xfb, 0xec, 0xf3, 0x79, 0xbe, 0xcf, 0xb3, 0xab, 0xdd, 0x47, 0x86, 0x5b, 0x2d, 0x6a,
	0x12, 0xed, 0x69, 0x87, 0x71, 0xcb, 0xd5, 0x78, 0x57, 0xf7, 0x89, 0x4d, 0x30, 0x23, 0x3a, 0xf7,
	0x71, 0x8b, 0xe8, 0xd8, 0xb3, 0x74, 0x9f, 0x78, 0xd4, 0xe7, 0x8d, 0xee, 0x8a, 0xfc, 0xa5, 0x79,
	0x3e, 0xe5, 0x14, 0x55, 0xfa, 0x1d, 0x35, 0xe9, 0xa8, 0x09, 0x47, 0x0d, 0x7b, 0x96, 0x26, 0xa7,
	0x77, 0x57, 0xca, 0xab, 0x29, 0x82, 0x98, 0x16, 0xe3, 0xbe, 0xd5, 0xec, 0x70, 0x8b, 0xba, 0x61,
	0xa8, 0xf2, 0x9d, 0x14, 0xee, 0xfb, 0x9c, 0x7b, 0x4d, 0x6a, 0x1e, 0x4a, 0xd7, 0xea, 0x0b, 0x5d,
	0xb9, 0x8f, 0x5d, 0x86, 0x5b, 0x89, 0x70, 0xf3, 0x6d, 0x4a, 0xdb, 0x76, 0x68, 0xc5, 0xae, 0x4b,
	0x39, 0x0e, 0x8c, 0x4c, 0x5a, 0x17, 0xa4, 0x55, 0x3c, 0x35, 0x3b, 0x7b, 0xba, 0xd9, 0xf1, 0x71,
	0xc2, 0x7b, 0xee, 0xa4, 0x9d, 0x38, 0x1e, 0x8f, 0xe4, 0x2c, 0x9e, 0x34, 0x72, 0xcb, 0x21, 0x8c,
	0x63, 0xc7, 0x0b, 0x27, 0xa8, 0xdb, 0x30, 0x69, 0x88, 0x5c, 0xd0, 0x34, 0x64, 0x2c, 0xb3, 0xa4,
	0x2c, 0x29, 0xcb, 0x05, 0x23, 0x63, 0x99, 0xe8, 0x26, 0xe4, 0x1d, 0x6a, 0x5a, 0x7b, 0x16, 0x31,
	0x4b, 0x99, 0x25, 0x65, 0xb9, 0x58, 0x2d, 0x6b, 0x21, 0x4d, 0x8b, 0x68, 0xda, 0x4e, 0x44, 0x33,
	0xe2, 0xb9, 0xea, 0x15, 0x40, 0x5b, 0x16, 0xe3, 0x21, 0x95, 0x19, 0xe4, 0xb3, 0x0e, 0x61, 0x5c,
	0xc5, 0x70, 0xb9, 0x6f, 0x94, 0x79, 0xd4, 0x65, 0x04, 0x7d, 0x0c, 0x93, 0x61, 0x29, 0x4b, 0xca,
	0x52, 0x76, 0xb9, 0x58, 0xad, 0x6a, 0x67, 0x5f, 0x65, 0x2d, 0x84, 0x19, 0x92, 0xa0, 0x3e, 0x81,
	0xd2, 0x16, 0xa5, 0x9f, 0x76, 0xbc, 0x9d, 0x5e, 0x85, 0x65, 0x78, 0xf4, 0x06, 0x4c, 0x27, 0xea,
	0xde, 0x88, 0x13, 0x9d, 0x4a, 0x8c, 0x6e, 0x9a, 0x68, 0x0e, 0x0a, 0x72, 0x65, 0xad, 0x30, 0xe9,
	0x82, 0x91, 0x0f, 0x07, 0x36, 0x4d, 0xd5, 0x86, 0xd9, 0x21, 0x7c, 0x99, 0xc8, 0x63, 0x28, 0x26,
	0x50, 0x82, 0x5e, 0xac, 0xbe, 0xfd, 0xe2, 0x6c, 0x92, 0xac, 0x24, 0x41, 0xbd, 0x0b, 0x73, 0x41,
	0xc1, 0xb6, 0x7d, 0xda, 0xf6, 0xb1, 0xc3, 0x36, 0x5d, 0x99, 0xad, 0x4c, 0xa8, 0x4f, 0xa9, 0x72,
	0x42, 0xa9, 0x0f, 0xf3, 0xc3, 0x7d, 0xa5, 0x58, 0x03, 0xf2, 0x9e, 0xb4, 0xc9, 0xba, 0xdf, 0x4c,
	0x53, 0x77, 0xc9, 0x35, 0xc8, 0x9e, 0x11, 0x73, 0xd4, 0xaf, 0x14, 0xb8, 0xba, 0x41, 0x78, 0x6c,
	0x3b, 0xab, 0x58, 0xb4, 0x0d, 0x39, 0x09, 0x91, 0xdb, 0x6c, 0x54, 0x2d, 0x11, 0x46, 0xa5, 0x50,
	0x1a, 0x54, 0x22, 0x53, 0xaf, 0x43, 0xae, 0x45, 0x5d, 0x4e, 0x5c, 0x2e, 0xd7, 0xe8, 0xce, 0x48,
	0xd1, 0x04, 0x33, 0x22, 0xa9, 0xb7, 0x61, 0x76, 0x83, 0xf0, 0xc4, 0x52, 0x6e, 0xe3, 0x36, 0x39,
	0xd3, 0x4a, 0xfd, 0x9c, 0x85, 0xa9, 0x3e, 0x68, 0xb2, 0x1c, 0xca, 0x4b, 0x29, 0x07, 0xfa, 0x02,
	0x16, 0x7d, 0x4a, 0x79, 0x83, 0x11, 0xbf, 0x4b, 0xfc, 0x06, 0xb7, 0x1c, 0xcb, 0x6d, 0x37, 0x92,
	0xc7, 0x9e, 0x2c, 0xfc, 0xed, 0x34, 0x91, 0x6a, 0x09, 0x7f, 0x63, 0x3e, 0x08, 0x50, 0x17, 0xfc,
	0x1d, 0x81, 0x4f, 0x5a, 0x51, 0x13, 0xc0, 0xa5, 0x9c, 0x1c, 0x50, 0x9f, 0xef, 0x1f, 0x96, 0xb2,
	0x22, 0xd6, 0x5a, 0x9a, 0x58, 0x8f, 0x62, 0xef, 0x44, 0x8d, 0x99, 0x91, 0xa0, 0xa2, 0x27, 0x50,
	0x60, 0x56, 0xdb, 0xc5, 0xbc, 0xe3, 0x93, 0xd2, 0x84, 0xd8, 0xd3, 0x1f, 0xa6, 0x09, 0x71, 0x1f,
	0xdb, 0x76, 0x3d, 0x02, 0xd4, 0x3b, 0x8e, 0x83, 0xfd, 0x43, 0xa3, 0x87, 0x54, 0xbf, 0xcf, 0xc0,
	0xcc, 0x70, 0x19, 0x68, 0x07, 0x72, 0xcc, 0xa6, 0x07, 0x84, 0x45, 0x5b, 0xea, 0x6e, 0x9a, 0xc0,
	0xf5, 0x4e, 0x93, 0xfb, 0x24, 0x0e, 0x19, 0xa1, 0x02, 0xaa, 0x49, 0x88, 0x17, 0x50, 0x33, 0xe3,
	0x53, 0x25, 0x2a, 0xa0, 0xda, 0xd8, 0x6f, 0x07, 0xd4, 0xec, 0xf8, 0x54, 0x89, 0x52, 0x7f, 0x52,
	0x60, 0xba, 0xdf, 0x86, 0x3e, 0x81, 0x89, 0x16, 0xb6, 0x6d, 0x59, 0x91, 0x5b, 0xa9, 0x97, 0x42,
	0x86, 0x10, 0x10, 0xf4, 0x1a, 0x5c, 0x64, 0x21, 0xbe, 0xc1, 0xac, 0xe7, 0x44, 0x14, 0x24, 0x6b,
	0x14, 0xe5, 0x58, 0xdd, 0x7a, 0x4e, 0xd0, 0xeb, 0x30, 0x15, 0x4d, 0x31, 0x89, 0xc7, 0xf7, 0x45,
	0x7a, 0x59, 0x23, 0xf2, 0xab, 0x05, 0x63, 0xea, 0x77, 0x0a, 0x14, 0x13, 0x74, 0xb4, 0x0e, 0x59,
	0x9f, 0xec, 0x49, 0x8d, 0x37, 0xd2, 0x6a, 0x0c, 0x5e, 0xb2, 0xc0, 0x1f, 0xad, 0xc1, 0x25, 0xf9,
	0x6e, 0x45, 0x57, 0xb3, 0x5c, 0xb2, 0xd9, 0x81, 0x0b, 0xb3, 0x26, 0x27, 0x18, 0xd3, 0xa1, 0x47,
	0xf4, 0xac, 0xd6, 0x20, 0x27, 0x99, 0x67, 0xbd, 0xab, 0x10, 0x4c, 0x78, 0x98, 0xef, 0x97, 0x32,
	0x4b, 0xd9, 0xe5, 0x29, 0x43, 0xfc, 0x56, 0x3f, 0x87, 0xc2, 0x43, 0xc2, 0xf7, 0xa9, 0x19, 0x70,
	0x5e, 0xfe, 0x49, 0xb2, 0x08, 0x45, 0x47, 0xe0, 0x1b, 0x2e, 0x76, 0x88, 0xbc, 0x20, 0x21, 0x1c,
	0x7a, 0x84, 0x1d, 0xa2, 0x2e, 0x01, 0xf4, 0xfc, 0x02, 0x85, 0x62, 0x5e, 0x28, 0x5f, 0xfc, 0x56,
	0xff, 0xc9, 0xc2, 0x95, 0x61, 0xef, 0x1a, 0x7a, 0x08, 0x93, 0x21, 0x48, 0x8a, 0x7d, 0x2f, 0x8d,
	0xd8, 0x38, 0x69, 0x43, 0x42, 0xd0, 0x2e, 0x5c, 0x34, 0x89, 0x47, 0x5c, 0x93, 0xb8, 0x2d, 0x8b,
	0x30, 0x51, 0xa5, 0xd1, 0x2b, 0xd0, 0xc7, 0x42, 0x14, 0xae, 0x8a, 0xa5, 0xb0, 0xb8, 0xd5, 0x15,
	0xdb, 0xad, 0x17, 0x26, 0x3b, 0x56, 0x98, 0x99, 0x1e, 0xb6, 0x96, 0x0c, 0xd8, 0x85, 0xf2, 0x7f,
	0x1c, 0xde, 0x13, 0x63, 0x1e, 0xde, 0x25, 0x76, 0xda, 0xc1, 0xfd, 0x18, 0xf2, 0xe4, 0x19, 0x76,
	0x3c, 0x9b, 0xb0, 0xd2, 0x05, 0x91, 0xd9, 0x48, 0x2f, 0x49, 0x0c, 0x51, 0xdf, 0x81, 0x4b, 0x1b,
	0x84, 0x7f, 0xc4, 0x18, 0x89, 0x7b, 0x83, 0x6b, 0x00, 0x38, 0x78, 0x6e, 0x24, 0xb6, 0x4a, 0x41,
	0x8c, 0x04, 0x3b, 0xaa, 0xfa, 0xcd, 0x05, 0xc8, 0xc9, 0xa6, 0x11, 0x7d, 0xad, 0x40, 0x31, 0xd1,
	0x44, 0xa2, 0x0f, 0xd2, 0x88, 0x19, 0xec, 0x49, 0xcb, 0xf7, 0x46, 0xf6, 0x0f, 0x9b, 0x09, 0xf5,
	0x7f, 0xe8, 0x47, 0x05, 0x5e, 0x19, 0x68, 0x0a, 0x51, 0x2d, 0x15, 0xf8, 0x94, 0x9e, 0xb5, 0xbc,
	0x3e, 0x26, 0x25, 0x16, 0xf9, 0x8b, 0x02, 0x57, 0x86, 0xf5, 0x83, 0x68, 0x23, 0x6d, 0x01, 0x4e,
	0xe9, 0x46, 0xcb, 0x0f, 0xc6, 0x07, 0xc5, 0x6a, 0x7f, 0x50, 0xe0, 0xff, 0x27, 0xdb, 0x37, 0x74,
	0x3f, 0x4d, 0x80, 0x53, 0xda, 0xd0, 0x72, 0x6d, 0x3c, 0x48, 0xa4, 0xb0, 0xfa, 0x7b, 0x1e, 0xa6,
	0xc2, 0xc1, 0x35, 0x9f, 0x1e, 0x30, 0xe2, 0xa3, 0xdf, 0xce, 0xbd, 0xc2, 0xef, 0xa6, 0x01, 0x3d,
	0xe0, 0xdc, 0x5b, 0xa3, 0xe6, 0xa1, 0x3a, 0xf7, 0xe5, 0x5f, 0x7f, 0x7f, 0x9b, 0x79, 0x15, 0x5d,
	0xd6, 0x8f, 0xe2, 0x1e, 0xf4, 0x58, 0x7e, 0xbc, 0xa2, 0x3f, 0xce, 0xad, 0xd0, 0xa3, 0x89, 0x5d,
	0x11, 0x62, 0xdf, 0x42, 0xd7, 0x87, 0x88, 0xd5, 0x9b, 0x96, 0xab, 0x1f, 0xc9, 0x7b, 0x48, 0x0b,
	0x8e, 0x8a, 0xd5, 0x4a, 0xe5, 0x38, 0x48, 0xe1, 0xdc, 0x5e, 0xbf, 0xd1, 0x92, 0xd0, 0x45, 0x12,
	0xd7, 0xd1, 0x9b, 0xc3, 0x92, 0xe0, 0xcf, 0xf4, 0xa3, 0xfe, 0xab, 0xfd, 0x18, 0xfd, 0xaa, 0x00,
	0x1a, 0xfc, 0x78, 0x40, 0xeb, 0x29, 0xd7, 0x61, 0xf8, 0xc7, 0xc7, 0x88, 0x49, 0x2c, 0x88, 0x24,
	0x4a, 0x68, 0x66, 0x78, 0x12, 0xc8, 0x13, 0xc7, 0xf8, 0x16, 0xe6, 0x24, 0x3a, 0x13, 0xd1, 0xcc,
	0x40, 0xab, 0xb3, 0xee, 0x78, 0xfc, 0x70, 0x44, 0x01, 0x97, 0x84, 0x80, 0x02, 0xca, 0xe9, 0xb6,
	0x08, 0x82, 0xfe, 0x54, 0x20, 0x1f, 0xdd, 0x1c, 0xe8, 0xfd, 0x94, 0xb5, 0x49, 0xde, 0x37, 0x23,
	0x0a, 0x5a, 0x17, 0x82, 0xee, 0xa1, 0x6b, 0x7a, 0x25, 0xaa, 0xc3, 0x51, 0xef, 0xda, 0x5a, 0x6d,
	0x31, 0xa6, 0x57, 0x2a, 0xc7, 0xbb, 0x0b, 0x68, 0x7e, 0xf8, 0x84, 0xa7, 0xc2, 0xbe, 0x56, 0xdc,
	0x2d, 0xc4, 0xff, 0x1c, 0x35, 0x27, 0x45, 0xa9, 0x6e, 0xfc, 0x1b, 0x00, 0x00, 0xff, 0xff, 0x34,
	0x33, 0x09, 0x3b, 0x12, 0x13, 0x00, 0x00,
}
