// Code generated by protoc-gen-twirp v5.3.0, DO NOT EDIT.
// source: code.justin.tv/release/trace/internal/ext/guardian_v1/guardian.proto

/*
Package guardian_v1 is a generated twirp stub package.
This code was generated with github.com/twitchtv/twirp/protoc-gen-twirp v5.3.0.

It is generated from these files:
	code.justin.tv/release/trace/internal/ext/guardian_v1/guardian.proto
*/
package guardian_v1

import bytes "bytes"
import strings "strings"
import context "context"
import fmt "fmt"
import ioutil "io/ioutil"
import http "net/http"

import jsonpb "github.com/golang/protobuf/jsonpb"
import proto "github.com/golang/protobuf/proto"
import twirp "github.com/twitchtv/twirp"
import ctxsetters "github.com/twitchtv/twirp/ctxsetters"

import google_protobuf "github.com/golang/protobuf/ptypes/empty"

// Imports only used by utility functions:
import io "io"
import strconv "strconv"
import json "encoding/json"
import url "net/url"

// ==================
// Guardian Interface
// ==================

// Manages Twitch-internal OAuth2 applications and provides access to LDAP
// users and groups.
type Guardian interface {
	// Lists all LDAP users.
	//
	// No authentication required.
	ListUsers(context.Context, *ListUsersRequest) (*ListUsersResponse, error)

	// Gets details of a single LDAP user, including the names (`cn`) of all
	// groups of which the user is a member.
	//
	// No authentication required.
	GetUser(context.Context, *GetUserRequest) (*GetUserResponse, error)

	// Lists all LDAP groups.
	//
	// No authentication required.
	ListGroups(context.Context, *ListGroupsRequest) (*ListGroupsResponse, error)

	// Gets details of a single LDAP group, including the full names (`cn`) of
	// all member users.
	//
	// No authentication required.
	GetGroup(context.Context, *GetGroupRequest) (*GetGroupResponse, error)

	// Lists all Twitch-internal OAuth2 client applications.
	//
	// Authentication is required.
	ListClients(context.Context, *ListClientsRequest) (*ListClientsResponse, error)

	// Gets details of a single Twitch-internal OAuth2 client application.
	//
	// Authentication is required.
	GetClient(context.Context, *GetClientRequest) (*GetClientResponse, error)

	// Creates a Twitch-internal OAuth2 client application.
	//
	// Authentication is required. Content-Type must be
	// `application/vnd.api+json`. See the request message for details on which
	// fields must be set.
	CreateClient(context.Context, *CreateClientRequest) (*CreateClientResponse, error)

	// Updates a Twitch-internal OAuth2 client application.
	//
	// Authentication is required. Content-Type must be
	// `application/vnd.api+json`. See the request message for details on which
	// fields must be set.
	UpdateClient(context.Context, *UpdateClientRequest) (*UpdateClientResponse, error)

	// Deletes a Twitch-internal OAuth2 client application.
	//
	// Authentication is required.
	DeleteClient(context.Context, *DeleteClientRequest) (*google_protobuf.Empty, error)
}

// ========================
// Guardian Protobuf Client
// ========================

type guardianProtobufClient struct {
	client HTTPClient
	urls   [9]string
}

// NewGuardianProtobufClient creates a Protobuf client that implements the Guardian interface.
// It communicates using Protobuf and can be configured with a custom HTTPClient.
func NewGuardianProtobufClient(addr string, client HTTPClient) Guardian {
	prefix := urlBase(addr) + GuardianPathPrefix
	urls := [9]string{
		prefix + "ListUsers",
		prefix + "GetUser",
		prefix + "ListGroups",
		prefix + "GetGroup",
		prefix + "ListClients",
		prefix + "GetClient",
		prefix + "CreateClient",
		prefix + "UpdateClient",
		prefix + "DeleteClient",
	}
	if httpClient, ok := client.(*http.Client); ok {
		return &guardianProtobufClient{
			client: withoutRedirects(httpClient),
			urls:   urls,
		}
	}
	return &guardianProtobufClient{
		client: client,
		urls:   urls,
	}
}

func (c *guardianProtobufClient) ListUsers(ctx context.Context, in *ListUsersRequest) (*ListUsersResponse, error) {
	ctx = ctxsetters.WithPackageName(ctx, "code_justin_tv.release.trace.internal.ext.guardian.v1")
	ctx = ctxsetters.WithServiceName(ctx, "Guardian")
	ctx = ctxsetters.WithMethodName(ctx, "ListUsers")
	out := new(ListUsersResponse)
	err := doProtobufRequest(ctx, c.client, c.urls[0], in, out)
	return out, err
}

func (c *guardianProtobufClient) GetUser(ctx context.Context, in *GetUserRequest) (*GetUserResponse, error) {
	ctx = ctxsetters.WithPackageName(ctx, "code_justin_tv.release.trace.internal.ext.guardian.v1")
	ctx = ctxsetters.WithServiceName(ctx, "Guardian")
	ctx = ctxsetters.WithMethodName(ctx, "GetUser")
	out := new(GetUserResponse)
	err := doProtobufRequest(ctx, c.client, c.urls[1], in, out)
	return out, err
}

func (c *guardianProtobufClient) ListGroups(ctx context.Context, in *ListGroupsRequest) (*ListGroupsResponse, error) {
	ctx = ctxsetters.WithPackageName(ctx, "code_justin_tv.release.trace.internal.ext.guardian.v1")
	ctx = ctxsetters.WithServiceName(ctx, "Guardian")
	ctx = ctxsetters.WithMethodName(ctx, "ListGroups")
	out := new(ListGroupsResponse)
	err := doProtobufRequest(ctx, c.client, c.urls[2], in, out)
	return out, err
}

func (c *guardianProtobufClient) GetGroup(ctx context.Context, in *GetGroupRequest) (*GetGroupResponse, error) {
	ctx = ctxsetters.WithPackageName(ctx, "code_justin_tv.release.trace.internal.ext.guardian.v1")
	ctx = ctxsetters.WithServiceName(ctx, "Guardian")
	ctx = ctxsetters.WithMethodName(ctx, "GetGroup")
	out := new(GetGroupResponse)
	err := doProtobufRequest(ctx, c.client, c.urls[3], in, out)
	return out, err
}

func (c *guardianProtobufClient) ListClients(ctx context.Context, in *ListClientsRequest) (*ListClientsResponse, error) {
	ctx = ctxsetters.WithPackageName(ctx, "code_justin_tv.release.trace.internal.ext.guardian.v1")
	ctx = ctxsetters.WithServiceName(ctx, "Guardian")
	ctx = ctxsetters.WithMethodName(ctx, "ListClients")
	out := new(ListClientsResponse)
	err := doProtobufRequest(ctx, c.client, c.urls[4], in, out)
	return out, err
}

func (c *guardianProtobufClient) GetClient(ctx context.Context, in *GetClientRequest) (*GetClientResponse, error) {
	ctx = ctxsetters.WithPackageName(ctx, "code_justin_tv.release.trace.internal.ext.guardian.v1")
	ctx = ctxsetters.WithServiceName(ctx, "Guardian")
	ctx = ctxsetters.WithMethodName(ctx, "GetClient")
	out := new(GetClientResponse)
	err := doProtobufRequest(ctx, c.client, c.urls[5], in, out)
	return out, err
}

func (c *guardianProtobufClient) CreateClient(ctx context.Context, in *CreateClientRequest) (*CreateClientResponse, error) {
	ctx = ctxsetters.WithPackageName(ctx, "code_justin_tv.release.trace.internal.ext.guardian.v1")
	ctx = ctxsetters.WithServiceName(ctx, "Guardian")
	ctx = ctxsetters.WithMethodName(ctx, "CreateClient")
	out := new(CreateClientResponse)
	err := doProtobufRequest(ctx, c.client, c.urls[6], in, out)
	return out, err
}

func (c *guardianProtobufClient) UpdateClient(ctx context.Context, in *UpdateClientRequest) (*UpdateClientResponse, error) {
	ctx = ctxsetters.WithPackageName(ctx, "code_justin_tv.release.trace.internal.ext.guardian.v1")
	ctx = ctxsetters.WithServiceName(ctx, "Guardian")
	ctx = ctxsetters.WithMethodName(ctx, "UpdateClient")
	out := new(UpdateClientResponse)
	err := doProtobufRequest(ctx, c.client, c.urls[7], in, out)
	return out, err
}

func (c *guardianProtobufClient) DeleteClient(ctx context.Context, in *DeleteClientRequest) (*google_protobuf.Empty, error) {
	ctx = ctxsetters.WithPackageName(ctx, "code_justin_tv.release.trace.internal.ext.guardian.v1")
	ctx = ctxsetters.WithServiceName(ctx, "Guardian")
	ctx = ctxsetters.WithMethodName(ctx, "DeleteClient")
	out := new(google_protobuf.Empty)
	err := doProtobufRequest(ctx, c.client, c.urls[8], in, out)
	return out, err
}

// ====================
// Guardian JSON Client
// ====================

type guardianJSONClient struct {
	client HTTPClient
	urls   [9]string
}

// NewGuardianJSONClient creates a JSON client that implements the Guardian interface.
// It communicates using JSON and can be configured with a custom HTTPClient.
func NewGuardianJSONClient(addr string, client HTTPClient) Guardian {
	prefix := urlBase(addr) + GuardianPathPrefix
	urls := [9]string{
		prefix + "ListUsers",
		prefix + "GetUser",
		prefix + "ListGroups",
		prefix + "GetGroup",
		prefix + "ListClients",
		prefix + "GetClient",
		prefix + "CreateClient",
		prefix + "UpdateClient",
		prefix + "DeleteClient",
	}
	if httpClient, ok := client.(*http.Client); ok {
		return &guardianJSONClient{
			client: withoutRedirects(httpClient),
			urls:   urls,
		}
	}
	return &guardianJSONClient{
		client: client,
		urls:   urls,
	}
}

func (c *guardianJSONClient) ListUsers(ctx context.Context, in *ListUsersRequest) (*ListUsersResponse, error) {
	ctx = ctxsetters.WithPackageName(ctx, "code_justin_tv.release.trace.internal.ext.guardian.v1")
	ctx = ctxsetters.WithServiceName(ctx, "Guardian")
	ctx = ctxsetters.WithMethodName(ctx, "ListUsers")
	out := new(ListUsersResponse)
	err := doJSONRequest(ctx, c.client, c.urls[0], in, out)
	return out, err
}

func (c *guardianJSONClient) GetUser(ctx context.Context, in *GetUserRequest) (*GetUserResponse, error) {
	ctx = ctxsetters.WithPackageName(ctx, "code_justin_tv.release.trace.internal.ext.guardian.v1")
	ctx = ctxsetters.WithServiceName(ctx, "Guardian")
	ctx = ctxsetters.WithMethodName(ctx, "GetUser")
	out := new(GetUserResponse)
	err := doJSONRequest(ctx, c.client, c.urls[1], in, out)
	return out, err
}

func (c *guardianJSONClient) ListGroups(ctx context.Context, in *ListGroupsRequest) (*ListGroupsResponse, error) {
	ctx = ctxsetters.WithPackageName(ctx, "code_justin_tv.release.trace.internal.ext.guardian.v1")
	ctx = ctxsetters.WithServiceName(ctx, "Guardian")
	ctx = ctxsetters.WithMethodName(ctx, "ListGroups")
	out := new(ListGroupsResponse)
	err := doJSONRequest(ctx, c.client, c.urls[2], in, out)
	return out, err
}

func (c *guardianJSONClient) GetGroup(ctx context.Context, in *GetGroupRequest) (*GetGroupResponse, error) {
	ctx = ctxsetters.WithPackageName(ctx, "code_justin_tv.release.trace.internal.ext.guardian.v1")
	ctx = ctxsetters.WithServiceName(ctx, "Guardian")
	ctx = ctxsetters.WithMethodName(ctx, "GetGroup")
	out := new(GetGroupResponse)
	err := doJSONRequest(ctx, c.client, c.urls[3], in, out)
	return out, err
}

func (c *guardianJSONClient) ListClients(ctx context.Context, in *ListClientsRequest) (*ListClientsResponse, error) {
	ctx = ctxsetters.WithPackageName(ctx, "code_justin_tv.release.trace.internal.ext.guardian.v1")
	ctx = ctxsetters.WithServiceName(ctx, "Guardian")
	ctx = ctxsetters.WithMethodName(ctx, "ListClients")
	out := new(ListClientsResponse)
	err := doJSONRequest(ctx, c.client, c.urls[4], in, out)
	return out, err
}

func (c *guardianJSONClient) GetClient(ctx context.Context, in *GetClientRequest) (*GetClientResponse, error) {
	ctx = ctxsetters.WithPackageName(ctx, "code_justin_tv.release.trace.internal.ext.guardian.v1")
	ctx = ctxsetters.WithServiceName(ctx, "Guardian")
	ctx = ctxsetters.WithMethodName(ctx, "GetClient")
	out := new(GetClientResponse)
	err := doJSONRequest(ctx, c.client, c.urls[5], in, out)
	return out, err
}

func (c *guardianJSONClient) CreateClient(ctx context.Context, in *CreateClientRequest) (*CreateClientResponse, error) {
	ctx = ctxsetters.WithPackageName(ctx, "code_justin_tv.release.trace.internal.ext.guardian.v1")
	ctx = ctxsetters.WithServiceName(ctx, "Guardian")
	ctx = ctxsetters.WithMethodName(ctx, "CreateClient")
	out := new(CreateClientResponse)
	err := doJSONRequest(ctx, c.client, c.urls[6], in, out)
	return out, err
}

func (c *guardianJSONClient) UpdateClient(ctx context.Context, in *UpdateClientRequest) (*UpdateClientResponse, error) {
	ctx = ctxsetters.WithPackageName(ctx, "code_justin_tv.release.trace.internal.ext.guardian.v1")
	ctx = ctxsetters.WithServiceName(ctx, "Guardian")
	ctx = ctxsetters.WithMethodName(ctx, "UpdateClient")
	out := new(UpdateClientResponse)
	err := doJSONRequest(ctx, c.client, c.urls[7], in, out)
	return out, err
}

func (c *guardianJSONClient) DeleteClient(ctx context.Context, in *DeleteClientRequest) (*google_protobuf.Empty, error) {
	ctx = ctxsetters.WithPackageName(ctx, "code_justin_tv.release.trace.internal.ext.guardian.v1")
	ctx = ctxsetters.WithServiceName(ctx, "Guardian")
	ctx = ctxsetters.WithMethodName(ctx, "DeleteClient")
	out := new(google_protobuf.Empty)
	err := doJSONRequest(ctx, c.client, c.urls[8], in, out)
	return out, err
}

// =======================
// Guardian Server Handler
// =======================

type guardianServer struct {
	Guardian
	hooks *twirp.ServerHooks
}

func NewGuardianServer(svc Guardian, hooks *twirp.ServerHooks) TwirpServer {
	return &guardianServer{
		Guardian: svc,
		hooks:    hooks,
	}
}

// writeError writes an HTTP response with a valid Twirp error format, and triggers hooks.
// If err is not a twirp.Error, it will get wrapped with twirp.InternalErrorWith(err)
func (s *guardianServer) writeError(ctx context.Context, resp http.ResponseWriter, err error) {
	writeError(ctx, resp, err, s.hooks)
}

// GuardianPathPrefix is used for all URL paths on a twirp Guardian server.
// Requests are always: POST GuardianPathPrefix/method
// It can be used in an HTTP mux to route twirp requests along with non-twirp requests on other routes.
const GuardianPathPrefix = "/twirp/code_justin_tv.release.trace.internal.ext.guardian.v1.Guardian/"

func (s *guardianServer) ServeHTTP(resp http.ResponseWriter, req *http.Request) {
	ctx := req.Context()
	ctx = ctxsetters.WithPackageName(ctx, "code_justin_tv.release.trace.internal.ext.guardian.v1")
	ctx = ctxsetters.WithServiceName(ctx, "Guardian")
	ctx = ctxsetters.WithResponseWriter(ctx, resp)

	var err error
	ctx, err = callRequestReceived(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	if req.Method != "POST" {
		msg := fmt.Sprintf("unsupported method %q (only POST is allowed)", req.Method)
		err = badRouteError(msg, req.Method, req.URL.Path)
		s.writeError(ctx, resp, err)
		return
	}

	switch req.URL.Path {
	case "/twirp/code_justin_tv.release.trace.internal.ext.guardian.v1.Guardian/ListUsers":
		s.serveListUsers(ctx, resp, req)
		return
	case "/twirp/code_justin_tv.release.trace.internal.ext.guardian.v1.Guardian/GetUser":
		s.serveGetUser(ctx, resp, req)
		return
	case "/twirp/code_justin_tv.release.trace.internal.ext.guardian.v1.Guardian/ListGroups":
		s.serveListGroups(ctx, resp, req)
		return
	case "/twirp/code_justin_tv.release.trace.internal.ext.guardian.v1.Guardian/GetGroup":
		s.serveGetGroup(ctx, resp, req)
		return
	case "/twirp/code_justin_tv.release.trace.internal.ext.guardian.v1.Guardian/ListClients":
		s.serveListClients(ctx, resp, req)
		return
	case "/twirp/code_justin_tv.release.trace.internal.ext.guardian.v1.Guardian/GetClient":
		s.serveGetClient(ctx, resp, req)
		return
	case "/twirp/code_justin_tv.release.trace.internal.ext.guardian.v1.Guardian/CreateClient":
		s.serveCreateClient(ctx, resp, req)
		return
	case "/twirp/code_justin_tv.release.trace.internal.ext.guardian.v1.Guardian/UpdateClient":
		s.serveUpdateClient(ctx, resp, req)
		return
	case "/twirp/code_justin_tv.release.trace.internal.ext.guardian.v1.Guardian/DeleteClient":
		s.serveDeleteClient(ctx, resp, req)
		return
	default:
		msg := fmt.Sprintf("no handler for path %q", req.URL.Path)
		err = badRouteError(msg, req.Method, req.URL.Path)
		s.writeError(ctx, resp, err)
		return
	}
}

func (s *guardianServer) serveListUsers(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	header := req.Header.Get("Content-Type")
	i := strings.Index(header, ";")
	if i == -1 {
		i = len(header)
	}
	switch strings.TrimSpace(strings.ToLower(header[:i])) {
	case "application/json":
		s.serveListUsersJSON(ctx, resp, req)
	case "application/protobuf":
		s.serveListUsersProtobuf(ctx, resp, req)
	default:
		msg := fmt.Sprintf("unexpected Content-Type: %q", req.Header.Get("Content-Type"))
		twerr := badRouteError(msg, req.Method, req.URL.Path)
		s.writeError(ctx, resp, twerr)
	}
}

func (s *guardianServer) serveListUsersJSON(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "ListUsers")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	reqContent := new(ListUsersRequest)
	unmarshaler := jsonpb.Unmarshaler{AllowUnknownFields: true}
	if err = unmarshaler.Unmarshal(req.Body, reqContent); err != nil {
		err = wrapErr(err, "failed to parse request json")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	// Call service method
	var respContent *ListUsersResponse
	func() {
		defer func() {
			// In case of a panic, serve a 500 error and then panic.
			if r := recover(); r != nil {
				s.writeError(ctx, resp, twirp.InternalError("Internal service panic"))
				panic(r)
			}
		}()
		respContent, err = s.ListUsers(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *ListUsersResponse and nil error while calling ListUsers. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	var buf bytes.Buffer
	marshaler := &jsonpb.Marshaler{OrigName: true}
	if err = marshaler.Marshal(&buf, respContent); err != nil {
		err = wrapErr(err, "failed to marshal json response")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/json")
	resp.WriteHeader(http.StatusOK)

	respBytes := buf.Bytes()
	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *guardianServer) serveListUsersProtobuf(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "ListUsers")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	buf, err := ioutil.ReadAll(req.Body)
	if err != nil {
		err = wrapErr(err, "failed to read request body")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}
	reqContent := new(ListUsersRequest)
	if err = proto.Unmarshal(buf, reqContent); err != nil {
		err = wrapErr(err, "failed to parse request proto")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	// Call service method
	var respContent *ListUsersResponse
	func() {
		defer func() {
			// In case of a panic, serve a 500 error and then panic.
			if r := recover(); r != nil {
				s.writeError(ctx, resp, twirp.InternalError("Internal service panic"))
				panic(r)
			}
		}()
		respContent, err = s.ListUsers(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *ListUsersResponse and nil error while calling ListUsers. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	respBytes, err := proto.Marshal(respContent)
	if err != nil {
		err = wrapErr(err, "failed to marshal proto response")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/protobuf")
	resp.WriteHeader(http.StatusOK)
	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *guardianServer) serveGetUser(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	header := req.Header.Get("Content-Type")
	i := strings.Index(header, ";")
	if i == -1 {
		i = len(header)
	}
	switch strings.TrimSpace(strings.ToLower(header[:i])) {
	case "application/json":
		s.serveGetUserJSON(ctx, resp, req)
	case "application/protobuf":
		s.serveGetUserProtobuf(ctx, resp, req)
	default:
		msg := fmt.Sprintf("unexpected Content-Type: %q", req.Header.Get("Content-Type"))
		twerr := badRouteError(msg, req.Method, req.URL.Path)
		s.writeError(ctx, resp, twerr)
	}
}

func (s *guardianServer) serveGetUserJSON(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "GetUser")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	reqContent := new(GetUserRequest)
	unmarshaler := jsonpb.Unmarshaler{AllowUnknownFields: true}
	if err = unmarshaler.Unmarshal(req.Body, reqContent); err != nil {
		err = wrapErr(err, "failed to parse request json")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	// Call service method
	var respContent *GetUserResponse
	func() {
		defer func() {
			// In case of a panic, serve a 500 error and then panic.
			if r := recover(); r != nil {
				s.writeError(ctx, resp, twirp.InternalError("Internal service panic"))
				panic(r)
			}
		}()
		respContent, err = s.GetUser(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *GetUserResponse and nil error while calling GetUser. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	var buf bytes.Buffer
	marshaler := &jsonpb.Marshaler{OrigName: true}
	if err = marshaler.Marshal(&buf, respContent); err != nil {
		err = wrapErr(err, "failed to marshal json response")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/json")
	resp.WriteHeader(http.StatusOK)

	respBytes := buf.Bytes()
	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *guardianServer) serveGetUserProtobuf(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "GetUser")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	buf, err := ioutil.ReadAll(req.Body)
	if err != nil {
		err = wrapErr(err, "failed to read request body")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}
	reqContent := new(GetUserRequest)
	if err = proto.Unmarshal(buf, reqContent); err != nil {
		err = wrapErr(err, "failed to parse request proto")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	// Call service method
	var respContent *GetUserResponse
	func() {
		defer func() {
			// In case of a panic, serve a 500 error and then panic.
			if r := recover(); r != nil {
				s.writeError(ctx, resp, twirp.InternalError("Internal service panic"))
				panic(r)
			}
		}()
		respContent, err = s.GetUser(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *GetUserResponse and nil error while calling GetUser. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	respBytes, err := proto.Marshal(respContent)
	if err != nil {
		err = wrapErr(err, "failed to marshal proto response")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/protobuf")
	resp.WriteHeader(http.StatusOK)
	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *guardianServer) serveListGroups(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	header := req.Header.Get("Content-Type")
	i := strings.Index(header, ";")
	if i == -1 {
		i = len(header)
	}
	switch strings.TrimSpace(strings.ToLower(header[:i])) {
	case "application/json":
		s.serveListGroupsJSON(ctx, resp, req)
	case "application/protobuf":
		s.serveListGroupsProtobuf(ctx, resp, req)
	default:
		msg := fmt.Sprintf("unexpected Content-Type: %q", req.Header.Get("Content-Type"))
		twerr := badRouteError(msg, req.Method, req.URL.Path)
		s.writeError(ctx, resp, twerr)
	}
}

func (s *guardianServer) serveListGroupsJSON(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "ListGroups")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	reqContent := new(ListGroupsRequest)
	unmarshaler := jsonpb.Unmarshaler{AllowUnknownFields: true}
	if err = unmarshaler.Unmarshal(req.Body, reqContent); err != nil {
		err = wrapErr(err, "failed to parse request json")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	// Call service method
	var respContent *ListGroupsResponse
	func() {
		defer func() {
			// In case of a panic, serve a 500 error and then panic.
			if r := recover(); r != nil {
				s.writeError(ctx, resp, twirp.InternalError("Internal service panic"))
				panic(r)
			}
		}()
		respContent, err = s.ListGroups(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *ListGroupsResponse and nil error while calling ListGroups. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	var buf bytes.Buffer
	marshaler := &jsonpb.Marshaler{OrigName: true}
	if err = marshaler.Marshal(&buf, respContent); err != nil {
		err = wrapErr(err, "failed to marshal json response")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/json")
	resp.WriteHeader(http.StatusOK)

	respBytes := buf.Bytes()
	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *guardianServer) serveListGroupsProtobuf(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "ListGroups")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	buf, err := ioutil.ReadAll(req.Body)
	if err != nil {
		err = wrapErr(err, "failed to read request body")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}
	reqContent := new(ListGroupsRequest)
	if err = proto.Unmarshal(buf, reqContent); err != nil {
		err = wrapErr(err, "failed to parse request proto")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	// Call service method
	var respContent *ListGroupsResponse
	func() {
		defer func() {
			// In case of a panic, serve a 500 error and then panic.
			if r := recover(); r != nil {
				s.writeError(ctx, resp, twirp.InternalError("Internal service panic"))
				panic(r)
			}
		}()
		respContent, err = s.ListGroups(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *ListGroupsResponse and nil error while calling ListGroups. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	respBytes, err := proto.Marshal(respContent)
	if err != nil {
		err = wrapErr(err, "failed to marshal proto response")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/protobuf")
	resp.WriteHeader(http.StatusOK)
	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *guardianServer) serveGetGroup(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	header := req.Header.Get("Content-Type")
	i := strings.Index(header, ";")
	if i == -1 {
		i = len(header)
	}
	switch strings.TrimSpace(strings.ToLower(header[:i])) {
	case "application/json":
		s.serveGetGroupJSON(ctx, resp, req)
	case "application/protobuf":
		s.serveGetGroupProtobuf(ctx, resp, req)
	default:
		msg := fmt.Sprintf("unexpected Content-Type: %q", req.Header.Get("Content-Type"))
		twerr := badRouteError(msg, req.Method, req.URL.Path)
		s.writeError(ctx, resp, twerr)
	}
}

func (s *guardianServer) serveGetGroupJSON(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "GetGroup")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	reqContent := new(GetGroupRequest)
	unmarshaler := jsonpb.Unmarshaler{AllowUnknownFields: true}
	if err = unmarshaler.Unmarshal(req.Body, reqContent); err != nil {
		err = wrapErr(err, "failed to parse request json")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	// Call service method
	var respContent *GetGroupResponse
	func() {
		defer func() {
			// In case of a panic, serve a 500 error and then panic.
			if r := recover(); r != nil {
				s.writeError(ctx, resp, twirp.InternalError("Internal service panic"))
				panic(r)
			}
		}()
		respContent, err = s.GetGroup(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *GetGroupResponse and nil error while calling GetGroup. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	var buf bytes.Buffer
	marshaler := &jsonpb.Marshaler{OrigName: true}
	if err = marshaler.Marshal(&buf, respContent); err != nil {
		err = wrapErr(err, "failed to marshal json response")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/json")
	resp.WriteHeader(http.StatusOK)

	respBytes := buf.Bytes()
	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *guardianServer) serveGetGroupProtobuf(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "GetGroup")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	buf, err := ioutil.ReadAll(req.Body)
	if err != nil {
		err = wrapErr(err, "failed to read request body")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}
	reqContent := new(GetGroupRequest)
	if err = proto.Unmarshal(buf, reqContent); err != nil {
		err = wrapErr(err, "failed to parse request proto")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	// Call service method
	var respContent *GetGroupResponse
	func() {
		defer func() {
			// In case of a panic, serve a 500 error and then panic.
			if r := recover(); r != nil {
				s.writeError(ctx, resp, twirp.InternalError("Internal service panic"))
				panic(r)
			}
		}()
		respContent, err = s.GetGroup(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *GetGroupResponse and nil error while calling GetGroup. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	respBytes, err := proto.Marshal(respContent)
	if err != nil {
		err = wrapErr(err, "failed to marshal proto response")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/protobuf")
	resp.WriteHeader(http.StatusOK)
	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *guardianServer) serveListClients(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	header := req.Header.Get("Content-Type")
	i := strings.Index(header, ";")
	if i == -1 {
		i = len(header)
	}
	switch strings.TrimSpace(strings.ToLower(header[:i])) {
	case "application/json":
		s.serveListClientsJSON(ctx, resp, req)
	case "application/protobuf":
		s.serveListClientsProtobuf(ctx, resp, req)
	default:
		msg := fmt.Sprintf("unexpected Content-Type: %q", req.Header.Get("Content-Type"))
		twerr := badRouteError(msg, req.Method, req.URL.Path)
		s.writeError(ctx, resp, twerr)
	}
}

func (s *guardianServer) serveListClientsJSON(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "ListClients")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	reqContent := new(ListClientsRequest)
	unmarshaler := jsonpb.Unmarshaler{AllowUnknownFields: true}
	if err = unmarshaler.Unmarshal(req.Body, reqContent); err != nil {
		err = wrapErr(err, "failed to parse request json")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	// Call service method
	var respContent *ListClientsResponse
	func() {
		defer func() {
			// In case of a panic, serve a 500 error and then panic.
			if r := recover(); r != nil {
				s.writeError(ctx, resp, twirp.InternalError("Internal service panic"))
				panic(r)
			}
		}()
		respContent, err = s.ListClients(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *ListClientsResponse and nil error while calling ListClients. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	var buf bytes.Buffer
	marshaler := &jsonpb.Marshaler{OrigName: true}
	if err = marshaler.Marshal(&buf, respContent); err != nil {
		err = wrapErr(err, "failed to marshal json response")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/json")
	resp.WriteHeader(http.StatusOK)

	respBytes := buf.Bytes()
	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *guardianServer) serveListClientsProtobuf(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "ListClients")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	buf, err := ioutil.ReadAll(req.Body)
	if err != nil {
		err = wrapErr(err, "failed to read request body")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}
	reqContent := new(ListClientsRequest)
	if err = proto.Unmarshal(buf, reqContent); err != nil {
		err = wrapErr(err, "failed to parse request proto")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	// Call service method
	var respContent *ListClientsResponse
	func() {
		defer func() {
			// In case of a panic, serve a 500 error and then panic.
			if r := recover(); r != nil {
				s.writeError(ctx, resp, twirp.InternalError("Internal service panic"))
				panic(r)
			}
		}()
		respContent, err = s.ListClients(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *ListClientsResponse and nil error while calling ListClients. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	respBytes, err := proto.Marshal(respContent)
	if err != nil {
		err = wrapErr(err, "failed to marshal proto response")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/protobuf")
	resp.WriteHeader(http.StatusOK)
	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *guardianServer) serveGetClient(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	header := req.Header.Get("Content-Type")
	i := strings.Index(header, ";")
	if i == -1 {
		i = len(header)
	}
	switch strings.TrimSpace(strings.ToLower(header[:i])) {
	case "application/json":
		s.serveGetClientJSON(ctx, resp, req)
	case "application/protobuf":
		s.serveGetClientProtobuf(ctx, resp, req)
	default:
		msg := fmt.Sprintf("unexpected Content-Type: %q", req.Header.Get("Content-Type"))
		twerr := badRouteError(msg, req.Method, req.URL.Path)
		s.writeError(ctx, resp, twerr)
	}
}

func (s *guardianServer) serveGetClientJSON(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "GetClient")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	reqContent := new(GetClientRequest)
	unmarshaler := jsonpb.Unmarshaler{AllowUnknownFields: true}
	if err = unmarshaler.Unmarshal(req.Body, reqContent); err != nil {
		err = wrapErr(err, "failed to parse request json")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	// Call service method
	var respContent *GetClientResponse
	func() {
		defer func() {
			// In case of a panic, serve a 500 error and then panic.
			if r := recover(); r != nil {
				s.writeError(ctx, resp, twirp.InternalError("Internal service panic"))
				panic(r)
			}
		}()
		respContent, err = s.GetClient(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *GetClientResponse and nil error while calling GetClient. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	var buf bytes.Buffer
	marshaler := &jsonpb.Marshaler{OrigName: true}
	if err = marshaler.Marshal(&buf, respContent); err != nil {
		err = wrapErr(err, "failed to marshal json response")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/json")
	resp.WriteHeader(http.StatusOK)

	respBytes := buf.Bytes()
	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *guardianServer) serveGetClientProtobuf(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "GetClient")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	buf, err := ioutil.ReadAll(req.Body)
	if err != nil {
		err = wrapErr(err, "failed to read request body")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}
	reqContent := new(GetClientRequest)
	if err = proto.Unmarshal(buf, reqContent); err != nil {
		err = wrapErr(err, "failed to parse request proto")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	// Call service method
	var respContent *GetClientResponse
	func() {
		defer func() {
			// In case of a panic, serve a 500 error and then panic.
			if r := recover(); r != nil {
				s.writeError(ctx, resp, twirp.InternalError("Internal service panic"))
				panic(r)
			}
		}()
		respContent, err = s.GetClient(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *GetClientResponse and nil error while calling GetClient. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	respBytes, err := proto.Marshal(respContent)
	if err != nil {
		err = wrapErr(err, "failed to marshal proto response")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/protobuf")
	resp.WriteHeader(http.StatusOK)
	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *guardianServer) serveCreateClient(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	header := req.Header.Get("Content-Type")
	i := strings.Index(header, ";")
	if i == -1 {
		i = len(header)
	}
	switch strings.TrimSpace(strings.ToLower(header[:i])) {
	case "application/json":
		s.serveCreateClientJSON(ctx, resp, req)
	case "application/protobuf":
		s.serveCreateClientProtobuf(ctx, resp, req)
	default:
		msg := fmt.Sprintf("unexpected Content-Type: %q", req.Header.Get("Content-Type"))
		twerr := badRouteError(msg, req.Method, req.URL.Path)
		s.writeError(ctx, resp, twerr)
	}
}

func (s *guardianServer) serveCreateClientJSON(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "CreateClient")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	reqContent := new(CreateClientRequest)
	unmarshaler := jsonpb.Unmarshaler{AllowUnknownFields: true}
	if err = unmarshaler.Unmarshal(req.Body, reqContent); err != nil {
		err = wrapErr(err, "failed to parse request json")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	// Call service method
	var respContent *CreateClientResponse
	func() {
		defer func() {
			// In case of a panic, serve a 500 error and then panic.
			if r := recover(); r != nil {
				s.writeError(ctx, resp, twirp.InternalError("Internal service panic"))
				panic(r)
			}
		}()
		respContent, err = s.CreateClient(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *CreateClientResponse and nil error while calling CreateClient. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	var buf bytes.Buffer
	marshaler := &jsonpb.Marshaler{OrigName: true}
	if err = marshaler.Marshal(&buf, respContent); err != nil {
		err = wrapErr(err, "failed to marshal json response")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/json")
	resp.WriteHeader(http.StatusOK)

	respBytes := buf.Bytes()
	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *guardianServer) serveCreateClientProtobuf(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "CreateClient")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	buf, err := ioutil.ReadAll(req.Body)
	if err != nil {
		err = wrapErr(err, "failed to read request body")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}
	reqContent := new(CreateClientRequest)
	if err = proto.Unmarshal(buf, reqContent); err != nil {
		err = wrapErr(err, "failed to parse request proto")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	// Call service method
	var respContent *CreateClientResponse
	func() {
		defer func() {
			// In case of a panic, serve a 500 error and then panic.
			if r := recover(); r != nil {
				s.writeError(ctx, resp, twirp.InternalError("Internal service panic"))
				panic(r)
			}
		}()
		respContent, err = s.CreateClient(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *CreateClientResponse and nil error while calling CreateClient. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	respBytes, err := proto.Marshal(respContent)
	if err != nil {
		err = wrapErr(err, "failed to marshal proto response")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/protobuf")
	resp.WriteHeader(http.StatusOK)
	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *guardianServer) serveUpdateClient(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	header := req.Header.Get("Content-Type")
	i := strings.Index(header, ";")
	if i == -1 {
		i = len(header)
	}
	switch strings.TrimSpace(strings.ToLower(header[:i])) {
	case "application/json":
		s.serveUpdateClientJSON(ctx, resp, req)
	case "application/protobuf":
		s.serveUpdateClientProtobuf(ctx, resp, req)
	default:
		msg := fmt.Sprintf("unexpected Content-Type: %q", req.Header.Get("Content-Type"))
		twerr := badRouteError(msg, req.Method, req.URL.Path)
		s.writeError(ctx, resp, twerr)
	}
}

func (s *guardianServer) serveUpdateClientJSON(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "UpdateClient")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	reqContent := new(UpdateClientRequest)
	unmarshaler := jsonpb.Unmarshaler{AllowUnknownFields: true}
	if err = unmarshaler.Unmarshal(req.Body, reqContent); err != nil {
		err = wrapErr(err, "failed to parse request json")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	// Call service method
	var respContent *UpdateClientResponse
	func() {
		defer func() {
			// In case of a panic, serve a 500 error and then panic.
			if r := recover(); r != nil {
				s.writeError(ctx, resp, twirp.InternalError("Internal service panic"))
				panic(r)
			}
		}()
		respContent, err = s.UpdateClient(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *UpdateClientResponse and nil error while calling UpdateClient. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	var buf bytes.Buffer
	marshaler := &jsonpb.Marshaler{OrigName: true}
	if err = marshaler.Marshal(&buf, respContent); err != nil {
		err = wrapErr(err, "failed to marshal json response")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/json")
	resp.WriteHeader(http.StatusOK)

	respBytes := buf.Bytes()
	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *guardianServer) serveUpdateClientProtobuf(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "UpdateClient")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	buf, err := ioutil.ReadAll(req.Body)
	if err != nil {
		err = wrapErr(err, "failed to read request body")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}
	reqContent := new(UpdateClientRequest)
	if err = proto.Unmarshal(buf, reqContent); err != nil {
		err = wrapErr(err, "failed to parse request proto")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	// Call service method
	var respContent *UpdateClientResponse
	func() {
		defer func() {
			// In case of a panic, serve a 500 error and then panic.
			if r := recover(); r != nil {
				s.writeError(ctx, resp, twirp.InternalError("Internal service panic"))
				panic(r)
			}
		}()
		respContent, err = s.UpdateClient(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *UpdateClientResponse and nil error while calling UpdateClient. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	respBytes, err := proto.Marshal(respContent)
	if err != nil {
		err = wrapErr(err, "failed to marshal proto response")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/protobuf")
	resp.WriteHeader(http.StatusOK)
	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *guardianServer) serveDeleteClient(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	header := req.Header.Get("Content-Type")
	i := strings.Index(header, ";")
	if i == -1 {
		i = len(header)
	}
	switch strings.TrimSpace(strings.ToLower(header[:i])) {
	case "application/json":
		s.serveDeleteClientJSON(ctx, resp, req)
	case "application/protobuf":
		s.serveDeleteClientProtobuf(ctx, resp, req)
	default:
		msg := fmt.Sprintf("unexpected Content-Type: %q", req.Header.Get("Content-Type"))
		twerr := badRouteError(msg, req.Method, req.URL.Path)
		s.writeError(ctx, resp, twerr)
	}
}

func (s *guardianServer) serveDeleteClientJSON(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "DeleteClient")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	reqContent := new(DeleteClientRequest)
	unmarshaler := jsonpb.Unmarshaler{AllowUnknownFields: true}
	if err = unmarshaler.Unmarshal(req.Body, reqContent); err != nil {
		err = wrapErr(err, "failed to parse request json")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	// Call service method
	var respContent *google_protobuf.Empty
	func() {
		defer func() {
			// In case of a panic, serve a 500 error and then panic.
			if r := recover(); r != nil {
				s.writeError(ctx, resp, twirp.InternalError("Internal service panic"))
				panic(r)
			}
		}()
		respContent, err = s.DeleteClient(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *google_protobuf.Empty and nil error while calling DeleteClient. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	var buf bytes.Buffer
	marshaler := &jsonpb.Marshaler{OrigName: true}
	if err = marshaler.Marshal(&buf, respContent); err != nil {
		err = wrapErr(err, "failed to marshal json response")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/json")
	resp.WriteHeader(http.StatusOK)

	respBytes := buf.Bytes()
	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *guardianServer) serveDeleteClientProtobuf(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "DeleteClient")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	buf, err := ioutil.ReadAll(req.Body)
	if err != nil {
		err = wrapErr(err, "failed to read request body")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}
	reqContent := new(DeleteClientRequest)
	if err = proto.Unmarshal(buf, reqContent); err != nil {
		err = wrapErr(err, "failed to parse request proto")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	// Call service method
	var respContent *google_protobuf.Empty
	func() {
		defer func() {
			// In case of a panic, serve a 500 error and then panic.
			if r := recover(); r != nil {
				s.writeError(ctx, resp, twirp.InternalError("Internal service panic"))
				panic(r)
			}
		}()
		respContent, err = s.DeleteClient(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *google_protobuf.Empty and nil error while calling DeleteClient. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	respBytes, err := proto.Marshal(respContent)
	if err != nil {
		err = wrapErr(err, "failed to marshal proto response")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/protobuf")
	resp.WriteHeader(http.StatusOK)
	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *guardianServer) ServiceDescriptor() ([]byte, int) {
	return twirpFileDescriptor0, 0
}

func (s *guardianServer) ProtocGenTwirpVersion() string {
	return "v5.3.0"
}

// =====
// Utils
// =====

// HTTPClient is the interface used by generated clients to send HTTP requests.
// It is fulfilled by *(net/http).Client, which is sufficient for most users.
// Users can provide their own implementation for special retry policies.
//
// HTTPClient implementations should not follow redirects. Redirects are
// automatically disabled if *(net/http).Client is passed to client
// constructors. See the withoutRedirects function in this file for more
// details.
type HTTPClient interface {
	Do(req *http.Request) (*http.Response, error)
}

// TwirpServer is the interface generated server structs will support: they're
// HTTP handlers with additional methods for accessing metadata about the
// service. Those accessors are a low-level API for building reflection tools.
// Most people can think of TwirpServers as just http.Handlers.
type TwirpServer interface {
	http.Handler
	// ServiceDescriptor returns gzipped bytes describing the .proto file that
	// this service was generated from. Once unzipped, the bytes can be
	// unmarshalled as a
	// github.com/golang/protobuf/protoc-gen-go/descriptor.FileDescriptorProto.
	//
	// The returned integer is the index of this particular service within that
	// FileDescriptorProto's 'Service' slice of ServiceDescriptorProtos. This is a
	// low-level field, expected to be used for reflection.
	ServiceDescriptor() ([]byte, int)
	// ProtocGenTwirpVersion is the semantic version string of the version of
	// twirp used to generate this file.
	ProtocGenTwirpVersion() string
}

// WriteError writes an HTTP response with a valid Twirp error format.
// If err is not a twirp.Error, it will get wrapped with twirp.InternalErrorWith(err)
func WriteError(resp http.ResponseWriter, err error) {
	writeError(context.Background(), resp, err, nil)
}

// writeError writes Twirp errors in the response and triggers hooks.
func writeError(ctx context.Context, resp http.ResponseWriter, err error, hooks *twirp.ServerHooks) {
	// Non-twirp errors are wrapped as Internal (default)
	twerr, ok := err.(twirp.Error)
	if !ok {
		twerr = twirp.InternalErrorWith(err)
	}

	statusCode := twirp.ServerHTTPStatusFromErrorCode(twerr.Code())
	ctx = ctxsetters.WithStatusCode(ctx, statusCode)
	ctx = callError(ctx, hooks, twerr)

	resp.Header().Set("Content-Type", "application/json") // Error responses are always JSON (instead of protobuf)
	resp.WriteHeader(statusCode)                          // HTTP response status code

	respBody := marshalErrorToJSON(twerr)
	_, writeErr := resp.Write(respBody)
	if writeErr != nil {
		// We have three options here. We could log the error, call the Error
		// hook, or just silently ignore the error.
		//
		// Logging is unacceptable because we don't have a user-controlled
		// logger; writing out to stderr without permission is too rude.
		//
		// Calling the Error hook would confuse users: it would mean the Error
		// hook got called twice for one request, which is likely to lead to
		// duplicated log messages and metrics, no matter how well we document
		// the behavior.
		//
		// Silently ignoring the error is our least-bad option. It's highly
		// likely that the connection is broken and the original 'err' says
		// so anyway.
		_ = writeErr
	}

	callResponseSent(ctx, hooks)
}

// urlBase helps ensure that addr specifies a scheme. If it is unparsable
// as a URL, it returns addr unchanged.
func urlBase(addr string) string {
	// If the addr specifies a scheme, use it. If not, default to
	// http. If url.Parse fails on it, return it unchanged.
	url, err := url.Parse(addr)
	if err != nil {
		return addr
	}
	if url.Scheme == "" {
		url.Scheme = "http"
	}
	return url.String()
}

// getCustomHTTPReqHeaders retrieves a copy of any headers that are set in
// a context through the twirp.WithHTTPRequestHeaders function.
// If there are no headers set, or if they have the wrong type, nil is returned.
func getCustomHTTPReqHeaders(ctx context.Context) http.Header {
	header, ok := twirp.HTTPRequestHeaders(ctx)
	if !ok || header == nil {
		return nil
	}
	copied := make(http.Header)
	for k, vv := range header {
		if vv == nil {
			copied[k] = nil
			continue
		}
		copied[k] = make([]string, len(vv))
		copy(copied[k], vv)
	}
	return copied
}

// newRequest makes an http.Request from a client, adding common headers.
func newRequest(ctx context.Context, url string, reqBody io.Reader, contentType string) (*http.Request, error) {
	req, err := http.NewRequest("POST", url, reqBody)
	if err != nil {
		return nil, err
	}
	req = req.WithContext(ctx)
	if customHeader := getCustomHTTPReqHeaders(ctx); customHeader != nil {
		req.Header = customHeader
	}
	req.Header.Set("Accept", contentType)
	req.Header.Set("Content-Type", contentType)
	req.Header.Set("Twirp-Version", "v5.3.0")
	return req, nil
}

// JSON serialization for errors
type twerrJSON struct {
	Code string            `json:"code"`
	Msg  string            `json:"msg"`
	Meta map[string]string `json:"meta,omitempty"`
}

// marshalErrorToJSON returns JSON from a twirp.Error, that can be used as HTTP error response body.
// If serialization fails, it will use a descriptive Internal error instead.
func marshalErrorToJSON(twerr twirp.Error) []byte {
	// make sure that msg is not too large
	msg := twerr.Msg()
	if len(msg) > 1e6 {
		msg = msg[:1e6]
	}

	tj := twerrJSON{
		Code: string(twerr.Code()),
		Msg:  msg,
		Meta: twerr.MetaMap(),
	}

	buf, err := json.Marshal(&tj)
	if err != nil {
		buf = []byte("{\"type\": \"" + twirp.Internal + "\", \"msg\": \"There was an error but it could not be serialized into JSON\"}") // fallback
	}

	return buf
}

// errorFromResponse builds a twirp.Error from a non-200 HTTP response.
// If the response has a valid serialized Twirp error, then it's returned.
// If not, the response status code is used to generate a similar twirp
// error. See twirpErrorFromIntermediary for more info on intermediary errors.
func errorFromResponse(resp *http.Response) twirp.Error {
	statusCode := resp.StatusCode
	statusText := http.StatusText(statusCode)

	if isHTTPRedirect(statusCode) {
		// Unexpected redirect: it must be an error from an intermediary.
		// Twirp clients don't follow redirects automatically, Twirp only handles
		// POST requests, redirects should only happen on GET and HEAD requests.
		location := resp.Header.Get("Location")
		msg := fmt.Sprintf("unexpected HTTP status code %d %q received, Location=%q", statusCode, statusText, location)
		return twirpErrorFromIntermediary(statusCode, msg, location)
	}

	respBodyBytes, err := ioutil.ReadAll(resp.Body)
	if err != nil {
		return clientError("failed to read server error response body", err)
	}
	var tj twerrJSON
	if err := json.Unmarshal(respBodyBytes, &tj); err != nil {
		// Invalid JSON response; it must be an error from an intermediary.
		msg := fmt.Sprintf("Error from intermediary with HTTP status code %d %q", statusCode, statusText)
		return twirpErrorFromIntermediary(statusCode, msg, string(respBodyBytes))
	}

	errorCode := twirp.ErrorCode(tj.Code)
	if !twirp.IsValidErrorCode(errorCode) {
		msg := "invalid type returned from server error response: " + tj.Code
		return twirp.InternalError(msg)
	}

	twerr := twirp.NewError(errorCode, tj.Msg)
	for k, v := range tj.Meta {
		twerr = twerr.WithMeta(k, v)
	}
	return twerr
}

// twirpErrorFromIntermediary maps HTTP errors from non-twirp sources to twirp errors.
// The mapping is similar to gRPC: https://github.com/grpc/grpc/blob/master/doc/http-grpc-status-mapping.md.
// Returned twirp Errors have some additional metadata for inspection.
func twirpErrorFromIntermediary(status int, msg string, bodyOrLocation string) twirp.Error {
	var code twirp.ErrorCode
	if isHTTPRedirect(status) { // 3xx
		code = twirp.Internal
	} else {
		switch status {
		case 400: // Bad Request
			code = twirp.Internal
		case 401: // Unauthorized
			code = twirp.Unauthenticated
		case 403: // Forbidden
			code = twirp.PermissionDenied
		case 404: // Not Found
			code = twirp.BadRoute
		case 429, 502, 503, 504: // Too Many Requests, Bad Gateway, Service Unavailable, Gateway Timeout
			code = twirp.Unavailable
		default: // All other codes
			code = twirp.Unknown
		}
	}

	twerr := twirp.NewError(code, msg)
	twerr = twerr.WithMeta("http_error_from_intermediary", "true") // to easily know if this error was from intermediary
	twerr = twerr.WithMeta("status_code", strconv.Itoa(status))
	if isHTTPRedirect(status) {
		twerr = twerr.WithMeta("location", bodyOrLocation)
	} else {
		twerr = twerr.WithMeta("body", bodyOrLocation)
	}
	return twerr
}
func isHTTPRedirect(status int) bool {
	return status >= 300 && status <= 399
}

// wrappedError implements the github.com/pkg/errors.Causer interface, allowing errors to be
// examined for their root cause.
type wrappedError struct {
	msg   string
	cause error
}

func wrapErr(err error, msg string) error { return &wrappedError{msg: msg, cause: err} }
func (e *wrappedError) Cause() error      { return e.cause }
func (e *wrappedError) Error() string     { return e.msg + ": " + e.cause.Error() }

// clientError adds consistency to errors generated in the client
func clientError(desc string, err error) twirp.Error {
	return twirp.InternalErrorWith(wrapErr(err, desc))
}

// badRouteError is used when the twirp server cannot route a request
func badRouteError(msg string, method, url string) twirp.Error {
	err := twirp.NewError(twirp.BadRoute, msg)
	err = err.WithMeta("twirp_invalid_route", method+" "+url)
	return err
}

// The standard library will, by default, redirect requests (including POSTs) if it gets a 302 or
// 303 response, and also 301s in go1.8. It redirects by making a second request, changing the
// method to GET and removing the body. This produces very confusing error messages, so instead we
// set a redirect policy that always errors. This stops Go from executing the redirect.
//
// We have to be a little careful in case the user-provided http.Client has its own CheckRedirect
// policy - if so, we'll run through that policy first.
//
// Because this requires modifying the http.Client, we make a new copy of the client and return it.
func withoutRedirects(in *http.Client) *http.Client {
	copy := *in
	copy.CheckRedirect = func(req *http.Request, via []*http.Request) error {
		if in.CheckRedirect != nil {
			// Run the input's redirect if it exists, in case it has side effects, but ignore any error it
			// returns, since we want to use ErrUseLastResponse.
			err := in.CheckRedirect(req, via)
			_ = err // Silly, but this makes sure generated code passes errcheck -blank, which some people use.
		}
		return http.ErrUseLastResponse
	}
	return &copy
}

// doProtobufRequest is common code to make a request to the remote twirp service.
func doProtobufRequest(ctx context.Context, client HTTPClient, url string, in, out proto.Message) (err error) {
	reqBodyBytes, err := proto.Marshal(in)
	if err != nil {
		return clientError("failed to marshal proto request", err)
	}
	reqBody := bytes.NewBuffer(reqBodyBytes)
	if err = ctx.Err(); err != nil {
		return clientError("aborted because context was done", err)
	}

	req, err := newRequest(ctx, url, reqBody, "application/protobuf")
	if err != nil {
		return clientError("could not build request", err)
	}
	resp, err := client.Do(req)
	if err != nil {
		return clientError("failed to do request", err)
	}

	defer func() {
		cerr := resp.Body.Close()
		if err == nil && cerr != nil {
			err = clientError("failed to close response body", cerr)
		}
	}()

	if err = ctx.Err(); err != nil {
		return clientError("aborted because context was done", err)
	}

	if resp.StatusCode != 200 {
		return errorFromResponse(resp)
	}

	respBodyBytes, err := ioutil.ReadAll(resp.Body)
	if err != nil {
		return clientError("failed to read response body", err)
	}
	if err = ctx.Err(); err != nil {
		return clientError("aborted because context was done", err)
	}

	if err = proto.Unmarshal(respBodyBytes, out); err != nil {
		return clientError("failed to unmarshal proto response", err)
	}
	return nil
}

// doJSONRequest is common code to make a request to the remote twirp service.
func doJSONRequest(ctx context.Context, client HTTPClient, url string, in, out proto.Message) (err error) {
	reqBody := bytes.NewBuffer(nil)
	marshaler := &jsonpb.Marshaler{OrigName: true}
	if err = marshaler.Marshal(reqBody, in); err != nil {
		return clientError("failed to marshal json request", err)
	}
	if err = ctx.Err(); err != nil {
		return clientError("aborted because context was done", err)
	}

	req, err := newRequest(ctx, url, reqBody, "application/json")
	if err != nil {
		return clientError("could not build request", err)
	}
	resp, err := client.Do(req)
	if err != nil {
		return clientError("failed to do request", err)
	}

	defer func() {
		cerr := resp.Body.Close()
		if err == nil && cerr != nil {
			err = clientError("failed to close response body", cerr)
		}
	}()

	if err = ctx.Err(); err != nil {
		return clientError("aborted because context was done", err)
	}

	if resp.StatusCode != 200 {
		return errorFromResponse(resp)
	}

	unmarshaler := jsonpb.Unmarshaler{AllowUnknownFields: true}
	if err = unmarshaler.Unmarshal(resp.Body, out); err != nil {
		return clientError("failed to unmarshal json response", err)
	}
	if err = ctx.Err(); err != nil {
		return clientError("aborted because context was done", err)
	}
	return nil
}

// Call twirp.ServerHooks.RequestReceived if the hook is available
func callRequestReceived(ctx context.Context, h *twirp.ServerHooks) (context.Context, error) {
	if h == nil || h.RequestReceived == nil {
		return ctx, nil
	}
	return h.RequestReceived(ctx)
}

// Call twirp.ServerHooks.RequestRouted if the hook is available
func callRequestRouted(ctx context.Context, h *twirp.ServerHooks) (context.Context, error) {
	if h == nil || h.RequestRouted == nil {
		return ctx, nil
	}
	return h.RequestRouted(ctx)
}

// Call twirp.ServerHooks.ResponsePrepared if the hook is available
func callResponsePrepared(ctx context.Context, h *twirp.ServerHooks) context.Context {
	if h == nil || h.ResponsePrepared == nil {
		return ctx
	}
	return h.ResponsePrepared(ctx)
}

// Call twirp.ServerHooks.ResponseSent if the hook is available
func callResponseSent(ctx context.Context, h *twirp.ServerHooks) {
	if h == nil || h.ResponseSent == nil {
		return
	}
	h.ResponseSent(ctx)
}

// Call twirp.ServerHooks.Error if the hook is available
func callError(ctx context.Context, h *twirp.ServerHooks, err twirp.Error) context.Context {
	if h == nil || h.Error == nil {
		return ctx
	}
	return h.Error(ctx, err)
}

var twirpFileDescriptor0 = []byte{
	// 1191 bytes of a gzipped FileDescriptorProto
	0x1f, 0x8b, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0xff, 0xec, 0x98, 0x4d, 0x6f, 0xdc, 0xc4,
	0x1f, 0xc7, 0x65, 0x67, 0x1f, 0x7f, 0xbb, 0x49, 0x93, 0xd9, 0xfc, 0x2b, 0xd7, 0x7f, 0x90, 0x82,
	0x11, 0x28, 0xea, 0xc1, 0x56, 0x17, 0x71, 0xe1, 0x49, 0x2a, 0x49, 0x9a, 0x52, 0x10, 0x0f, 0x6e,
	0x7b, 0x00, 0x0e, 0x2b, 0xc7, 0x9e, 0x6e, 0x26, 0xda, 0xb5, 0xcd, 0xcc, 0x78, 0xd5, 0x10, 0x55,
	0x42, 0xdc, 0x38, 0x57, 0x42, 0x42, 0xe2, 0xcc, 0x1b, 0x40, 0x85, 0x0b, 0x12, 0xe2, 0xca, 0x81,
	0x0b, 0x6f, 0x81, 0x0b, 0xef, 0x02, 0xcd, 0xc3, 0x7a, 0xed, 0x64, 0x2b, 0x22, 0x3b, 0x1c, 0xaa,
	0xf4, 0x14, 0xcf, 0xd8, 0xfe, 0xce, 0x77, 0x3e, 0xf3, 0xf5, 0xcc, 0x2f, 0x0b, 0xbb, 0x61, 0x12,
	0x61, 0xf7, 0x28, 0x63, 0x9c, 0xc4, 0x2e, 0x9f, 0x79, 0x14, 0x4f, 0x70, 0xc0, 0xb0, 0xc7, 0x69,
	0x10, 0x62, 0x8f, 0xc4, 0x1c, 0xd3, 0x38, 0x98, 0x78, 0xf8, 0x21, 0xf7, 0xc6, 0x59, 0x40, 0x23,
	0x12, 0xc4, 0xa3, 0xd9, 0x8d, 0xfc, 0xda, 0x4d, 0x69, 0xc2, 0x13, 0xf4, 0xba, 0x50, 0x19, 0x29,
	0x95, 0x11, 0x9f, 0xb9, 0x5a, 0xc5, 0x95, 0x2a, 0xee, 0x5c, 0xc5, 0xc5, 0x0f, 0xb9, 0x9b, 0xbf,
	0x39, 0xbb, 0x61, 0xbf, 0x30, 0x4e, 0x92, 0xf1, 0x04, 0x7b, 0x41, 0x4a, 0xbc, 0x20, 0x8e, 0x13,
	0x1e, 0x70, 0x92, 0xc4, 0x4c, 0x89, 0xda, 0xff, 0xd7, 0x77, 0x65, 0xeb, 0x20, 0x7b, 0xe0, 0xe1,
	0x69, 0xca, 0x8f, 0xd5, 0x4d, 0xe7, 0x77, 0x13, 0x1a, 0xf7, 0x19, 0xa6, 0x68, 0x0d, 0x4c, 0x12,
	0x59, 0xc6, 0x96, 0xb1, 0xdd, 0xf5, 0x4d, 0x12, 0x21, 0x04, 0x0d, 0x7e, 0x9c, 0x62, 0xcb, 0x94,
	0x3d, 0xf2, 0x1a, 0x3d, 0x00, 0x08, 0x38, 0xa7, 0xe4, 0x20, 0xe3, 0x98, 0x59, 0x2b, 0x5b, 0xc6,
	0x76, 0x6f, 0x78, 0xcb, 0xad, 0xe4, 0xd9, 0x15, 0x83, 0xba, 0x37, 0x73, 0x35, 0xbf, 0xa0, 0x6c,
	0x3f, 0x31, 0x00, 0x16, 0xb7, 0xd0, 0x3a, 0xac, 0x64, 0xb9, 0x37, 0x71, 0x89, 0x5e, 0x04, 0xc8,
	0x48, 0x34, 0x8a, 0xb3, 0xe9, 0x01, 0xa6, 0xd2, 0x62, 0xd3, 0xef, 0x66, 0x24, 0xfa, 0x50, 0x76,
	0xa0, 0x4d, 0x68, 0xe2, 0x69, 0x40, 0x26, 0xd2, 0x62, 0xd7, 0x57, 0x0d, 0x31, 0xc3, 0x30, 0xb6,
	0x1a, 0x6a, 0x86, 0x61, 0x2c, 0x44, 0xc6, 0x0b, 0x91, 0xa6, 0x12, 0x19, 0xe7, 0x22, 0xd7, 0xa0,
	0x73, 0x98, 0x4c, 0xf1, 0x28, 0x22, 0xd4, 0x6a, 0xc9, 0x97, 0xda, 0xa2, 0xbd, 0x4b, 0x28, 0xba,
	0x0a, 0xad, 0x31, 0x4d, 0xb2, 0x94, 0x59, 0xed, 0xad, 0x95, 0xed, 0xae, 0xaf, 0x5b, 0xce, 0x57,
	0x26, 0x34, 0xf7, 0xc5, 0xe5, 0xb9, 0x68, 0x8e, 0x97, 0xd0, 0xdc, 0xaf, 0x48, 0x53, 0x8e, 0xfa,
	0x34, 0x9c, 0x47, 0xa7, 0x69, 0x8e, 0xb5, 0xb7, 0xa6, 0x2f, 0x2e, 0x35, 0x18, 0x33, 0x07, 0xb3,
	0x05, 0xbd, 0x08, 0xb3, 0x90, 0x92, 0x54, 0xc4, 0x48, 0x43, 0x2c, 0x76, 0x21, 0x0b, 0xda, 0x53,
	0x2c, 0x28, 0x31, 0xab, 0x21, 0x09, 0xcc, 0x9b, 0xce, 0xaf, 0x2b, 0xd0, 0xda, 0x99, 0x10, 0x1c,
	0xf3, 0x73, 0x31, 0x38, 0x5c, 0xc2, 0xe0, 0x76, 0x45, 0x06, 0x6a, 0xd8, 0xa7, 0x41, 0xf8, 0xc1,
	0x2c, 0x51, 0x58, 0x62, 0x2e, 0x0e, 0xa6, 0xb9, 0x39, 0x71, 0x7d, 0x3e, 0x0e, 0x33, 0x4c, 0x99,
	0xb8, 0xab, 0x72, 0x35, 0x6f, 0x22, 0x07, 0xfa, 0x14, 0x47, 0x84, 0xe2, 0x90, 0x8f, 0x32, 0x4a,
	0x64, 0xbc, 0xba, 0x7e, 0xa9, 0x0f, 0xd9, 0x2a, 0x61, 0x69, 0x30, 0xc6, 0x3a, 0x61, 0x79, 0x5b,
	0x8c, 0xcd, 0x70, 0x48, 0x31, 0x1f, 0x1d, 0x06, 0xec, 0xd0, 0x6a, 0xab, 0xb1, 0x0b, 0x5d, 0xe8,
	0x55, 0x58, 0x13, 0x7f, 0x47, 0xc1, 0x64, 0x9c, 0x50, 0xc2, 0x0f, 0xa7, 0x56, 0x47, 0x3e, 0x74,
	0xaa, 0x57, 0x84, 0x95, 0x85, 0x49, 0x8a, 0x99, 0xd5, 0x55, 0x61, 0x55, 0xad, 0x42, 0x88, 0xa1,
	0x14, 0xe2, 0x97, 0xa1, 0x7d, 0x87, 0x25, 0xf1, 0xcd, 0x94, 0x14, 0xa7, 0x67, 0x94, 0xa6, 0xe7,
	0xfc, 0x61, 0x40, 0x73, 0x8f, 0xd2, 0x44, 0x7e, 0x6b, 0x9c, 0xf0, 0x09, 0xd6, 0x4f, 0xa8, 0x86,
	0x10, 0x8f, 0x30, 0x17, 0x9f, 0xa0, 0x02, 0xaa, 0x5b, 0xd2, 0x0c, 0x0f, 0x78, 0xc6, 0x34, 0x4d,
	0xdd, 0x42, 0x9f, 0x43, 0x8b, 0x25, 0x19, 0x0d, 0xb1, 0xe4, 0xd8, 0x1b, 0xee, 0x54, 0xcc, 0x80,
	0xf4, 0xe4, 0xde, 0x95, 0x52, 0xbe, 0x96, 0xb4, 0x1d, 0x68, 0xa9, 0x1e, 0x31, 0xa1, 0x34, 0x91,
	0x2f, 0xcf, 0x27, 0xa4, 0x9b, 0x0e, 0x82, 0xf5, 0x0f, 0x08, 0xe3, 0x62, 0x57, 0x62, 0x3e, 0xfe,
	0x22, 0xc3, 0x8c, 0x3b, 0xdf, 0x9a, 0xb0, 0x51, 0xe8, 0x64, 0x69, 0x12, 0x33, 0x8c, 0x3e, 0x86,
	0x66, 0x26, 0x3a, 0x2c, 0x63, 0x6b, 0x65, 0xbb, 0x37, 0x7c, 0xb3, 0xc6, 0xfe, 0xe7, 0x37, 0xa2,
	0x80, 0x07, 0xe8, 0x53, 0xe8, 0x1c, 0xb1, 0x24, 0x1e, 0x05, 0x29, 0x91, 0xb8, 0x7a, 0xc3, 0x77,
	0x2a, 0x8a, 0xea, 0x85, 0xf3, 0xdb, 0x42, 0x2f, 0x48, 0x09, 0xba, 0x07, 0x2d, 0x2c, 0x90, 0x08,
	0xde, 0xc2, 0xed, 0x5b, 0x75, 0xb8, 0xfa, 0x5a, 0xcb, 0x71, 0x60, 0x6d, 0x1f, 0x4b, 0x2c, 0x1a,
	0xd5, 0xd9, 0x2d, 0xda, 0x79, 0x6c, 0xc2, 0x95, 0xfc, 0x21, 0x8d, 0xee, 0x23, 0x68, 0x08, 0x74,
	0xf2, 0xb1, 0xcb, 0x49, 0x6e, 0xa0, 0x12, 0x25, 0xb7, 0xeb, 0x3c, 0x67, 0xdf, 0x99, 0x80, 0x8a,
	0xbd, 0x9a, 0x96, 0x9f, 0x7f, 0xa0, 0x46, 0x2d, 0x07, 0x52, 0xf6, 0x59, 0x05, 0xf6, 0x92, 0x4c,
	0x91, 0x9a, 0x82, 0xce, 0x9a, 0x3a, 0xae, 0x8c, 0xf9, 0x71, 0x25, 0x3e, 0xd3, 0xf5, 0xc5, 0x33,
	0x1a, 0xde, 0x27, 0xd0, 0x94, 0xf0, 0x74, 0xd6, 0x2e, 0x25, 0xbb, 0x4d, 0x15, 0x2b, 0x75, 0x2e,
	0xe6, 0x69, 0xfb, 0xde, 0x84, 0x41, 0xa9, 0x5b, 0x13, 0xbb, 0x07, 0xed, 0x50, 0x75, 0xe9, 0xbc,
	0xbd, 0x5d, 0xeb, 0x1c, 0x7e, 0x76, 0xf7, 0x36, 0x11, 0x26, 0x3d, 0x87, 0x45, 0xe2, 0x8a, 0xc5,
	0x82, 0xf8, 0x60, 0x37, 0x0a, 0x0f, 0x69, 0x80, 0x77, 0xa1, 0xa5, 0x00, 0xea, 0xcc, 0x5d, 0x4e,
	0x7e, 0x47, 0x30, 0xd8, 0xa1, 0x38, 0xe0, 0xb8, 0x8c, 0xf0, 0xbf, 0x80, 0x23, 0xa2, 0xbc, 0x59,
	0x1e, 0xec, 0xf9, 0x52, 0x14, 0x96, 0xe2, 0x4b, 0x18, 0xdc, 0x4f, 0xa3, 0x33, 0x4b, 0x71, 0xba,
	0xf4, 0x5d, 0xc0, 0x32, 0x2f, 0x76, 0x69, 0xca, 0x83, 0x3f, 0x5f, 0x9a, 0xc2, 0xd2, 0xbc, 0x02,
	0x83, 0x5d, 0x3c, 0xc1, 0xff, 0xb2, 0x34, 0xc3, 0xbf, 0xfb, 0xd0, 0xd9, 0xd7, 0x22, 0xe8, 0x47,
	0x03, 0xba, 0x79, 0x39, 0x8a, 0xaa, 0xfe, 0xa7, 0x78, 0xba, 0xca, 0xb5, 0x6f, 0xd7, 0x17, 0x52,
	0x4b, 0xeb, 0x0c, 0xbe, 0xfe, 0xf3, 0xaf, 0xc7, 0xe6, 0x2a, 0xea, 0x79, 0x93, 0x28, 0x48, 0x3d,
	0x59, 0x25, 0x0b, 0xd7, 0x6d, 0x5d, 0x07, 0xa2, 0xbd, 0xaa, 0xa7, 0x70, 0xa9, 0xd8, 0xb4, 0x6f,
	0xd5, 0x95, 0xd1, 0x7e, 0xaf, 0x49, 0xbf, 0x03, 0xb4, 0x51, 0xf0, 0xeb, 0x9d, 0x64, 0x24, 0x7a,
	0x84, 0x7e, 0x36, 0x00, 0x16, 0x25, 0x19, 0xaa, 0xc3, 0xa8, 0x54, 0xeb, 0xd9, 0xef, 0x5d, 0x80,
	0x92, 0xb6, 0xbf, 0x29, 0xed, 0xaf, 0xa1, 0xbe, 0xb2, 0xaf, 0x6a, 0x45, 0xf4, 0x93, 0x01, 0x9d,
	0x79, 0x35, 0x84, 0x6a, 0x90, 0x2a, 0x96, 0x5c, 0xf6, 0x7e, 0x6d, 0x9d, 0xe5, 0xc8, 0x95, 0x67,
	0xef, 0x24, 0x8c, 0x1f, 0x09, 0xe3, 0xbd, 0x42, 0x5d, 0x82, 0xea, 0x90, 0x2a, 0x97, 0x3c, 0xf6,
	0x9d, 0x8b, 0x90, 0xd2, 0x33, 0x58, 0x97, 0x33, 0x00, 0xd4, 0xf1, 0x74, 0xb5, 0x84, 0x9e, 0x18,
	0xd0, 0xcd, 0xab, 0x01, 0x54, 0x03, 0x55, 0x69, 0x2f, 0xa8, 0xfc, 0x5d, 0x9e, 0x29, 0x4c, 0x9c,
	0xff, 0x49, 0xcb, 0x57, 0xd0, 0xea, 0xdc, 0xb2, 0x77, 0x22, 0x32, 0xfe, 0x8b, 0x01, 0xfd, 0xe2,
	0xe9, 0x89, 0xaa, 0x62, 0x5a, 0x72, 0xde, 0xdb, 0xef, 0x5f, 0x88, 0x56, 0x79, 0x63, 0x71, 0x72,
	0xe6, 0x6f, 0x18, 0xd7, 0xd1, 0x6f, 0x06, 0xf4, 0x8b, 0x27, 0x4c, 0x65, 0xfb, 0x4b, 0xce, 0xc8,
	0xca, 0xf6, 0x97, 0x1d, 0x79, 0x8e, 0x25, 0xed, 0xa3, 0x61, 0x99, 0xbf, 0x98, 0xc3, 0x37, 0x06,
	0xf4, 0x8b, 0xe7, 0x40, 0xe5, 0x39, 0x2c, 0x39, 0x4c, 0xec, 0xab, 0xae, 0xfa, 0xe1, 0xd7, 0x9d,
	0xff, 0xf0, 0xeb, 0xee, 0x4d, 0x53, 0x7e, 0x3c, 0x8f, 0xc3, 0xf5, 0xb2, 0x9d, 0x77, 0x57, 0x3f,
	0xeb, 0x15, 0x7e, 0x99, 0x3e, 0x68, 0xc9, 0xb7, 0x5e, 0xfb, 0x27, 0x00, 0x00, 0xff, 0xff, 0xc7,
	0xb2, 0x43, 0xe7, 0xd9, 0x16, 0x00, 0x00,
}
