package metrics

import "time"

func jitterDuration(i int, d time.Duration, rng func(i int64) int64) time.Duration {
	delta := rng(int64(d)) + 1
	if i > 0 {
		// First sleep is in range [0.0, 1.0).
		// Subsequent sleeps are in range [0.8, 1.0).
		delta /= 5
	}
	return d - time.Duration(delta)
}
