// Code generated by protoc-gen-go. DO NOT EDIT.
// source: code.justin.tv/release/trace/pbmsg/event.proto

package pbmsg

import proto "github.com/golang/protobuf/proto"
import fmt "fmt"
import math "math"

// Reference imports to suppress errors if they are not otherwise used.
var _ = proto.Marshal
var _ = fmt.Errorf
var _ = math.Inf

type Compression int32

const (
	// The data is not compressed.
	Compression_NONE Compression = 0
	// The data is comressed with gzip.
	Compression_GZIP Compression = 1
)

var Compression_name = map[int32]string{
	0: "NONE",
	1: "GZIP",
}
var Compression_value = map[string]int32{
	"NONE": 0,
	"GZIP": 1,
}

func (x Compression) Enum() *Compression {
	p := new(Compression)
	*p = x
	return p
}
func (x Compression) String() string {
	return proto.EnumName(Compression_name, int32(x))
}
func (x *Compression) UnmarshalJSON(data []byte) error {
	value, err := proto.UnmarshalJSONEnum(Compression_value, data, "Compression")
	if err != nil {
		return err
	}
	*x = Compression(value)
	return nil
}
func (Compression) EnumDescriptor() ([]byte, []int) { return fileDescriptor1, []int{0} }

// Kind describes the type of event instrumented.
//
// When a request-response RPC takes place, there are several identifiable
// instants that can be observed by the client, and several that can be
// observed by the server.  Each of those is assigned a different Kind
// value.  An program may only be instrumented to measure a small subset
// of the possible events.  The goal of the Kind enumeration is to
// document all known events precisely, so that if two programs emit an
// event with a particular Kind, that the results will be comparable.
//
// If a program wishes to emit an event which is not described by an
// existing Kind value, a new Kind should be written to fit the bill.  The
// new value should be reusable across other programs with similar
// requirements and should not be particular to the language or framework
// used.
type Event_Kind int32

const (
	// Server reads the beginning of a request.  The server has received
	// sufficient data from the client to determine which Trace
	// transaction the request should be attributed to, if any.  If the
	// protocol differentiates between a metadata preamble and a payload
	// that follows, this event is emitted immediately after the entire
	// metadata has been received.
	//
	// For an HTTP request, this would be when the transport has presented
	// the request URI and headers are presented to the application.
	Event_REQUEST_HEAD_RECEIVED Event_Kind = 20
	// Server finishes reading the last of the request body.
	//
	// For an HTTP request, this would be when the transport has presented
	// the last of the request body to the application and notified it
	// that no more body data will be received.  Trailers may be yet to
	// come.
	Event_REQUEST_BODY_RECEIVED Event_Kind = 21
	// Server responds to a request.  There has not yet been any direct
	// communication to the client about the client's request on the
	// application layer, but the server will change that immediately
	// after generating this event.  Transport-layer acknowledgement of
	// data receipt does not trigger this event.
	//
	// For an HTTP response, this would be when the status code and
	// headers are presented to the HTTP transport, before any bytes are
	// written to the wire.
	Event_RESPONSE_HEAD_PREPARED Event_Kind = 30
	// Server has sent the last of the response body to the client.
	//
	// For an HTTP response, this would be when the last of the response
	// body has been accepted by the HTTP transport, and the application
	// has notified the transport that no more body data will be sent.
	Event_RESPONSE_BODY_SENT Event_Kind = 31
	// Client initiates a request.  There has been no indication given to
	// the outside world that this particular request is about to take
	// place.  The application knows enough about the request to begin
	// making externally-visible actions.
	//
	// For an HTTP request, this would be when the request URI and headers
	// are presented to the HTTP transport, before any bytes are written
	// to the wire.  The hostname may still need to be resolved, a TCP
	// connection may still need to be established, a TLS handshake may
	// still need to take place.
	Event_REQUEST_HEAD_PREPARED Event_Kind = 40
	// Client finishes the externally-visible actions required for the
	// request.
	//
	// For an HTTP request, this would be when the last of the request
	// body has been accepted by the HTTP transport, and the application
	// has notified the transport that no more body data will be sent.
	Event_REQUEST_BODY_SENT Event_Kind = 41
	// Client reads the beginning of the response.  The response metadata
	// has been read and is ready to be presented to the application's
	// business logic, giving some initial indication of if the RPC
	// succeeded.  The response body has not yet been read.
	//
	// For an HTTP response, this would be when the client's HTTP
	// transport has read and decoded the full response headers from the
	// wire and is presenting them to the application, but before the
	// response body has been consumed.
	Event_RESPONSE_HEAD_RECEIVED Event_Kind = 50
	// Client finishes reading the last of the response body.
	//
	// For an HTTP response, this would be when the transport has
	// presented the last of the response body to the application and
	// notified it that no more body data will be received.  Trailers may
	// be yet to come.
	Event_RESPONSE_BODY_RECEIVED Event_Kind = 51
)

var Event_Kind_name = map[int32]string{
	20: "REQUEST_HEAD_RECEIVED",
	21: "REQUEST_BODY_RECEIVED",
	30: "RESPONSE_HEAD_PREPARED",
	31: "RESPONSE_BODY_SENT",
	40: "REQUEST_HEAD_PREPARED",
	41: "REQUEST_BODY_SENT",
	50: "RESPONSE_HEAD_RECEIVED",
	51: "RESPONSE_BODY_RECEIVED",
}
var Event_Kind_value = map[string]int32{
	"REQUEST_HEAD_RECEIVED":  20,
	"REQUEST_BODY_RECEIVED":  21,
	"RESPONSE_HEAD_PREPARED": 30,
	"RESPONSE_BODY_SENT":     31,
	"REQUEST_HEAD_PREPARED":  40,
	"REQUEST_BODY_SENT":      41,
	"RESPONSE_HEAD_RECEIVED": 50,
	"RESPONSE_BODY_RECEIVED": 51,
}

func (x Event_Kind) Enum() *Event_Kind {
	p := new(Event_Kind)
	*p = x
	return p
}
func (x Event_Kind) String() string {
	return proto.EnumName(Event_Kind_name, int32(x))
}
func (x *Event_Kind) UnmarshalJSON(data []byte) error {
	value, err := proto.UnmarshalJSONEnum(Event_Kind_value, data, "Event_Kind")
	if err != nil {
		return err
	}
	*x = Event_Kind(value)
	return nil
}
func (Event_Kind) EnumDescriptor() ([]byte, []int) { return fileDescriptor1, []int{0, 0} }

// https://www.iana.org/assignments/http-methods/http-methods.xhtml
type ExtraHTTP_Method int32

const (
	// invalid, default value
	ExtraHTTP_UNKNOWN ExtraHTTP_Method = 0
	// https://tools.ietf.org/html/rfc7231#section-4.3.1  safe, idempotent
	ExtraHTTP_GET ExtraHTTP_Method = 1
	// https://tools.ietf.org/html/rfc7231#section-4.3.2  safe, idempotent
	ExtraHTTP_HEAD ExtraHTTP_Method = 2
	// https://tools.ietf.org/html/rfc7231#section-4.3.3
	ExtraHTTP_POST ExtraHTTP_Method = 3
	// https://tools.ietf.org/html/rfc7231#section-4.3.4  idempotent
	ExtraHTTP_PUT ExtraHTTP_Method = 4
	// https://tools.ietf.org/html/rfc7231#section-4.3.5  idempotent
	ExtraHTTP_DELETE ExtraHTTP_Method = 5
	// https://tools.ietf.org/html/rfc7231#section-4.3.6
	ExtraHTTP_CONNECT ExtraHTTP_Method = 6
	// https://tools.ietf.org/html/rfc7231#section-4.3.7  safe, idempotent
	ExtraHTTP_OPTIONS ExtraHTTP_Method = 7
	// https://tools.ietf.org/html/rfc7231#section-4.3.8  safe, idempotent
	ExtraHTTP_TRACE ExtraHTTP_Method = 8
	// https://tools.ietf.org/html/rfc5789
	ExtraHTTP_PATCH ExtraHTTP_Method = 9
)

var ExtraHTTP_Method_name = map[int32]string{
	0: "UNKNOWN",
	1: "GET",
	2: "HEAD",
	3: "POST",
	4: "PUT",
	5: "DELETE",
	6: "CONNECT",
	7: "OPTIONS",
	8: "TRACE",
	9: "PATCH",
}
var ExtraHTTP_Method_value = map[string]int32{
	"UNKNOWN": 0,
	"GET":     1,
	"HEAD":    2,
	"POST":    3,
	"PUT":     4,
	"DELETE":  5,
	"CONNECT": 6,
	"OPTIONS": 7,
	"TRACE":   8,
	"PATCH":   9,
}

func (x ExtraHTTP_Method) Enum() *ExtraHTTP_Method {
	p := new(ExtraHTTP_Method)
	*p = x
	return p
}
func (x ExtraHTTP_Method) String() string {
	return proto.EnumName(ExtraHTTP_Method_name, int32(x))
}
func (x *ExtraHTTP_Method) UnmarshalJSON(data []byte) error {
	value, err := proto.UnmarshalJSONEnum(ExtraHTTP_Method_value, data, "ExtraHTTP_Method")
	if err != nil {
		return err
	}
	*x = ExtraHTTP_Method(value)
	return nil
}
func (ExtraHTTP_Method) EnumDescriptor() ([]byte, []int) { return fileDescriptor1, []int{2, 0} }

type ExtraMemcached_MemcachedCommand int32

const (
	// Default value - unset. Probably an administrative
	// command like STAT.
	ExtraMemcached_UNKNOWN_COMMAND ExtraMemcached_MemcachedCommand = 0
	// Set means "store this data."
	ExtraMemcached_SET ExtraMemcached_MemcachedCommand = 1
	// Add means "store this data, but only if the server
	// doesn't already have data for this key."
	ExtraMemcached_ADD ExtraMemcached_MemcachedCommand = 2
	// Replace means "store this data, but only if the
	// server *does* have data for this key."
	ExtraMemcached_REPLACE ExtraMemcached_MemcachedCommand = 3
	// Append means "add this data to an existing key
	// after existing data." Append does not come with an
	// expiration time.
	ExtraMemcached_APPEND ExtraMemcached_MemcachedCommand = 4
	// Prepend means "add this data to an existing key
	// before existing data." Prepend does not come with
	// an expiration time.
	ExtraMemcached_PREPEND ExtraMemcached_MemcachedCommand = 5
	// Compare-and-set means "Store this data, if and only
	// if no one else has updated since I last fetched
	// it."
	ExtraMemcached_CAS ExtraMemcached_MemcachedCommand = 6
	// Get retrieves one or more keys. If no_reply is set
	// to true, then the server will not respond in the
	// case of cache misses, so it is the client's
	// responsibility to match up which requested keys
	// actually got a VALUE response if they ask for
	// multiple keys at once.
	ExtraMemcached_GET ExtraMemcached_MemcachedCommand = 7
	// Gets is like Get, but asks for the cas_unique to be
	// sent along with the response.
	ExtraMemcached_GETS ExtraMemcached_MemcachedCommand = 8
	// Delete forcibly removes a key.
	ExtraMemcached_DELETE ExtraMemcached_MemcachedCommand = 9
	// Incr means "increment this key by this amount." The
	// server returns the new value of the key.
	ExtraMemcached_INCR ExtraMemcached_MemcachedCommand = 10
	// Decr means "decrement this key by this amount." The
	// server returns the new value of the key.
	ExtraMemcached_DECR ExtraMemcached_MemcachedCommand = 11
)

var ExtraMemcached_MemcachedCommand_name = map[int32]string{
	0:  "UNKNOWN_COMMAND",
	1:  "SET",
	2:  "ADD",
	3:  "REPLACE",
	4:  "APPEND",
	5:  "PREPEND",
	6:  "CAS",
	7:  "GET",
	8:  "GETS",
	9:  "DELETE",
	10: "INCR",
	11: "DECR",
}
var ExtraMemcached_MemcachedCommand_value = map[string]int32{
	"UNKNOWN_COMMAND": 0,
	"SET":             1,
	"ADD":             2,
	"REPLACE":         3,
	"APPEND":          4,
	"PREPEND":         5,
	"CAS":             6,
	"GET":             7,
	"GETS":            8,
	"DELETE":          9,
	"INCR":            10,
	"DECR":            11,
}

func (x ExtraMemcached_MemcachedCommand) Enum() *ExtraMemcached_MemcachedCommand {
	p := new(ExtraMemcached_MemcachedCommand)
	*p = x
	return p
}
func (x ExtraMemcached_MemcachedCommand) String() string {
	return proto.EnumName(ExtraMemcached_MemcachedCommand_name, int32(x))
}
func (x *ExtraMemcached_MemcachedCommand) UnmarshalJSON(data []byte) error {
	value, err := proto.UnmarshalJSONEnum(ExtraMemcached_MemcachedCommand_value, data, "ExtraMemcached_MemcachedCommand")
	if err != nil {
		return err
	}
	*x = ExtraMemcached_MemcachedCommand(value)
	return nil
}
func (ExtraMemcached_MemcachedCommand) EnumDescriptor() ([]byte, []int) {
	return fileDescriptor1, []int{4, 0}
}

// An Event represents a single Trace-worthy event.  This includes RPC
// lifecycle events (client started to send a request, server finishes sending
// a response), and application-specific custom events.
type Event struct {
	// Lifecycle event this message is attached to
	Kind *Event_Kind `protobuf:"varint,1,opt,name=kind,enum=code.justin.tv.release.trace.pbmsg.Event_Kind" json:"kind,omitempty"`
	// Unix epoch time in nanoseconds, as measured by the process
	Time *int64 `protobuf:"fixed64,2,opt,name=time" json:"time,omitempty"`
	// FQDN of the process's host
	Hostname *string `protobuf:"bytes,3,opt,name=hostname" json:"hostname,omitempty"`
	// Service name of the process
	Svcname *string `protobuf:"bytes,4,opt,name=svcname" json:"svcname,omitempty"`
	// PID of the process
	Pid *int32 `protobuf:"varint,5,opt,name=pid" json:"pid,omitempty"`
	// 128-bit identifier for the entire transaction.  This field is sent as
	// two 64-bit integers, least significant word first.
	TransactionId []uint64 `protobuf:"fixed64,6,rep,packed,name=transaction_id,json=transactionId" json:"transaction_id,omitempty"`
	// Identifier for a single RPC span (one request leading to one response).
	// Each level of the distributed call stack adds a new element to the path
	// field.  The value at each level is the (zero-indexed) number of
	// outbound RPC requests made at that level.
	Path []uint32 `protobuf:"varint,7,rep,packed,name=path" json:"path,omitempty"`
	// Additional protocol-specific information
	Extra *Extra `protobuf:"bytes,8,opt,name=extra" json:"extra,omitempty"`
	// Amazon Resource Name for the process's EC2 instance.  This may be sent
	// instead of the hostname field.
	Ec2Arn           *string `protobuf:"bytes,20,opt,name=ec2_arn,json=ec2Arn" json:"ec2_arn,omitempty"`
	XXX_unrecognized []byte  `json:"-"`
}

func (m *Event) Reset()                    { *m = Event{} }
func (m *Event) String() string            { return proto.CompactTextString(m) }
func (*Event) ProtoMessage()               {}
func (*Event) Descriptor() ([]byte, []int) { return fileDescriptor1, []int{0} }

func (m *Event) GetKind() Event_Kind {
	if m != nil && m.Kind != nil {
		return *m.Kind
	}
	return Event_REQUEST_HEAD_RECEIVED
}

func (m *Event) GetTime() int64 {
	if m != nil && m.Time != nil {
		return *m.Time
	}
	return 0
}

func (m *Event) GetHostname() string {
	if m != nil && m.Hostname != nil {
		return *m.Hostname
	}
	return ""
}

func (m *Event) GetSvcname() string {
	if m != nil && m.Svcname != nil {
		return *m.Svcname
	}
	return ""
}

func (m *Event) GetPid() int32 {
	if m != nil && m.Pid != nil {
		return *m.Pid
	}
	return 0
}

func (m *Event) GetTransactionId() []uint64 {
	if m != nil {
		return m.TransactionId
	}
	return nil
}

func (m *Event) GetPath() []uint32 {
	if m != nil {
		return m.Path
	}
	return nil
}

func (m *Event) GetExtra() *Extra {
	if m != nil {
		return m.Extra
	}
	return nil
}

func (m *Event) GetEc2Arn() string {
	if m != nil && m.Ec2Arn != nil {
		return *m.Ec2Arn
	}
	return ""
}

// An Extra describes protocol-specific information to be associated with an
// Event.
type Extra struct {
	// The address of the peer.  This could be an ipv4:port pair, [ipv6]:port
	// pair, or hostname:port pair for TCP/UDP-based protocols, a bare IP
	// address or hostname for IP- based protocols, or a path to a unix domain
	// socket.
	//
	// This field is NOT an attempt to identify the client, e.g. via the HTTP
	// X-Forwarded-For header.
	Peer *string `protobuf:"bytes,1,opt,name=peer" json:"peer,omitempty"`
	// Additional HTTP-specific information for the Event.
	Http *ExtraHTTP `protobuf:"bytes,2,opt,name=http" json:"http,omitempty"`
	// Additional SQL-specific information for the Event.
	Sql *ExtraSQL `protobuf:"bytes,3,opt,name=sql" json:"sql,omitempty"`
	// Additional Memcached-specific information for the Event.
	Memcached *ExtraMemcached `protobuf:"bytes,4,opt,name=memcached" json:"memcached,omitempty"`
	// Additional gRPC-specific information for the Event.
	Grpc             *ExtraGRPC `protobuf:"bytes,5,opt,name=grpc" json:"grpc,omitempty"`
	XXX_unrecognized []byte     `json:"-"`
}

func (m *Extra) Reset()                    { *m = Extra{} }
func (m *Extra) String() string            { return proto.CompactTextString(m) }
func (*Extra) ProtoMessage()               {}
func (*Extra) Descriptor() ([]byte, []int) { return fileDescriptor1, []int{1} }

func (m *Extra) GetPeer() string {
	if m != nil && m.Peer != nil {
		return *m.Peer
	}
	return ""
}

func (m *Extra) GetHttp() *ExtraHTTP {
	if m != nil {
		return m.Http
	}
	return nil
}

func (m *Extra) GetSql() *ExtraSQL {
	if m != nil {
		return m.Sql
	}
	return nil
}

func (m *Extra) GetMemcached() *ExtraMemcached {
	if m != nil {
		return m.Memcached
	}
	return nil
}

func (m *Extra) GetGrpc() *ExtraGRPC {
	if m != nil {
		return m.Grpc
	}
	return nil
}

// An ExtraHTTP describes HTTP-specific information to be associated with an
// Event.
type ExtraHTTP struct {
	// Status code of HTTP response.  Common values will include 200 or 404.
	// Values less than zero indicate an error observed by the client which
	// caused it to give up on the request before getting a status code from
	// the server.
	StatusCode *int32 `protobuf:"zigzag32,1,opt,name=status_code,json=statusCode" json:"status_code,omitempty"`
	// Method of HTTP request.
	Method *ExtraHTTP_Method `protobuf:"varint,2,opt,name=method,enum=code.justin.tv.release.trace.pbmsg.ExtraHTTP_Method" json:"method,omitempty"`
	// Path of the HTTP request.  This is only the path - the scheme,
	// hostname, query, and fragment are not included.
	UriPath          *string `protobuf:"bytes,16,opt,name=uri_path,json=uriPath" json:"uri_path,omitempty"`
	XXX_unrecognized []byte  `json:"-"`
}

func (m *ExtraHTTP) Reset()                    { *m = ExtraHTTP{} }
func (m *ExtraHTTP) String() string            { return proto.CompactTextString(m) }
func (*ExtraHTTP) ProtoMessage()               {}
func (*ExtraHTTP) Descriptor() ([]byte, []int) { return fileDescriptor1, []int{2} }

func (m *ExtraHTTP) GetStatusCode() int32 {
	if m != nil && m.StatusCode != nil {
		return *m.StatusCode
	}
	return 0
}

func (m *ExtraHTTP) GetMethod() ExtraHTTP_Method {
	if m != nil && m.Method != nil {
		return *m.Method
	}
	return ExtraHTTP_UNKNOWN
}

func (m *ExtraHTTP) GetUriPath() string {
	if m != nil && m.UriPath != nil {
		return *m.UriPath
	}
	return ""
}

// An ExtraSQL describes SQL-specific information to be associated with an
// Event.
type ExtraSQL struct {
	// Name of the target database.
	DatabaseName *string `protobuf:"bytes,1,opt,name=database_name,json=databaseName" json:"database_name,omitempty"`
	// Username used to connect to the target database.
	DatabaseUser *string `protobuf:"bytes,2,opt,name=database_user,json=databaseUser" json:"database_user,omitempty"`
	// Query string with all user data removed: e.g. strings replaced by '',
	// integers replaced by 0, etc.  This value may be truncated (particularly
	// if it's larger than 1kB).
	StrippedQuery    *string `protobuf:"bytes,16,opt,name=stripped_query,json=strippedQuery" json:"stripped_query,omitempty"`
	XXX_unrecognized []byte  `json:"-"`
}

func (m *ExtraSQL) Reset()                    { *m = ExtraSQL{} }
func (m *ExtraSQL) String() string            { return proto.CompactTextString(m) }
func (*ExtraSQL) ProtoMessage()               {}
func (*ExtraSQL) Descriptor() ([]byte, []int) { return fileDescriptor1, []int{3} }

func (m *ExtraSQL) GetDatabaseName() string {
	if m != nil && m.DatabaseName != nil {
		return *m.DatabaseName
	}
	return ""
}

func (m *ExtraSQL) GetDatabaseUser() string {
	if m != nil && m.DatabaseUser != nil {
		return *m.DatabaseUser
	}
	return ""
}

func (m *ExtraSQL) GetStrippedQuery() string {
	if m != nil && m.StrippedQuery != nil {
		return *m.StrippedQuery
	}
	return ""
}

// An ExtraMemcached describes memcached-specific information to be
// associated with an event. Most of this was written with the
// assistance of the memcached protocol spec at
// https://github.com/memcached/memcached/blob/c10feb9ebe2179f6fbe4ac2e3cd12bfefdd42631/doc/protocol.txt.
type ExtraMemcached struct {
	// The command sent to memcached by a client
	Command *ExtraMemcached_MemcachedCommand `protobuf:"varint,1,opt,name=command,enum=code.justin.tv.release.trace.pbmsg.ExtraMemcached_MemcachedCommand" json:"command,omitempty"`
	// The number of keys in this memcached event. This is useful
	// for understanding bulk transactions: the request side might
	// ask for 150 keys, but the response side might have only
	// 100, indicating that the cache was hit for 100 out of the
	// 150 requested keys.
	NKeys *uint32 `protobuf:"varint,2,opt,name=n_keys,json=nKeys" json:"n_keys,omitempty"`
	// Some commands involve the client setting a 32-bit integer
	// expiration time. According to the memcached protocol spec,
	// this may be either a Unix time, or a number of seconds
	// starting from current time. The memcached server decides
	// which it is by the size of the expiration time: if the
	// value is less than or equal to 60*60*24*30 (30 days), then
	// it's taken as a relative expiration; if it's over this
	// amount then it is interpreted as Unix time. If its set to
	// zero, then the item never expires.
	Expiration       *uint32 `protobuf:"fixed32,3,opt,name=expiration" json:"expiration,omitempty"`
	XXX_unrecognized []byte  `json:"-"`
}

func (m *ExtraMemcached) Reset()                    { *m = ExtraMemcached{} }
func (m *ExtraMemcached) String() string            { return proto.CompactTextString(m) }
func (*ExtraMemcached) ProtoMessage()               {}
func (*ExtraMemcached) Descriptor() ([]byte, []int) { return fileDescriptor1, []int{4} }

func (m *ExtraMemcached) GetCommand() ExtraMemcached_MemcachedCommand {
	if m != nil && m.Command != nil {
		return *m.Command
	}
	return ExtraMemcached_UNKNOWN_COMMAND
}

func (m *ExtraMemcached) GetNKeys() uint32 {
	if m != nil && m.NKeys != nil {
		return *m.NKeys
	}
	return 0
}

func (m *ExtraMemcached) GetExpiration() uint32 {
	if m != nil && m.Expiration != nil {
		return *m.Expiration
	}
	return 0
}

// An ExtraGRPC describes gRPC-specific information to be associated with an
// event.
type ExtraGRPC struct {
	// Fully-qualified method name, including proto package name, service
	// name, and method name.
	Method           *string `protobuf:"bytes,1,opt,name=method" json:"method,omitempty"`
	XXX_unrecognized []byte  `json:"-"`
}

func (m *ExtraGRPC) Reset()                    { *m = ExtraGRPC{} }
func (m *ExtraGRPC) String() string            { return proto.CompactTextString(m) }
func (*ExtraGRPC) ProtoMessage()               {}
func (*ExtraGRPC) Descriptor() ([]byte, []int) { return fileDescriptor1, []int{5} }

func (m *ExtraGRPC) GetMethod() string {
	if m != nil && m.Method != nil {
		return *m.Method
	}
	return ""
}

// An UnusedExtra describes protocol-specific information to be associated
// with an Event.  This message is not yet ready for use, meaning that the
// field names, identities, and numbers are subject to change!
type UnusedExtra struct {
	// written by an engineer - "string" means utf-8 encoded, which should be
	// fine?
	Text          *string `protobuf:"bytes,20,opt,name=text" json:"text,omitempty"`
	TextTruncated *bool   `protobuf:"varint,1020,opt,name=text_truncated,json=textTruncated" json:"text_truncated,omitempty"`
	// if there's a payload, how big is it?
	PayloadSize *int64 `protobuf:"varint,21,opt,name=payload_size,json=payloadSize" json:"payload_size,omitempty"`
	// request uri
	HttpUri          *string `protobuf:"bytes,41,opt,name=http_uri,json=httpUri" json:"http_uri,omitempty"`
	HttpUriTruncated *bool   `protobuf:"varint,1041,opt,name=http_uri_truncated,json=httpUriTruncated" json:"http_uri_truncated,omitempty"`
	// headers, partial list
	HttpHeader []*UnusedExtra_KV `protobuf:"bytes,43,rep,name=http_header,json=httpHeader" json:"http_header,omitempty"`
	// if there are headers that we expect to be very long, we may want to
	// pull them out into their own fields so we can note when we truncate
	// them
	HttpReferer          *string `protobuf:"bytes,44,opt,name=http_referer,json=httpReferer" json:"http_referer,omitempty"`
	HttpRefererTruncated *bool   `protobuf:"varint,1044,opt,name=http_referer_truncated,json=httpRefererTruncated" json:"http_referer_truncated,omitempty"`
	XXX_unrecognized     []byte  `json:"-"`
}

func (m *UnusedExtra) Reset()                    { *m = UnusedExtra{} }
func (m *UnusedExtra) String() string            { return proto.CompactTextString(m) }
func (*UnusedExtra) ProtoMessage()               {}
func (*UnusedExtra) Descriptor() ([]byte, []int) { return fileDescriptor1, []int{6} }

func (m *UnusedExtra) GetText() string {
	if m != nil && m.Text != nil {
		return *m.Text
	}
	return ""
}

func (m *UnusedExtra) GetTextTruncated() bool {
	if m != nil && m.TextTruncated != nil {
		return *m.TextTruncated
	}
	return false
}

func (m *UnusedExtra) GetPayloadSize() int64 {
	if m != nil && m.PayloadSize != nil {
		return *m.PayloadSize
	}
	return 0
}

func (m *UnusedExtra) GetHttpUri() string {
	if m != nil && m.HttpUri != nil {
		return *m.HttpUri
	}
	return ""
}

func (m *UnusedExtra) GetHttpUriTruncated() bool {
	if m != nil && m.HttpUriTruncated != nil {
		return *m.HttpUriTruncated
	}
	return false
}

func (m *UnusedExtra) GetHttpHeader() []*UnusedExtra_KV {
	if m != nil {
		return m.HttpHeader
	}
	return nil
}

func (m *UnusedExtra) GetHttpReferer() string {
	if m != nil && m.HttpReferer != nil {
		return *m.HttpReferer
	}
	return ""
}

func (m *UnusedExtra) GetHttpRefererTruncated() bool {
	if m != nil && m.HttpRefererTruncated != nil {
		return *m.HttpRefererTruncated
	}
	return false
}

// if we use proto3 we can just use maps
type UnusedExtra_KV struct {
	// option map_entry = true;
	Key              *string `protobuf:"bytes,1,opt,name=key" json:"key,omitempty"`
	Value            *string `protobuf:"bytes,2,opt,name=value" json:"value,omitempty"`
	XXX_unrecognized []byte  `json:"-"`
}

func (m *UnusedExtra_KV) Reset()                    { *m = UnusedExtra_KV{} }
func (m *UnusedExtra_KV) String() string            { return proto.CompactTextString(m) }
func (*UnusedExtra_KV) ProtoMessage()               {}
func (*UnusedExtra_KV) Descriptor() ([]byte, []int) { return fileDescriptor1, []int{6, 0} }

func (m *UnusedExtra_KV) GetKey() string {
	if m != nil && m.Key != nil {
		return *m.Key
	}
	return ""
}

func (m *UnusedExtra_KV) GetValue() string {
	if m != nil && m.Value != nil {
		return *m.Value
	}
	return ""
}

// An EventSet is a list of Events.  It may be used when sending multiple
// events in a datagram, or when saving them to disk.  There is no codified or
// implied relation between Events grouped into an EventSet.
type EventSet struct {
	// List of Events
	Event []*Event `protobuf:"bytes,1,rep,name=event" json:"event,omitempty"`
	// A compressed EventSet. If this is set, then the event field should be empty.
	CompressedEventSet []byte `protobuf:"bytes,2,opt,name=compressed_event_set,json=compressedEventSet" json:"compressed_event_set,omitempty"`
	// The compression codec used to encode compressed_event_set.
	Compression      *Compression `protobuf:"varint,3,opt,name=compression,enum=code.justin.tv.release.trace.pbmsg.Compression" json:"compression,omitempty"`
	XXX_unrecognized []byte       `json:"-"`
}

func (m *EventSet) Reset()                    { *m = EventSet{} }
func (m *EventSet) String() string            { return proto.CompactTextString(m) }
func (*EventSet) ProtoMessage()               {}
func (*EventSet) Descriptor() ([]byte, []int) { return fileDescriptor1, []int{7} }

func (m *EventSet) GetEvent() []*Event {
	if m != nil {
		return m.Event
	}
	return nil
}

func (m *EventSet) GetCompressedEventSet() []byte {
	if m != nil {
		return m.CompressedEventSet
	}
	return nil
}

func (m *EventSet) GetCompression() Compression {
	if m != nil && m.Compression != nil {
		return *m.Compression
	}
	return Compression_NONE
}

func init() {
	proto.RegisterType((*Event)(nil), "code.justin.tv.release.trace.pbmsg.Event")
	proto.RegisterType((*Extra)(nil), "code.justin.tv.release.trace.pbmsg.Extra")
	proto.RegisterType((*ExtraHTTP)(nil), "code.justin.tv.release.trace.pbmsg.ExtraHTTP")
	proto.RegisterType((*ExtraSQL)(nil), "code.justin.tv.release.trace.pbmsg.ExtraSQL")
	proto.RegisterType((*ExtraMemcached)(nil), "code.justin.tv.release.trace.pbmsg.ExtraMemcached")
	proto.RegisterType((*ExtraGRPC)(nil), "code.justin.tv.release.trace.pbmsg.ExtraGRPC")
	proto.RegisterType((*UnusedExtra)(nil), "code.justin.tv.release.trace.pbmsg.UnusedExtra")
	proto.RegisterType((*UnusedExtra_KV)(nil), "code.justin.tv.release.trace.pbmsg.UnusedExtra.KV")
	proto.RegisterType((*EventSet)(nil), "code.justin.tv.release.trace.pbmsg.EventSet")
	proto.RegisterEnum("code.justin.tv.release.trace.pbmsg.Compression", Compression_name, Compression_value)
	proto.RegisterEnum("code.justin.tv.release.trace.pbmsg.Event_Kind", Event_Kind_name, Event_Kind_value)
	proto.RegisterEnum("code.justin.tv.release.trace.pbmsg.ExtraHTTP_Method", ExtraHTTP_Method_name, ExtraHTTP_Method_value)
	proto.RegisterEnum("code.justin.tv.release.trace.pbmsg.ExtraMemcached_MemcachedCommand", ExtraMemcached_MemcachedCommand_name, ExtraMemcached_MemcachedCommand_value)
}

func init() { proto.RegisterFile("code.justin.tv/release/trace/pbmsg/event.proto", fileDescriptor1) }

var fileDescriptor1 = []byte{
	// 1127 bytes of a gzipped FileDescriptorProto
	0x1f, 0x8b, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0xff, 0x94, 0x55, 0xc1, 0x6e, 0xdb, 0x46,
	0x13, 0x0e, 0x45, 0x49, 0x94, 0x86, 0x91, 0xfe, 0xcd, 0xfe, 0xb6, 0xcb, 0xe4, 0x90, 0x28, 0x0c,
	0x5a, 0xc8, 0x6d, 0x42, 0x17, 0x6a, 0x7b, 0xe9, 0xa1, 0x85, 0x4c, 0x11, 0xb1, 0x61, 0x9b, 0xa2,
	0x97, 0x54, 0x8a, 0x06, 0x28, 0x08, 0x86, 0xdc, 0x46, 0xac, 0x2d, 0x8a, 0x59, 0xae, 0x5c, 0x3b,
	0x7d, 0x87, 0x02, 0x05, 0x0a, 0xf4, 0xd0, 0x53, 0x9f, 0xa1, 0xaf, 0xd0, 0x07, 0xe8, 0xb9, 0xcf,
	0xd2, 0x43, 0xb1, 0x4b, 0x49, 0xa6, 0x9b, 0x43, 0xe5, 0x13, 0x67, 0x67, 0xe6, 0x9b, 0xd9, 0x99,
	0xf9, 0x38, 0x0b, 0x56, 0x3c, 0x4f, 0xa8, 0xf5, 0xdd, 0xa2, 0xe0, 0x69, 0x66, 0xf1, 0x8b, 0x3d,
	0x46, 0xcf, 0x69, 0x54, 0xd0, 0x3d, 0xce, 0xa2, 0x98, 0xee, 0xe5, 0xaf, 0x66, 0xc5, 0xeb, 0x3d,
	0x7a, 0x41, 0x33, 0x6e, 0xe5, 0x6c, 0xce, 0xe7, 0xd8, 0xbc, 0xe9, 0x6f, 0x2d, 0xfd, 0x2d, 0xe9,
	0x6f, 0x49, 0x7f, 0xf3, 0xb7, 0x3a, 0x34, 0x1c, 0x81, 0xc1, 0xfb, 0x50, 0x3f, 0x4b, 0xb3, 0xc4,
	0x50, 0x7a, 0x4a, 0xbf, 0x3b, 0xb0, 0xac, 0xff, 0x06, 0x5b, 0x12, 0x68, 0x1d, 0xa5, 0x59, 0x42,
	0x24, 0x16, 0x63, 0xa8, 0xf3, 0x74, 0x46, 0x8d, 0x5a, 0x4f, 0xe9, 0x23, 0x22, 0x65, 0xfc, 0x00,
	0x5a, 0xd3, 0x79, 0xc1, 0xb3, 0x68, 0x46, 0x0d, 0xb5, 0xa7, 0xf4, 0xdb, 0x64, 0x7d, 0xc6, 0x06,
	0x68, 0xc5, 0x45, 0x2c, 0x4d, 0x75, 0x69, 0x5a, 0x1d, 0x31, 0x02, 0x35, 0x4f, 0x13, 0xa3, 0xd1,
	0x53, 0xfa, 0x0d, 0x22, 0x44, 0xbc, 0x0b, 0x5d, 0xce, 0xa2, 0xac, 0x88, 0x62, 0x9e, 0xce, 0xb3,
	0x30, 0x4d, 0x8c, 0x66, 0x4f, 0xed, 0x37, 0xf7, 0x6b, 0x48, 0x21, 0x9d, 0x8a, 0xe5, 0x30, 0xc1,
	0x3b, 0x50, 0xcf, 0x23, 0x3e, 0x35, 0xb4, 0x9e, 0xda, 0xef, 0x48, 0x07, 0x79, 0xc6, 0x5f, 0x42,
	0x83, 0x5e, 0x72, 0x16, 0x19, 0xad, 0x9e, 0xd2, 0xd7, 0x07, 0xbb, 0x1b, 0xd5, 0x28, 0x00, 0xa4,
	0xc4, 0xe1, 0xf7, 0x40, 0xa3, 0xf1, 0x20, 0x8c, 0x58, 0x66, 0x6c, 0xc9, 0xfb, 0x36, 0x69, 0x3c,
	0x18, 0xb2, 0xcc, 0xfc, 0x4b, 0x81, 0xba, 0xe8, 0x03, 0xbe, 0x0f, 0xdb, 0xc4, 0x39, 0x9d, 0x38,
	0x7e, 0x10, 0x1e, 0x38, 0xc3, 0x51, 0x48, 0x1c, 0xdb, 0x39, 0x7c, 0xe1, 0x8c, 0xd0, 0x56, 0xd5,
	0xb4, 0x3f, 0x1e, 0x7d, 0x7d, 0x6d, 0xda, 0xc6, 0x0f, 0x60, 0x87, 0x38, 0xbe, 0x37, 0x76, 0x7d,
	0xa7, 0x84, 0x79, 0xc4, 0xf1, 0x86, 0xc4, 0x19, 0xa1, 0x87, 0x78, 0x07, 0xf0, 0xda, 0x26, 0x71,
	0xbe, 0xe3, 0x06, 0xe8, 0xd1, 0x3b, 0x99, 0xd6, 0x90, 0x3e, 0xde, 0x86, 0x7b, 0x37, 0x32, 0x49,
	0xc4, 0xee, 0xbb, 0x59, 0xd6, 0x37, 0x18, 0xdc, 0xb0, 0xdd, 0xbc, 0xdd, 0x27, 0xe6, 0xef, 0x35,
	0x68, 0xc8, 0x36, 0x88, 0xf9, 0xe6, 0x94, 0x32, 0xc9, 0x91, 0x36, 0x91, 0x32, 0x1e, 0x42, 0x7d,
	0xca, 0x79, 0x2e, 0x67, 0xae, 0x0f, 0x9e, 0x6d, 0xdc, 0xd3, 0x83, 0x20, 0xf0, 0x88, 0x84, 0xe2,
	0x2f, 0x40, 0x2d, 0xde, 0x9c, 0x4b, 0x76, 0xe8, 0x83, 0xa7, 0x1b, 0x47, 0xf0, 0x4f, 0x8f, 0x89,
	0x00, 0x62, 0x0f, 0xda, 0x33, 0x3a, 0x8b, 0xa3, 0x78, 0x4a, 0x13, 0x49, 0x24, 0x7d, 0x30, 0xd8,
	0x38, 0xca, 0xc9, 0x0a, 0x49, 0xae, 0x83, 0x88, 0xa2, 0x5e, 0xb3, 0x3c, 0x96, 0xfc, 0xbb, 0x4d,
	0x51, 0xcf, 0x89, 0x67, 0x13, 0x09, 0x35, 0x7f, 0xac, 0x41, 0x7b, 0x5d, 0x28, 0x7e, 0x04, 0x7a,
	0xc1, 0x23, 0xbe, 0x28, 0x42, 0x11, 0x4a, 0x36, 0xf0, 0x1e, 0x81, 0x52, 0x65, 0xcf, 0x13, 0x8a,
	0x8f, 0xa1, 0x39, 0xa3, 0x7c, 0x3a, 0x4f, 0x64, 0x23, 0xbb, 0x83, 0x4f, 0x6f, 0xd5, 0x48, 0xeb,
	0x44, 0x62, 0xc9, 0x32, 0x06, 0xbe, 0x0f, 0xad, 0x05, 0x4b, 0x43, 0xf9, 0x17, 0xa0, 0xf2, 0xcf,
	0x5a, 0xb0, 0xd4, 0x8b, 0xf8, 0xd4, 0xfc, 0x1e, 0x9a, 0xa5, 0x33, 0xd6, 0x41, 0x9b, 0xb8, 0x47,
	0xee, 0xf8, 0x2b, 0x17, 0xdd, 0xc1, 0x1a, 0xa8, 0xcf, 0x9d, 0x00, 0x29, 0xb8, 0x05, 0x75, 0x41,
	0x0e, 0x54, 0x13, 0x92, 0x37, 0xf6, 0x03, 0xa4, 0x0a, 0xa3, 0x37, 0x09, 0x50, 0x1d, 0x03, 0x34,
	0x47, 0xce, 0xb1, 0x13, 0x38, 0xa8, 0x21, 0xe0, 0xf6, 0xd8, 0x75, 0x1d, 0x3b, 0x40, 0x4d, 0x71,
	0x18, 0x7b, 0xc1, 0xe1, 0xd8, 0xf5, 0x91, 0x86, 0xdb, 0xd0, 0x08, 0xc8, 0xd0, 0x76, 0x50, 0x4b,
	0x88, 0xde, 0x30, 0xb0, 0x0f, 0x50, 0xdb, 0xfc, 0x01, 0x5a, 0xab, 0xb1, 0xe1, 0x27, 0xd0, 0x49,
	0x22, 0x1e, 0xbd, 0x8a, 0x0a, 0x1a, 0xca, 0xdf, 0xbf, 0x64, 0xd4, 0xdd, 0x95, 0xd2, 0x15, 0x3b,
	0xa0, 0xea, 0xb4, 0x28, 0x28, 0x93, 0x9d, 0xa9, 0x38, 0x4d, 0x0a, 0xca, 0xf0, 0xfb, 0xd0, 0x2d,
	0x38, 0x4b, 0xf3, 0x9c, 0x26, 0xe1, 0x9b, 0x05, 0x65, 0x57, 0xcb, 0x7a, 0x3b, 0x2b, 0xed, 0xa9,
	0x50, 0x9a, 0x7f, 0xd4, 0xa0, 0x7b, 0x73, 0xdc, 0xf8, 0x1b, 0xd0, 0xe2, 0xf9, 0x6c, 0x16, 0xad,
	0x77, 0x9e, 0x7d, 0x7b, 0xce, 0x58, 0x6b, 0xc9, 0x2e, 0x43, 0x91, 0x55, 0x4c, 0xbc, 0x0d, 0xcd,
	0x2c, 0x3c, 0xa3, 0x57, 0x85, 0xbc, 0x76, 0x87, 0x34, 0xb2, 0x23, 0x7a, 0x55, 0xe0, 0x87, 0x00,
	0xf4, 0x32, 0x4f, 0x59, 0x24, 0x76, 0x95, 0xa4, 0xbc, 0x46, 0x2a, 0x1a, 0xf3, 0x57, 0x05, 0xd0,
	0xbf, 0x83, 0xe2, 0xff, 0xc3, 0xff, 0x96, 0x93, 0x0a, 0xed, 0xf1, 0xc9, 0xc9, 0xd0, 0x1d, 0x95,
	0x13, 0xf3, 0xe5, 0xc4, 0x34, 0x50, 0x87, 0x23, 0x31, 0x30, 0x1d, 0x34, 0xe2, 0x78, 0xc7, 0xa2,
	0xf3, 0xaa, 0x18, 0xd5, 0xd0, 0xf3, 0x1c, 0x77, 0x84, 0xea, 0xc2, 0x20, 0xd6, 0x83, 0x38, 0x34,
	0x84, 0xbb, 0x3d, 0xf4, 0x51, 0x73, 0x35, 0x72, 0x4d, 0x0c, 0xfa, 0xb9, 0x13, 0xf8, 0xa8, 0x55,
	0x99, 0x6f, 0x5b, 0x68, 0x0f, 0x5d, 0x9b, 0x20, 0x10, 0xd2, 0xc8, 0xb1, 0x09, 0xd2, 0xcd, 0x27,
	0x4b, 0x4e, 0x0b, 0x9e, 0xe3, 0x9d, 0x35, 0x65, 0xcb, 0xe9, 0x2d, 0x4f, 0xe6, 0x2f, 0x2a, 0xe8,
	0x93, 0x6c, 0x51, 0xd0, 0x64, 0xbd, 0x35, 0x38, 0xbd, 0xe4, 0xcb, 0x95, 0x29, 0x65, 0xfc, 0x01,
	0x74, 0xc5, 0x37, 0xe4, 0x6c, 0x91, 0xc5, 0x11, 0xa7, 0x89, 0xf1, 0xb7, 0xd6, 0x53, 0xfa, 0x2d,
	0xd2, 0x11, 0xea, 0x60, 0xa5, 0xc5, 0x8f, 0xe1, 0x6e, 0x1e, 0x5d, 0x9d, 0xcf, 0xa3, 0x24, 0x2c,
	0xd2, 0xb7, 0xd4, 0xd8, 0xee, 0x29, 0x7d, 0x95, 0xe8, 0x4b, 0x9d, 0x9f, 0xbe, 0xa5, 0x82, 0xeb,
	0x62, 0x8b, 0x84, 0x0b, 0x96, 0x1a, 0xbb, 0x25, 0xd7, 0xc5, 0x79, 0xc2, 0x52, 0xfc, 0x0c, 0xf0,
	0xca, 0x54, 0xc9, 0xf4, 0x53, 0x4b, 0x66, 0x42, 0x4b, 0xaf, 0xeb, 0x64, 0x3e, 0xe8, 0xd2, 0x7d,
	0x4a, 0xa3, 0x84, 0x32, 0xe3, 0xa3, 0x9e, 0xba, 0xe9, 0x26, 0xa9, 0x94, 0x6b, 0x1d, 0xbd, 0x20,
	0x20, 0xc2, 0x1c, 0xc8, 0x28, 0xa2, 0x02, 0x19, 0x94, 0xd1, 0x6f, 0x29, 0xa3, 0xcc, 0x78, 0x2a,
	0xaf, 0x28, 0x13, 0x91, 0x52, 0x85, 0x3f, 0x83, 0x9d, 0xaa, 0x4b, 0xe5, 0xaa, 0x3f, 0x97, 0x57,
	0xdd, 0xaa, 0x78, 0xaf, 0xaf, 0xfb, 0xe0, 0x29, 0xd4, 0x8e, 0x5e, 0x88, 0x97, 0xf2, 0x8c, 0x5e,
	0x2d, 0x47, 0x20, 0x44, 0xbc, 0x05, 0x8d, 0x8b, 0xe8, 0x7c, 0x41, 0x97, 0xff, 0x4b, 0x79, 0xf8,
	0xbc, 0x66, 0x28, 0xe6, 0x9f, 0x0a, 0xb4, 0xe4, 0xa3, 0xed, 0x53, 0x2e, 0x5f, 0x43, 0x21, 0x1b,
	0x8a, 0xac, 0x73, 0x77, 0xe3, 0x17, 0x9f, 0x94, 0x38, 0xfc, 0x31, 0x6c, 0xc5, 0xf3, 0x59, 0xce,
	0x68, 0x51, 0xd0, 0x24, 0x94, 0xba, 0xb0, 0xa0, 0x5c, 0xa6, 0xbd, 0x4b, 0xf0, 0xb5, 0x6d, 0x9d,
	0xf2, 0x14, 0xf4, 0x95, 0x76, 0xc5, 0xfe, 0xee, 0x60, 0x6f, 0x93, 0xc4, 0xf6, 0x35, 0x8c, 0x54,
	0x63, 0x7c, 0xf8, 0x18, 0xf4, 0x8a, 0x4d, 0x50, 0xd5, 0x1d, 0xbb, 0x0e, 0xba, 0x23, 0x49, 0xfd,
	0xf2, 0xd0, 0x43, 0xca, 0xbe, 0xf6, 0xb2, 0x21, 0x83, 0xfc, 0x13, 0x00, 0x00, 0xff, 0xff, 0x11,
	0xee, 0xab, 0x85, 0x41, 0x09, 0x00, 0x00,
}
