package scanproto

import (
	"testing"

	"code.justin.tv/release/trace/internal/kinesalite"
	"github.com/aws/aws-sdk-go/service/kinesis"
)

// ListShards should get all shards
func TestListShards(t *testing.T) {
	var (
		stream = "test-list-shards"
		n      = maxShardsPerDescribe * 2
	)

	kinesalite.WithStream(t, stream, n, func(k *kinesis.Kinesis) {
		shards, err := listShards(k, stream)
		if err != nil {
			t.Fatalf("listShards err=%q", err)
		}

		uniqueShards := make(map[string]struct{})
		for _, s := range shards {
			uniqueShards[s] = struct{}{}
		}
		if len(uniqueShards) != n {
			t.Errorf("did not get all shards have=%d wante=%d", len(shards), n)
		}
	})
}
