package pkgpath

import "testing"

func TestPkgpathCaller(t *testing.T) {
	pkg, ok := Caller(0)
	if have, want := pkg, "code.justin.tv/common/golibs/pkgpath"; have != want {
		t.Errorf("Main(); %q != %q", have, want)
	}
	if have, want := ok, true; have != want {
		t.Errorf("Main(); %t != %t", have, want)
	}
}

func TestPkgpathCallerClosure(t *testing.T) {
	var pkg string
	var ok bool
	func() {
		pkg, ok = Caller(0)
	}()
	if have, want := pkg, "code.justin.tv/common/golibs/pkgpath"; have != want {
		t.Errorf("Main(); %q != %q", have, want)
	}
	if have, want := ok, true; have != want {
		t.Errorf("Main(); %t != %t", have, want)
	}
}
