package gometrics

import "testing"

func TestFractionToPercent(t *testing.T) {

	sets := map[float64]int64{
		0:     0,
		1:     100,
		0.019: 2,
		0.499: 50,
		0.754: 75,
	}

	for k, v := range sets {
		if fractionToPercent(k) != v {
			t.Fatalf("failed fraction conversion. expected %v got %v", v, fractionToPercent(k))
		}
	}
}
