// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package firehose

import (
	"fmt"
	"time"

	"github.com/aws/aws-sdk-go/aws"
	"github.com/aws/aws-sdk-go/aws/awsutil"
	"github.com/aws/aws-sdk-go/aws/request"
)

const opCreateDeliveryStream = "CreateDeliveryStream"

// CreateDeliveryStreamRequest generates a "aws/request.Request" representing the
// client's request for the CreateDeliveryStream operation. The "output" return
// value will be populated with the request's response once the request complets
// successfuly.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See CreateDeliveryStream for more information on using the CreateDeliveryStream
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the CreateDeliveryStreamRequest method.
//    req, resp := client.CreateDeliveryStreamRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/firehose-2015-08-04/CreateDeliveryStream
func (c *Firehose) CreateDeliveryStreamRequest(input *CreateDeliveryStreamInput) (req *request.Request, output *CreateDeliveryStreamOutput) {
	op := &request.Operation{
		Name:       opCreateDeliveryStream,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &CreateDeliveryStreamInput{}
	}

	output = &CreateDeliveryStreamOutput{}
	req = c.newRequest(op, input, output)
	return
}

// CreateDeliveryStream API operation for Amazon Kinesis Firehose.
//
// Creates a delivery stream.
//
// By default, you can create up to 20 delivery streams per region.
//
// This is an asynchronous operation that immediately returns. The initial status
// of the delivery stream is CREATING. After the delivery stream is created,
// its status is ACTIVE and it now accepts data. Attempts to send data to a
// delivery stream that is not in the ACTIVE state cause an exception. To check
// the state of a delivery stream, use DescribeDeliveryStream.
//
// A Kinesis Firehose delivery stream can be configured to receive records directly
// from providers using PutRecord or PutRecordBatch, or it can be configured
// to use an existing Kinesis stream as its source. To specify a Kinesis stream
// as input, set the DeliveryStreamType parameter to KinesisStreamAsSource,
// and provide the Kinesis stream ARN and role ARN in the KinesisStreamSourceConfiguration
// parameter.
//
// A delivery stream is configured with a single destination: Amazon S3, Amazon
// ES, or Amazon Redshift. You must specify only one of the following destination
// configuration parameters: ExtendedS3DestinationConfiguration, S3DestinationConfiguration,
// ElasticsearchDestinationConfiguration, or RedshiftDestinationConfiguration.
//
// When you specify S3DestinationConfiguration, you can also provide the following
// optional values: BufferingHints, EncryptionConfiguration, and CompressionFormat.
// By default, if no BufferingHints value is provided, Kinesis Firehose buffers
// data up to 5 MB or for 5 minutes, whichever condition is satisfied first.
// Note that BufferingHints is a hint, so there are some cases where the service
// cannot adhere to these conditions strictly; for example, record boundaries
// are such that the size is a little over or under the configured buffering
// size. By default, no encryption is performed. We strongly recommend that
// you enable encryption to ensure secure data storage in Amazon S3.
//
// A few notes about Amazon Redshift as a destination:
//
//    * An Amazon Redshift destination requires an S3 bucket as intermediate
//    location, as Kinesis Firehose first delivers data to S3 and then uses
//    COPY syntax to load data into an Amazon Redshift table. This is specified
//    in the RedshiftDestinationConfiguration.S3Configuration parameter.
//
//    * The compression formats SNAPPY or ZIP cannot be specified in RedshiftDestinationConfiguration.S3Configuration
//    because the Amazon Redshift COPY operation that reads from the S3 bucket
//    doesn't support these compression formats.
//
//    * We strongly recommend that you use the user name and password you provide
//    exclusively with Kinesis Firehose, and that the permissions for the account
//    are restricted for Amazon Redshift INSERT permissions.
//
// Kinesis Firehose assumes the IAM role that is configured as part of the destination.
// The role should allow the Kinesis Firehose principal to assume the role,
// and the role should have permissions that allow the service to deliver the
// data. For more information, see Amazon S3 Bucket Access (http://docs.aws.amazon.com/firehose/latest/dev/controlling-access.html#using-iam-s3)
// in the Amazon Kinesis Firehose Developer Guide.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Kinesis Firehose's
// API operation CreateDeliveryStream for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeInvalidArgumentException "InvalidArgumentException"
//   The specified input parameter has a value that is not valid.
//
//   * ErrCodeLimitExceededException "LimitExceededException"
//   You have already reached the limit for a requested resource.
//
//   * ErrCodeResourceInUseException "ResourceInUseException"
//   The resource is already in use and not available for this operation.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/firehose-2015-08-04/CreateDeliveryStream
func (c *Firehose) CreateDeliveryStream(input *CreateDeliveryStreamInput) (*CreateDeliveryStreamOutput, error) {
	req, out := c.CreateDeliveryStreamRequest(input)
	return out, req.Send()
}

// CreateDeliveryStreamWithContext is the same as CreateDeliveryStream with the addition of
// the ability to pass a context and additional request options.
//
// See CreateDeliveryStream for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Firehose) CreateDeliveryStreamWithContext(ctx aws.Context, input *CreateDeliveryStreamInput, opts ...request.Option) (*CreateDeliveryStreamOutput, error) {
	req, out := c.CreateDeliveryStreamRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeleteDeliveryStream = "DeleteDeliveryStream"

// DeleteDeliveryStreamRequest generates a "aws/request.Request" representing the
// client's request for the DeleteDeliveryStream operation. The "output" return
// value will be populated with the request's response once the request complets
// successfuly.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeleteDeliveryStream for more information on using the DeleteDeliveryStream
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DeleteDeliveryStreamRequest method.
//    req, resp := client.DeleteDeliveryStreamRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/firehose-2015-08-04/DeleteDeliveryStream
func (c *Firehose) DeleteDeliveryStreamRequest(input *DeleteDeliveryStreamInput) (req *request.Request, output *DeleteDeliveryStreamOutput) {
	op := &request.Operation{
		Name:       opDeleteDeliveryStream,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DeleteDeliveryStreamInput{}
	}

	output = &DeleteDeliveryStreamOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DeleteDeliveryStream API operation for Amazon Kinesis Firehose.
//
// Deletes a delivery stream and its data.
//
// You can delete a delivery stream only if it is in ACTIVE or DELETING state,
// and not in the CREATING state. While the deletion request is in process,
// the delivery stream is in the DELETING state.
//
// To check the state of a delivery stream, use DescribeDeliveryStream.
//
// While the delivery stream is DELETING state, the service may continue to
// accept the records, but the service doesn't make any guarantees with respect
// to delivering the data. Therefore, as a best practice, you should first stop
// any applications that are sending records before deleting a delivery stream.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Kinesis Firehose's
// API operation DeleteDeliveryStream for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeResourceInUseException "ResourceInUseException"
//   The resource is already in use and not available for this operation.
//
//   * ErrCodeResourceNotFoundException "ResourceNotFoundException"
//   The specified resource could not be found.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/firehose-2015-08-04/DeleteDeliveryStream
func (c *Firehose) DeleteDeliveryStream(input *DeleteDeliveryStreamInput) (*DeleteDeliveryStreamOutput, error) {
	req, out := c.DeleteDeliveryStreamRequest(input)
	return out, req.Send()
}

// DeleteDeliveryStreamWithContext is the same as DeleteDeliveryStream with the addition of
// the ability to pass a context and additional request options.
//
// See DeleteDeliveryStream for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Firehose) DeleteDeliveryStreamWithContext(ctx aws.Context, input *DeleteDeliveryStreamInput, opts ...request.Option) (*DeleteDeliveryStreamOutput, error) {
	req, out := c.DeleteDeliveryStreamRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDescribeDeliveryStream = "DescribeDeliveryStream"

// DescribeDeliveryStreamRequest generates a "aws/request.Request" representing the
// client's request for the DescribeDeliveryStream operation. The "output" return
// value will be populated with the request's response once the request complets
// successfuly.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DescribeDeliveryStream for more information on using the DescribeDeliveryStream
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DescribeDeliveryStreamRequest method.
//    req, resp := client.DescribeDeliveryStreamRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/firehose-2015-08-04/DescribeDeliveryStream
func (c *Firehose) DescribeDeliveryStreamRequest(input *DescribeDeliveryStreamInput) (req *request.Request, output *DescribeDeliveryStreamOutput) {
	op := &request.Operation{
		Name:       opDescribeDeliveryStream,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DescribeDeliveryStreamInput{}
	}

	output = &DescribeDeliveryStreamOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DescribeDeliveryStream API operation for Amazon Kinesis Firehose.
//
// Describes the specified delivery stream and gets the status. For example,
// after your delivery stream is created, call DescribeDeliveryStream to see
// if the delivery stream is ACTIVE and therefore ready for data to be sent
// to it.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Kinesis Firehose's
// API operation DescribeDeliveryStream for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeResourceNotFoundException "ResourceNotFoundException"
//   The specified resource could not be found.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/firehose-2015-08-04/DescribeDeliveryStream
func (c *Firehose) DescribeDeliveryStream(input *DescribeDeliveryStreamInput) (*DescribeDeliveryStreamOutput, error) {
	req, out := c.DescribeDeliveryStreamRequest(input)
	return out, req.Send()
}

// DescribeDeliveryStreamWithContext is the same as DescribeDeliveryStream with the addition of
// the ability to pass a context and additional request options.
//
// See DescribeDeliveryStream for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Firehose) DescribeDeliveryStreamWithContext(ctx aws.Context, input *DescribeDeliveryStreamInput, opts ...request.Option) (*DescribeDeliveryStreamOutput, error) {
	req, out := c.DescribeDeliveryStreamRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opListDeliveryStreams = "ListDeliveryStreams"

// ListDeliveryStreamsRequest generates a "aws/request.Request" representing the
// client's request for the ListDeliveryStreams operation. The "output" return
// value will be populated with the request's response once the request complets
// successfuly.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListDeliveryStreams for more information on using the ListDeliveryStreams
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the ListDeliveryStreamsRequest method.
//    req, resp := client.ListDeliveryStreamsRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/firehose-2015-08-04/ListDeliveryStreams
func (c *Firehose) ListDeliveryStreamsRequest(input *ListDeliveryStreamsInput) (req *request.Request, output *ListDeliveryStreamsOutput) {
	op := &request.Operation{
		Name:       opListDeliveryStreams,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &ListDeliveryStreamsInput{}
	}

	output = &ListDeliveryStreamsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListDeliveryStreams API operation for Amazon Kinesis Firehose.
//
// Lists your delivery streams.
//
// The number of delivery streams might be too large to return using a single
// call to ListDeliveryStreams. You can limit the number of delivery streams
// returned, using the Limit parameter. To determine whether there are more
// delivery streams to list, check the value of HasMoreDeliveryStreams in the
// output. If there are more delivery streams to list, you can request them
// by specifying the name of the last delivery stream returned in the call in
// the ExclusiveStartDeliveryStreamName parameter of a subsequent call.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Kinesis Firehose's
// API operation ListDeliveryStreams for usage and error information.
// See also, https://docs.aws.amazon.com/goto/WebAPI/firehose-2015-08-04/ListDeliveryStreams
func (c *Firehose) ListDeliveryStreams(input *ListDeliveryStreamsInput) (*ListDeliveryStreamsOutput, error) {
	req, out := c.ListDeliveryStreamsRequest(input)
	return out, req.Send()
}

// ListDeliveryStreamsWithContext is the same as ListDeliveryStreams with the addition of
// the ability to pass a context and additional request options.
//
// See ListDeliveryStreams for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Firehose) ListDeliveryStreamsWithContext(ctx aws.Context, input *ListDeliveryStreamsInput, opts ...request.Option) (*ListDeliveryStreamsOutput, error) {
	req, out := c.ListDeliveryStreamsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opPutRecord = "PutRecord"

// PutRecordRequest generates a "aws/request.Request" representing the
// client's request for the PutRecord operation. The "output" return
// value will be populated with the request's response once the request complets
// successfuly.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See PutRecord for more information on using the PutRecord
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the PutRecordRequest method.
//    req, resp := client.PutRecordRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/firehose-2015-08-04/PutRecord
func (c *Firehose) PutRecordRequest(input *PutRecordInput) (req *request.Request, output *PutRecordOutput) {
	op := &request.Operation{
		Name:       opPutRecord,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &PutRecordInput{}
	}

	output = &PutRecordOutput{}
	req = c.newRequest(op, input, output)
	return
}

// PutRecord API operation for Amazon Kinesis Firehose.
//
// Writes a single data record into an Amazon Kinesis Firehose delivery stream.
// To write multiple data records into a delivery stream, use PutRecordBatch.
// Applications using these operations are referred to as producers.
//
// By default, each delivery stream can take in up to 2,000 transactions per
// second, 5,000 records per second, or 5 MB per second. Note that if you use
// PutRecord and PutRecordBatch, the limits are an aggregate across these two
// operations for each delivery stream. For more information about limits and
// how to request an increase, see Amazon Kinesis Firehose Limits (http://docs.aws.amazon.com/firehose/latest/dev/limits.html).
//
// You must specify the name of the delivery stream and the data record when
// using PutRecord. The data record consists of a data blob that can be up to
// 1,000 KB in size, and any kind of data, for example, a segment from a log
// file, geographic location data, website clickstream data, and so on.
//
// Kinesis Firehose buffers records before delivering them to the destination.
// To disambiguate the data blobs at the destination, a common solution is to
// use delimiters in the data, such as a newline (\n) or some other character
// unique within the data. This allows the consumer application to parse individual
// data items when reading the data from the destination.
//
// The PutRecord operation returns a RecordId, which is a unique string assigned
// to each record. Producer applications can use this ID for purposes such as
// auditability and investigation.
//
// If the PutRecord operation throws a ServiceUnavailableException, back off
// and retry. If the exception persists, it is possible that the throughput
// limits have been exceeded for the delivery stream.
//
// Data records sent to Kinesis Firehose are stored for 24 hours from the time
// they are added to a delivery stream as it attempts to send the records to
// the destination. If the destination is unreachable for more than 24 hours,
// the data is no longer available.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Kinesis Firehose's
// API operation PutRecord for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeResourceNotFoundException "ResourceNotFoundException"
//   The specified resource could not be found.
//
//   * ErrCodeInvalidArgumentException "InvalidArgumentException"
//   The specified input parameter has a value that is not valid.
//
//   * ErrCodeServiceUnavailableException "ServiceUnavailableException"
//   The service is unavailable, back off and retry the operation. If you continue
//   to see the exception, throughput limits for the delivery stream may have
//   been exceeded. For more information about limits and how to request an increase,
//   see Amazon Kinesis Firehose Limits (http://docs.aws.amazon.com/firehose/latest/dev/limits.html).
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/firehose-2015-08-04/PutRecord
func (c *Firehose) PutRecord(input *PutRecordInput) (*PutRecordOutput, error) {
	req, out := c.PutRecordRequest(input)
	return out, req.Send()
}

// PutRecordWithContext is the same as PutRecord with the addition of
// the ability to pass a context and additional request options.
//
// See PutRecord for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Firehose) PutRecordWithContext(ctx aws.Context, input *PutRecordInput, opts ...request.Option) (*PutRecordOutput, error) {
	req, out := c.PutRecordRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opPutRecordBatch = "PutRecordBatch"

// PutRecordBatchRequest generates a "aws/request.Request" representing the
// client's request for the PutRecordBatch operation. The "output" return
// value will be populated with the request's response once the request complets
// successfuly.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See PutRecordBatch for more information on using the PutRecordBatch
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the PutRecordBatchRequest method.
//    req, resp := client.PutRecordBatchRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/firehose-2015-08-04/PutRecordBatch
func (c *Firehose) PutRecordBatchRequest(input *PutRecordBatchInput) (req *request.Request, output *PutRecordBatchOutput) {
	op := &request.Operation{
		Name:       opPutRecordBatch,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &PutRecordBatchInput{}
	}

	output = &PutRecordBatchOutput{}
	req = c.newRequest(op, input, output)
	return
}

// PutRecordBatch API operation for Amazon Kinesis Firehose.
//
// Writes multiple data records into a delivery stream in a single call, which
// can achieve higher throughput per producer than when writing single records.
// To write single data records into a delivery stream, use PutRecord. Applications
// using these operations are referred to as producers.
//
// By default, each delivery stream can take in up to 2,000 transactions per
// second, 5,000 records per second, or 5 MB per second. If you use PutRecord
// and PutRecordBatch, the limits are an aggregate across these two operations
// for each delivery stream. For more information about limits, see Amazon Kinesis
// Firehose Limits (http://docs.aws.amazon.com/firehose/latest/dev/limits.html).
//
// Each PutRecordBatch request supports up to 500 records. Each record in the
// request can be as large as 1,000 KB (before 64-bit encoding), up to a limit
// of 4 MB for the entire request. These limits cannot be changed.
//
// You must specify the name of the delivery stream and the data record when
// using PutRecord. The data record consists of a data blob that can be up to
// 1,000 KB in size, and any kind of data. For example, it could be a segment
// from a log file, geographic location data, web site clickstream data, and
// so on.
//
// Kinesis Firehose buffers records before delivering them to the destination.
// To disambiguate the data blobs at the destination, a common solution is to
// use delimiters in the data, such as a newline (\n) or some other character
// unique within the data. This allows the consumer application to parse individual
// data items when reading the data from the destination.
//
// The PutRecordBatch response includes a count of failed records, FailedPutCount,
// and an array of responses, RequestResponses. Each entry in the RequestResponses
// array provides additional information about the processed record. It directly
// correlates with a record in the request array using the same ordering, from
// the top to the bottom. The response array always includes the same number
// of records as the request array. RequestResponses includes both successfully
// and unsuccessfully processed records. Kinesis Firehose attempts to process
// all records in each PutRecordBatch request. A single record failure does
// not stop the processing of subsequent records.
//
// A successfully processed record includes a RecordId value, which is unique
// for the record. An unsuccessfully processed record includes ErrorCode and
// ErrorMessage values. ErrorCode reflects the type of error, and is one of
// the following values: ServiceUnavailable or InternalFailure. ErrorMessage
// provides more detailed information about the error.
//
// If there is an internal server error or a timeout, the write might have completed
// or it might have failed. If FailedPutCount is greater than 0, retry the request,
// resending only those records that might have failed processing. This minimizes
// the possible duplicate records and also reduces the total bytes sent (and
// corresponding charges). We recommend that you handle any duplicates at the
// destination.
//
// If PutRecordBatch throws ServiceUnavailableException, back off and retry.
// If the exception persists, it is possible that the throughput limits have
// been exceeded for the delivery stream.
//
// Data records sent to Kinesis Firehose are stored for 24 hours from the time
// they are added to a delivery stream as it attempts to send the records to
// the destination. If the destination is unreachable for more than 24 hours,
// the data is no longer available.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Kinesis Firehose's
// API operation PutRecordBatch for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeResourceNotFoundException "ResourceNotFoundException"
//   The specified resource could not be found.
//
//   * ErrCodeInvalidArgumentException "InvalidArgumentException"
//   The specified input parameter has a value that is not valid.
//
//   * ErrCodeServiceUnavailableException "ServiceUnavailableException"
//   The service is unavailable, back off and retry the operation. If you continue
//   to see the exception, throughput limits for the delivery stream may have
//   been exceeded. For more information about limits and how to request an increase,
//   see Amazon Kinesis Firehose Limits (http://docs.aws.amazon.com/firehose/latest/dev/limits.html).
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/firehose-2015-08-04/PutRecordBatch
func (c *Firehose) PutRecordBatch(input *PutRecordBatchInput) (*PutRecordBatchOutput, error) {
	req, out := c.PutRecordBatchRequest(input)
	return out, req.Send()
}

// PutRecordBatchWithContext is the same as PutRecordBatch with the addition of
// the ability to pass a context and additional request options.
//
// See PutRecordBatch for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Firehose) PutRecordBatchWithContext(ctx aws.Context, input *PutRecordBatchInput, opts ...request.Option) (*PutRecordBatchOutput, error) {
	req, out := c.PutRecordBatchRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opUpdateDestination = "UpdateDestination"

// UpdateDestinationRequest generates a "aws/request.Request" representing the
// client's request for the UpdateDestination operation. The "output" return
// value will be populated with the request's response once the request complets
// successfuly.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See UpdateDestination for more information on using the UpdateDestination
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the UpdateDestinationRequest method.
//    req, resp := client.UpdateDestinationRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/firehose-2015-08-04/UpdateDestination
func (c *Firehose) UpdateDestinationRequest(input *UpdateDestinationInput) (req *request.Request, output *UpdateDestinationOutput) {
	op := &request.Operation{
		Name:       opUpdateDestination,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &UpdateDestinationInput{}
	}

	output = &UpdateDestinationOutput{}
	req = c.newRequest(op, input, output)
	return
}

// UpdateDestination API operation for Amazon Kinesis Firehose.
//
// Updates the specified destination of the specified delivery stream.
//
// You can use this operation to change the destination type (for example, to
// replace the Amazon S3 destination with Amazon Redshift) or change the parameters
// associated with a destination (for example, to change the bucket name of
// the Amazon S3 destination). The update might not occur immediately. The target
// delivery stream remains active while the configurations are updated, so data
// writes to the delivery stream can continue during this process. The updated
// configurations are usually effective within a few minutes.
//
// Note that switching between Amazon ES and other services is not supported.
// For an Amazon ES destination, you can only update to another Amazon ES destination.
//
// If the destination type is the same, Kinesis Firehose merges the configuration
// parameters specified with the destination configuration that already exists
// on the delivery stream. If any of the parameters are not specified in the
// call, the existing values are retained. For example, in the Amazon S3 destination,
// if EncryptionConfiguration is not specified, then the existing EncryptionConfiguration
// is maintained on the destination.
//
// If the destination type is not the same, for example, changing the destination
// from Amazon S3 to Amazon Redshift, Kinesis Firehose does not merge any parameters.
// In this case, all parameters must be specified.
//
// Kinesis Firehose uses CurrentDeliveryStreamVersionId to avoid race conditions
// and conflicting merges. This is a required field, and the service updates
// the configuration only if the existing configuration has a version ID that
// matches. After the update is applied successfully, the version ID is updated,
// and can be retrieved using DescribeDeliveryStream. Use the new version ID
// to set CurrentDeliveryStreamVersionId in the next call.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Kinesis Firehose's
// API operation UpdateDestination for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeInvalidArgumentException "InvalidArgumentException"
//   The specified input parameter has a value that is not valid.
//
//   * ErrCodeResourceInUseException "ResourceInUseException"
//   The resource is already in use and not available for this operation.
//
//   * ErrCodeResourceNotFoundException "ResourceNotFoundException"
//   The specified resource could not be found.
//
//   * ErrCodeConcurrentModificationException "ConcurrentModificationException"
//   Another modification has already happened. Fetch VersionId again and use
//   it to update the destination.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/firehose-2015-08-04/UpdateDestination
func (c *Firehose) UpdateDestination(input *UpdateDestinationInput) (*UpdateDestinationOutput, error) {
	req, out := c.UpdateDestinationRequest(input)
	return out, req.Send()
}

// UpdateDestinationWithContext is the same as UpdateDestination with the addition of
// the ability to pass a context and additional request options.
//
// See UpdateDestination for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Firehose) UpdateDestinationWithContext(ctx aws.Context, input *UpdateDestinationInput, opts ...request.Option) (*UpdateDestinationOutput, error) {
	req, out := c.UpdateDestinationRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// Describes hints for the buffering to perform before delivering data to the
// destination. Please note that these options are treated as hints, and therefore
// Kinesis Firehose may choose to use different values when it is optimal.
type BufferingHints struct {
	_ struct{} `type:"structure"`

	// Buffer incoming data for the specified period of time, in seconds, before
	// delivering it to the destination. The default value is 300.
	IntervalInSeconds *int64 `min:"60" type:"integer"`

	// Buffer incoming data to the specified size, in MBs, before delivering it
	// to the destination. The default value is 5.
	//
	// We recommend setting this parameter to a value greater than the amount of
	// data you typically ingest into the delivery stream in 10 seconds. For example,
	// if you typically ingest data at 1 MB/sec, the value should be 10 MB or higher.
	SizeInMBs *int64 `min:"1" type:"integer"`
}

// String returns the string representation
func (s BufferingHints) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s BufferingHints) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *BufferingHints) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "BufferingHints"}
	if s.IntervalInSeconds != nil && *s.IntervalInSeconds < 60 {
		invalidParams.Add(request.NewErrParamMinValue("IntervalInSeconds", 60))
	}
	if s.SizeInMBs != nil && *s.SizeInMBs < 1 {
		invalidParams.Add(request.NewErrParamMinValue("SizeInMBs", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetIntervalInSeconds sets the IntervalInSeconds field's value.
func (s *BufferingHints) SetIntervalInSeconds(v int64) *BufferingHints {
	s.IntervalInSeconds = &v
	return s
}

// SetSizeInMBs sets the SizeInMBs field's value.
func (s *BufferingHints) SetSizeInMBs(v int64) *BufferingHints {
	s.SizeInMBs = &v
	return s
}

// Describes the Amazon CloudWatch logging options for your delivery stream.
type CloudWatchLoggingOptions struct {
	_ struct{} `type:"structure"`

	// Enables or disables CloudWatch logging.
	Enabled *bool `type:"boolean"`

	// The CloudWatch group name for logging. This value is required if CloudWatch
	// logging is enabled.
	LogGroupName *string `type:"string"`

	// The CloudWatch log stream name for logging. This value is required if CloudWatch
	// logging is enabled.
	LogStreamName *string `type:"string"`
}

// String returns the string representation
func (s CloudWatchLoggingOptions) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CloudWatchLoggingOptions) GoString() string {
	return s.String()
}

// SetEnabled sets the Enabled field's value.
func (s *CloudWatchLoggingOptions) SetEnabled(v bool) *CloudWatchLoggingOptions {
	s.Enabled = &v
	return s
}

// SetLogGroupName sets the LogGroupName field's value.
func (s *CloudWatchLoggingOptions) SetLogGroupName(v string) *CloudWatchLoggingOptions {
	s.LogGroupName = &v
	return s
}

// SetLogStreamName sets the LogStreamName field's value.
func (s *CloudWatchLoggingOptions) SetLogStreamName(v string) *CloudWatchLoggingOptions {
	s.LogStreamName = &v
	return s
}

// Describes a COPY command for Amazon Redshift.
type CopyCommand struct {
	_ struct{} `type:"structure"`

	// Optional parameters to use with the Amazon Redshift COPY command. For more
	// information, see the "Optional Parameters" section of Amazon Redshift COPY
	// command (http://docs.aws.amazon.com/redshift/latest/dg/r_COPY.html). Some
	// possible examples that would apply to Kinesis Firehose are as follows:
	//
	// delimiter '\t' lzop; - fields are delimited with "\t" (TAB character) and
	// compressed using lzop.
	//
	// delimiter '|' - fields are delimited with "|" (this is the default delimiter).
	//
	// delimiter '|' escape - the delimiter should be escaped.
	//
	// fixedwidth 'venueid:3,venuename:25,venuecity:12,venuestate:2,venueseats:6'
	// - fields are fixed width in the source, with each width specified after every
	// column in the table.
	//
	// JSON 's3://mybucket/jsonpaths.txt' - data is in JSON format, and the path
	// specified is the format of the data.
	//
	// For more examples, see Amazon Redshift COPY command examples (http://docs.aws.amazon.com/redshift/latest/dg/r_COPY_command_examples.html).
	CopyOptions *string `type:"string"`

	// A comma-separated list of column names.
	DataTableColumns *string `type:"string"`

	// The name of the target table. The table must already exist in the database.
	//
	// DataTableName is a required field
	DataTableName *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s CopyCommand) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CopyCommand) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CopyCommand) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CopyCommand"}
	if s.DataTableName == nil {
		invalidParams.Add(request.NewErrParamRequired("DataTableName"))
	}
	if s.DataTableName != nil && len(*s.DataTableName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("DataTableName", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetCopyOptions sets the CopyOptions field's value.
func (s *CopyCommand) SetCopyOptions(v string) *CopyCommand {
	s.CopyOptions = &v
	return s
}

// SetDataTableColumns sets the DataTableColumns field's value.
func (s *CopyCommand) SetDataTableColumns(v string) *CopyCommand {
	s.DataTableColumns = &v
	return s
}

// SetDataTableName sets the DataTableName field's value.
func (s *CopyCommand) SetDataTableName(v string) *CopyCommand {
	s.DataTableName = &v
	return s
}

type CreateDeliveryStreamInput struct {
	_ struct{} `type:"structure"`

	// The name of the delivery stream. This name must be unique per AWS account
	// in the same region. If the delivery streams are in different accounts or
	// different regions, you can have multiple delivery streams with the same name.
	//
	// DeliveryStreamName is a required field
	DeliveryStreamName *string `min:"1" type:"string" required:"true"`

	// The delivery stream type. This parameter can be one of the following values:
	//
	//    * DirectPut: Provider applications access the delivery stream directly.
	//
	//    * KinesisStreamAsSource: The delivery stream uses a Kinesis stream as
	//    a source.
	DeliveryStreamType *string `type:"string" enum:"DeliveryStreamType"`

	// The destination in Amazon ES. You can specify only one destination.
	ElasticsearchDestinationConfiguration *ElasticsearchDestinationConfiguration `type:"structure"`

	// The destination in Amazon S3. You can specify only one destination.
	ExtendedS3DestinationConfiguration *ExtendedS3DestinationConfiguration `type:"structure"`

	// When a Kinesis stream is used as the source for the delivery stream, a KinesisStreamSourceConfiguration
	// containing the Kinesis stream ARN and the role ARN for the source stream.
	KinesisStreamSourceConfiguration *KinesisStreamSourceConfiguration `type:"structure"`

	// The destination in Amazon Redshift. You can specify only one destination.
	RedshiftDestinationConfiguration *RedshiftDestinationConfiguration `type:"structure"`

	// [Deprecated] The destination in Amazon S3. You can specify only one destination.
	S3DestinationConfiguration *S3DestinationConfiguration `deprecated:"true" type:"structure"`

	// The destination in Splunk. You can specify only one destination.
	SplunkDestinationConfiguration *SplunkDestinationConfiguration `type:"structure"`
}

// String returns the string representation
func (s CreateDeliveryStreamInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateDeliveryStreamInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreateDeliveryStreamInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CreateDeliveryStreamInput"}
	if s.DeliveryStreamName == nil {
		invalidParams.Add(request.NewErrParamRequired("DeliveryStreamName"))
	}
	if s.DeliveryStreamName != nil && len(*s.DeliveryStreamName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("DeliveryStreamName", 1))
	}
	if s.ElasticsearchDestinationConfiguration != nil {
		if err := s.ElasticsearchDestinationConfiguration.Validate(); err != nil {
			invalidParams.AddNested("ElasticsearchDestinationConfiguration", err.(request.ErrInvalidParams))
		}
	}
	if s.ExtendedS3DestinationConfiguration != nil {
		if err := s.ExtendedS3DestinationConfiguration.Validate(); err != nil {
			invalidParams.AddNested("ExtendedS3DestinationConfiguration", err.(request.ErrInvalidParams))
		}
	}
	if s.KinesisStreamSourceConfiguration != nil {
		if err := s.KinesisStreamSourceConfiguration.Validate(); err != nil {
			invalidParams.AddNested("KinesisStreamSourceConfiguration", err.(request.ErrInvalidParams))
		}
	}
	if s.RedshiftDestinationConfiguration != nil {
		if err := s.RedshiftDestinationConfiguration.Validate(); err != nil {
			invalidParams.AddNested("RedshiftDestinationConfiguration", err.(request.ErrInvalidParams))
		}
	}
	if s.S3DestinationConfiguration != nil {
		if err := s.S3DestinationConfiguration.Validate(); err != nil {
			invalidParams.AddNested("S3DestinationConfiguration", err.(request.ErrInvalidParams))
		}
	}
	if s.SplunkDestinationConfiguration != nil {
		if err := s.SplunkDestinationConfiguration.Validate(); err != nil {
			invalidParams.AddNested("SplunkDestinationConfiguration", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetDeliveryStreamName sets the DeliveryStreamName field's value.
func (s *CreateDeliveryStreamInput) SetDeliveryStreamName(v string) *CreateDeliveryStreamInput {
	s.DeliveryStreamName = &v
	return s
}

// SetDeliveryStreamType sets the DeliveryStreamType field's value.
func (s *CreateDeliveryStreamInput) SetDeliveryStreamType(v string) *CreateDeliveryStreamInput {
	s.DeliveryStreamType = &v
	return s
}

// SetElasticsearchDestinationConfiguration sets the ElasticsearchDestinationConfiguration field's value.
func (s *CreateDeliveryStreamInput) SetElasticsearchDestinationConfiguration(v *ElasticsearchDestinationConfiguration) *CreateDeliveryStreamInput {
	s.ElasticsearchDestinationConfiguration = v
	return s
}

// SetExtendedS3DestinationConfiguration sets the ExtendedS3DestinationConfiguration field's value.
func (s *CreateDeliveryStreamInput) SetExtendedS3DestinationConfiguration(v *ExtendedS3DestinationConfiguration) *CreateDeliveryStreamInput {
	s.ExtendedS3DestinationConfiguration = v
	return s
}

// SetKinesisStreamSourceConfiguration sets the KinesisStreamSourceConfiguration field's value.
func (s *CreateDeliveryStreamInput) SetKinesisStreamSourceConfiguration(v *KinesisStreamSourceConfiguration) *CreateDeliveryStreamInput {
	s.KinesisStreamSourceConfiguration = v
	return s
}

// SetRedshiftDestinationConfiguration sets the RedshiftDestinationConfiguration field's value.
func (s *CreateDeliveryStreamInput) SetRedshiftDestinationConfiguration(v *RedshiftDestinationConfiguration) *CreateDeliveryStreamInput {
	s.RedshiftDestinationConfiguration = v
	return s
}

// SetS3DestinationConfiguration sets the S3DestinationConfiguration field's value.
func (s *CreateDeliveryStreamInput) SetS3DestinationConfiguration(v *S3DestinationConfiguration) *CreateDeliveryStreamInput {
	s.S3DestinationConfiguration = v
	return s
}

// SetSplunkDestinationConfiguration sets the SplunkDestinationConfiguration field's value.
func (s *CreateDeliveryStreamInput) SetSplunkDestinationConfiguration(v *SplunkDestinationConfiguration) *CreateDeliveryStreamInput {
	s.SplunkDestinationConfiguration = v
	return s
}

type CreateDeliveryStreamOutput struct {
	_ struct{} `type:"structure"`

	// The ARN of the delivery stream.
	DeliveryStreamARN *string `min:"1" type:"string"`
}

// String returns the string representation
func (s CreateDeliveryStreamOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateDeliveryStreamOutput) GoString() string {
	return s.String()
}

// SetDeliveryStreamARN sets the DeliveryStreamARN field's value.
func (s *CreateDeliveryStreamOutput) SetDeliveryStreamARN(v string) *CreateDeliveryStreamOutput {
	s.DeliveryStreamARN = &v
	return s
}

type DeleteDeliveryStreamInput struct {
	_ struct{} `type:"structure"`

	// The name of the delivery stream.
	//
	// DeliveryStreamName is a required field
	DeliveryStreamName *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s DeleteDeliveryStreamInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteDeliveryStreamInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteDeliveryStreamInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DeleteDeliveryStreamInput"}
	if s.DeliveryStreamName == nil {
		invalidParams.Add(request.NewErrParamRequired("DeliveryStreamName"))
	}
	if s.DeliveryStreamName != nil && len(*s.DeliveryStreamName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("DeliveryStreamName", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetDeliveryStreamName sets the DeliveryStreamName field's value.
func (s *DeleteDeliveryStreamInput) SetDeliveryStreamName(v string) *DeleteDeliveryStreamInput {
	s.DeliveryStreamName = &v
	return s
}

type DeleteDeliveryStreamOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s DeleteDeliveryStreamOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteDeliveryStreamOutput) GoString() string {
	return s.String()
}

// Contains information about a delivery stream.
type DeliveryStreamDescription struct {
	_ struct{} `type:"structure"`

	// The date and time that the delivery stream was created.
	CreateTimestamp *time.Time `type:"timestamp" timestampFormat:"unix"`

	// The Amazon Resource Name (ARN) of the delivery stream.
	//
	// DeliveryStreamARN is a required field
	DeliveryStreamARN *string `min:"1" type:"string" required:"true"`

	// The name of the delivery stream.
	//
	// DeliveryStreamName is a required field
	DeliveryStreamName *string `min:"1" type:"string" required:"true"`

	// The status of the delivery stream.
	//
	// DeliveryStreamStatus is a required field
	DeliveryStreamStatus *string `type:"string" required:"true" enum:"DeliveryStreamStatus"`

	// The delivery stream type. This can be one of the following values:
	//
	//    * DirectPut: Provider applications access the delivery stream directly.
	//
	//    * KinesisStreamAsSource: The delivery stream uses a Kinesis stream as
	//    a source.
	//
	// DeliveryStreamType is a required field
	DeliveryStreamType *string `type:"string" required:"true" enum:"DeliveryStreamType"`

	// The destinations.
	//
	// Destinations is a required field
	Destinations []*DestinationDescription `type:"list" required:"true"`

	// Indicates whether there are more destinations available to list.
	//
	// HasMoreDestinations is a required field
	HasMoreDestinations *bool `type:"boolean" required:"true"`

	// The date and time that the delivery stream was last updated.
	LastUpdateTimestamp *time.Time `type:"timestamp" timestampFormat:"unix"`

	// If the DeliveryStreamType parameter is KinesisStreamAsSource, a SourceDescription
	// object describing the source Kinesis stream.
	Source *SourceDescription `type:"structure"`

	// Each time the destination is updated for a delivery stream, the version ID
	// is changed, and the current version ID is required when updating the destination.
	// This is so that the service knows it is applying the changes to the correct
	// version of the delivery stream.
	//
	// VersionId is a required field
	VersionId *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s DeliveryStreamDescription) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeliveryStreamDescription) GoString() string {
	return s.String()
}

// SetCreateTimestamp sets the CreateTimestamp field's value.
func (s *DeliveryStreamDescription) SetCreateTimestamp(v time.Time) *DeliveryStreamDescription {
	s.CreateTimestamp = &v
	return s
}

// SetDeliveryStreamARN sets the DeliveryStreamARN field's value.
func (s *DeliveryStreamDescription) SetDeliveryStreamARN(v string) *DeliveryStreamDescription {
	s.DeliveryStreamARN = &v
	return s
}

// SetDeliveryStreamName sets the DeliveryStreamName field's value.
func (s *DeliveryStreamDescription) SetDeliveryStreamName(v string) *DeliveryStreamDescription {
	s.DeliveryStreamName = &v
	return s
}

// SetDeliveryStreamStatus sets the DeliveryStreamStatus field's value.
func (s *DeliveryStreamDescription) SetDeliveryStreamStatus(v string) *DeliveryStreamDescription {
	s.DeliveryStreamStatus = &v
	return s
}

// SetDeliveryStreamType sets the DeliveryStreamType field's value.
func (s *DeliveryStreamDescription) SetDeliveryStreamType(v string) *DeliveryStreamDescription {
	s.DeliveryStreamType = &v
	return s
}

// SetDestinations sets the Destinations field's value.
func (s *DeliveryStreamDescription) SetDestinations(v []*DestinationDescription) *DeliveryStreamDescription {
	s.Destinations = v
	return s
}

// SetHasMoreDestinations sets the HasMoreDestinations field's value.
func (s *DeliveryStreamDescription) SetHasMoreDestinations(v bool) *DeliveryStreamDescription {
	s.HasMoreDestinations = &v
	return s
}

// SetLastUpdateTimestamp sets the LastUpdateTimestamp field's value.
func (s *DeliveryStreamDescription) SetLastUpdateTimestamp(v time.Time) *DeliveryStreamDescription {
	s.LastUpdateTimestamp = &v
	return s
}

// SetSource sets the Source field's value.
func (s *DeliveryStreamDescription) SetSource(v *SourceDescription) *DeliveryStreamDescription {
	s.Source = v
	return s
}

// SetVersionId sets the VersionId field's value.
func (s *DeliveryStreamDescription) SetVersionId(v string) *DeliveryStreamDescription {
	s.VersionId = &v
	return s
}

type DescribeDeliveryStreamInput struct {
	_ struct{} `type:"structure"`

	// The name of the delivery stream.
	//
	// DeliveryStreamName is a required field
	DeliveryStreamName *string `min:"1" type:"string" required:"true"`

	// The ID of the destination to start returning the destination information.
	// Currently, Kinesis Firehose supports one destination per delivery stream.
	ExclusiveStartDestinationId *string `min:"1" type:"string"`

	// The limit on the number of destinations to return. Currently, you can have
	// one destination per delivery stream.
	Limit *int64 `min:"1" type:"integer"`
}

// String returns the string representation
func (s DescribeDeliveryStreamInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeDeliveryStreamInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DescribeDeliveryStreamInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DescribeDeliveryStreamInput"}
	if s.DeliveryStreamName == nil {
		invalidParams.Add(request.NewErrParamRequired("DeliveryStreamName"))
	}
	if s.DeliveryStreamName != nil && len(*s.DeliveryStreamName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("DeliveryStreamName", 1))
	}
	if s.ExclusiveStartDestinationId != nil && len(*s.ExclusiveStartDestinationId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ExclusiveStartDestinationId", 1))
	}
	if s.Limit != nil && *s.Limit < 1 {
		invalidParams.Add(request.NewErrParamMinValue("Limit", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetDeliveryStreamName sets the DeliveryStreamName field's value.
func (s *DescribeDeliveryStreamInput) SetDeliveryStreamName(v string) *DescribeDeliveryStreamInput {
	s.DeliveryStreamName = &v
	return s
}

// SetExclusiveStartDestinationId sets the ExclusiveStartDestinationId field's value.
func (s *DescribeDeliveryStreamInput) SetExclusiveStartDestinationId(v string) *DescribeDeliveryStreamInput {
	s.ExclusiveStartDestinationId = &v
	return s
}

// SetLimit sets the Limit field's value.
func (s *DescribeDeliveryStreamInput) SetLimit(v int64) *DescribeDeliveryStreamInput {
	s.Limit = &v
	return s
}

type DescribeDeliveryStreamOutput struct {
	_ struct{} `type:"structure"`

	// Information about the delivery stream.
	//
	// DeliveryStreamDescription is a required field
	DeliveryStreamDescription *DeliveryStreamDescription `type:"structure" required:"true"`
}

// String returns the string representation
func (s DescribeDeliveryStreamOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeDeliveryStreamOutput) GoString() string {
	return s.String()
}

// SetDeliveryStreamDescription sets the DeliveryStreamDescription field's value.
func (s *DescribeDeliveryStreamOutput) SetDeliveryStreamDescription(v *DeliveryStreamDescription) *DescribeDeliveryStreamOutput {
	s.DeliveryStreamDescription = v
	return s
}

// Describes the destination for a delivery stream.
type DestinationDescription struct {
	_ struct{} `type:"structure"`

	// The ID of the destination.
	//
	// DestinationId is a required field
	DestinationId *string `min:"1" type:"string" required:"true"`

	// The destination in Amazon ES.
	ElasticsearchDestinationDescription *ElasticsearchDestinationDescription `type:"structure"`

	// The destination in Amazon S3.
	ExtendedS3DestinationDescription *ExtendedS3DestinationDescription `type:"structure"`

	// The destination in Amazon Redshift.
	RedshiftDestinationDescription *RedshiftDestinationDescription `type:"structure"`

	// [Deprecated] The destination in Amazon S3.
	S3DestinationDescription *S3DestinationDescription `type:"structure"`

	// The destination in Splunk.
	SplunkDestinationDescription *SplunkDestinationDescription `type:"structure"`
}

// String returns the string representation
func (s DestinationDescription) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DestinationDescription) GoString() string {
	return s.String()
}

// SetDestinationId sets the DestinationId field's value.
func (s *DestinationDescription) SetDestinationId(v string) *DestinationDescription {
	s.DestinationId = &v
	return s
}

// SetElasticsearchDestinationDescription sets the ElasticsearchDestinationDescription field's value.
func (s *DestinationDescription) SetElasticsearchDestinationDescription(v *ElasticsearchDestinationDescription) *DestinationDescription {
	s.ElasticsearchDestinationDescription = v
	return s
}

// SetExtendedS3DestinationDescription sets the ExtendedS3DestinationDescription field's value.
func (s *DestinationDescription) SetExtendedS3DestinationDescription(v *ExtendedS3DestinationDescription) *DestinationDescription {
	s.ExtendedS3DestinationDescription = v
	return s
}

// SetRedshiftDestinationDescription sets the RedshiftDestinationDescription field's value.
func (s *DestinationDescription) SetRedshiftDestinationDescription(v *RedshiftDestinationDescription) *DestinationDescription {
	s.RedshiftDestinationDescription = v
	return s
}

// SetS3DestinationDescription sets the S3DestinationDescription field's value.
func (s *DestinationDescription) SetS3DestinationDescription(v *S3DestinationDescription) *DestinationDescription {
	s.S3DestinationDescription = v
	return s
}

// SetSplunkDestinationDescription sets the SplunkDestinationDescription field's value.
func (s *DestinationDescription) SetSplunkDestinationDescription(v *SplunkDestinationDescription) *DestinationDescription {
	s.SplunkDestinationDescription = v
	return s
}

// Describes the buffering to perform before delivering data to the Amazon ES
// destination.
type ElasticsearchBufferingHints struct {
	_ struct{} `type:"structure"`

	// Buffer incoming data for the specified period of time, in seconds, before
	// delivering it to the destination. The default value is 300 (5 minutes).
	IntervalInSeconds *int64 `min:"60" type:"integer"`

	// Buffer incoming data to the specified size, in MBs, before delivering it
	// to the destination. The default value is 5.
	//
	// We recommend setting this parameter to a value greater than the amount of
	// data you typically ingest into the delivery stream in 10 seconds. For example,
	// if you typically ingest data at 1 MB/sec, the value should be 10 MB or higher.
	SizeInMBs *int64 `min:"1" type:"integer"`
}

// String returns the string representation
func (s ElasticsearchBufferingHints) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ElasticsearchBufferingHints) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ElasticsearchBufferingHints) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ElasticsearchBufferingHints"}
	if s.IntervalInSeconds != nil && *s.IntervalInSeconds < 60 {
		invalidParams.Add(request.NewErrParamMinValue("IntervalInSeconds", 60))
	}
	if s.SizeInMBs != nil && *s.SizeInMBs < 1 {
		invalidParams.Add(request.NewErrParamMinValue("SizeInMBs", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetIntervalInSeconds sets the IntervalInSeconds field's value.
func (s *ElasticsearchBufferingHints) SetIntervalInSeconds(v int64) *ElasticsearchBufferingHints {
	s.IntervalInSeconds = &v
	return s
}

// SetSizeInMBs sets the SizeInMBs field's value.
func (s *ElasticsearchBufferingHints) SetSizeInMBs(v int64) *ElasticsearchBufferingHints {
	s.SizeInMBs = &v
	return s
}

// Describes the configuration of a destination in Amazon ES.
type ElasticsearchDestinationConfiguration struct {
	_ struct{} `type:"structure"`

	// The buffering options. If no value is specified, the default values for ElasticsearchBufferingHints
	// are used.
	BufferingHints *ElasticsearchBufferingHints `type:"structure"`

	// The CloudWatch logging options for your delivery stream.
	CloudWatchLoggingOptions *CloudWatchLoggingOptions `type:"structure"`

	// The ARN of the Amazon ES domain. The IAM role must have permissions for DescribeElasticsearchDomain,
	// DescribeElasticsearchDomains, and DescribeElasticsearchDomainConfig after
	// assuming the role specified in RoleARN.
	//
	// DomainARN is a required field
	DomainARN *string `min:"1" type:"string" required:"true"`

	// The Elasticsearch index name.
	//
	// IndexName is a required field
	IndexName *string `min:"1" type:"string" required:"true"`

	// The Elasticsearch index rotation period. Index rotation appends a time stamp
	// to the IndexName to facilitate the expiration of old data. For more information,
	// see Index Rotation for Amazon Elasticsearch Service Destination (http://docs.aws.amazon.com/firehose/latest/dev/basic-deliver.html#es-index-rotation).
	// The default value is OneDay.
	IndexRotationPeriod *string `type:"string" enum:"ElasticsearchIndexRotationPeriod"`

	// The data processing configuration.
	ProcessingConfiguration *ProcessingConfiguration `type:"structure"`

	// The retry behavior in case Kinesis Firehose is unable to deliver documents
	// to Amazon ES. The default value is 300 (5 minutes).
	RetryOptions *ElasticsearchRetryOptions `type:"structure"`

	// The ARN of the IAM role to be assumed by Kinesis Firehose for calling the
	// Amazon ES Configuration API and for indexing documents. For more information,
	// see Amazon S3 Bucket Access (http://docs.aws.amazon.com/firehose/latest/dev/controlling-access.html#using-iam-s3).
	//
	// RoleARN is a required field
	RoleARN *string `min:"1" type:"string" required:"true"`

	// Defines how documents should be delivered to Amazon S3. When set to FailedDocumentsOnly,
	// Kinesis Firehose writes any documents that could not be indexed to the configured
	// Amazon S3 destination, with elasticsearch-failed/ appended to the key prefix.
	// When set to AllDocuments, Kinesis Firehose delivers all incoming records
	// to Amazon S3, and also writes failed documents with elasticsearch-failed/
	// appended to the prefix. For more information, see Amazon S3 Backup for Amazon
	// Elasticsearch Service Destination (http://docs.aws.amazon.com/firehose/latest/dev/basic-deliver.html#es-s3-backup).
	// Default value is FailedDocumentsOnly.
	S3BackupMode *string `type:"string" enum:"ElasticsearchS3BackupMode"`

	// The configuration for the backup Amazon S3 location.
	//
	// S3Configuration is a required field
	S3Configuration *S3DestinationConfiguration `type:"structure" required:"true"`

	// The Elasticsearch type name.
	//
	// TypeName is a required field
	TypeName *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s ElasticsearchDestinationConfiguration) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ElasticsearchDestinationConfiguration) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ElasticsearchDestinationConfiguration) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ElasticsearchDestinationConfiguration"}
	if s.DomainARN == nil {
		invalidParams.Add(request.NewErrParamRequired("DomainARN"))
	}
	if s.DomainARN != nil && len(*s.DomainARN) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("DomainARN", 1))
	}
	if s.IndexName == nil {
		invalidParams.Add(request.NewErrParamRequired("IndexName"))
	}
	if s.IndexName != nil && len(*s.IndexName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("IndexName", 1))
	}
	if s.RoleARN == nil {
		invalidParams.Add(request.NewErrParamRequired("RoleARN"))
	}
	if s.RoleARN != nil && len(*s.RoleARN) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("RoleARN", 1))
	}
	if s.S3Configuration == nil {
		invalidParams.Add(request.NewErrParamRequired("S3Configuration"))
	}
	if s.TypeName == nil {
		invalidParams.Add(request.NewErrParamRequired("TypeName"))
	}
	if s.TypeName != nil && len(*s.TypeName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("TypeName", 1))
	}
	if s.BufferingHints != nil {
		if err := s.BufferingHints.Validate(); err != nil {
			invalidParams.AddNested("BufferingHints", err.(request.ErrInvalidParams))
		}
	}
	if s.ProcessingConfiguration != nil {
		if err := s.ProcessingConfiguration.Validate(); err != nil {
			invalidParams.AddNested("ProcessingConfiguration", err.(request.ErrInvalidParams))
		}
	}
	if s.S3Configuration != nil {
		if err := s.S3Configuration.Validate(); err != nil {
			invalidParams.AddNested("S3Configuration", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetBufferingHints sets the BufferingHints field's value.
func (s *ElasticsearchDestinationConfiguration) SetBufferingHints(v *ElasticsearchBufferingHints) *ElasticsearchDestinationConfiguration {
	s.BufferingHints = v
	return s
}

// SetCloudWatchLoggingOptions sets the CloudWatchLoggingOptions field's value.
func (s *ElasticsearchDestinationConfiguration) SetCloudWatchLoggingOptions(v *CloudWatchLoggingOptions) *ElasticsearchDestinationConfiguration {
	s.CloudWatchLoggingOptions = v
	return s
}

// SetDomainARN sets the DomainARN field's value.
func (s *ElasticsearchDestinationConfiguration) SetDomainARN(v string) *ElasticsearchDestinationConfiguration {
	s.DomainARN = &v
	return s
}

// SetIndexName sets the IndexName field's value.
func (s *ElasticsearchDestinationConfiguration) SetIndexName(v string) *ElasticsearchDestinationConfiguration {
	s.IndexName = &v
	return s
}

// SetIndexRotationPeriod sets the IndexRotationPeriod field's value.
func (s *ElasticsearchDestinationConfiguration) SetIndexRotationPeriod(v string) *ElasticsearchDestinationConfiguration {
	s.IndexRotationPeriod = &v
	return s
}

// SetProcessingConfiguration sets the ProcessingConfiguration field's value.
func (s *ElasticsearchDestinationConfiguration) SetProcessingConfiguration(v *ProcessingConfiguration) *ElasticsearchDestinationConfiguration {
	s.ProcessingConfiguration = v
	return s
}

// SetRetryOptions sets the RetryOptions field's value.
func (s *ElasticsearchDestinationConfiguration) SetRetryOptions(v *ElasticsearchRetryOptions) *ElasticsearchDestinationConfiguration {
	s.RetryOptions = v
	return s
}

// SetRoleARN sets the RoleARN field's value.
func (s *ElasticsearchDestinationConfiguration) SetRoleARN(v string) *ElasticsearchDestinationConfiguration {
	s.RoleARN = &v
	return s
}

// SetS3BackupMode sets the S3BackupMode field's value.
func (s *ElasticsearchDestinationConfiguration) SetS3BackupMode(v string) *ElasticsearchDestinationConfiguration {
	s.S3BackupMode = &v
	return s
}

// SetS3Configuration sets the S3Configuration field's value.
func (s *ElasticsearchDestinationConfiguration) SetS3Configuration(v *S3DestinationConfiguration) *ElasticsearchDestinationConfiguration {
	s.S3Configuration = v
	return s
}

// SetTypeName sets the TypeName field's value.
func (s *ElasticsearchDestinationConfiguration) SetTypeName(v string) *ElasticsearchDestinationConfiguration {
	s.TypeName = &v
	return s
}

// The destination description in Amazon ES.
type ElasticsearchDestinationDescription struct {
	_ struct{} `type:"structure"`

	// The buffering options.
	BufferingHints *ElasticsearchBufferingHints `type:"structure"`

	// The CloudWatch logging options.
	CloudWatchLoggingOptions *CloudWatchLoggingOptions `type:"structure"`

	// The ARN of the Amazon ES domain.
	DomainARN *string `min:"1" type:"string"`

	// The Elasticsearch index name.
	IndexName *string `min:"1" type:"string"`

	// The Elasticsearch index rotation period
	IndexRotationPeriod *string `type:"string" enum:"ElasticsearchIndexRotationPeriod"`

	// The data processing configuration.
	ProcessingConfiguration *ProcessingConfiguration `type:"structure"`

	// The Amazon ES retry options.
	RetryOptions *ElasticsearchRetryOptions `type:"structure"`

	// The ARN of the AWS credentials.
	RoleARN *string `min:"1" type:"string"`

	// The Amazon S3 backup mode.
	S3BackupMode *string `type:"string" enum:"ElasticsearchS3BackupMode"`

	// The Amazon S3 destination.
	S3DestinationDescription *S3DestinationDescription `type:"structure"`

	// The Elasticsearch type name.
	TypeName *string `min:"1" type:"string"`
}

// String returns the string representation
func (s ElasticsearchDestinationDescription) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ElasticsearchDestinationDescription) GoString() string {
	return s.String()
}

// SetBufferingHints sets the BufferingHints field's value.
func (s *ElasticsearchDestinationDescription) SetBufferingHints(v *ElasticsearchBufferingHints) *ElasticsearchDestinationDescription {
	s.BufferingHints = v
	return s
}

// SetCloudWatchLoggingOptions sets the CloudWatchLoggingOptions field's value.
func (s *ElasticsearchDestinationDescription) SetCloudWatchLoggingOptions(v *CloudWatchLoggingOptions) *ElasticsearchDestinationDescription {
	s.CloudWatchLoggingOptions = v
	return s
}

// SetDomainARN sets the DomainARN field's value.
func (s *ElasticsearchDestinationDescription) SetDomainARN(v string) *ElasticsearchDestinationDescription {
	s.DomainARN = &v
	return s
}

// SetIndexName sets the IndexName field's value.
func (s *ElasticsearchDestinationDescription) SetIndexName(v string) *ElasticsearchDestinationDescription {
	s.IndexName = &v
	return s
}

// SetIndexRotationPeriod sets the IndexRotationPeriod field's value.
func (s *ElasticsearchDestinationDescription) SetIndexRotationPeriod(v string) *ElasticsearchDestinationDescription {
	s.IndexRotationPeriod = &v
	return s
}

// SetProcessingConfiguration sets the ProcessingConfiguration field's value.
func (s *ElasticsearchDestinationDescription) SetProcessingConfiguration(v *ProcessingConfiguration) *ElasticsearchDestinationDescription {
	s.ProcessingConfiguration = v
	return s
}

// SetRetryOptions sets the RetryOptions field's value.
func (s *ElasticsearchDestinationDescription) SetRetryOptions(v *ElasticsearchRetryOptions) *ElasticsearchDestinationDescription {
	s.RetryOptions = v
	return s
}

// SetRoleARN sets the RoleARN field's value.
func (s *ElasticsearchDestinationDescription) SetRoleARN(v string) *ElasticsearchDestinationDescription {
	s.RoleARN = &v
	return s
}

// SetS3BackupMode sets the S3BackupMode field's value.
func (s *ElasticsearchDestinationDescription) SetS3BackupMode(v string) *ElasticsearchDestinationDescription {
	s.S3BackupMode = &v
	return s
}

// SetS3DestinationDescription sets the S3DestinationDescription field's value.
func (s *ElasticsearchDestinationDescription) SetS3DestinationDescription(v *S3DestinationDescription) *ElasticsearchDestinationDescription {
	s.S3DestinationDescription = v
	return s
}

// SetTypeName sets the TypeName field's value.
func (s *ElasticsearchDestinationDescription) SetTypeName(v string) *ElasticsearchDestinationDescription {
	s.TypeName = &v
	return s
}

// Describes an update for a destination in Amazon ES.
type ElasticsearchDestinationUpdate struct {
	_ struct{} `type:"structure"`

	// The buffering options. If no value is specified, ElasticsearchBufferingHints
	// object default values are used.
	BufferingHints *ElasticsearchBufferingHints `type:"structure"`

	// The CloudWatch logging options for your delivery stream.
	CloudWatchLoggingOptions *CloudWatchLoggingOptions `type:"structure"`

	// The ARN of the Amazon ES domain. The IAM role must have permissions for DescribeElasticsearchDomain,
	// DescribeElasticsearchDomains, and DescribeElasticsearchDomainConfig after
	// assuming the IAM role specified in RoleARN.
	DomainARN *string `min:"1" type:"string"`

	// The Elasticsearch index name.
	IndexName *string `min:"1" type:"string"`

	// The Elasticsearch index rotation period. Index rotation appends a time stamp
	// to IndexName to facilitate the expiration of old data. For more information,
	// see Index Rotation for Amazon Elasticsearch Service Destination (http://docs.aws.amazon.com/firehose/latest/dev/basic-deliver.html#es-index-rotation).
	// Default value is OneDay.
	IndexRotationPeriod *string `type:"string" enum:"ElasticsearchIndexRotationPeriod"`

	// The data processing configuration.
	ProcessingConfiguration *ProcessingConfiguration `type:"structure"`

	// The retry behavior in case Kinesis Firehose is unable to deliver documents
	// to Amazon ES. The default value is 300 (5 minutes).
	RetryOptions *ElasticsearchRetryOptions `type:"structure"`

	// The ARN of the IAM role to be assumed by Kinesis Firehose for calling the
	// Amazon ES Configuration API and for indexing documents. For more information,
	// see Amazon S3 Bucket Access (http://docs.aws.amazon.com/firehose/latest/dev/controlling-access.html#using-iam-s3).
	RoleARN *string `min:"1" type:"string"`

	// The Amazon S3 destination.
	S3Update *S3DestinationUpdate `type:"structure"`

	// The Elasticsearch type name.
	TypeName *string `min:"1" type:"string"`
}

// String returns the string representation
func (s ElasticsearchDestinationUpdate) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ElasticsearchDestinationUpdate) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ElasticsearchDestinationUpdate) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ElasticsearchDestinationUpdate"}
	if s.DomainARN != nil && len(*s.DomainARN) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("DomainARN", 1))
	}
	if s.IndexName != nil && len(*s.IndexName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("IndexName", 1))
	}
	if s.RoleARN != nil && len(*s.RoleARN) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("RoleARN", 1))
	}
	if s.TypeName != nil && len(*s.TypeName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("TypeName", 1))
	}
	if s.BufferingHints != nil {
		if err := s.BufferingHints.Validate(); err != nil {
			invalidParams.AddNested("BufferingHints", err.(request.ErrInvalidParams))
		}
	}
	if s.ProcessingConfiguration != nil {
		if err := s.ProcessingConfiguration.Validate(); err != nil {
			invalidParams.AddNested("ProcessingConfiguration", err.(request.ErrInvalidParams))
		}
	}
	if s.S3Update != nil {
		if err := s.S3Update.Validate(); err != nil {
			invalidParams.AddNested("S3Update", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetBufferingHints sets the BufferingHints field's value.
func (s *ElasticsearchDestinationUpdate) SetBufferingHints(v *ElasticsearchBufferingHints) *ElasticsearchDestinationUpdate {
	s.BufferingHints = v
	return s
}

// SetCloudWatchLoggingOptions sets the CloudWatchLoggingOptions field's value.
func (s *ElasticsearchDestinationUpdate) SetCloudWatchLoggingOptions(v *CloudWatchLoggingOptions) *ElasticsearchDestinationUpdate {
	s.CloudWatchLoggingOptions = v
	return s
}

// SetDomainARN sets the DomainARN field's value.
func (s *ElasticsearchDestinationUpdate) SetDomainARN(v string) *ElasticsearchDestinationUpdate {
	s.DomainARN = &v
	return s
}

// SetIndexName sets the IndexName field's value.
func (s *ElasticsearchDestinationUpdate) SetIndexName(v string) *ElasticsearchDestinationUpdate {
	s.IndexName = &v
	return s
}

// SetIndexRotationPeriod sets the IndexRotationPeriod field's value.
func (s *ElasticsearchDestinationUpdate) SetIndexRotationPeriod(v string) *ElasticsearchDestinationUpdate {
	s.IndexRotationPeriod = &v
	return s
}

// SetProcessingConfiguration sets the ProcessingConfiguration field's value.
func (s *ElasticsearchDestinationUpdate) SetProcessingConfiguration(v *ProcessingConfiguration) *ElasticsearchDestinationUpdate {
	s.ProcessingConfiguration = v
	return s
}

// SetRetryOptions sets the RetryOptions field's value.
func (s *ElasticsearchDestinationUpdate) SetRetryOptions(v *ElasticsearchRetryOptions) *ElasticsearchDestinationUpdate {
	s.RetryOptions = v
	return s
}

// SetRoleARN sets the RoleARN field's value.
func (s *ElasticsearchDestinationUpdate) SetRoleARN(v string) *ElasticsearchDestinationUpdate {
	s.RoleARN = &v
	return s
}

// SetS3Update sets the S3Update field's value.
func (s *ElasticsearchDestinationUpdate) SetS3Update(v *S3DestinationUpdate) *ElasticsearchDestinationUpdate {
	s.S3Update = v
	return s
}

// SetTypeName sets the TypeName field's value.
func (s *ElasticsearchDestinationUpdate) SetTypeName(v string) *ElasticsearchDestinationUpdate {
	s.TypeName = &v
	return s
}

// Configures retry behavior in case Kinesis Firehose is unable to deliver documents
// to Amazon ES.
type ElasticsearchRetryOptions struct {
	_ struct{} `type:"structure"`

	// After an initial failure to deliver to Amazon ES, the total amount of time
	// during which Kinesis Firehose re-attempts delivery (including the first attempt).
	// After this time has elapsed, the failed documents are written to Amazon S3.
	// Default value is 300 seconds (5 minutes). A value of 0 (zero) results in
	// no retries.
	DurationInSeconds *int64 `type:"integer"`
}

// String returns the string representation
func (s ElasticsearchRetryOptions) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ElasticsearchRetryOptions) GoString() string {
	return s.String()
}

// SetDurationInSeconds sets the DurationInSeconds field's value.
func (s *ElasticsearchRetryOptions) SetDurationInSeconds(v int64) *ElasticsearchRetryOptions {
	s.DurationInSeconds = &v
	return s
}

// Describes the encryption for a destination in Amazon S3.
type EncryptionConfiguration struct {
	_ struct{} `type:"structure"`

	// The encryption key.
	KMSEncryptionConfig *KMSEncryptionConfig `type:"structure"`

	// Specifically override existing encryption information to ensure that no encryption
	// is used.
	NoEncryptionConfig *string `type:"string" enum:"NoEncryptionConfig"`
}

// String returns the string representation
func (s EncryptionConfiguration) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s EncryptionConfiguration) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *EncryptionConfiguration) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "EncryptionConfiguration"}
	if s.KMSEncryptionConfig != nil {
		if err := s.KMSEncryptionConfig.Validate(); err != nil {
			invalidParams.AddNested("KMSEncryptionConfig", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetKMSEncryptionConfig sets the KMSEncryptionConfig field's value.
func (s *EncryptionConfiguration) SetKMSEncryptionConfig(v *KMSEncryptionConfig) *EncryptionConfiguration {
	s.KMSEncryptionConfig = v
	return s
}

// SetNoEncryptionConfig sets the NoEncryptionConfig field's value.
func (s *EncryptionConfiguration) SetNoEncryptionConfig(v string) *EncryptionConfiguration {
	s.NoEncryptionConfig = &v
	return s
}

// Describes the configuration of a destination in Amazon S3.
type ExtendedS3DestinationConfiguration struct {
	_ struct{} `type:"structure"`

	// The ARN of the S3 bucket.
	//
	// BucketARN is a required field
	BucketARN *string `min:"1" type:"string" required:"true"`

	// The buffering option.
	BufferingHints *BufferingHints `type:"structure"`

	// The CloudWatch logging options for your delivery stream.
	CloudWatchLoggingOptions *CloudWatchLoggingOptions `type:"structure"`

	// The compression format. If no value is specified, the default is UNCOMPRESSED.
	CompressionFormat *string `type:"string" enum:"CompressionFormat"`

	// The encryption configuration. If no value is specified, the default is no
	// encryption.
	EncryptionConfiguration *EncryptionConfiguration `type:"structure"`

	// The "YYYY/MM/DD/HH" time format prefix is automatically used for delivered
	// S3 files. You can specify an extra prefix to be added in front of the time
	// format prefix. If the prefix ends with a slash, it appears as a folder in
	// the S3 bucket. For more information, see Amazon S3 Object Name Format (http://docs.aws.amazon.com/firehose/latest/dev/basic-deliver.html)
	// in the Amazon Kinesis Firehose Developer Guide.
	Prefix *string `type:"string"`

	// The data processing configuration.
	ProcessingConfiguration *ProcessingConfiguration `type:"structure"`

	// The ARN of the AWS credentials.
	//
	// RoleARN is a required field
	RoleARN *string `min:"1" type:"string" required:"true"`

	// The configuration for backup in Amazon S3.
	S3BackupConfiguration *S3DestinationConfiguration `type:"structure"`

	// The Amazon S3 backup mode.
	S3BackupMode *string `type:"string" enum:"S3BackupMode"`
}

// String returns the string representation
func (s ExtendedS3DestinationConfiguration) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ExtendedS3DestinationConfiguration) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ExtendedS3DestinationConfiguration) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ExtendedS3DestinationConfiguration"}
	if s.BucketARN == nil {
		invalidParams.Add(request.NewErrParamRequired("BucketARN"))
	}
	if s.BucketARN != nil && len(*s.BucketARN) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("BucketARN", 1))
	}
	if s.RoleARN == nil {
		invalidParams.Add(request.NewErrParamRequired("RoleARN"))
	}
	if s.RoleARN != nil && len(*s.RoleARN) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("RoleARN", 1))
	}
	if s.BufferingHints != nil {
		if err := s.BufferingHints.Validate(); err != nil {
			invalidParams.AddNested("BufferingHints", err.(request.ErrInvalidParams))
		}
	}
	if s.EncryptionConfiguration != nil {
		if err := s.EncryptionConfiguration.Validate(); err != nil {
			invalidParams.AddNested("EncryptionConfiguration", err.(request.ErrInvalidParams))
		}
	}
	if s.ProcessingConfiguration != nil {
		if err := s.ProcessingConfiguration.Validate(); err != nil {
			invalidParams.AddNested("ProcessingConfiguration", err.(request.ErrInvalidParams))
		}
	}
	if s.S3BackupConfiguration != nil {
		if err := s.S3BackupConfiguration.Validate(); err != nil {
			invalidParams.AddNested("S3BackupConfiguration", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetBucketARN sets the BucketARN field's value.
func (s *ExtendedS3DestinationConfiguration) SetBucketARN(v string) *ExtendedS3DestinationConfiguration {
	s.BucketARN = &v
	return s
}

// SetBufferingHints sets the BufferingHints field's value.
func (s *ExtendedS3DestinationConfiguration) SetBufferingHints(v *BufferingHints) *ExtendedS3DestinationConfiguration {
	s.BufferingHints = v
	return s
}

// SetCloudWatchLoggingOptions sets the CloudWatchLoggingOptions field's value.
func (s *ExtendedS3DestinationConfiguration) SetCloudWatchLoggingOptions(v *CloudWatchLoggingOptions) *ExtendedS3DestinationConfiguration {
	s.CloudWatchLoggingOptions = v
	return s
}

// SetCompressionFormat sets the CompressionFormat field's value.
func (s *ExtendedS3DestinationConfiguration) SetCompressionFormat(v string) *ExtendedS3DestinationConfiguration {
	s.CompressionFormat = &v
	return s
}

// SetEncryptionConfiguration sets the EncryptionConfiguration field's value.
func (s *ExtendedS3DestinationConfiguration) SetEncryptionConfiguration(v *EncryptionConfiguration) *ExtendedS3DestinationConfiguration {
	s.EncryptionConfiguration = v
	return s
}

// SetPrefix sets the Prefix field's value.
func (s *ExtendedS3DestinationConfiguration) SetPrefix(v string) *ExtendedS3DestinationConfiguration {
	s.Prefix = &v
	return s
}

// SetProcessingConfiguration sets the ProcessingConfiguration field's value.
func (s *ExtendedS3DestinationConfiguration) SetProcessingConfiguration(v *ProcessingConfiguration) *ExtendedS3DestinationConfiguration {
	s.ProcessingConfiguration = v
	return s
}

// SetRoleARN sets the RoleARN field's value.
func (s *ExtendedS3DestinationConfiguration) SetRoleARN(v string) *ExtendedS3DestinationConfiguration {
	s.RoleARN = &v
	return s
}

// SetS3BackupConfiguration sets the S3BackupConfiguration field's value.
func (s *ExtendedS3DestinationConfiguration) SetS3BackupConfiguration(v *S3DestinationConfiguration) *ExtendedS3DestinationConfiguration {
	s.S3BackupConfiguration = v
	return s
}

// SetS3BackupMode sets the S3BackupMode field's value.
func (s *ExtendedS3DestinationConfiguration) SetS3BackupMode(v string) *ExtendedS3DestinationConfiguration {
	s.S3BackupMode = &v
	return s
}

// Describes a destination in Amazon S3.
type ExtendedS3DestinationDescription struct {
	_ struct{} `type:"structure"`

	// The ARN of the S3 bucket.
	//
	// BucketARN is a required field
	BucketARN *string `min:"1" type:"string" required:"true"`

	// The buffering option.
	//
	// BufferingHints is a required field
	BufferingHints *BufferingHints `type:"structure" required:"true"`

	// The CloudWatch logging options for your delivery stream.
	CloudWatchLoggingOptions *CloudWatchLoggingOptions `type:"structure"`

	// The compression format. If no value is specified, the default is UNCOMPRESSED.
	//
	// CompressionFormat is a required field
	CompressionFormat *string `type:"string" required:"true" enum:"CompressionFormat"`

	// The encryption configuration. If no value is specified, the default is no
	// encryption.
	//
	// EncryptionConfiguration is a required field
	EncryptionConfiguration *EncryptionConfiguration `type:"structure" required:"true"`

	// The "YYYY/MM/DD/HH" time format prefix is automatically used for delivered
	// S3 files. You can specify an extra prefix to be added in front of the time
	// format prefix. If the prefix ends with a slash, it appears as a folder in
	// the S3 bucket. For more information, see Amazon S3 Object Name Format (http://docs.aws.amazon.com/firehose/latest/dev/basic-deliver.html)
	// in the Amazon Kinesis Firehose Developer Guide.
	Prefix *string `type:"string"`

	// The data processing configuration.
	ProcessingConfiguration *ProcessingConfiguration `type:"structure"`

	// The ARN of the AWS credentials.
	//
	// RoleARN is a required field
	RoleARN *string `min:"1" type:"string" required:"true"`

	// The configuration for backup in Amazon S3.
	S3BackupDescription *S3DestinationDescription `type:"structure"`

	// The Amazon S3 backup mode.
	S3BackupMode *string `type:"string" enum:"S3BackupMode"`
}

// String returns the string representation
func (s ExtendedS3DestinationDescription) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ExtendedS3DestinationDescription) GoString() string {
	return s.String()
}

// SetBucketARN sets the BucketARN field's value.
func (s *ExtendedS3DestinationDescription) SetBucketARN(v string) *ExtendedS3DestinationDescription {
	s.BucketARN = &v
	return s
}

// SetBufferingHints sets the BufferingHints field's value.
func (s *ExtendedS3DestinationDescription) SetBufferingHints(v *BufferingHints) *ExtendedS3DestinationDescription {
	s.BufferingHints = v
	return s
}

// SetCloudWatchLoggingOptions sets the CloudWatchLoggingOptions field's value.
func (s *ExtendedS3DestinationDescription) SetCloudWatchLoggingOptions(v *CloudWatchLoggingOptions) *ExtendedS3DestinationDescription {
	s.CloudWatchLoggingOptions = v
	return s
}

// SetCompressionFormat sets the CompressionFormat field's value.
func (s *ExtendedS3DestinationDescription) SetCompressionFormat(v string) *ExtendedS3DestinationDescription {
	s.CompressionFormat = &v
	return s
}

// SetEncryptionConfiguration sets the EncryptionConfiguration field's value.
func (s *ExtendedS3DestinationDescription) SetEncryptionConfiguration(v *EncryptionConfiguration) *ExtendedS3DestinationDescription {
	s.EncryptionConfiguration = v
	return s
}

// SetPrefix sets the Prefix field's value.
func (s *ExtendedS3DestinationDescription) SetPrefix(v string) *ExtendedS3DestinationDescription {
	s.Prefix = &v
	return s
}

// SetProcessingConfiguration sets the ProcessingConfiguration field's value.
func (s *ExtendedS3DestinationDescription) SetProcessingConfiguration(v *ProcessingConfiguration) *ExtendedS3DestinationDescription {
	s.ProcessingConfiguration = v
	return s
}

// SetRoleARN sets the RoleARN field's value.
func (s *ExtendedS3DestinationDescription) SetRoleARN(v string) *ExtendedS3DestinationDescription {
	s.RoleARN = &v
	return s
}

// SetS3BackupDescription sets the S3BackupDescription field's value.
func (s *ExtendedS3DestinationDescription) SetS3BackupDescription(v *S3DestinationDescription) *ExtendedS3DestinationDescription {
	s.S3BackupDescription = v
	return s
}

// SetS3BackupMode sets the S3BackupMode field's value.
func (s *ExtendedS3DestinationDescription) SetS3BackupMode(v string) *ExtendedS3DestinationDescription {
	s.S3BackupMode = &v
	return s
}

// Describes an update for a destination in Amazon S3.
type ExtendedS3DestinationUpdate struct {
	_ struct{} `type:"structure"`

	// The ARN of the S3 bucket.
	BucketARN *string `min:"1" type:"string"`

	// The buffering option.
	BufferingHints *BufferingHints `type:"structure"`

	// The CloudWatch logging options for your delivery stream.
	CloudWatchLoggingOptions *CloudWatchLoggingOptions `type:"structure"`

	// The compression format. If no value is specified, the default is UNCOMPRESSED.
	CompressionFormat *string `type:"string" enum:"CompressionFormat"`

	// The encryption configuration. If no value is specified, the default is no
	// encryption.
	EncryptionConfiguration *EncryptionConfiguration `type:"structure"`

	// The "YYYY/MM/DD/HH" time format prefix is automatically used for delivered
	// S3 files. You can specify an extra prefix to be added in front of the time
	// format prefix. If the prefix ends with a slash, it appears as a folder in
	// the S3 bucket. For more information, see Amazon S3 Object Name Format (http://docs.aws.amazon.com/firehose/latest/dev/basic-deliver.html)
	// in the Amazon Kinesis Firehose Developer Guide.
	Prefix *string `type:"string"`

	// The data processing configuration.
	ProcessingConfiguration *ProcessingConfiguration `type:"structure"`

	// The ARN of the AWS credentials.
	RoleARN *string `min:"1" type:"string"`

	// Enables or disables Amazon S3 backup mode.
	S3BackupMode *string `type:"string" enum:"S3BackupMode"`

	// The Amazon S3 destination for backup.
	S3BackupUpdate *S3DestinationUpdate `type:"structure"`
}

// String returns the string representation
func (s ExtendedS3DestinationUpdate) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ExtendedS3DestinationUpdate) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ExtendedS3DestinationUpdate) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ExtendedS3DestinationUpdate"}
	if s.BucketARN != nil && len(*s.BucketARN) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("BucketARN", 1))
	}
	if s.RoleARN != nil && len(*s.RoleARN) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("RoleARN", 1))
	}
	if s.BufferingHints != nil {
		if err := s.BufferingHints.Validate(); err != nil {
			invalidParams.AddNested("BufferingHints", err.(request.ErrInvalidParams))
		}
	}
	if s.EncryptionConfiguration != nil {
		if err := s.EncryptionConfiguration.Validate(); err != nil {
			invalidParams.AddNested("EncryptionConfiguration", err.(request.ErrInvalidParams))
		}
	}
	if s.ProcessingConfiguration != nil {
		if err := s.ProcessingConfiguration.Validate(); err != nil {
			invalidParams.AddNested("ProcessingConfiguration", err.(request.ErrInvalidParams))
		}
	}
	if s.S3BackupUpdate != nil {
		if err := s.S3BackupUpdate.Validate(); err != nil {
			invalidParams.AddNested("S3BackupUpdate", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetBucketARN sets the BucketARN field's value.
func (s *ExtendedS3DestinationUpdate) SetBucketARN(v string) *ExtendedS3DestinationUpdate {
	s.BucketARN = &v
	return s
}

// SetBufferingHints sets the BufferingHints field's value.
func (s *ExtendedS3DestinationUpdate) SetBufferingHints(v *BufferingHints) *ExtendedS3DestinationUpdate {
	s.BufferingHints = v
	return s
}

// SetCloudWatchLoggingOptions sets the CloudWatchLoggingOptions field's value.
func (s *ExtendedS3DestinationUpdate) SetCloudWatchLoggingOptions(v *CloudWatchLoggingOptions) *ExtendedS3DestinationUpdate {
	s.CloudWatchLoggingOptions = v
	return s
}

// SetCompressionFormat sets the CompressionFormat field's value.
func (s *ExtendedS3DestinationUpdate) SetCompressionFormat(v string) *ExtendedS3DestinationUpdate {
	s.CompressionFormat = &v
	return s
}

// SetEncryptionConfiguration sets the EncryptionConfiguration field's value.
func (s *ExtendedS3DestinationUpdate) SetEncryptionConfiguration(v *EncryptionConfiguration) *ExtendedS3DestinationUpdate {
	s.EncryptionConfiguration = v
	return s
}

// SetPrefix sets the Prefix field's value.
func (s *ExtendedS3DestinationUpdate) SetPrefix(v string) *ExtendedS3DestinationUpdate {
	s.Prefix = &v
	return s
}

// SetProcessingConfiguration sets the ProcessingConfiguration field's value.
func (s *ExtendedS3DestinationUpdate) SetProcessingConfiguration(v *ProcessingConfiguration) *ExtendedS3DestinationUpdate {
	s.ProcessingConfiguration = v
	return s
}

// SetRoleARN sets the RoleARN field's value.
func (s *ExtendedS3DestinationUpdate) SetRoleARN(v string) *ExtendedS3DestinationUpdate {
	s.RoleARN = &v
	return s
}

// SetS3BackupMode sets the S3BackupMode field's value.
func (s *ExtendedS3DestinationUpdate) SetS3BackupMode(v string) *ExtendedS3DestinationUpdate {
	s.S3BackupMode = &v
	return s
}

// SetS3BackupUpdate sets the S3BackupUpdate field's value.
func (s *ExtendedS3DestinationUpdate) SetS3BackupUpdate(v *S3DestinationUpdate) *ExtendedS3DestinationUpdate {
	s.S3BackupUpdate = v
	return s
}

// Describes an encryption key for a destination in Amazon S3.
type KMSEncryptionConfig struct {
	_ struct{} `type:"structure"`

	// The ARN of the encryption key. Must belong to the same region as the destination
	// Amazon S3 bucket.
	//
	// AWSKMSKeyARN is a required field
	AWSKMSKeyARN *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s KMSEncryptionConfig) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s KMSEncryptionConfig) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *KMSEncryptionConfig) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "KMSEncryptionConfig"}
	if s.AWSKMSKeyARN == nil {
		invalidParams.Add(request.NewErrParamRequired("AWSKMSKeyARN"))
	}
	if s.AWSKMSKeyARN != nil && len(*s.AWSKMSKeyARN) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("AWSKMSKeyARN", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAWSKMSKeyARN sets the AWSKMSKeyARN field's value.
func (s *KMSEncryptionConfig) SetAWSKMSKeyARN(v string) *KMSEncryptionConfig {
	s.AWSKMSKeyARN = &v
	return s
}

// The stream and role ARNs for a Kinesis stream used as the source for a delivery
// stream.
type KinesisStreamSourceConfiguration struct {
	_ struct{} `type:"structure"`

	// The ARN of the source Kinesis stream.
	//
	// KinesisStreamARN is a required field
	KinesisStreamARN *string `min:"1" type:"string" required:"true"`

	// The ARN of the role that provides access to the source Kinesis stream.
	//
	// RoleARN is a required field
	RoleARN *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s KinesisStreamSourceConfiguration) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s KinesisStreamSourceConfiguration) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *KinesisStreamSourceConfiguration) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "KinesisStreamSourceConfiguration"}
	if s.KinesisStreamARN == nil {
		invalidParams.Add(request.NewErrParamRequired("KinesisStreamARN"))
	}
	if s.KinesisStreamARN != nil && len(*s.KinesisStreamARN) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("KinesisStreamARN", 1))
	}
	if s.RoleARN == nil {
		invalidParams.Add(request.NewErrParamRequired("RoleARN"))
	}
	if s.RoleARN != nil && len(*s.RoleARN) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("RoleARN", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetKinesisStreamARN sets the KinesisStreamARN field's value.
func (s *KinesisStreamSourceConfiguration) SetKinesisStreamARN(v string) *KinesisStreamSourceConfiguration {
	s.KinesisStreamARN = &v
	return s
}

// SetRoleARN sets the RoleARN field's value.
func (s *KinesisStreamSourceConfiguration) SetRoleARN(v string) *KinesisStreamSourceConfiguration {
	s.RoleARN = &v
	return s
}

// Details about a Kinesis stream used as the source for a Kinesis Firehose
// delivery stream.
type KinesisStreamSourceDescription struct {
	_ struct{} `type:"structure"`

	// Kinesis Firehose starts retrieving records from the Kinesis stream starting
	// with this time stamp.
	DeliveryStartTimestamp *time.Time `type:"timestamp" timestampFormat:"unix"`

	// The ARN of the source Kinesis stream.
	KinesisStreamARN *string `min:"1" type:"string"`

	// The ARN of the role used by the source Kinesis stream.
	RoleARN *string `min:"1" type:"string"`
}

// String returns the string representation
func (s KinesisStreamSourceDescription) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s KinesisStreamSourceDescription) GoString() string {
	return s.String()
}

// SetDeliveryStartTimestamp sets the DeliveryStartTimestamp field's value.
func (s *KinesisStreamSourceDescription) SetDeliveryStartTimestamp(v time.Time) *KinesisStreamSourceDescription {
	s.DeliveryStartTimestamp = &v
	return s
}

// SetKinesisStreamARN sets the KinesisStreamARN field's value.
func (s *KinesisStreamSourceDescription) SetKinesisStreamARN(v string) *KinesisStreamSourceDescription {
	s.KinesisStreamARN = &v
	return s
}

// SetRoleARN sets the RoleARN field's value.
func (s *KinesisStreamSourceDescription) SetRoleARN(v string) *KinesisStreamSourceDescription {
	s.RoleARN = &v
	return s
}

type ListDeliveryStreamsInput struct {
	_ struct{} `type:"structure"`

	// The delivery stream type. This can be one of the following values:
	//
	//    * DirectPut: Provider applications access the delivery stream directly.
	//
	//    * KinesisStreamAsSource: The delivery stream uses a Kinesis stream as
	//    a source.
	//
	// This parameter is optional. If this parameter is omitted, delivery streams
	// of all types are returned.
	DeliveryStreamType *string `type:"string" enum:"DeliveryStreamType"`

	// The name of the delivery stream to start the list with.
	ExclusiveStartDeliveryStreamName *string `min:"1" type:"string"`

	// The maximum number of delivery streams to list. The default value is 10.
	Limit *int64 `min:"1" type:"integer"`
}

// String returns the string representation
func (s ListDeliveryStreamsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListDeliveryStreamsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListDeliveryStreamsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListDeliveryStreamsInput"}
	if s.ExclusiveStartDeliveryStreamName != nil && len(*s.ExclusiveStartDeliveryStreamName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ExclusiveStartDeliveryStreamName", 1))
	}
	if s.Limit != nil && *s.Limit < 1 {
		invalidParams.Add(request.NewErrParamMinValue("Limit", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetDeliveryStreamType sets the DeliveryStreamType field's value.
func (s *ListDeliveryStreamsInput) SetDeliveryStreamType(v string) *ListDeliveryStreamsInput {
	s.DeliveryStreamType = &v
	return s
}

// SetExclusiveStartDeliveryStreamName sets the ExclusiveStartDeliveryStreamName field's value.
func (s *ListDeliveryStreamsInput) SetExclusiveStartDeliveryStreamName(v string) *ListDeliveryStreamsInput {
	s.ExclusiveStartDeliveryStreamName = &v
	return s
}

// SetLimit sets the Limit field's value.
func (s *ListDeliveryStreamsInput) SetLimit(v int64) *ListDeliveryStreamsInput {
	s.Limit = &v
	return s
}

type ListDeliveryStreamsOutput struct {
	_ struct{} `type:"structure"`

	// The names of the delivery streams.
	//
	// DeliveryStreamNames is a required field
	DeliveryStreamNames []*string `type:"list" required:"true"`

	// Indicates whether there are more delivery streams available to list.
	//
	// HasMoreDeliveryStreams is a required field
	HasMoreDeliveryStreams *bool `type:"boolean" required:"true"`
}

// String returns the string representation
func (s ListDeliveryStreamsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListDeliveryStreamsOutput) GoString() string {
	return s.String()
}

// SetDeliveryStreamNames sets the DeliveryStreamNames field's value.
func (s *ListDeliveryStreamsOutput) SetDeliveryStreamNames(v []*string) *ListDeliveryStreamsOutput {
	s.DeliveryStreamNames = v
	return s
}

// SetHasMoreDeliveryStreams sets the HasMoreDeliveryStreams field's value.
func (s *ListDeliveryStreamsOutput) SetHasMoreDeliveryStreams(v bool) *ListDeliveryStreamsOutput {
	s.HasMoreDeliveryStreams = &v
	return s
}

// Describes a data processing configuration.
type ProcessingConfiguration struct {
	_ struct{} `type:"structure"`

	// Enables or disables data processing.
	Enabled *bool `type:"boolean"`

	// The data processors.
	Processors []*Processor `type:"list"`
}

// String returns the string representation
func (s ProcessingConfiguration) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ProcessingConfiguration) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ProcessingConfiguration) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ProcessingConfiguration"}
	if s.Processors != nil {
		for i, v := range s.Processors {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "Processors", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetEnabled sets the Enabled field's value.
func (s *ProcessingConfiguration) SetEnabled(v bool) *ProcessingConfiguration {
	s.Enabled = &v
	return s
}

// SetProcessors sets the Processors field's value.
func (s *ProcessingConfiguration) SetProcessors(v []*Processor) *ProcessingConfiguration {
	s.Processors = v
	return s
}

// Describes a data processor.
type Processor struct {
	_ struct{} `type:"structure"`

	// The processor parameters.
	Parameters []*ProcessorParameter `type:"list"`

	// The type of processor.
	//
	// Type is a required field
	Type *string `type:"string" required:"true" enum:"ProcessorType"`
}

// String returns the string representation
func (s Processor) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s Processor) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *Processor) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "Processor"}
	if s.Type == nil {
		invalidParams.Add(request.NewErrParamRequired("Type"))
	}
	if s.Parameters != nil {
		for i, v := range s.Parameters {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "Parameters", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetParameters sets the Parameters field's value.
func (s *Processor) SetParameters(v []*ProcessorParameter) *Processor {
	s.Parameters = v
	return s
}

// SetType sets the Type field's value.
func (s *Processor) SetType(v string) *Processor {
	s.Type = &v
	return s
}

// Describes the processor parameter.
type ProcessorParameter struct {
	_ struct{} `type:"structure"`

	// The name of the parameter.
	//
	// ParameterName is a required field
	ParameterName *string `type:"string" required:"true" enum:"ProcessorParameterName"`

	// The parameter value.
	//
	// ParameterValue is a required field
	ParameterValue *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s ProcessorParameter) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ProcessorParameter) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ProcessorParameter) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ProcessorParameter"}
	if s.ParameterName == nil {
		invalidParams.Add(request.NewErrParamRequired("ParameterName"))
	}
	if s.ParameterValue == nil {
		invalidParams.Add(request.NewErrParamRequired("ParameterValue"))
	}
	if s.ParameterValue != nil && len(*s.ParameterValue) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ParameterValue", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetParameterName sets the ParameterName field's value.
func (s *ProcessorParameter) SetParameterName(v string) *ProcessorParameter {
	s.ParameterName = &v
	return s
}

// SetParameterValue sets the ParameterValue field's value.
func (s *ProcessorParameter) SetParameterValue(v string) *ProcessorParameter {
	s.ParameterValue = &v
	return s
}

type PutRecordBatchInput struct {
	_ struct{} `type:"structure"`

	// The name of the delivery stream.
	//
	// DeliveryStreamName is a required field
	DeliveryStreamName *string `min:"1" type:"string" required:"true"`

	// One or more records.
	//
	// Records is a required field
	Records []*Record `min:"1" type:"list" required:"true"`
}

// String returns the string representation
func (s PutRecordBatchInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s PutRecordBatchInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *PutRecordBatchInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "PutRecordBatchInput"}
	if s.DeliveryStreamName == nil {
		invalidParams.Add(request.NewErrParamRequired("DeliveryStreamName"))
	}
	if s.DeliveryStreamName != nil && len(*s.DeliveryStreamName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("DeliveryStreamName", 1))
	}
	if s.Records == nil {
		invalidParams.Add(request.NewErrParamRequired("Records"))
	}
	if s.Records != nil && len(s.Records) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Records", 1))
	}
	if s.Records != nil {
		for i, v := range s.Records {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "Records", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetDeliveryStreamName sets the DeliveryStreamName field's value.
func (s *PutRecordBatchInput) SetDeliveryStreamName(v string) *PutRecordBatchInput {
	s.DeliveryStreamName = &v
	return s
}

// SetRecords sets the Records field's value.
func (s *PutRecordBatchInput) SetRecords(v []*Record) *PutRecordBatchInput {
	s.Records = v
	return s
}

type PutRecordBatchOutput struct {
	_ struct{} `type:"structure"`

	// The number of records that might have failed processing.
	//
	// FailedPutCount is a required field
	FailedPutCount *int64 `type:"integer" required:"true"`

	// The results array. For each record, the index of the response element is
	// the same as the index used in the request array.
	//
	// RequestResponses is a required field
	RequestResponses []*PutRecordBatchResponseEntry `min:"1" type:"list" required:"true"`
}

// String returns the string representation
func (s PutRecordBatchOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s PutRecordBatchOutput) GoString() string {
	return s.String()
}

// SetFailedPutCount sets the FailedPutCount field's value.
func (s *PutRecordBatchOutput) SetFailedPutCount(v int64) *PutRecordBatchOutput {
	s.FailedPutCount = &v
	return s
}

// SetRequestResponses sets the RequestResponses field's value.
func (s *PutRecordBatchOutput) SetRequestResponses(v []*PutRecordBatchResponseEntry) *PutRecordBatchOutput {
	s.RequestResponses = v
	return s
}

// Contains the result for an individual record from a PutRecordBatch request.
// If the record is successfully added to your delivery stream, it receives
// a record ID. If the record fails to be added to your delivery stream, the
// result includes an error code and an error message.
type PutRecordBatchResponseEntry struct {
	_ struct{} `type:"structure"`

	// The error code for an individual record result.
	ErrorCode *string `type:"string"`

	// The error message for an individual record result.
	ErrorMessage *string `type:"string"`

	// The ID of the record.
	RecordId *string `min:"1" type:"string"`
}

// String returns the string representation
func (s PutRecordBatchResponseEntry) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s PutRecordBatchResponseEntry) GoString() string {
	return s.String()
}

// SetErrorCode sets the ErrorCode field's value.
func (s *PutRecordBatchResponseEntry) SetErrorCode(v string) *PutRecordBatchResponseEntry {
	s.ErrorCode = &v
	return s
}

// SetErrorMessage sets the ErrorMessage field's value.
func (s *PutRecordBatchResponseEntry) SetErrorMessage(v string) *PutRecordBatchResponseEntry {
	s.ErrorMessage = &v
	return s
}

// SetRecordId sets the RecordId field's value.
func (s *PutRecordBatchResponseEntry) SetRecordId(v string) *PutRecordBatchResponseEntry {
	s.RecordId = &v
	return s
}

type PutRecordInput struct {
	_ struct{} `type:"structure"`

	// The name of the delivery stream.
	//
	// DeliveryStreamName is a required field
	DeliveryStreamName *string `min:"1" type:"string" required:"true"`

	// The record.
	//
	// Record is a required field
	Record *Record `type:"structure" required:"true"`
}

// String returns the string representation
func (s PutRecordInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s PutRecordInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *PutRecordInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "PutRecordInput"}
	if s.DeliveryStreamName == nil {
		invalidParams.Add(request.NewErrParamRequired("DeliveryStreamName"))
	}
	if s.DeliveryStreamName != nil && len(*s.DeliveryStreamName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("DeliveryStreamName", 1))
	}
	if s.Record == nil {
		invalidParams.Add(request.NewErrParamRequired("Record"))
	}
	if s.Record != nil {
		if err := s.Record.Validate(); err != nil {
			invalidParams.AddNested("Record", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetDeliveryStreamName sets the DeliveryStreamName field's value.
func (s *PutRecordInput) SetDeliveryStreamName(v string) *PutRecordInput {
	s.DeliveryStreamName = &v
	return s
}

// SetRecord sets the Record field's value.
func (s *PutRecordInput) SetRecord(v *Record) *PutRecordInput {
	s.Record = v
	return s
}

type PutRecordOutput struct {
	_ struct{} `type:"structure"`

	// The ID of the record.
	//
	// RecordId is a required field
	RecordId *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s PutRecordOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s PutRecordOutput) GoString() string {
	return s.String()
}

// SetRecordId sets the RecordId field's value.
func (s *PutRecordOutput) SetRecordId(v string) *PutRecordOutput {
	s.RecordId = &v
	return s
}

// The unit of data in a delivery stream.
type Record struct {
	_ struct{} `type:"structure"`

	// The data blob, which is base64-encoded when the blob is serialized. The maximum
	// size of the data blob, before base64-encoding, is 1,000 KB.
	//
	// Data is automatically base64 encoded/decoded by the SDK.
	//
	// Data is a required field
	Data []byte `type:"blob" required:"true"`
}

// String returns the string representation
func (s Record) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s Record) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *Record) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "Record"}
	if s.Data == nil {
		invalidParams.Add(request.NewErrParamRequired("Data"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetData sets the Data field's value.
func (s *Record) SetData(v []byte) *Record {
	s.Data = v
	return s
}

// Describes the configuration of a destination in Amazon Redshift.
type RedshiftDestinationConfiguration struct {
	_ struct{} `type:"structure"`

	// The CloudWatch logging options for your delivery stream.
	CloudWatchLoggingOptions *CloudWatchLoggingOptions `type:"structure"`

	// The database connection string.
	//
	// ClusterJDBCURL is a required field
	ClusterJDBCURL *string `min:"1" type:"string" required:"true"`

	// The COPY command.
	//
	// CopyCommand is a required field
	CopyCommand *CopyCommand `type:"structure" required:"true"`

	// The user password.
	//
	// Password is a required field
	Password *string `min:"6" type:"string" required:"true"`

	// The data processing configuration.
	ProcessingConfiguration *ProcessingConfiguration `type:"structure"`

	// The retry behavior in case Kinesis Firehose is unable to deliver documents
	// to Amazon Redshift. Default value is 3600 (60 minutes).
	RetryOptions *RedshiftRetryOptions `type:"structure"`

	// The ARN of the AWS credentials.
	//
	// RoleARN is a required field
	RoleARN *string `min:"1" type:"string" required:"true"`

	// The configuration for backup in Amazon S3.
	S3BackupConfiguration *S3DestinationConfiguration `type:"structure"`

	// The Amazon S3 backup mode.
	S3BackupMode *string `type:"string" enum:"RedshiftS3BackupMode"`

	// The configuration for the intermediate Amazon S3 location from which Amazon
	// Redshift obtains data. Restrictions are described in the topic for CreateDeliveryStream.
	//
	// The compression formats SNAPPY or ZIP cannot be specified in RedshiftDestinationConfiguration.S3Configuration
	// because the Amazon Redshift COPY operation that reads from the S3 bucket
	// doesn't support these compression formats.
	//
	// S3Configuration is a required field
	S3Configuration *S3DestinationConfiguration `type:"structure" required:"true"`

	// The name of the user.
	//
	// Username is a required field
	Username *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s RedshiftDestinationConfiguration) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s RedshiftDestinationConfiguration) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *RedshiftDestinationConfiguration) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "RedshiftDestinationConfiguration"}
	if s.ClusterJDBCURL == nil {
		invalidParams.Add(request.NewErrParamRequired("ClusterJDBCURL"))
	}
	if s.ClusterJDBCURL != nil && len(*s.ClusterJDBCURL) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ClusterJDBCURL", 1))
	}
	if s.CopyCommand == nil {
		invalidParams.Add(request.NewErrParamRequired("CopyCommand"))
	}
	if s.Password == nil {
		invalidParams.Add(request.NewErrParamRequired("Password"))
	}
	if s.Password != nil && len(*s.Password) < 6 {
		invalidParams.Add(request.NewErrParamMinLen("Password", 6))
	}
	if s.RoleARN == nil {
		invalidParams.Add(request.NewErrParamRequired("RoleARN"))
	}
	if s.RoleARN != nil && len(*s.RoleARN) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("RoleARN", 1))
	}
	if s.S3Configuration == nil {
		invalidParams.Add(request.NewErrParamRequired("S3Configuration"))
	}
	if s.Username == nil {
		invalidParams.Add(request.NewErrParamRequired("Username"))
	}
	if s.Username != nil && len(*s.Username) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Username", 1))
	}
	if s.CopyCommand != nil {
		if err := s.CopyCommand.Validate(); err != nil {
			invalidParams.AddNested("CopyCommand", err.(request.ErrInvalidParams))
		}
	}
	if s.ProcessingConfiguration != nil {
		if err := s.ProcessingConfiguration.Validate(); err != nil {
			invalidParams.AddNested("ProcessingConfiguration", err.(request.ErrInvalidParams))
		}
	}
	if s.S3BackupConfiguration != nil {
		if err := s.S3BackupConfiguration.Validate(); err != nil {
			invalidParams.AddNested("S3BackupConfiguration", err.(request.ErrInvalidParams))
		}
	}
	if s.S3Configuration != nil {
		if err := s.S3Configuration.Validate(); err != nil {
			invalidParams.AddNested("S3Configuration", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetCloudWatchLoggingOptions sets the CloudWatchLoggingOptions field's value.
func (s *RedshiftDestinationConfiguration) SetCloudWatchLoggingOptions(v *CloudWatchLoggingOptions) *RedshiftDestinationConfiguration {
	s.CloudWatchLoggingOptions = v
	return s
}

// SetClusterJDBCURL sets the ClusterJDBCURL field's value.
func (s *RedshiftDestinationConfiguration) SetClusterJDBCURL(v string) *RedshiftDestinationConfiguration {
	s.ClusterJDBCURL = &v
	return s
}

// SetCopyCommand sets the CopyCommand field's value.
func (s *RedshiftDestinationConfiguration) SetCopyCommand(v *CopyCommand) *RedshiftDestinationConfiguration {
	s.CopyCommand = v
	return s
}

// SetPassword sets the Password field's value.
func (s *RedshiftDestinationConfiguration) SetPassword(v string) *RedshiftDestinationConfiguration {
	s.Password = &v
	return s
}

// SetProcessingConfiguration sets the ProcessingConfiguration field's value.
func (s *RedshiftDestinationConfiguration) SetProcessingConfiguration(v *ProcessingConfiguration) *RedshiftDestinationConfiguration {
	s.ProcessingConfiguration = v
	return s
}

// SetRetryOptions sets the RetryOptions field's value.
func (s *RedshiftDestinationConfiguration) SetRetryOptions(v *RedshiftRetryOptions) *RedshiftDestinationConfiguration {
	s.RetryOptions = v
	return s
}

// SetRoleARN sets the RoleARN field's value.
func (s *RedshiftDestinationConfiguration) SetRoleARN(v string) *RedshiftDestinationConfiguration {
	s.RoleARN = &v
	return s
}

// SetS3BackupConfiguration sets the S3BackupConfiguration field's value.
func (s *RedshiftDestinationConfiguration) SetS3BackupConfiguration(v *S3DestinationConfiguration) *RedshiftDestinationConfiguration {
	s.S3BackupConfiguration = v
	return s
}

// SetS3BackupMode sets the S3BackupMode field's value.
func (s *RedshiftDestinationConfiguration) SetS3BackupMode(v string) *RedshiftDestinationConfiguration {
	s.S3BackupMode = &v
	return s
}

// SetS3Configuration sets the S3Configuration field's value.
func (s *RedshiftDestinationConfiguration) SetS3Configuration(v *S3DestinationConfiguration) *RedshiftDestinationConfiguration {
	s.S3Configuration = v
	return s
}

// SetUsername sets the Username field's value.
func (s *RedshiftDestinationConfiguration) SetUsername(v string) *RedshiftDestinationConfiguration {
	s.Username = &v
	return s
}

// Describes a destination in Amazon Redshift.
type RedshiftDestinationDescription struct {
	_ struct{} `type:"structure"`

	// The CloudWatch logging options for your delivery stream.
	CloudWatchLoggingOptions *CloudWatchLoggingOptions `type:"structure"`

	// The database connection string.
	//
	// ClusterJDBCURL is a required field
	ClusterJDBCURL *string `min:"1" type:"string" required:"true"`

	// The COPY command.
	//
	// CopyCommand is a required field
	CopyCommand *CopyCommand `type:"structure" required:"true"`

	// The data processing configuration.
	ProcessingConfiguration *ProcessingConfiguration `type:"structure"`

	// The retry behavior in case Kinesis Firehose is unable to deliver documents
	// to Amazon Redshift. Default value is 3600 (60 minutes).
	RetryOptions *RedshiftRetryOptions `type:"structure"`

	// The ARN of the AWS credentials.
	//
	// RoleARN is a required field
	RoleARN *string `min:"1" type:"string" required:"true"`

	// The configuration for backup in Amazon S3.
	S3BackupDescription *S3DestinationDescription `type:"structure"`

	// The Amazon S3 backup mode.
	S3BackupMode *string `type:"string" enum:"RedshiftS3BackupMode"`

	// The Amazon S3 destination.
	//
	// S3DestinationDescription is a required field
	S3DestinationDescription *S3DestinationDescription `type:"structure" required:"true"`

	// The name of the user.
	//
	// Username is a required field
	Username *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s RedshiftDestinationDescription) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s RedshiftDestinationDescription) GoString() string {
	return s.String()
}

// SetCloudWatchLoggingOptions sets the CloudWatchLoggingOptions field's value.
func (s *RedshiftDestinationDescription) SetCloudWatchLoggingOptions(v *CloudWatchLoggingOptions) *RedshiftDestinationDescription {
	s.CloudWatchLoggingOptions = v
	return s
}

// SetClusterJDBCURL sets the ClusterJDBCURL field's value.
func (s *RedshiftDestinationDescription) SetClusterJDBCURL(v string) *RedshiftDestinationDescription {
	s.ClusterJDBCURL = &v
	return s
}

// SetCopyCommand sets the CopyCommand field's value.
func (s *RedshiftDestinationDescription) SetCopyCommand(v *CopyCommand) *RedshiftDestinationDescription {
	s.CopyCommand = v
	return s
}

// SetProcessingConfiguration sets the ProcessingConfiguration field's value.
func (s *RedshiftDestinationDescription) SetProcessingConfiguration(v *ProcessingConfiguration) *RedshiftDestinationDescription {
	s.ProcessingConfiguration = v
	return s
}

// SetRetryOptions sets the RetryOptions field's value.
func (s *RedshiftDestinationDescription) SetRetryOptions(v *RedshiftRetryOptions) *RedshiftDestinationDescription {
	s.RetryOptions = v
	return s
}

// SetRoleARN sets the RoleARN field's value.
func (s *RedshiftDestinationDescription) SetRoleARN(v string) *RedshiftDestinationDescription {
	s.RoleARN = &v
	return s
}

// SetS3BackupDescription sets the S3BackupDescription field's value.
func (s *RedshiftDestinationDescription) SetS3BackupDescription(v *S3DestinationDescription) *RedshiftDestinationDescription {
	s.S3BackupDescription = v
	return s
}

// SetS3BackupMode sets the S3BackupMode field's value.
func (s *RedshiftDestinationDescription) SetS3BackupMode(v string) *RedshiftDestinationDescription {
	s.S3BackupMode = &v
	return s
}

// SetS3DestinationDescription sets the S3DestinationDescription field's value.
func (s *RedshiftDestinationDescription) SetS3DestinationDescription(v *S3DestinationDescription) *RedshiftDestinationDescription {
	s.S3DestinationDescription = v
	return s
}

// SetUsername sets the Username field's value.
func (s *RedshiftDestinationDescription) SetUsername(v string) *RedshiftDestinationDescription {
	s.Username = &v
	return s
}

// Describes an update for a destination in Amazon Redshift.
type RedshiftDestinationUpdate struct {
	_ struct{} `type:"structure"`

	// The CloudWatch logging options for your delivery stream.
	CloudWatchLoggingOptions *CloudWatchLoggingOptions `type:"structure"`

	// The database connection string.
	ClusterJDBCURL *string `min:"1" type:"string"`

	// The COPY command.
	CopyCommand *CopyCommand `type:"structure"`

	// The user password.
	Password *string `min:"6" type:"string"`

	// The data processing configuration.
	ProcessingConfiguration *ProcessingConfiguration `type:"structure"`

	// The retry behavior in case Kinesis Firehose is unable to deliver documents
	// to Amazon Redshift. Default value is 3600 (60 minutes).
	RetryOptions *RedshiftRetryOptions `type:"structure"`

	// The ARN of the AWS credentials.
	RoleARN *string `min:"1" type:"string"`

	// The Amazon S3 backup mode.
	S3BackupMode *string `type:"string" enum:"RedshiftS3BackupMode"`

	// The Amazon S3 destination for backup.
	S3BackupUpdate *S3DestinationUpdate `type:"structure"`

	// The Amazon S3 destination.
	//
	// The compression formats SNAPPY or ZIP cannot be specified in RedshiftDestinationUpdate.S3Update
	// because the Amazon Redshift COPY operation that reads from the S3 bucket
	// doesn't support these compression formats.
	S3Update *S3DestinationUpdate `type:"structure"`

	// The name of the user.
	Username *string `min:"1" type:"string"`
}

// String returns the string representation
func (s RedshiftDestinationUpdate) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s RedshiftDestinationUpdate) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *RedshiftDestinationUpdate) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "RedshiftDestinationUpdate"}
	if s.ClusterJDBCURL != nil && len(*s.ClusterJDBCURL) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ClusterJDBCURL", 1))
	}
	if s.Password != nil && len(*s.Password) < 6 {
		invalidParams.Add(request.NewErrParamMinLen("Password", 6))
	}
	if s.RoleARN != nil && len(*s.RoleARN) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("RoleARN", 1))
	}
	if s.Username != nil && len(*s.Username) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Username", 1))
	}
	if s.CopyCommand != nil {
		if err := s.CopyCommand.Validate(); err != nil {
			invalidParams.AddNested("CopyCommand", err.(request.ErrInvalidParams))
		}
	}
	if s.ProcessingConfiguration != nil {
		if err := s.ProcessingConfiguration.Validate(); err != nil {
			invalidParams.AddNested("ProcessingConfiguration", err.(request.ErrInvalidParams))
		}
	}
	if s.S3BackupUpdate != nil {
		if err := s.S3BackupUpdate.Validate(); err != nil {
			invalidParams.AddNested("S3BackupUpdate", err.(request.ErrInvalidParams))
		}
	}
	if s.S3Update != nil {
		if err := s.S3Update.Validate(); err != nil {
			invalidParams.AddNested("S3Update", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetCloudWatchLoggingOptions sets the CloudWatchLoggingOptions field's value.
func (s *RedshiftDestinationUpdate) SetCloudWatchLoggingOptions(v *CloudWatchLoggingOptions) *RedshiftDestinationUpdate {
	s.CloudWatchLoggingOptions = v
	return s
}

// SetClusterJDBCURL sets the ClusterJDBCURL field's value.
func (s *RedshiftDestinationUpdate) SetClusterJDBCURL(v string) *RedshiftDestinationUpdate {
	s.ClusterJDBCURL = &v
	return s
}

// SetCopyCommand sets the CopyCommand field's value.
func (s *RedshiftDestinationUpdate) SetCopyCommand(v *CopyCommand) *RedshiftDestinationUpdate {
	s.CopyCommand = v
	return s
}

// SetPassword sets the Password field's value.
func (s *RedshiftDestinationUpdate) SetPassword(v string) *RedshiftDestinationUpdate {
	s.Password = &v
	return s
}

// SetProcessingConfiguration sets the ProcessingConfiguration field's value.
func (s *RedshiftDestinationUpdate) SetProcessingConfiguration(v *ProcessingConfiguration) *RedshiftDestinationUpdate {
	s.ProcessingConfiguration = v
	return s
}

// SetRetryOptions sets the RetryOptions field's value.
func (s *RedshiftDestinationUpdate) SetRetryOptions(v *RedshiftRetryOptions) *RedshiftDestinationUpdate {
	s.RetryOptions = v
	return s
}

// SetRoleARN sets the RoleARN field's value.
func (s *RedshiftDestinationUpdate) SetRoleARN(v string) *RedshiftDestinationUpdate {
	s.RoleARN = &v
	return s
}

// SetS3BackupMode sets the S3BackupMode field's value.
func (s *RedshiftDestinationUpdate) SetS3BackupMode(v string) *RedshiftDestinationUpdate {
	s.S3BackupMode = &v
	return s
}

// SetS3BackupUpdate sets the S3BackupUpdate field's value.
func (s *RedshiftDestinationUpdate) SetS3BackupUpdate(v *S3DestinationUpdate) *RedshiftDestinationUpdate {
	s.S3BackupUpdate = v
	return s
}

// SetS3Update sets the S3Update field's value.
func (s *RedshiftDestinationUpdate) SetS3Update(v *S3DestinationUpdate) *RedshiftDestinationUpdate {
	s.S3Update = v
	return s
}

// SetUsername sets the Username field's value.
func (s *RedshiftDestinationUpdate) SetUsername(v string) *RedshiftDestinationUpdate {
	s.Username = &v
	return s
}

// Configures retry behavior in case Kinesis Firehose is unable to deliver documents
// to Amazon Redshift.
type RedshiftRetryOptions struct {
	_ struct{} `type:"structure"`

	// The length of time during which Kinesis Firehose retries delivery after a
	// failure, starting from the initial request and including the first attempt.
	// The default value is 3600 seconds (60 minutes). Kinesis Firehose does not
	// retry if the value of DurationInSeconds is 0 (zero) or if the first delivery
	// attempt takes longer than the current value.
	DurationInSeconds *int64 `type:"integer"`
}

// String returns the string representation
func (s RedshiftRetryOptions) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s RedshiftRetryOptions) GoString() string {
	return s.String()
}

// SetDurationInSeconds sets the DurationInSeconds field's value.
func (s *RedshiftRetryOptions) SetDurationInSeconds(v int64) *RedshiftRetryOptions {
	s.DurationInSeconds = &v
	return s
}

// Describes the configuration of a destination in Amazon S3.
type S3DestinationConfiguration struct {
	_ struct{} `type:"structure"`

	// The ARN of the S3 bucket.
	//
	// BucketARN is a required field
	BucketARN *string `min:"1" type:"string" required:"true"`

	// The buffering option. If no value is specified, BufferingHints object default
	// values are used.
	BufferingHints *BufferingHints `type:"structure"`

	// The CloudWatch logging options for your delivery stream.
	CloudWatchLoggingOptions *CloudWatchLoggingOptions `type:"structure"`

	// The compression format. If no value is specified, the default is UNCOMPRESSED.
	//
	// The compression formats SNAPPY or ZIP cannot be specified for Amazon Redshift
	// destinations because they are not supported by the Amazon Redshift COPY operation
	// that reads from the S3 bucket.
	CompressionFormat *string `type:"string" enum:"CompressionFormat"`

	// The encryption configuration. If no value is specified, the default is no
	// encryption.
	EncryptionConfiguration *EncryptionConfiguration `type:"structure"`

	// The "YYYY/MM/DD/HH" time format prefix is automatically used for delivered
	// S3 files. You can specify an extra prefix to be added in front of the time
	// format prefix. If the prefix ends with a slash, it appears as a folder in
	// the S3 bucket. For more information, see Amazon S3 Object Name Format (http://docs.aws.amazon.com/firehose/latest/dev/basic-deliver.html)
	// in the Amazon Kinesis Firehose Developer Guide.
	Prefix *string `type:"string"`

	// The ARN of the AWS credentials.
	//
	// RoleARN is a required field
	RoleARN *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s S3DestinationConfiguration) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s S3DestinationConfiguration) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *S3DestinationConfiguration) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "S3DestinationConfiguration"}
	if s.BucketARN == nil {
		invalidParams.Add(request.NewErrParamRequired("BucketARN"))
	}
	if s.BucketARN != nil && len(*s.BucketARN) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("BucketARN", 1))
	}
	if s.RoleARN == nil {
		invalidParams.Add(request.NewErrParamRequired("RoleARN"))
	}
	if s.RoleARN != nil && len(*s.RoleARN) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("RoleARN", 1))
	}
	if s.BufferingHints != nil {
		if err := s.BufferingHints.Validate(); err != nil {
			invalidParams.AddNested("BufferingHints", err.(request.ErrInvalidParams))
		}
	}
	if s.EncryptionConfiguration != nil {
		if err := s.EncryptionConfiguration.Validate(); err != nil {
			invalidParams.AddNested("EncryptionConfiguration", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetBucketARN sets the BucketARN field's value.
func (s *S3DestinationConfiguration) SetBucketARN(v string) *S3DestinationConfiguration {
	s.BucketARN = &v
	return s
}

// SetBufferingHints sets the BufferingHints field's value.
func (s *S3DestinationConfiguration) SetBufferingHints(v *BufferingHints) *S3DestinationConfiguration {
	s.BufferingHints = v
	return s
}

// SetCloudWatchLoggingOptions sets the CloudWatchLoggingOptions field's value.
func (s *S3DestinationConfiguration) SetCloudWatchLoggingOptions(v *CloudWatchLoggingOptions) *S3DestinationConfiguration {
	s.CloudWatchLoggingOptions = v
	return s
}

// SetCompressionFormat sets the CompressionFormat field's value.
func (s *S3DestinationConfiguration) SetCompressionFormat(v string) *S3DestinationConfiguration {
	s.CompressionFormat = &v
	return s
}

// SetEncryptionConfiguration sets the EncryptionConfiguration field's value.
func (s *S3DestinationConfiguration) SetEncryptionConfiguration(v *EncryptionConfiguration) *S3DestinationConfiguration {
	s.EncryptionConfiguration = v
	return s
}

// SetPrefix sets the Prefix field's value.
func (s *S3DestinationConfiguration) SetPrefix(v string) *S3DestinationConfiguration {
	s.Prefix = &v
	return s
}

// SetRoleARN sets the RoleARN field's value.
func (s *S3DestinationConfiguration) SetRoleARN(v string) *S3DestinationConfiguration {
	s.RoleARN = &v
	return s
}

// Describes a destination in Amazon S3.
type S3DestinationDescription struct {
	_ struct{} `type:"structure"`

	// The ARN of the S3 bucket.
	//
	// BucketARN is a required field
	BucketARN *string `min:"1" type:"string" required:"true"`

	// The buffering option. If no value is specified, BufferingHints object default
	// values are used.
	//
	// BufferingHints is a required field
	BufferingHints *BufferingHints `type:"structure" required:"true"`

	// The CloudWatch logging options for your delivery stream.
	CloudWatchLoggingOptions *CloudWatchLoggingOptions `type:"structure"`

	// The compression format. If no value is specified, the default is UNCOMPRESSED.
	//
	// CompressionFormat is a required field
	CompressionFormat *string `type:"string" required:"true" enum:"CompressionFormat"`

	// The encryption configuration. If no value is specified, the default is no
	// encryption.
	//
	// EncryptionConfiguration is a required field
	EncryptionConfiguration *EncryptionConfiguration `type:"structure" required:"true"`

	// The "YYYY/MM/DD/HH" time format prefix is automatically used for delivered
	// S3 files. You can specify an extra prefix to be added in front of the time
	// format prefix. If the prefix ends with a slash, it appears as a folder in
	// the S3 bucket. For more information, see Amazon S3 Object Name Format (http://docs.aws.amazon.com/firehose/latest/dev/basic-deliver.html)
	// in the Amazon Kinesis Firehose Developer Guide.
	Prefix *string `type:"string"`

	// The ARN of the AWS credentials.
	//
	// RoleARN is a required field
	RoleARN *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s S3DestinationDescription) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s S3DestinationDescription) GoString() string {
	return s.String()
}

// SetBucketARN sets the BucketARN field's value.
func (s *S3DestinationDescription) SetBucketARN(v string) *S3DestinationDescription {
	s.BucketARN = &v
	return s
}

// SetBufferingHints sets the BufferingHints field's value.
func (s *S3DestinationDescription) SetBufferingHints(v *BufferingHints) *S3DestinationDescription {
	s.BufferingHints = v
	return s
}

// SetCloudWatchLoggingOptions sets the CloudWatchLoggingOptions field's value.
func (s *S3DestinationDescription) SetCloudWatchLoggingOptions(v *CloudWatchLoggingOptions) *S3DestinationDescription {
	s.CloudWatchLoggingOptions = v
	return s
}

// SetCompressionFormat sets the CompressionFormat field's value.
func (s *S3DestinationDescription) SetCompressionFormat(v string) *S3DestinationDescription {
	s.CompressionFormat = &v
	return s
}

// SetEncryptionConfiguration sets the EncryptionConfiguration field's value.
func (s *S3DestinationDescription) SetEncryptionConfiguration(v *EncryptionConfiguration) *S3DestinationDescription {
	s.EncryptionConfiguration = v
	return s
}

// SetPrefix sets the Prefix field's value.
func (s *S3DestinationDescription) SetPrefix(v string) *S3DestinationDescription {
	s.Prefix = &v
	return s
}

// SetRoleARN sets the RoleARN field's value.
func (s *S3DestinationDescription) SetRoleARN(v string) *S3DestinationDescription {
	s.RoleARN = &v
	return s
}

// Describes an update for a destination in Amazon S3.
type S3DestinationUpdate struct {
	_ struct{} `type:"structure"`

	// The ARN of the S3 bucket.
	BucketARN *string `min:"1" type:"string"`

	// The buffering option. If no value is specified, BufferingHints object default
	// values are used.
	BufferingHints *BufferingHints `type:"structure"`

	// The CloudWatch logging options for your delivery stream.
	CloudWatchLoggingOptions *CloudWatchLoggingOptions `type:"structure"`

	// The compression format. If no value is specified, the default is UNCOMPRESSED.
	//
	// The compression formats SNAPPY or ZIP cannot be specified for Amazon Redshift
	// destinations because they are not supported by the Amazon Redshift COPY operation
	// that reads from the S3 bucket.
	CompressionFormat *string `type:"string" enum:"CompressionFormat"`

	// The encryption configuration. If no value is specified, the default is no
	// encryption.
	EncryptionConfiguration *EncryptionConfiguration `type:"structure"`

	// The "YYYY/MM/DD/HH" time format prefix is automatically used for delivered
	// S3 files. You can specify an extra prefix to be added in front of the time
	// format prefix. If the prefix ends with a slash, it appears as a folder in
	// the S3 bucket. For more information, see Amazon S3 Object Name Format (http://docs.aws.amazon.com/firehose/latest/dev/basic-deliver.html)
	// in the Amazon Kinesis Firehose Developer Guide.
	Prefix *string `type:"string"`

	// The ARN of the AWS credentials.
	RoleARN *string `min:"1" type:"string"`
}

// String returns the string representation
func (s S3DestinationUpdate) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s S3DestinationUpdate) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *S3DestinationUpdate) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "S3DestinationUpdate"}
	if s.BucketARN != nil && len(*s.BucketARN) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("BucketARN", 1))
	}
	if s.RoleARN != nil && len(*s.RoleARN) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("RoleARN", 1))
	}
	if s.BufferingHints != nil {
		if err := s.BufferingHints.Validate(); err != nil {
			invalidParams.AddNested("BufferingHints", err.(request.ErrInvalidParams))
		}
	}
	if s.EncryptionConfiguration != nil {
		if err := s.EncryptionConfiguration.Validate(); err != nil {
			invalidParams.AddNested("EncryptionConfiguration", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetBucketARN sets the BucketARN field's value.
func (s *S3DestinationUpdate) SetBucketARN(v string) *S3DestinationUpdate {
	s.BucketARN = &v
	return s
}

// SetBufferingHints sets the BufferingHints field's value.
func (s *S3DestinationUpdate) SetBufferingHints(v *BufferingHints) *S3DestinationUpdate {
	s.BufferingHints = v
	return s
}

// SetCloudWatchLoggingOptions sets the CloudWatchLoggingOptions field's value.
func (s *S3DestinationUpdate) SetCloudWatchLoggingOptions(v *CloudWatchLoggingOptions) *S3DestinationUpdate {
	s.CloudWatchLoggingOptions = v
	return s
}

// SetCompressionFormat sets the CompressionFormat field's value.
func (s *S3DestinationUpdate) SetCompressionFormat(v string) *S3DestinationUpdate {
	s.CompressionFormat = &v
	return s
}

// SetEncryptionConfiguration sets the EncryptionConfiguration field's value.
func (s *S3DestinationUpdate) SetEncryptionConfiguration(v *EncryptionConfiguration) *S3DestinationUpdate {
	s.EncryptionConfiguration = v
	return s
}

// SetPrefix sets the Prefix field's value.
func (s *S3DestinationUpdate) SetPrefix(v string) *S3DestinationUpdate {
	s.Prefix = &v
	return s
}

// SetRoleARN sets the RoleARN field's value.
func (s *S3DestinationUpdate) SetRoleARN(v string) *S3DestinationUpdate {
	s.RoleARN = &v
	return s
}

// Details about a Kinesis stream used as the source for a Kinesis Firehose
// delivery stream.
type SourceDescription struct {
	_ struct{} `type:"structure"`

	// The KinesisStreamSourceDescription value for the source Kinesis stream.
	KinesisStreamSourceDescription *KinesisStreamSourceDescription `type:"structure"`
}

// String returns the string representation
func (s SourceDescription) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s SourceDescription) GoString() string {
	return s.String()
}

// SetKinesisStreamSourceDescription sets the KinesisStreamSourceDescription field's value.
func (s *SourceDescription) SetKinesisStreamSourceDescription(v *KinesisStreamSourceDescription) *SourceDescription {
	s.KinesisStreamSourceDescription = v
	return s
}

// Describes the configuration of a destination in Splunk.
type SplunkDestinationConfiguration struct {
	_ struct{} `type:"structure"`

	// The CloudWatch logging options for your delivery stream.
	CloudWatchLoggingOptions *CloudWatchLoggingOptions `type:"structure"`

	// The amount of time that Kinesis Firehose waits to receive an acknowledgment
	// from Splunk after it sends it data. At the end of the timeout period Kinesis
	// Firehose either tries to send the data again or considers it an error, based
	// on your retry settings.
	HECAcknowledgmentTimeoutInSeconds *int64 `min:"180" type:"integer"`

	// The HTTP Event Collector (HEC) endpoint to which Kinesis Firehose sends your
	// data.
	//
	// HECEndpoint is a required field
	HECEndpoint *string `type:"string" required:"true"`

	// This type can be either "Raw" or "Event".
	//
	// HECEndpointType is a required field
	HECEndpointType *string `type:"string" required:"true" enum:"HECEndpointType"`

	// This is a GUID you obtain from your Splunk cluster when you create a new
	// HEC endpoint.
	//
	// HECToken is a required field
	HECToken *string `type:"string" required:"true"`

	// The data processing configuration.
	ProcessingConfiguration *ProcessingConfiguration `type:"structure"`

	// The retry behavior in case Kinesis Firehose is unable to deliver data to
	// Splunk or if it doesn't receive an acknowledgment of receipt from Splunk.
	RetryOptions *SplunkRetryOptions `type:"structure"`

	// Defines how documents should be delivered to Amazon S3. When set to FailedDocumentsOnly,
	// Kinesis Firehose writes any data that could not be indexed to the configured
	// Amazon S3 destination. When set to AllDocuments, Kinesis Firehose delivers
	// all incoming records to Amazon S3, and also writes failed documents to Amazon
	// S3. Default value is FailedDocumentsOnly.
	S3BackupMode *string `type:"string" enum:"SplunkS3BackupMode"`

	// The configuration for the backup Amazon S3 location.
	//
	// S3Configuration is a required field
	S3Configuration *S3DestinationConfiguration `type:"structure" required:"true"`
}

// String returns the string representation
func (s SplunkDestinationConfiguration) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s SplunkDestinationConfiguration) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *SplunkDestinationConfiguration) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "SplunkDestinationConfiguration"}
	if s.HECAcknowledgmentTimeoutInSeconds != nil && *s.HECAcknowledgmentTimeoutInSeconds < 180 {
		invalidParams.Add(request.NewErrParamMinValue("HECAcknowledgmentTimeoutInSeconds", 180))
	}
	if s.HECEndpoint == nil {
		invalidParams.Add(request.NewErrParamRequired("HECEndpoint"))
	}
	if s.HECEndpointType == nil {
		invalidParams.Add(request.NewErrParamRequired("HECEndpointType"))
	}
	if s.HECToken == nil {
		invalidParams.Add(request.NewErrParamRequired("HECToken"))
	}
	if s.S3Configuration == nil {
		invalidParams.Add(request.NewErrParamRequired("S3Configuration"))
	}
	if s.ProcessingConfiguration != nil {
		if err := s.ProcessingConfiguration.Validate(); err != nil {
			invalidParams.AddNested("ProcessingConfiguration", err.(request.ErrInvalidParams))
		}
	}
	if s.S3Configuration != nil {
		if err := s.S3Configuration.Validate(); err != nil {
			invalidParams.AddNested("S3Configuration", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetCloudWatchLoggingOptions sets the CloudWatchLoggingOptions field's value.
func (s *SplunkDestinationConfiguration) SetCloudWatchLoggingOptions(v *CloudWatchLoggingOptions) *SplunkDestinationConfiguration {
	s.CloudWatchLoggingOptions = v
	return s
}

// SetHECAcknowledgmentTimeoutInSeconds sets the HECAcknowledgmentTimeoutInSeconds field's value.
func (s *SplunkDestinationConfiguration) SetHECAcknowledgmentTimeoutInSeconds(v int64) *SplunkDestinationConfiguration {
	s.HECAcknowledgmentTimeoutInSeconds = &v
	return s
}

// SetHECEndpoint sets the HECEndpoint field's value.
func (s *SplunkDestinationConfiguration) SetHECEndpoint(v string) *SplunkDestinationConfiguration {
	s.HECEndpoint = &v
	return s
}

// SetHECEndpointType sets the HECEndpointType field's value.
func (s *SplunkDestinationConfiguration) SetHECEndpointType(v string) *SplunkDestinationConfiguration {
	s.HECEndpointType = &v
	return s
}

// SetHECToken sets the HECToken field's value.
func (s *SplunkDestinationConfiguration) SetHECToken(v string) *SplunkDestinationConfiguration {
	s.HECToken = &v
	return s
}

// SetProcessingConfiguration sets the ProcessingConfiguration field's value.
func (s *SplunkDestinationConfiguration) SetProcessingConfiguration(v *ProcessingConfiguration) *SplunkDestinationConfiguration {
	s.ProcessingConfiguration = v
	return s
}

// SetRetryOptions sets the RetryOptions field's value.
func (s *SplunkDestinationConfiguration) SetRetryOptions(v *SplunkRetryOptions) *SplunkDestinationConfiguration {
	s.RetryOptions = v
	return s
}

// SetS3BackupMode sets the S3BackupMode field's value.
func (s *SplunkDestinationConfiguration) SetS3BackupMode(v string) *SplunkDestinationConfiguration {
	s.S3BackupMode = &v
	return s
}

// SetS3Configuration sets the S3Configuration field's value.
func (s *SplunkDestinationConfiguration) SetS3Configuration(v *S3DestinationConfiguration) *SplunkDestinationConfiguration {
	s.S3Configuration = v
	return s
}

// Describes a destination in Splunk.
type SplunkDestinationDescription struct {
	_ struct{} `type:"structure"`

	// The CloudWatch logging options for your delivery stream.
	CloudWatchLoggingOptions *CloudWatchLoggingOptions `type:"structure"`

	// The amount of time that Kinesis Firehose waits to receive an acknowledgment
	// from Splunk after it sends it data. At the end of the timeout period Kinesis
	// Firehose either tries to send the data again or considers it an error, based
	// on your retry settings.
	HECAcknowledgmentTimeoutInSeconds *int64 `min:"180" type:"integer"`

	// The HTTP Event Collector (HEC) endpoint to which Kinesis Firehose sends your
	// data.
	HECEndpoint *string `type:"string"`

	// This type can be either "Raw" or "Event".
	HECEndpointType *string `type:"string" enum:"HECEndpointType"`

	// This is a GUID you obtain from your Splunk cluster when you create a new
	// HEC endpoint.
	HECToken *string `type:"string"`

	// The data processing configuration.
	ProcessingConfiguration *ProcessingConfiguration `type:"structure"`

	// The retry behavior in case Kinesis Firehose is unable to deliver data to
	// Splunk or if it doesn't receive an acknowledgment of receipt from Splunk.
	RetryOptions *SplunkRetryOptions `type:"structure"`

	// Defines how documents should be delivered to Amazon S3. When set to FailedDocumentsOnly,
	// Kinesis Firehose writes any data that could not be indexed to the configured
	// Amazon S3 destination. When set to AllDocuments, Kinesis Firehose delivers
	// all incoming records to Amazon S3, and also writes failed documents to Amazon
	// S3. Default value is FailedDocumentsOnly.
	S3BackupMode *string `type:"string" enum:"SplunkS3BackupMode"`

	// The Amazon S3 destination.>
	S3DestinationDescription *S3DestinationDescription `type:"structure"`
}

// String returns the string representation
func (s SplunkDestinationDescription) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s SplunkDestinationDescription) GoString() string {
	return s.String()
}

// SetCloudWatchLoggingOptions sets the CloudWatchLoggingOptions field's value.
func (s *SplunkDestinationDescription) SetCloudWatchLoggingOptions(v *CloudWatchLoggingOptions) *SplunkDestinationDescription {
	s.CloudWatchLoggingOptions = v
	return s
}

// SetHECAcknowledgmentTimeoutInSeconds sets the HECAcknowledgmentTimeoutInSeconds field's value.
func (s *SplunkDestinationDescription) SetHECAcknowledgmentTimeoutInSeconds(v int64) *SplunkDestinationDescription {
	s.HECAcknowledgmentTimeoutInSeconds = &v
	return s
}

// SetHECEndpoint sets the HECEndpoint field's value.
func (s *SplunkDestinationDescription) SetHECEndpoint(v string) *SplunkDestinationDescription {
	s.HECEndpoint = &v
	return s
}

// SetHECEndpointType sets the HECEndpointType field's value.
func (s *SplunkDestinationDescription) SetHECEndpointType(v string) *SplunkDestinationDescription {
	s.HECEndpointType = &v
	return s
}

// SetHECToken sets the HECToken field's value.
func (s *SplunkDestinationDescription) SetHECToken(v string) *SplunkDestinationDescription {
	s.HECToken = &v
	return s
}

// SetProcessingConfiguration sets the ProcessingConfiguration field's value.
func (s *SplunkDestinationDescription) SetProcessingConfiguration(v *ProcessingConfiguration) *SplunkDestinationDescription {
	s.ProcessingConfiguration = v
	return s
}

// SetRetryOptions sets the RetryOptions field's value.
func (s *SplunkDestinationDescription) SetRetryOptions(v *SplunkRetryOptions) *SplunkDestinationDescription {
	s.RetryOptions = v
	return s
}

// SetS3BackupMode sets the S3BackupMode field's value.
func (s *SplunkDestinationDescription) SetS3BackupMode(v string) *SplunkDestinationDescription {
	s.S3BackupMode = &v
	return s
}

// SetS3DestinationDescription sets the S3DestinationDescription field's value.
func (s *SplunkDestinationDescription) SetS3DestinationDescription(v *S3DestinationDescription) *SplunkDestinationDescription {
	s.S3DestinationDescription = v
	return s
}

// Describes an update for a destination in Splunk.
type SplunkDestinationUpdate struct {
	_ struct{} `type:"structure"`

	// The CloudWatch logging options for your delivery stream.
	CloudWatchLoggingOptions *CloudWatchLoggingOptions `type:"structure"`

	// The amount of time that Kinesis Firehose waits to receive an acknowledgment
	// from Splunk after it sends it data. At the end of the timeout period Kinesis
	// Firehose either tries to send the data again or considers it an error, based
	// on your retry settings.
	HECAcknowledgmentTimeoutInSeconds *int64 `min:"180" type:"integer"`

	// The HTTP Event Collector (HEC) endpoint to which Kinesis Firehose sends your
	// data.
	HECEndpoint *string `type:"string"`

	// This type can be either "Raw" or "Event".
	HECEndpointType *string `type:"string" enum:"HECEndpointType"`

	// This is a GUID you obtain from your Splunk cluster when you create a new
	// HEC endpoint.
	HECToken *string `type:"string"`

	// The data processing configuration.
	ProcessingConfiguration *ProcessingConfiguration `type:"structure"`

	// The retry behavior in case Kinesis Firehose is unable to deliver data to
	// Splunk or if it doesn't receive an acknowledgment of receipt from Splunk.
	RetryOptions *SplunkRetryOptions `type:"structure"`

	// Defines how documents should be delivered to Amazon S3. When set to FailedDocumentsOnly,
	// Kinesis Firehose writes any data that could not be indexed to the configured
	// Amazon S3 destination. When set to AllDocuments, Kinesis Firehose delivers
	// all incoming records to Amazon S3, and also writes failed documents to Amazon
	// S3. Default value is FailedDocumentsOnly.
	S3BackupMode *string `type:"string" enum:"SplunkS3BackupMode"`

	// Your update to the configuration of the backup Amazon S3 location.
	S3Update *S3DestinationUpdate `type:"structure"`
}

// String returns the string representation
func (s SplunkDestinationUpdate) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s SplunkDestinationUpdate) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *SplunkDestinationUpdate) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "SplunkDestinationUpdate"}
	if s.HECAcknowledgmentTimeoutInSeconds != nil && *s.HECAcknowledgmentTimeoutInSeconds < 180 {
		invalidParams.Add(request.NewErrParamMinValue("HECAcknowledgmentTimeoutInSeconds", 180))
	}
	if s.ProcessingConfiguration != nil {
		if err := s.ProcessingConfiguration.Validate(); err != nil {
			invalidParams.AddNested("ProcessingConfiguration", err.(request.ErrInvalidParams))
		}
	}
	if s.S3Update != nil {
		if err := s.S3Update.Validate(); err != nil {
			invalidParams.AddNested("S3Update", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetCloudWatchLoggingOptions sets the CloudWatchLoggingOptions field's value.
func (s *SplunkDestinationUpdate) SetCloudWatchLoggingOptions(v *CloudWatchLoggingOptions) *SplunkDestinationUpdate {
	s.CloudWatchLoggingOptions = v
	return s
}

// SetHECAcknowledgmentTimeoutInSeconds sets the HECAcknowledgmentTimeoutInSeconds field's value.
func (s *SplunkDestinationUpdate) SetHECAcknowledgmentTimeoutInSeconds(v int64) *SplunkDestinationUpdate {
	s.HECAcknowledgmentTimeoutInSeconds = &v
	return s
}

// SetHECEndpoint sets the HECEndpoint field's value.
func (s *SplunkDestinationUpdate) SetHECEndpoint(v string) *SplunkDestinationUpdate {
	s.HECEndpoint = &v
	return s
}

// SetHECEndpointType sets the HECEndpointType field's value.
func (s *SplunkDestinationUpdate) SetHECEndpointType(v string) *SplunkDestinationUpdate {
	s.HECEndpointType = &v
	return s
}

// SetHECToken sets the HECToken field's value.
func (s *SplunkDestinationUpdate) SetHECToken(v string) *SplunkDestinationUpdate {
	s.HECToken = &v
	return s
}

// SetProcessingConfiguration sets the ProcessingConfiguration field's value.
func (s *SplunkDestinationUpdate) SetProcessingConfiguration(v *ProcessingConfiguration) *SplunkDestinationUpdate {
	s.ProcessingConfiguration = v
	return s
}

// SetRetryOptions sets the RetryOptions field's value.
func (s *SplunkDestinationUpdate) SetRetryOptions(v *SplunkRetryOptions) *SplunkDestinationUpdate {
	s.RetryOptions = v
	return s
}

// SetS3BackupMode sets the S3BackupMode field's value.
func (s *SplunkDestinationUpdate) SetS3BackupMode(v string) *SplunkDestinationUpdate {
	s.S3BackupMode = &v
	return s
}

// SetS3Update sets the S3Update field's value.
func (s *SplunkDestinationUpdate) SetS3Update(v *S3DestinationUpdate) *SplunkDestinationUpdate {
	s.S3Update = v
	return s
}

// Configures retry behavior in case Kinesis Firehose is unable to deliver documents
// to Splunk or if it doesn't receive an acknowledgment from Splunk.
type SplunkRetryOptions struct {
	_ struct{} `type:"structure"`

	// The total amount of time that Kinesis Firehose spends on retries. This duration
	// starts after the initial attempt to send data to Splunk fails and doesn't
	// include the periods during which Kinesis Firehose waits for acknowledgment
	// from Splunk after each attempt.
	DurationInSeconds *int64 `type:"integer"`
}

// String returns the string representation
func (s SplunkRetryOptions) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s SplunkRetryOptions) GoString() string {
	return s.String()
}

// SetDurationInSeconds sets the DurationInSeconds field's value.
func (s *SplunkRetryOptions) SetDurationInSeconds(v int64) *SplunkRetryOptions {
	s.DurationInSeconds = &v
	return s
}

type UpdateDestinationInput struct {
	_ struct{} `type:"structure"`

	// Obtain this value from the VersionId result of DeliveryStreamDescription.
	// This value is required, and helps the service to perform conditional operations.
	// For example, if there is an interleaving update and this value is null, then
	// the update destination fails. After the update is successful, the VersionId
	// value is updated. The service then performs a merge of the old configuration
	// with the new configuration.
	//
	// CurrentDeliveryStreamVersionId is a required field
	CurrentDeliveryStreamVersionId *string `min:"1" type:"string" required:"true"`

	// The name of the delivery stream.
	//
	// DeliveryStreamName is a required field
	DeliveryStreamName *string `min:"1" type:"string" required:"true"`

	// The ID of the destination.
	//
	// DestinationId is a required field
	DestinationId *string `min:"1" type:"string" required:"true"`

	// Describes an update for a destination in Amazon ES.
	ElasticsearchDestinationUpdate *ElasticsearchDestinationUpdate `type:"structure"`

	// Describes an update for a destination in Amazon S3.
	ExtendedS3DestinationUpdate *ExtendedS3DestinationUpdate `type:"structure"`

	// Describes an update for a destination in Amazon Redshift.
	RedshiftDestinationUpdate *RedshiftDestinationUpdate `type:"structure"`

	// [Deprecated] Describes an update for a destination in Amazon S3.
	S3DestinationUpdate *S3DestinationUpdate `deprecated:"true" type:"structure"`

	// Describes an update for a destination in Splunk.
	SplunkDestinationUpdate *SplunkDestinationUpdate `type:"structure"`
}

// String returns the string representation
func (s UpdateDestinationInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s UpdateDestinationInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *UpdateDestinationInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "UpdateDestinationInput"}
	if s.CurrentDeliveryStreamVersionId == nil {
		invalidParams.Add(request.NewErrParamRequired("CurrentDeliveryStreamVersionId"))
	}
	if s.CurrentDeliveryStreamVersionId != nil && len(*s.CurrentDeliveryStreamVersionId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("CurrentDeliveryStreamVersionId", 1))
	}
	if s.DeliveryStreamName == nil {
		invalidParams.Add(request.NewErrParamRequired("DeliveryStreamName"))
	}
	if s.DeliveryStreamName != nil && len(*s.DeliveryStreamName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("DeliveryStreamName", 1))
	}
	if s.DestinationId == nil {
		invalidParams.Add(request.NewErrParamRequired("DestinationId"))
	}
	if s.DestinationId != nil && len(*s.DestinationId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("DestinationId", 1))
	}
	if s.ElasticsearchDestinationUpdate != nil {
		if err := s.ElasticsearchDestinationUpdate.Validate(); err != nil {
			invalidParams.AddNested("ElasticsearchDestinationUpdate", err.(request.ErrInvalidParams))
		}
	}
	if s.ExtendedS3DestinationUpdate != nil {
		if err := s.ExtendedS3DestinationUpdate.Validate(); err != nil {
			invalidParams.AddNested("ExtendedS3DestinationUpdate", err.(request.ErrInvalidParams))
		}
	}
	if s.RedshiftDestinationUpdate != nil {
		if err := s.RedshiftDestinationUpdate.Validate(); err != nil {
			invalidParams.AddNested("RedshiftDestinationUpdate", err.(request.ErrInvalidParams))
		}
	}
	if s.S3DestinationUpdate != nil {
		if err := s.S3DestinationUpdate.Validate(); err != nil {
			invalidParams.AddNested("S3DestinationUpdate", err.(request.ErrInvalidParams))
		}
	}
	if s.SplunkDestinationUpdate != nil {
		if err := s.SplunkDestinationUpdate.Validate(); err != nil {
			invalidParams.AddNested("SplunkDestinationUpdate", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetCurrentDeliveryStreamVersionId sets the CurrentDeliveryStreamVersionId field's value.
func (s *UpdateDestinationInput) SetCurrentDeliveryStreamVersionId(v string) *UpdateDestinationInput {
	s.CurrentDeliveryStreamVersionId = &v
	return s
}

// SetDeliveryStreamName sets the DeliveryStreamName field's value.
func (s *UpdateDestinationInput) SetDeliveryStreamName(v string) *UpdateDestinationInput {
	s.DeliveryStreamName = &v
	return s
}

// SetDestinationId sets the DestinationId field's value.
func (s *UpdateDestinationInput) SetDestinationId(v string) *UpdateDestinationInput {
	s.DestinationId = &v
	return s
}

// SetElasticsearchDestinationUpdate sets the ElasticsearchDestinationUpdate field's value.
func (s *UpdateDestinationInput) SetElasticsearchDestinationUpdate(v *ElasticsearchDestinationUpdate) *UpdateDestinationInput {
	s.ElasticsearchDestinationUpdate = v
	return s
}

// SetExtendedS3DestinationUpdate sets the ExtendedS3DestinationUpdate field's value.
func (s *UpdateDestinationInput) SetExtendedS3DestinationUpdate(v *ExtendedS3DestinationUpdate) *UpdateDestinationInput {
	s.ExtendedS3DestinationUpdate = v
	return s
}

// SetRedshiftDestinationUpdate sets the RedshiftDestinationUpdate field's value.
func (s *UpdateDestinationInput) SetRedshiftDestinationUpdate(v *RedshiftDestinationUpdate) *UpdateDestinationInput {
	s.RedshiftDestinationUpdate = v
	return s
}

// SetS3DestinationUpdate sets the S3DestinationUpdate field's value.
func (s *UpdateDestinationInput) SetS3DestinationUpdate(v *S3DestinationUpdate) *UpdateDestinationInput {
	s.S3DestinationUpdate = v
	return s
}

// SetSplunkDestinationUpdate sets the SplunkDestinationUpdate field's value.
func (s *UpdateDestinationInput) SetSplunkDestinationUpdate(v *SplunkDestinationUpdate) *UpdateDestinationInput {
	s.SplunkDestinationUpdate = v
	return s
}

type UpdateDestinationOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s UpdateDestinationOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s UpdateDestinationOutput) GoString() string {
	return s.String()
}

const (
	// CompressionFormatUncompressed is a CompressionFormat enum value
	CompressionFormatUncompressed = "UNCOMPRESSED"

	// CompressionFormatGzip is a CompressionFormat enum value
	CompressionFormatGzip = "GZIP"

	// CompressionFormatZip is a CompressionFormat enum value
	CompressionFormatZip = "ZIP"

	// CompressionFormatSnappy is a CompressionFormat enum value
	CompressionFormatSnappy = "Snappy"
)

const (
	// DeliveryStreamStatusCreating is a DeliveryStreamStatus enum value
	DeliveryStreamStatusCreating = "CREATING"

	// DeliveryStreamStatusDeleting is a DeliveryStreamStatus enum value
	DeliveryStreamStatusDeleting = "DELETING"

	// DeliveryStreamStatusActive is a DeliveryStreamStatus enum value
	DeliveryStreamStatusActive = "ACTIVE"
)

const (
	// DeliveryStreamTypeDirectPut is a DeliveryStreamType enum value
	DeliveryStreamTypeDirectPut = "DirectPut"

	// DeliveryStreamTypeKinesisStreamAsSource is a DeliveryStreamType enum value
	DeliveryStreamTypeKinesisStreamAsSource = "KinesisStreamAsSource"
)

const (
	// ElasticsearchIndexRotationPeriodNoRotation is a ElasticsearchIndexRotationPeriod enum value
	ElasticsearchIndexRotationPeriodNoRotation = "NoRotation"

	// ElasticsearchIndexRotationPeriodOneHour is a ElasticsearchIndexRotationPeriod enum value
	ElasticsearchIndexRotationPeriodOneHour = "OneHour"

	// ElasticsearchIndexRotationPeriodOneDay is a ElasticsearchIndexRotationPeriod enum value
	ElasticsearchIndexRotationPeriodOneDay = "OneDay"

	// ElasticsearchIndexRotationPeriodOneWeek is a ElasticsearchIndexRotationPeriod enum value
	ElasticsearchIndexRotationPeriodOneWeek = "OneWeek"

	// ElasticsearchIndexRotationPeriodOneMonth is a ElasticsearchIndexRotationPeriod enum value
	ElasticsearchIndexRotationPeriodOneMonth = "OneMonth"
)

const (
	// ElasticsearchS3BackupModeFailedDocumentsOnly is a ElasticsearchS3BackupMode enum value
	ElasticsearchS3BackupModeFailedDocumentsOnly = "FailedDocumentsOnly"

	// ElasticsearchS3BackupModeAllDocuments is a ElasticsearchS3BackupMode enum value
	ElasticsearchS3BackupModeAllDocuments = "AllDocuments"
)

const (
	// HECEndpointTypeRaw is a HECEndpointType enum value
	HECEndpointTypeRaw = "Raw"

	// HECEndpointTypeEvent is a HECEndpointType enum value
	HECEndpointTypeEvent = "Event"
)

const (
	// NoEncryptionConfigNoEncryption is a NoEncryptionConfig enum value
	NoEncryptionConfigNoEncryption = "NoEncryption"
)

const (
	// ProcessorParameterNameLambdaArn is a ProcessorParameterName enum value
	ProcessorParameterNameLambdaArn = "LambdaArn"

	// ProcessorParameterNameNumberOfRetries is a ProcessorParameterName enum value
	ProcessorParameterNameNumberOfRetries = "NumberOfRetries"

	// ProcessorParameterNameRoleArn is a ProcessorParameterName enum value
	ProcessorParameterNameRoleArn = "RoleArn"

	// ProcessorParameterNameBufferSizeInMbs is a ProcessorParameterName enum value
	ProcessorParameterNameBufferSizeInMbs = "BufferSizeInMBs"

	// ProcessorParameterNameBufferIntervalInSeconds is a ProcessorParameterName enum value
	ProcessorParameterNameBufferIntervalInSeconds = "BufferIntervalInSeconds"
)

const (
	// ProcessorTypeLambda is a ProcessorType enum value
	ProcessorTypeLambda = "Lambda"
)

const (
	// RedshiftS3BackupModeDisabled is a RedshiftS3BackupMode enum value
	RedshiftS3BackupModeDisabled = "Disabled"

	// RedshiftS3BackupModeEnabled is a RedshiftS3BackupMode enum value
	RedshiftS3BackupModeEnabled = "Enabled"
)

const (
	// S3BackupModeDisabled is a S3BackupMode enum value
	S3BackupModeDisabled = "Disabled"

	// S3BackupModeEnabled is a S3BackupMode enum value
	S3BackupModeEnabled = "Enabled"
)

const (
	// SplunkS3BackupModeFailedEventsOnly is a SplunkS3BackupMode enum value
	SplunkS3BackupModeFailedEventsOnly = "FailedEventsOnly"

	// SplunkS3BackupModeAllEvents is a SplunkS3BackupMode enum value
	SplunkS3BackupModeAllEvents = "AllEvents"
)
