Twitch Stats
============

TwitchStats is a helper function for sending data to mixpanel.

```go
var stats *twitchstats.Stats

func init() {
	stats = &twitchstats.Stats{MixPanelToken: mpToken}
	// Store info that will be true for all events:
	stats.Add("buildsystem", "foo")
	stats.Add("buildEnviron", environment)
	stats.Add("skadiCommit", gitCommit)
}

func foo() {
	// Create a new event:
	event := stats.NewEvent()
	// Start the timer and everything else:
	event.Start()
	// Signel that the event is done and to send when finished with this function:
	defer event.Finish()

	// Store some info to send to mixpanel that is specific to the event:
	event.Add("dayofweek", 1)
	
	// Timers for sub tasks:
	event.StartSub("sub_task_timer")
	do_sub_task()
	event.FinishSub("sub_task_timer")

	// Do actual work...
}
```
