# vanity

Vanity is a small web service that has two goals:

1. Provide homepages for codebases.
2. Make `go get` work.

You can see it at [code.justin.tv](code.justin.tv/release/vanity).

## Terraform

Vanity's hardware is configured via terraform. You can find the configuration
in the [release/terraform/ under the production
folder](https://git.xarth.tv/release/terraform/blob/master/production/vanity.tf).

The configuration is fairly simple. One EC2 instance behind an ELB.

## Deploys

Vanity is deployed via [deploy](https://deploy.xarth.tv/#/release/vanity).


# Vanity, Go and Github

When doing a `go get` go will attempt to fetch the download with a URL
parameter of `?go-get=1`. In recent versions of Go this request will be done
under HTTPS.

When `go get` does this request it will look for a meta tag. This meta tag
will tell go where to fetch the code:

```
$ curl -q -s code.justin.tv/release/skadi?go-get=1 | grep go-import
<meta name="go-import" content="code.justin.tv/release/skadi git git+ssh://git@git.xarth.tv/release/skadi">
```

This URL tells Go what the name of the repo is, in case you are requesting a
subpackage, and it will return the git, svn, or mercurial URL to fetch the repo at.

This allows us to have working `go get` urls for git despite the fact that
github doesn't cleanly implement `go get` support. In addition we get nice
urls for our repos.
