#!/usr/bin/env bash

MAX_TIME=20
SVSTAT=$(sudo /usr/bin/svstat /etc/service/vanity )
echo $SVSTAT
if [[ "$(echo "$SVSTAT" | grep ': up (pid [0-9]*) ' | wc -l)" -gt 0 ]]; then
  up="$(svstat /etc/service/vanity/ | sed -n 's/.*pid.*[^)]) \([0-9]\+\).*/\1/p')"
  if [[ "${up}" -gt $MAX_TIME ]]; then
    echo "Failing deployment due to process run time after deployment greater then ${MAX_TIME}"
    exit 1
  fi
else
  echo "Service appears to be down"
  exit 1
fi
exit 0
