// bump

job {
	name 'release-vanity'
	using 'TEMPLATE-autobuild'
	scm {
		git {
			remote {
				github 'release/vanity', 'ssh', 'git.xarth.tv'
				credentials 'git-aws-read-key'
			}
		}
	}
	steps {
		shell 'rm -rf .manta/'
		shell 'manta -v -proxy'
		saveDeployArtifact 'release/vanity', '.manta'
		saveChasquiArtifact 'vanity', '.manta', 'deployments-vanity', '673385534282'
	}
}

job {
	name 'release-vanity-deploy'
	using 'TEMPLATE-deploy'
	steps {
			shell 'update-deployed-version -repo release/vanity'
			shell 'courier deploy --repo release/vanity --dir /opt/twitch/vanity'
			shell 'update-deployed-version -repo release/vanity -known-good'
	}
}

job {
	name 'release-vanity-deploy-chasqui'
	using 'TEMPLATE-deploy-chasqui'
	steps {
			deployChasquiArtifact 'vanity', '\$ENVIRONMENT', 'deployments-vanity'
	}
}
