package main

import (
	"flag"
	"fmt"
	"html/template"
	"log"
	"net"
	"net/http"
	"net/url"
	"os"
	"path"
	"strconv"

	"github.com/gorilla/handlers"
)

var (
	templates = template.Must(template.ParseGlob("templates/*"))
	siteName  string
	gitHost   string
)

func main() {
	bindIP := "0.0.0.0"
	bindPort := 80

	// Support automatic reload via GIN:
	if portENV := os.Getenv("PORT"); portENV != "" {
		var err error
		bindPort, err = strconv.Atoi(os.Getenv("PORT"))
		if err != nil {
			log.Printf("Failed to load PORT env %q: %v", portENV, err)
		}
	}

	grafanaURL := &url.URL{
		Scheme: "http",
		Host:   "grafana.xarth.tv",
	}

	flag.StringVar(&grafanaURL.Host, "grafana", grafanaURL.Host,
		"Hostname of grafana instance to receive proxied chart requests")
	flag.StringVar(&siteName, "site", "twcode.io", "Site name")
	flag.StringVar(&bindIP, "ip", bindIP, "IP to bind to")
	flag.StringVar(&gitHost, "git", "git.xarth.tv", "git hostname to use")
	flag.IntVar(&bindPort, "port", bindPort, "Port to bind to")
	flag.Parse()

	bind := net.JoinHostPort(bindIP, strconv.Itoa(bindPort))
	log.Printf("Listening on %q...", bind)
	log.Fatal(
		http.ListenAndServe(bind, handlers.LoggingHandler(os.Stdout, Handlers(grafanaURL))),
	)
}

func repoURL(owner, repo string) string {
	return fmt.Sprintf("git+ssh://git@%s/%s/%s", gitHost, owner, repo)
}

func importName(owner, repo string) string {
	return path.Join(siteName, owner, repo)
}
