return function (callback) {
  services.datasourceSrv.get("Graphite").then(function (datasource) {
    return datasource.metricFindQuery("stats.*.trace.data.v1." + ARGS.service + "*");
  }).then(function (metrics) {
    var dashboard = {
      title: ARGS.service,
      from: "now-6h",
      to: "now",
      editable: false,
      rows: []
    };

    _.each(metrics, function (metric) {
      dashboard.rows.push(makeRow(metric.text));
    });

    return dashboard;
  }).then(callback);
}


function makeRow(service) {
  return {
    height: "450px",
    collapse: false,
    panels: [{
      "title": service.substr(15).replace(/-/g,"/") + " Status Codes",
      "type": "graph",
      "span": 6,
      "renderer": "flot",
      "x-axis": true,
      "y-axis": true,
      "y_formats": ["short"],
      "grid": {
        "leftLogBase": 1,
        "leftMax": null,
        "leftMin": 0
      },
      "lines": true,
      "fill": 0,
      "linewidth": 1,
      "points": false,
      "pointradius": 5,
      "bars": false,
      "stack": false,
      "percentage": false,
      "legend": {
        "show": true,
        "values": false,
        "min": false,
        "max": false,
        "current": false,
        "total": false,
        "avg": false,
        "rightSide": false,
        "hideEmpty": true,
        "alignAsTable": false
      },
      "nullPointMode": "null as zero",
      "steppedLine": false,
      "tooltip": {
        "value_type": "cumulative",
        "shared": true
      },
      "timeFrom": null,
      "timeShift": null,
      "targets": [{
        "target": "aliasSub(sumSeriesWithWildcards(sumSeriesWithWildcards(stats.counters.trace.data.v1." + service + ".*.*.*.*.rate, 6), 6), '.*?([^.]*\\.[^.]*)\\.rate', '\\1')"
      }],
      "aliasColors": {},
      "seriesOverrides": [],
      "links": []
    }, {
      "title": service.substr(15).replace(/-/g,"/") + " Timings",
      "type": "graph",
      "span": 6,
      "renderer": "flot",
      "x-axis": true,
      "y-axis": true,
      "y_formats": ["ms"],
      "grid": {
        "leftLogBase": 1,
        "leftMax": null,
        "leftMin": 0
      },
      "lines": true,
      "fill": 0,
      "linewidth": 1,
      "points": false,
      "pointradius": 5,
      "bars": false,
      "stack": false,
      "percentage": false,
      "legend": {
        "show": true,
        "values": false,
        "min": false,
        "max": false,
        "current": false,
        "total": false,
        "avg": false,
        "rightSide": false,
        "hideEmpty": true,
        "alignAsTable": false
      },
      "nullPointMode": "null as zero",
      "steppedLine": false,
      "tooltip": {
        "value_type": "cumulative",
        "shared": true
      },
      "timeFrom": null,
      "timeShift": null,
      "targets": [{
        "target": "aliasSub(stats.timers.trace.data.v1." + service + ".*.*.*.duration.upper_99, '.*?([^.]*\\.[^.]*)\\.upper_99', '\\1')"
      }],
      "aliasColors": {},
      "seriesOverrides": [],
      "links": []
    }]
  };
};
