package main

import (
	"log"
	"os/exec"
)

const (
	defaultBarrelServiceDir = "/etc/service/barrel"
)

func main() {
	// Send SIGINT to the old barrel process.  We use sudo here because
	// although we don't run as root, we are allowed to run whatever command
	// we like as root.
	cmd := exec.Command("sudo", "svc", "-i", "--", defaultBarrelServiceDir)

	buf, err := cmd.CombinedOutput()
	if err != nil {
		log.Fatalf("err=%q output=%q", err, buf)
		return
	}
	log.Printf("restarted output=%q", buf)
}
