job {
	name 'release-villagers'
	using 'TEMPLATE-autobuild'
	scm {
		git {
			remote {
				github 'release/villagers', 'ssh', 'git-aws.internal.justin.tv'
				credentials 'git-aws-read-key'
			}
			clean true
		}
	}
	steps {
		shell 'rm -rf .manta/'
		shell 'manta -v -f mantafiles/.manta.build.json'
		shell 'docker build --build-arg SERVER_BIN=.manta/bin/barrel -t docker-registry.internal.justin.tv/release/villagers:$GIT_COMMIT -t docker-registry.internal.justin.tv/release/villagers:latest .'
		shell 'docker push docker-registry.internal.justin.tv/release/villagers:$GIT_COMMIT'
		shell 'docker push docker-registry.internal.justin.tv/release/villagers:latest'
		saveDeployArtifact 'release/villagers', '.manta'
		saveDirtyDeployArtifact 'release/villagers', '.manta'
		saveDeployArtifact 'release/villagers/all', '.'
	}
}

job {
	name 'release-villagers-deploy'
	using 'TEMPLATE-deploy'
	steps {
		shell '''
convert_host() {
	local host="$1"
	if [ -z "$(dig +short ${host} 2>/dev/null)" ]; then
		local consulname="$(echo "${host}" | sed -n -e "s/^\\(.*\\)\\.\\([^\\.]*\\)\\.justin\\.tv$/\\1/p")"
		local consuldc="$(echo "${host}" | sed -n -e "s/^\\(.*\\)\\.\\([^\\.]*\\)\\.justin\\.tv$/\\2/p")"
		host="$(curl -o - -s "http://consul.internal.justin.tv/v1/catalog/node/${consulname}?dc=${consuldc}" \
			| python -mjson.tool \
			| grep '"Address":' \
			| grep -o '[0-9\.]\+' \
			| sed 1q)"
	fi
	echo "${host}"
}

convert_list() {
    local list="$1"
    local hosts=""
    for host in $(echo "${list}" | tr "," " "); do
        hosts="${hosts:+$hosts,}$(convert_host ${host})"
    done
    echo "${hosts}"
}

export HOSTS="$(convert_list ${HOSTS})"
export HOSTS2="$(convert_list ${HOSTS2})"
export HOSTS3="$(convert_list ${HOSTS3})"
export HOSTS4="$(convert_list ${HOSTS4})"
export HOSTS5="$(convert_list ${HOSTS5})"
export HOSTS6="$(convert_list ${HOSTS6})"
export HOSTS7="$(convert_list ${HOSTS7})"
export HOSTS8="$(convert_list ${HOSTS8})"
export HOSTS9="$(convert_list ${HOSTS9})"

courier deploy --repo release/villagers --dir /opt/twitch/villagers
'''
	}
}

job {
	name 'release-villagers-deploy-cops-aws'
	using 'TEMPLATE-deploy-aws'

	wrappers {
		sshAgent 'git-aws-read-key'
		preBuildCleanup()
		timestamps()
		credentialsBinding {
			file('AWS_CONFIG_FILE', 'aws_config')
			string 'AWS_ACCESS_KEY_ID', 'video-ops-aws-access-key'
			string 'AWS_SECRET_ACCESS_KEY', 'video-ops-aws-secret-key'
		}
	}

	steps {
		downloadDeployArtifact 'release/villagers/all'
		shell '''
manta -v \
	-f mantafiles/.manta.deploy.json \
	-e PROFILE=twitch-video-ops-aws \
	-e ACTION=apply \
	-e AWS_ACCESS_KEY_ID=$AWS_ACCESS_KEY_ID \
	-e AWS_SECRET_ACCESS_KEY=$AWS_SECRET_ACCESS_KEY \
	-e IMAGE_TAG=$GIT_COMMIT
'''
	}
}

job {
	name 'release-villagers-deploy-cops-stg'
	using 'TEMPLATE-deploy-aws'

	wrappers {
		sshAgent 'git-aws-read-key'
		preBuildCleanup()
		timestamps()
		credentialsBinding {
			file('AWS_CONFIG_FILE', 'aws_config')
			string 'AWS_ACCESS_KEY_ID', 'video-ops-stg-access-key'
			string 'AWS_SECRET_ACCESS_KEY', 'video-ops-stg-secret-key'
		}
	}

	steps {
		downloadDeployArtifact 'release/villagers/all'
		shell '''
manta -v \
	-f mantafiles/.manta.deploy.json \
	-e PROFILE=twitch-video-ops-stg \
	-e ACTION=apply \
	-e AWS_ACCESS_KEY_ID=$AWS_ACCESS_KEY_ID \
	-e AWS_SECRET_ACCESS_KEY=$AWS_SECRET_ACCESS_KEY \
	-e IMAGE_TAG=$GIT_COMMIT
'''
	}
}
// retry 1