#!/bin/bash

# This is an example of how the run script for barrel might look. Key
# components are that it runs the command in a very constrained memory cgroup,
# and that it runs as an unprivileged user.

ulimit -n 262144

set -e -o pipefail -u

NAME="barrel"

if [[ ! -d "/sys/fs/cgroup/memory/${NAME}" ]]; then
	mkdir "/sys/fs/cgroup/memory/${NAME}"
fi
/bin/echo "$((32*1024*1024))" > "/sys/fs/cgroup/memory/${NAME}/memory.limit_in_bytes"
/bin/echo "0" > "/sys/fs/cgroup/memory/${NAME}/memory.swappiness"
/bin/echo "$$" > "/sys/fs/cgroup/memory/${NAME}/cgroup.procs"

if [[ ! -d "/sys/fs/cgroup/cpuacct/${NAME}" ]]; then
	mkdir "/sys/fs/cgroup/cpuacct/${NAME}"
fi
/bin/echo "$$" > "/sys/fs/cgroup/cpuacct/${NAME}/cgroup.procs"

exec setuidgid nobody ./barrel 2>&1
