//+build ignore

package main

import (
	"flag"
	"fmt"

	"code.justin.tv/rhys/nursery/builder"
)

func main() {
	var (
		gobin string

		runFmt       bool
		runVet       bool
		runTest      bool
		runRaceTest  bool
		buildBin     bool
		buildRaceBin bool

		tags repeatStringFlag
	)
	flag.StringVar(&gobin, "gobin", "./libexec", "Binary output directory")
	flag.BoolVar(&runFmt, "fmt", true, "Run gofmt")
	flag.BoolVar(&runVet, "vet", true, "Run govet")
	flag.BoolVar(&runTest, "test", true, "Run tests")
	flag.BoolVar(&runRaceTest, "racetest", true, "Run tests with race detector")
	flag.BoolVar(&buildBin, "bin", true, "Build commands")
	flag.BoolVar(&buildRaceBin, "racebin", true, "Build commands with race detector")
	flag.Var(&tags, "tag", "Add build tag")
	flag.Parse()

	(&builder.Job{
		Gobin: gobin,

		RunFmt: runFmt,
		RunVet: runVet,
		// RunTest: runTest,
	}).Run()
}

type repeatStringFlag []string

func (rs *repeatStringFlag) Set(val string) error {
	*rs = append(*rs, val)
	return nil
}

func (rs *repeatStringFlag) String() string {
	return fmt.Sprintf("%q", *rs)
}
