package main

import (
	"context"
	"flag"
	"log"

	"github.com/aws/aws-sdk-go/aws/session"
	"github.com/aws/aws-sdk-go/service/ec2"
)

func main() {
	flag.Parse()

	ctx := context.Background()
	ctx, cancel := context.WithCancel(ctx)
	defer cancel()

	sess, err := session.NewSession()
	if err != nil {
		log.Fatalf("session: %v", err)
	}

	ec2c := ec2.New(sess)

	ec2c.DescribeInstancesPagesWithContext(ctx, &ec2.DescribeInstancesInput{},
		func(resp *ec2.DescribeInstancesOutput, lastPage bool) bool {
			return true
		})

}
