package main

import (
	"bufio"
	"log"
	"math"
	"os"
	"sort"
	"strconv"
)

func main() {
	sc := bufio.NewScanner(os.Stdin)

	const binExp = 10

	var n, sum, square float64
	bins := make(map[int]int)
	for sc.Scan() {
		v, err := strconv.ParseFloat(sc.Text(), 64)
		if err != nil {
			continue
		}
		n, sum, square = n+1, sum+v, square+v*v

		if v > 0 {
			bin := int(math.Log2(v) * binExp)
			bins[bin]++
		}
	}

	variance := square/n - sum*sum/(n*n)
	log.Printf("n=%.f sum=%.f square=%.f variance=%.f", n, sum, square, variance)

	binStarts := make([]int, 0, len(bins))
	for bin := range bins {
		binStarts = append(binStarts, bin)
	}
	sort.Ints(binStarts)
	if len(binStarts) == 0 {
		return
	}

	var pdfSum float64
	for bin := binStarts[0]; bin <= binStarts[len(binStarts)-1]; bin++ {
		var (
			lo  = math.Exp2((float64(bin) + 0.0) / binExp)
			mid = math.Exp2((float64(bin) + 0.5) / binExp)
			hi  = math.Exp2((float64(bin) + 1.0) / binExp)
		)
		pdfSum += normalPDF(mid, sum/n, variance) * (hi - lo)
	}

	var chi2 float64
	for bin := binStarts[0]; bin <= binStarts[len(binStarts)-1]; bin++ {
		var (
			lo  = math.Exp2((float64(bin) + 0.0) / binExp)
			mid = math.Exp2((float64(bin) + 0.5) / binExp)
			hi  = math.Exp2((float64(bin) + 1.0) / binExp)
		)
		modelDensity := normalPDF(mid, sum/n, variance) * (hi - lo) / pdfSum
		dataDensity := float64(bins[bin]) / n
		contribution := (dataDensity - modelDensity) * (dataDensity - modelDensity) / modelDensity
		log.Printf("bin[%d:%f]=%3.f expect=%3.f contrib=%f", bin, mid, dataDensity*n, modelDensity*n, contribution)

		if contribution < 100 {
			chi2 += contribution
		}
	}
	log.Printf("chi2=%f", chi2)

}

func normalPDF(x, mean, variance float64) float64 {
	return math.Exp((x-mean)*(x-mean)/(-2*variance)) / math.Sqrt(2*math.Pi*variance)
}
