package main

import "testing"

func TestUncovered(t *testing.T) {
	testcase := func(want int64, parent [2]int64, children ...[2]int64) func(t *testing.T) {
		return func(t *testing.T) {
			have := uncovered(parent, children...)
			if have != want {
				t.Errorf("uncovered(%v, %v); %d != %d", parent, children, have, want)
			}
		}
	}

	t.Run("", testcase(100, [2]int64{0, 100}))
	t.Run("", testcase(70, [2]int64{30, 100}))
	t.Run("", testcase(20, [2]int64{30, 100},
		[2]int64{30, 40}, [2]int64{50, 80}, [2]int64{60, 70}, [2]int64{70, 90}))
}

func TestWaterfall(t *testing.T) {
	testcase := func(want int, parent [2]int64, children ...[2]int64) func(t *testing.T) {
		return func(t *testing.T) {
			have := waterfall(parent, children...)
			if have != want {
				t.Errorf("waterfall(%v, %v); %d != %d", parent, children, have, want)
			}
		}
	}

	t.Run("", testcase(0, [2]int64{0, 100}))
	t.Run("", testcase(0, [2]int64{30, 100}))
	t.Run("", testcase(3, [2]int64{30, 100},
		[2]int64{30, 40}, [2]int64{50, 80}, [2]int64{60, 70}, [2]int64{70, 90}))
}
