// +build ignore

// This tool prints a uniform random selection of n lines of its input, in
// random order.

package main

import (
	"bufio"
	"flag"
	"fmt"
	"math/rand"
	"os"
	"time"
)

func main() {
	n := flag.Int("n", 2, "number of lines to select")
	flag.Parse()

	picked := make([]string, 0, *n)

	rng := rand.New(rand.NewSource(time.Now().UnixNano()))

	sc := bufio.NewScanner(os.Stdin)
	var i int64
	for sc.Scan() {
		i++
		if len(picked) < cap(picked) {
			picked = append(picked, sc.Text())
			target := rng.Intn(len(picked))
			picked[target], picked[len(picked)-1] = picked[len(picked)-1], picked[target]
			continue
		}

		target := rng.Int63n(i)
		if target < int64(len(picked)) {
			picked[int(target)] = sc.Text()
		}
	}

	for _, v := range picked {
		fmt.Printf("%s\n", v)
	}
}
