//+build ignore

package main

import (
	"bufio"
	"compress/gzip"
	"flag"
	"fmt"
	"log"
	"os"
	"strings"
)

func main() {
	twirp := flag.Bool("twirp", false, "Find lines corresponding to low-level Twirp requests")
	flag.Parse()

	gr, err := gzip.NewReader(os.Stdin)
	if err != nil {
		log.Fatalf("gzip.NewReader: %v", err)
	}
	defer gr.Close()
	sc := bufio.NewScanner(gr)
	sc.Split(bufio.ScanLines)
	for sc.Scan() {
		line := sc.Text()

		if *twirp {
			parts := strings.SplitN(line, " ", 6)
			if len(parts) != 5 {
				continue
			}
			if parts[4] == "0" {
				fmt.Println(line)
			}
		} else {
			parts := strings.SplitN(line, " ", 5)
			if len(parts) != 4 {
				continue
			}
			if strings.HasPrefix(parts[2], "/twirp/") {
				continue
			}
			if len(parts[3]) >= 6 {
				fmt.Println(line)
			}
		}
	}
	err = sc.Err()
	if err != nil {
		log.Fatalf("bufio.Scanner.Err: %v", err)
	}
}
