// +build ignore

// This tool looks at multicp test logs to see when the process (or machine) was
// entirely paused.

package main

import (
	"bufio"
	"compress/gzip"
	"fmt"
	"log"
	"os"
	"strconv"
	"strings"
	"time"
)

func main() {
	r, err := gzip.NewReader(os.Stdin)
	if err != nil {
		log.Fatalf("%v", err)
	}
	sc := bufio.NewScanner(r)
	var prev time.Time
	i := 0
	for sc.Scan() {
		line := sc.Text()
		parts := strings.SplitN(line, " ", 5)
		if len(parts) != 4 {
			continue
		}

		t, err := time.Parse(time.RFC3339Nano, parts[0])
		if err != nil {
			log.Fatalf("%v", err)
		}

		rtt, err := strconv.ParseInt(parts[3], 10, 64)
		if err != nil {
			log.Fatalf("%v", err)
		}
		t = t.Add(time.Duration(rtt) * time.Microsecond)

		if i > 0 {
			delta := t.Sub(prev)
			if delta > 100*time.Millisecond {
				fmt.Printf("%0.6f %s\n", delta.Seconds(), parts[0])
			}
		}
		prev = t
		i = 1
	}
}
