package main

import (
	"flag"
	"log"

	"github.com/etcinit/gonduit"
	"github.com/etcinit/gonduit/core"
	"github.com/etcinit/gonduit/requests"
)

func main() {
	host := flag.String("host", "https://phabricator.internal.justin.tv", "Phabricator hostname")
	flag.Parse()

	conn, err := gonduit.Dial(*host, &core.ClientOptions{})
	if err != nil {
		log.Fatalf("dial err: %v", err)
	}

	req := requests.DifferentialQueryRequest{}

	resp, err := conn.DifferentialQuery(req)
	if err != nil {
		log.Fatalf("differential query err: %v", err)
	}
	for _, r := range *resp {
		log.Printf("id=%q", r.ID)
	}
}
