package main

import (
	"log"
	"time"

	"github.com/aws/aws-sdk-go/aws"
	"github.com/aws/aws-sdk-go/aws/session"
	"github.com/aws/aws-sdk-go/service/s3"
)

func main() {
	sess, err := session.NewSession(&aws.Config{
		Region: aws.String("us-west-2"),
	})
	if err != nil {
		log.Fatalf("err %q", err)
	}

	req, _ := s3.New(sess).PutObjectRequest(&s3.PutObjectInput{
		Bucket: aws.String("twitch-rhys-alpha-us-west-2-rhys-scratch-v1"),
		Key:    aws.String("users-perf-data-2"),
	})
	uri, err := req.Presign(5 * time.Minute)
	if err != nil {
		log.Fatalf("err %q", err)
	}

	log.Printf("uri %s", uri)
}
