package main

import (
	"testing"
	"time"
)

func TestCoverage(t *testing.T) {
	const epoch = 1234000
	span := timespan{
		seconds:  epoch,
		duration: 100 * time.Second,
	}

	tests := []struct {
		spans   []timespan
		covered time.Duration
	}{
		{spans: []timespan{{seconds: epoch + 5, duration: 3 * time.Second}}, covered: 3 * time.Second},
		{spans: []timespan{{seconds: epoch + 5, duration: 300 * time.Second}}, covered: 95 * time.Second},
		{spans: []timespan{{seconds: epoch + 500, duration: 3 * time.Second}}, covered: 0 * time.Second},
		{spans: []timespan{{seconds: epoch - 500, duration: 3 * time.Second}}, covered: 0 * time.Second},
		{spans: []timespan{
			{seconds: epoch + 5, duration: 3 * time.Second},
			{seconds: epoch + 6, duration: 3 * time.Second},
			{seconds: epoch + 10, duration: 3 * time.Second},
		}, covered: 7 * time.Second},
		{spans: []timespan{{seconds: epoch - 1, duration: 3 * time.Second}}, covered: 2 * time.Second},
		{spans: []timespan{{seconds: epoch + 98, duration: 3 * time.Second}}, covered: 2 * time.Second},
		{spans: []timespan{
			{seconds: epoch + 15, duration: 20 * time.Second},
			{seconds: epoch + 20, duration: 10 * time.Second},
			{seconds: epoch + 10, duration: 30 * time.Second},
		}, covered: 30 * time.Second},
		{spans: []timespan{
			{seconds: epoch + 30, duration: 20 * time.Second},
			{seconds: epoch + 31, duration: 20 * time.Second},
			{seconds: epoch + 32, duration: 10 * time.Second},
		}, covered: 21 * time.Second},
	}

	for i, tt := range tests {
		if have, want := span.coverage(tt.spans...), tt.covered; have != want {
			t.Errorf("span.coverage(#%d); %s != %s", i, have, want)
		}
	}
}
