package main

import (
	"bytes"
	"testing"

	"github.com/syndtr/goleveldb/leveldb/opt"
	"github.com/syndtr/goleveldb/leveldb/storage"
	"github.com/syndtr/goleveldb/leveldb/table"
)

func TestThing(t *testing.T) {
	var buf bytes.Buffer

	w := table.NewWriter(&buf, &opt.Options{Compression: opt.NoCompression})
	err := w.Append([]byte("key"), []byte("value"))
	if err != nil {
		t.Fatalf("Append; err = %q", err)
	}

	err = w.Close()
	if err != nil {
		t.Fatalf("Close; err = %q", err)
	}

	t.Logf("buf %#02x", buf.Bytes())
	// t.Logf("buf %s", buf.Bytes())

	r, err := table.NewReader(bytes.NewReader(buf.Bytes()), int64(buf.Len()),
		storage.FileDesc{Num: 1, Type: storage.TypeTable},
		nil, nil, nil)
	if err != nil {
		t.Fatalf("NewReader; err = %q", err)
	}

	it := r.NewIterator(nil, nil)
	for it.Next() {
		t.Logf("k=%q v=%q", it.Key(), it.Value())
	}

	// t.Fail()
}
