package main

import (
	"encoding/binary"
	"flag"
	"io"
	"log"
	"os"

	"github.com/syndtr/goleveldb/leveldb/table"
)

var (
	key   = flag.String("key", "", "Key to write")
	value = flag.String("value", "", "Value to write")
)

func main() {
	flag.Parse()

	var f io.Writer
	f = os.Stdout

	w := table.NewWriter(f, nil)

	for c := uint8(0); c < 255; c++ {
		k := append([]byte(nil), *key...)
		k = append(k, c)

		k = append(k, make([]byte, 8)...)
		binary.LittleEndian.PutUint64(k[len(k)-8:], 1)

		v := append([]byte(nil), *value...)

		err := w.Append(k, v)
		if err != nil {
			log.Fatalf("write err=%q", err)
		}
	}

	err := w.Close()
	if err != nil {
		log.Fatalf("close err=%q", err)
	}
}
