#!/usr/bin/env bash
set -e -o pipefail -u

for dir in *; do
	if [[ ! -d "${dir}" ]]; then
		continue
	fi
	pushd $dir >/dev/null


	protoc \
		--go_out=Mgoogle/api/annotations.proto=github.com/grpc-ecosystem/grpc-gateway/third_party/googleapis/google/api:../../../../.. \
		--twirp_out=Mgoogle/api/annotations.proto=github.com/grpc-ecosystem/grpc-gateway/third_party/googleapis/google/api:../../../../.. \
		-I../../../../.. \
		-I../../../../../github.com/google/protobuf/src \
		-I../../../../../github.com/googleapis/googleapis \
		../../../../../code.justin.tv/rhys/nursery/ext/"${dir}"/*.proto

	popd >/dev/null
done
exit 0
