package main

import "fmt"

func main() {
	b := map[string]bool{
		"true":  true,
		"false": false,
	}

	for _, key := range []string{"true", "false", "nope"} {
		var a bool = true
		a, a = b[key]
		fmt.Println(key, "\t", a)
	}

	fmt.Println("---")

	for _, key := range []string{"true", "false", "nope"} {
		var a bool = true
		a, a = lookup(b, key)
		fmt.Println(key, "\t", a)
	}
}

func lookup(b map[string]bool, key string) (bool, bool) {
	v, ok := b[key]
	return v, ok
}
