#!/usr/bin/env bash

go version

go build -o ./server ./main.go
./server &
server="$!"
sleep 1

for tool in "go tool pprof" "pprof"; do
	for record_style in "" "-inuse_space" "-alloc_space"; do
		$tool $record_style -proto -symbolize=remote -output ./heap.pb.gz http://127.0.0.1:8080/debug/pprof/heap &>/dev/null
		for view_style in "-inuse_space" "-alloc_space"; do
			$tool $view_style -top ./heap.pb.gz &>/dev/null || printf "failed tool=%q record=%q view=%q\n" "$tool" "$record_style" "$view_style"
		done
		rm ./heap.pb.gz
	done
done

kill -KILL -- "$server"
rm ./server
