package main

import (
	"bytes"
	"log"
	"text/template"
)

func main() {
	log.SetFlags(0)

	var buf bytes.Buffer

	tmpl := template.Must(template.New("").Parse(`{{call .PlusOne 1}}`))
	err := tmpl.Execute(&buf, map[string]interface{}{
		"PlusOne": func(n int) int {
			return n + 1
		},
	})

	if err != nil {
		log.Fatalf("error: %v", err)
	}
	if buf.String() != "2" {
		log.Fatalf("wrong output: %q", buf.String())
	}
}
